/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.RenderHelper;

@OnlyIn(value=Dist.CLIENT)
public class SubtitleRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderSubtitles(GuiGraphics guiGraphics, long currentTime) {
        MutableComponent fullText;
        if (!RenderHelper.isElementVisible(ModConfigScreen.ElementType.SUBTITLE)) {
            return;
        }
        if (KillIconRenderer.latestWeaponName.isEmpty() && KillIconRenderer.latestTargetName.isEmpty()) {
            return;
        }
        if (KillIconRenderer.textHideTime > 0L && currentTime >= KillIconRenderer.textHideTime) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        String format = KillIconRenderer.latestIsAssist ? Config.assistSubtitleFormat : Config.customSubtitleFormat;
        String localizedWeapon = SubtitleRenderer.translateKey(KillIconRenderer.latestWeaponName);
        String localizedTarget = SubtitleRenderer.translateKey(KillIconRenderer.latestTargetName);
        String formattedText = format;
        if (format.contains("{weapon}") && !localizedWeapon.isEmpty()) {
            formattedText = formattedText.replace("{weapon}", localizedWeapon);
        }
        if (format.contains("{target}") && !localizedTarget.isEmpty()) {
            formattedText = formattedText.replace("{target}", localizedTarget);
        }
        int weaponColorValue = KillIconRenderer.latestIsCritical ? Config.criticalColorHex : Config.weaponColorHex;
        int targetColorValue = KillIconRenderer.latestIsCritical ? Config.criticalColorHex : Config.targetColorHex;
        long elapsedSubtitle = currentTime - KillIconRenderer.subtitleAnimationStartTime;
        if (elapsedSubtitle < 250L) {
            float progress = Mth.m_14036_((float)((float)elapsedSubtitle / 250.0f), (float)0.0f, (float)1.0f);
            float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
            KillIconRenderer.subtitleScale = Mth.m_14179_((float)easedProgress, (float)1.5f, (float)1.0f);
            KillIconRenderer.subtitleBrightness = Mth.m_14179_((float)easedProgress, (float)10.0f, (float)1.0f);
        } else {
            KillIconRenderer.subtitleScale = 1.0f;
            KillIconRenderer.subtitleBrightness = 1.0f;
        }
        boolean hasWeaponPlaceholder = format.contains("{weapon}");
        boolean hasTargetPlaceholder = format.contains("{target}");
        if (hasWeaponPlaceholder && hasTargetPlaceholder) {
            weaponIndex = formattedText.indexOf(localizedWeapon);
            int targetIndex = formattedText.indexOf(localizedTarget);
            if (weaponIndex >= 0 && targetIndex >= 0) {
                if (weaponIndex < targetIndex) {
                    String beforeWeapon = formattedText.substring(0, weaponIndex);
                    between = formattedText.substring(Math.min(weaponIndex + localizedWeapon.length(), targetIndex), targetIndex);
                    String afterTarget = formattedText.substring(Math.min(targetIndex + localizedTarget.length(), formattedText.length()));
                    fullText = Component.m_237113_((String)beforeWeapon).m_7220_((Component)Component.m_237113_((String)localizedWeapon).m_130948_(Style.f_131099_.m_178520_(SubtitleRenderer.applyBrightness(weaponColorValue, KillIconRenderer.subtitleBrightness)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)between)).m_7220_((Component)Component.m_237113_((String)localizedTarget).m_130948_(Style.f_131099_.m_178520_(SubtitleRenderer.applyBrightness(targetColorValue, KillIconRenderer.subtitleBrightness)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)afterTarget));
                } else {
                    String beforeTarget = formattedText.substring(0, targetIndex);
                    between = formattedText.substring(Math.min(targetIndex + localizedTarget.length(), weaponIndex), weaponIndex);
                    String afterWeapon = formattedText.substring(Math.min(weaponIndex + localizedWeapon.length(), formattedText.length()));
                    fullText = Component.m_237113_((String)beforeTarget).m_7220_((Component)Component.m_237113_((String)localizedTarget).m_130948_(Style.f_131099_.m_178520_(SubtitleRenderer.applyBrightness(targetColorValue, KillIconRenderer.subtitleBrightness)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)between)).m_7220_((Component)Component.m_237113_((String)localizedWeapon).m_130948_(Style.f_131099_.m_178520_(SubtitleRenderer.applyBrightness(weaponColorValue, KillIconRenderer.subtitleBrightness)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)afterWeapon));
                }
            } else {
                fullText = Component.m_237113_((String)formattedText);
            }
        } else if (hasWeaponPlaceholder) {
            weaponIndex = formattedText.indexOf(localizedWeapon);
            if (weaponIndex >= 0) {
                String beforeWeapon = formattedText.substring(0, weaponIndex);
                String afterWeapon = formattedText.substring(Math.min(weaponIndex + localizedWeapon.length(), formattedText.length()));
                fullText = Component.m_237113_((String)beforeWeapon).m_7220_((Component)Component.m_237113_((String)localizedWeapon).m_130948_(Style.f_131099_.m_178520_(SubtitleRenderer.applyBrightness(weaponColorValue, KillIconRenderer.subtitleBrightness)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)afterWeapon));
            } else {
                fullText = Component.m_237113_((String)formattedText);
            }
        } else if (hasTargetPlaceholder) {
            int targetIndex = formattedText.indexOf(localizedTarget);
            if (targetIndex >= 0) {
                String beforeTarget = formattedText.substring(0, targetIndex);
                String afterTarget = formattedText.substring(Math.min(targetIndex + localizedTarget.length(), formattedText.length()));
                fullText = Component.m_237113_((String)beforeTarget).m_7220_((Component)Component.m_237113_((String)localizedTarget).m_130948_(Style.f_131099_.m_178520_(SubtitleRenderer.applyBrightness(targetColorValue, KillIconRenderer.subtitleBrightness)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)afterTarget));
            } else {
                fullText = Component.m_237113_((String)formattedText);
            }
        } else {
            fullText = Component.m_237113_((String)formattedText);
        }
        int textY = screenHeight + pos.subtitleY;
        int textWidth = font.m_92852_((FormattedText)fullText);
        int textX = screenWidth / 2 + pos.subtitleX - textWidth / 2;
        float subtitleSizeScale = (float)RenderHelper.getElementSize(ModConfigScreen.ElementType.SUBTITLE) / 100.0f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        try {
            float centerX = (float)textX + (float)textWidth / 2.0f;
            float f = textY;
            Objects.requireNonNull(font);
            float centerY = f + 9.0f / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_85841_(KillIconRenderer.subtitleScale * subtitleSizeScale, KillIconRenderer.subtitleScale * subtitleSizeScale, 1.0f);
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            guiGraphics.m_280614_(font, (Component)fullText, textX, textY, SubtitleRenderer.applyBrightness(-1, KillIconRenderer.subtitleBrightness), true);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    private static int applyBrightness(int color, float brightness) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * brightness);
        int g = (int)((float)(color >> 8 & 0xFF) * brightness);
        int b = (int)((float)(color & 0xFF) * brightness);
        r = Mth.m_14045_((int)r, (int)0, (int)255);
        g = Mth.m_14045_((int)g, (int)0, (int)255);
        b = Mth.m_14045_((int)b, (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static String translateKey(String key) {
        try {
            MutableComponent translated = Component.m_237115_((String)key);
            return translated.getString();
        }
        catch (Exception e) {
            if (key.contains(".")) {
                return key.substring(key.lastIndexOf(".") + 1);
            }
            return key;
        }
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                config.subtitleX = Config.scrollSubtitleX;
                config.subtitleY = Config.scrollSubtitleY;
                config.scoreX = Config.scrollScoreX;
                config.scoreY = Config.scrollScoreY;
                config.bonusX = Config.scrollBonusX;
                config.bonusY = Config.scrollBonusY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                config.subtitleX = Config.comboSubtitleX;
                config.subtitleY = Config.comboSubtitleY;
                config.scoreX = Config.comboScoreX;
                config.scoreY = Config.comboScoreY;
                config.bonusX = Config.comboBonusX;
                config.bonusY = Config.comboBonusY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
                config.subtitleX = Config.cardSubtitleX;
                config.subtitleY = Config.cardSubtitleY;
                config.scoreX = Config.cardScoreX;
                config.scoreY = Config.cardScoreY;
                config.bonusX = Config.cardBonusX;
                config.bonusY = Config.cardBonusY;
            }
        }
        return config;
    }
}

