/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.configmodules.BonusConfigModule;
import org.mods.gd656killicon.client.configmodules.CardIconConfigModule;
import org.mods.gd656killicon.client.configmodules.KillIconConfigModule;
import org.mods.gd656killicon.client.configmodules.ScoreConfigModule;
import org.mods.gd656killicon.client.configmodules.SubtitleConfigModule;

public class ElementConfigScreen
extends Screen {
    private final Screen parent;
    private final ModConfigScreen.DraggableElement element;
    private OptionsList list;
    public OptionsList.BooleanOptionEntry elementVisible;
    public OptionsList.SliderOptionEntry elementSize;
    private KillIconConfigModule killIconConfigModule;
    private SubtitleConfigModule subtitleConfigModule;
    private ScoreConfigModule scoreConfigModule;
    private BonusConfigModule bonusConfigModule;
    private CardIconConfigModule cardIconConfigModule;
    private static final int ITEM_HEIGHT = 15;
    private static final int SLIDER_WIDTH = 100;
    private static final int SLIDER_HEIGHT = 20;

    public ElementConfigScreen(Screen parent, ModConfigScreen.DraggableElement element) {
        super((Component)Component.translatable((String)"gd656killicon.elementconfig.title"));
        this.parent = parent;
        this.element = element;
    }

    protected void init() {
        super.init();
        int listTop = 32;
        int listBottom = this.height - 64;
        int listHeight = listBottom - listTop;
        this.list = new OptionsList(this.minecraft, this.width, listHeight, listTop, 15);
        this.addWidget((GuiEventListener)this.list);
        this.list.addEntryPublic(new OptionsList.CategoryEntry((Component)Component.literal((String)("\u5143\u7d20\u914d\u7f6e: " + this.element.name))));
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        int minSize = 16;
        int maxSize = 500;
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            maxSize = 96;
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            minSize = 50;
            maxSize = 200;
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            minSize = 100;
        }
        this.elementSize = new OptionsList.SliderOptionEntry((Component)Component.literal((String)"\u5143\u7d20\u5927\u5c0f"), minSize, maxSize, this.getCurrentElementSize(this.element.type));
        this.list.addEntryPublic(this.elementSize);
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.elementVisible = new OptionsList.BooleanOptionEntry((Component)Component.literal((String)"\u6e38\u620f\u4e2d\u663e\u793a"), this.getCurrentElementVisible(this.element.type));
        this.list.addEntryPublic(this.elementVisible);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            this.addPrivateConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE) {
            this.addSubtitleConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            this.addScoreConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.BONUS) {
            this.addBonusConfigOptions();
        }
        int buttonWidth = 100;
        int buttonSpacing = 10;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int startX = (this.width - totalWidth) / 2;
        int buttonY = this.height - 30;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.saveConfig();
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(startX, buttonY, buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(startX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).build());
    }

    private void addPrivateConfigOptions() {
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            if (Config.iconMode == Config.IconMode.CARD) {
                this.cardIconConfigModule = new CardIconConfigModule(this.list);
                this.cardIconConfigModule.addConfigOptions();
            } else {
                this.killIconConfigModule = new KillIconConfigModule(this.list);
                this.killIconConfigModule.addConfigOptions();
            }
        }
    }

    private void addSubtitleConfigOptions() {
        this.subtitleConfigModule = new SubtitleConfigModule(this.list);
        this.subtitleConfigModule.addConfigOptions();
    }

    private void addScoreConfigOptions() {
        this.scoreConfigModule = new ScoreConfigModule(this.list);
        this.scoreConfigModule.addConfigOptions();
    }

    private void addBonusConfigOptions() {
        this.bonusConfigModule = new BonusConfigModule(this.list);
        this.bonusConfigModule.addConfigOptions();
    }

    private int getCurrentElementSize(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollIconSize;
                case Config.IconMode.COMBO -> Config.comboIconSize;
                case Config.IconMode.CARD -> Config.cardIconSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleSize;
                case Config.IconMode.COMBO -> Config.comboSubtitleSize;
                case Config.IconMode.CARD -> Config.cardSubtitleSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollScoreSize;
                case Config.IconMode.COMBO -> Config.comboScoreSize;
                case Config.IconMode.CARD -> Config.cardScoreSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollBonusSize;
                case Config.IconMode.COMBO -> Config.comboBonusSize;
                case Config.IconMode.CARD -> Config.cardBonusSize;
            };
        }
        return 100;
    }

    private boolean getCurrentElementVisible(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollIconVisible;
                case Config.IconMode.COMBO -> Config.comboIconVisible;
                case Config.IconMode.CARD -> Config.cardIconVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleVisible;
                case Config.IconMode.COMBO -> Config.comboSubtitleVisible;
                case Config.IconMode.CARD -> Config.cardSubtitleVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollScoreVisible;
                case Config.IconMode.COMBO -> Config.comboScoreVisible;
                case Config.IconMode.CARD -> Config.cardScoreVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new MatchException(null, null);
                case Config.IconMode.SCROLLING -> Config.scrollBonusVisible;
                case Config.IconMode.COMBO -> Config.comboBonusVisible;
                case Config.IconMode.CARD -> Config.cardBonusVisible;
            };
        }
        return true;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        String sharedText;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            sharedText = "\u4e00\u4e8c\u6a21\u5171\u7528 \u4e09\u6a21\u5355\u72ec";
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, sharedText, 10, this.height - 9 - 10, 0x888888, true);
        }
        if (this.element.type == ModConfigScreen.ElementType.SUBTITLE) {
            sharedText = "\u4e09\u6a21\u5f0f\u5171\u7528";
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, sharedText, 10, this.height - 9 - 10, 0x888888, true);
        }
        if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            sharedText = "\u4e09\u6a21\u5f0f\u5171\u7528";
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, sharedText, 10, this.height - 9 - 10, 0x888888, true);
        }
        if (this.element.type == ModConfigScreen.ElementType.BONUS) {
            sharedText = "\u4e09\u6a21\u5f0f\u5171\u7528";
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, sharedText, 10, this.height - 9 - 10, 0x888888, true);
        }
        if (this.list != null) {
            this.list.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundColor = -1728053248;
        guiGraphics.fillGradient(0, 0, this.width, this.height, backgroundColor, backgroundColor);
    }

    private void saveConfig() {
        int newSize = this.elementSize.getValue();
        boolean newVisible = this.elementVisible.getValue();
        switch (this.element.type) {
            case ICON: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_ICON_SIZE.set((Object)newSize);
                        Config.SCROLL_ICON_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_ICON_SIZE.set((Object)newSize);
                        Config.COMBO_ICON_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_ICON_SIZE.set((Object)newSize);
                        Config.CARD_ICON_VISIBLE.set((Object)newVisible);
                    }
                }
                if (Config.iconMode == Config.IconMode.CARD) {
                    if (this.cardIconConfigModule == null) break;
                    this.cardIconConfigModule.saveConfig();
                    break;
                }
                if (this.killIconConfigModule == null) break;
                this.killIconConfigModule.saveConfig();
                break;
            }
            case SUBTITLE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_SUBTITLE_SIZE.set((Object)newSize);
                        Config.SCROLL_SUBTITLE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_SUBTITLE_SIZE.set((Object)newSize);
                        Config.COMBO_SUBTITLE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_SUBTITLE_SIZE.set((Object)newSize);
                        Config.CARD_SUBTITLE_VISIBLE.set((Object)newVisible);
                    }
                }
                if (this.subtitleConfigModule == null) break;
                this.subtitleConfigModule.saveConfig();
                break;
            }
            case SCORE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_SCORE_SIZE.set((Object)newSize);
                        Config.SCROLL_SCORE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_SCORE_SIZE.set((Object)newSize);
                        Config.COMBO_SCORE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_SCORE_SIZE.set((Object)newSize);
                        Config.CARD_SCORE_VISIBLE.set((Object)newVisible);
                    }
                }
                if (this.scoreConfigModule == null) break;
                this.scoreConfigModule.saveConfig();
                break;
            }
            case BONUS: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_BONUS_SIZE.set((Object)newSize);
                        Config.SCROLL_BONUS_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_BONUS_SIZE.set((Object)newSize);
                        Config.COMBO_BONUS_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_BONUS_SIZE.set((Object)newSize);
                        Config.CARD_BONUS_VISIBLE.set((Object)newVisible);
                    }
                }
                if (this.bonusConfigModule == null) break;
                this.bonusConfigModule.saveConfig();
            }
        }
        Config.SPEC.save();
        Config.loadConfig();
        if (this.parent instanceof ModConfigScreen) {
            ((ModConfigScreen)this.parent).updateElementSizes();
        }
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public static class OptionsList
    extends ContainerObjectSelectionList<Entry> {
        public OptionsList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
        }

        public void addEntryPublic(Entry entry) {
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public static class EditBoxOptionEntry
        extends Entry {
            private final EditBox editBox;
            private final Component label;
            private final boolean isColorOption;

            public EditBoxOptionEntry(Component label, String initialValue, int width) {
                this(label, initialValue, width, false);
            }

            public EditBoxOptionEntry(Component label, String initialValue, int width, boolean isColorOption) {
                this.label = label;
                this.isColorOption = isColorOption;
                this.editBox = new EditBox(Minecraft.getInstance().font, 0, 0, width, 20, (Component)Component.empty());
                this.editBox.setValue(initialValue);
                this.editBox.setMaxLength(isColorOption ? 6 : 256);
                this.editBox.setFocused(true);
                this.editBox.setCanLoseFocus(true);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(Minecraft.getInstance().font, this.label, left + 10, textY, 0xFFFFFF);
                if (this.isColorOption) {
                    int colorValue;
                    this.editBox.setX(left + width - 150 + 75);
                    this.editBox.setY(top + (height - 20) / 2);
                    this.editBox.setWidth(75);
                    this.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
                    int colorBoxX = left + width - 150 + 130;
                    int colorBoxSize = 20;
                    int colorBoxY = top + (height - 20) / 2;
                    String colorText = this.editBox.getValue();
                    try {
                        String colorStr = "FF" + colorText.replace("#", "");
                        colorValue = (int)Long.parseLong(colorStr, 16);
                    }
                    catch (Exception e) {
                        colorValue = -1;
                    }
                    guiGraphics.fill(colorBoxX, colorBoxY, colorBoxX + colorBoxSize, colorBoxY + colorBoxSize, colorValue);
                    guiGraphics.renderOutline(colorBoxX, colorBoxY, colorBoxSize, colorBoxSize, -16777216);
                } else {
                    this.editBox.setX(left + width - 150 + 50);
                    this.editBox.setY(top + (height - 20) / 2);
                    this.editBox.setWidth(100);
                    this.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            public String getValue() {
                return this.editBox.getValue();
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.editBox);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.editBox);
            }
        }

        public static class IconStyleOptionEntry
        extends Entry {
            private final CycleButton<Config.IconStyle> styleButton;
            private final Component label;

            public IconStyleOptionEntry(Component label, Config.IconStyle initialValue) {
                this.label = label;
                this.styleButton = CycleButton.builder(style -> Component.translatable((String)style.getTranslationKey())).withValues((Object[])Config.IconStyle.values()).withInitialValue((Object)initialValue).create(0, 0, 100, 20, (Component)Component.empty(), (button, style) -> Component.translatable((String)style.getTranslationKey()));
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(Minecraft.getInstance().font, this.label, left + 10, textY, 0xFFFFFF);
                this.styleButton.setX(left + width - 100 - 10);
                this.styleButton.setY(top + (height - 20) / 2);
                this.styleButton.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconStyle getValue() {
                return (Config.IconStyle)((Object)this.styleButton.getValue());
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.styleButton);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.styleButton);
            }
        }

        public static class SliderOptionEntry
        extends Entry {
            private final CustomSlider slider;
            private final Component label;

            public SliderOptionEntry(Component label, int min, int max, int initialValue) {
                this.label = label;
                this.slider = new CustomSlider(0, 0, 100, 20, (Component)Component.empty(), (double)(initialValue - min) / (double)(max - min), min, max);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(Minecraft.getInstance().font, this.label, left + 10, textY, 0xFFFFFF);
                this.slider.setX(left + width - 100 - 10);
                this.slider.setY(top + (height - 20) / 2);
                this.slider.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public int getValue() {
                return this.slider.getIntValue();
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.slider);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.slider);
            }

            public static class CustomSlider
            extends AbstractSliderButton {
                private final int min;
                private final int max;

                public CustomSlider(int x, int y, int width, int height, Component message, double value, int min, int max) {
                    super(x, y, width, height, message, value);
                    this.min = min;
                    this.max = max;
                    this.updateMessage();
                }

                protected void updateMessage() {
                    this.setMessage((Component)Component.literal((String)String.valueOf(this.getIntValue())));
                }

                protected void applyValue() {
                }

                public int getIntValue() {
                    return this.min + (int)(this.value * (double)(this.max - this.min));
                }
            }
        }

        public static class BooleanOptionEntry
        extends Entry {
            private final Checkbox checkbox;
            private final Component label;

            public BooleanOptionEntry(Component label, boolean initialValue) {
                this.label = label;
                this.checkbox = Checkbox.builder((Component)Component.empty(), (Font)Minecraft.getInstance().font).pos(0, 0).selected(initialValue).build();
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(Minecraft.getInstance().font, this.label, left + 10, textY, 0xFFFFFF);
                this.checkbox.setX(left + width - 30);
                this.checkbox.setY(top);
                this.checkbox.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean getValue() {
                return this.checkbox.selected();
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.checkbox);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.checkbox);
            }
        }

        public static class CategoryEntry
        extends Entry {
            private final Component text;

            public CategoryEntry(Component text) {
                this.text = text;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.text, left + width / 2, textY, 0xFFFFFF);
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of();
            }
        }

        public static class SpacerEntry
        extends Entry {
            public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of();
            }
        }

        static abstract class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            Entry() {
            }
        }
    }
}

