/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.RankingDataRequestPacket;

public class RankingListScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int PADDING = 10;
    private static final int ROWS_PER_PAGE = 32;
    private static final int TITLE_HEIGHT = 30;
    private final int rankColumnWidth = 60;
    private final int playerColumnWidth = 200;
    private int rowHeight;
    private int tableHeight;
    private int tableWidth;
    private int tableX;
    private int tableY;
    private Button nextPageButton;
    private Button prevPageButton;
    private int currentPage = 0;
    private boolean hasData = false;
    private boolean isLoading = true;
    private final boolean isInGame;
    private boolean rankingEnabled = true;
    private int totalPages = 0;
    private int currentMouseX;
    private int currentMouseY;
    private static RankingListScreen instance;
    private final Screen parent;
    private final List<RankingEntry> rankingEntries = new ArrayList<RankingEntry>();

    public RankingListScreen(Screen parent) {
        super((Component)Component.literal((String)"\u51fb\u6740\u56fe\u6807\u6392\u884c\u699c"));
        this.parent = parent;
        instance = this;
        this.isInGame = Minecraft.getInstance().player != null;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundColor = -1728053248;
        guiGraphics.fillGradient(0, 0, this.width, this.height, backgroundColor, backgroundColor);
    }

    protected void init() {
        super.init();
        this.tableWidth = this.width - 20;
        this.tableHeight = this.height - 30 - 20 - 30;
        this.tableX = 10;
        this.tableY = 40;
        this.rowHeight = 18;
        this.initButtons();
        this.loadRankingData();
    }

    private void initButtons() {
        int bottomY = this.height - 20 - 10;
        Button backButton = Button.builder((Component)Component.literal((String)"\u8fd4\u56de"), button -> this.onClose()).bounds(this.width / 2 - 30, bottomY, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)backButton);
        this.nextPageButton = Button.builder((Component)Component.literal((String)"\u4e0b\u4e00\u9875"), button -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.updateButtonStates();
            }
        }).bounds(this.width - 60 - 10, bottomY, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.nextPageButton);
        this.prevPageButton = Button.builder((Component)Component.literal((String)"\u4e0a\u4e00\u9875"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateButtonStates();
            }
        }).bounds(10, bottomY, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.prevPageButton);
        this.updateButtonStates();
    }

    private boolean isMouseOverRow(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.tableX && mouseX <= this.tableX + this.tableWidth && mouseY >= rowY && mouseY <= rowY + this.rowHeight;
    }

    private void loadRankingData() {
        this.isLoading = true;
        this.hasData = false;
        this.rankingEnabled = true;
        if (!this.isInGame) {
            this.isLoading = false;
            return;
        }
        NetworkHandler.sendToServer(new RankingDataRequestPacket());
    }

    public void onClose() {
        instance = null;
        Minecraft.getInstance().setScreen(this.parent);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        if (!this.isInGame) {
            String notInGameText = "\u8bf7\u5728\u6e38\u620f\u5185\u67e5\u770b\u6392\u884c\u699c";
            guiGraphics.drawCenteredString(this.font, notInGameText, this.width / 2, this.height / 2, 0xFF5555);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        if (this.isLoading) {
            String loadingText = "\u6b63\u5728\u52a0\u8f7d\u6392\u884c\u699c\u6570\u636e...";
            guiGraphics.drawCenteredString(this.font, loadingText, this.width / 2, this.height / 2, 0xFFFFFF);
        } else if (!this.rankingEnabled) {
            String disabledText = "\u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed";
            guiGraphics.drawCenteredString(this.font, disabledText, this.width / 2, this.height / 2, 0xFF5555);
        } else if (!this.hasData) {
            String noDataText = "\u6682\u65e0\u6570\u636e";
            guiGraphics.drawCenteredString(this.font, noDataText, this.width / 2, this.height / 2, 0x888888);
        } else {
            String pageInfo = "\u7b2c " + (this.currentPage + 1) + " \u9875 / \u5171 " + this.totalPages + " \u9875";
            guiGraphics.drawString(this.font, pageInfo, this.width / 2 - this.font.width(pageInfo) / 2, 20, 0xCCCCCC, true);
            this.renderRankingTable(guiGraphics);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderRankingTable(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + this.tableHeight, Integer.MIN_VALUE);
        this.renderTableHeader(guiGraphics);
        this.renderTableRows(guiGraphics);
    }

    private void renderTableHeader(GuiGraphics guiGraphics) {
        int headerY = this.tableY + 5;
        guiGraphics.fill(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + 25, -2143009724);
        guiGraphics.fill(this.tableX, this.tableY + 25, this.tableX + this.tableWidth, this.tableY + 26, -10066330);
        int rankX = this.tableX + 10;
        int playerX = this.tableX + 60 + 10;
        int scoreX = this.tableX + 60 + 200 + 10;
        guiGraphics.drawString(this.font, "\u6392\u540d", rankX, headerY, 0xFFFFFF, true);
        guiGraphics.drawString(this.font, "\u73a9\u5bb6\u540d\u79f0", playerX, headerY, 0xFFFFFF, true);
        guiGraphics.drawString(this.font, "\u5206\u6570", scoreX, headerY, 0xFFFFFF, true);
        int separator1X = this.tableX + 60;
        int separator2X = separator1X + 200;
        guiGraphics.fill(separator1X, this.tableY, separator1X + 1, this.tableY + this.tableHeight, -10066330);
        guiGraphics.fill(separator2X, this.tableY, separator2X + 1, this.tableY + this.tableHeight, -10066330);
    }

    private void renderTableRows(GuiGraphics guiGraphics) {
        int startIndex = this.currentPage * 32;
        int endIndex = Math.min(startIndex + 32, this.rankingEntries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            RankingEntry entry = this.rankingEntries.get(i);
            int rowY = this.tableY + 30 + (i - startIndex) * this.rowHeight;
            if ((i - startIndex) % 2 == 0) {
                guiGraphics.fill(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40202020);
            }
            if (this.isMouseOverRow(this.currentMouseX, this.currentMouseY, rowY)) {
                guiGraphics.fill(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40666666);
            }
            guiGraphics.fill(this.tableX, rowY + this.rowHeight, this.tableX + this.tableWidth, rowY + this.rowHeight + 1, 0x40444444);
            this.renderRowData(guiGraphics, entry, rowY);
        }
    }

    private void renderRowData(GuiGraphics guiGraphics, RankingEntry entry, int rowY) {
        Objects.requireNonNull(this.font);
        int textY = rowY + (this.rowHeight - 9) / 2;
        int rankX = this.tableX + 10;
        String rankText = String.valueOf(entry.rank);
        int rankColor = this.getRankColor(entry.rank);
        guiGraphics.drawString(this.font, rankText, rankX, textY, rankColor, true);
        int playerX = this.tableX + 60 + 10;
        guiGraphics.drawString(this.font, entry.playerName, playerX, textY, 0xFFFFFF, true);
        int scoreX = this.tableX + 60 + 200 + 10;
        String scoreText = String.format("%,d", entry.score);
        guiGraphics.drawString(this.font, scoreText, scoreX, textY, 0xFFFFFF, true);
    }

    private void updateButtonStates() {
        this.prevPageButton.active = this.currentPage > 0 && this.hasData && this.rankingEnabled;
        this.nextPageButton.active = this.currentPage < this.totalPages - 1 && this.hasData && this.rankingEnabled;
    }

    public void updateRankingData(Map<UUID, Integer> serverRankingData, boolean rankingEnabled) {
        this.rankingEntries.clear();
        this.rankingEnabled = rankingEnabled;
        if (!rankingEnabled) {
            this.hasData = false;
            this.isLoading = false;
            this.updateButtonStates();
            return;
        }
        if (serverRankingData != null && !serverRankingData.isEmpty()) {
            ArrayList<Map.Entry<UUID, Integer>> sortedEntries = new ArrayList<Map.Entry<UUID, Integer>>(serverRankingData.entrySet());
            sortedEntries.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
            int rank = 1;
            for (Map.Entry entry : sortedEntries) {
                UUID playerId = (UUID)entry.getKey();
                int score = (Integer)entry.getValue();
                String playerName = this.getPlayerName(playerId);
                this.rankingEntries.add(new RankingEntry(rank, playerName, playerId, score));
                ++rank;
            }
            this.hasData = true;
        } else {
            this.hasData = false;
        }
        this.totalPages = this.hasData ? (int)Math.ceil((double)this.rankingEntries.size() / 32.0) : 0;
        this.isLoading = false;
        this.updateButtonStates();
    }

    public static RankingListScreen getInstance() {
        return instance;
    }

    private String getPlayerName(UUID playerId) {
        try {
            Player player;
            if (this.minecraft != null && this.minecraft.level != null && (player = this.minecraft.level.getPlayerByUUID(playerId)) != null) {
                return player.getGameProfile().getName();
            }
            return "\u73a9\u5bb6_" + playerId.toString().substring(0, 8);
        }
        catch (Exception e) {
            return "\u672a\u77e5\u73a9\u5bb6";
        }
    }

    private int getRankColor(int rank) {
        return switch (rank) {
            case 1 -> -10496;
            case 2 -> -4144960;
            case 3 -> -3309774;
            default -> -1;
        };
    }

    private record RankingEntry(int rank, String playerName, UUID playerId, int score) {
    }
}

