/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.data.ScoreboardBindingData;

public class ScoreData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_scores";
    private boolean rankingListEnabled = true;
    private final ConcurrentHashMap<UUID, Integer> playerScores = new ConcurrentHashMap();
    private int cardComboKillDurationTime = 60;

    public ScoreData() {
    }

    public ScoreData(CompoundTag nbt) {
        ListTag scoreList = nbt.getList("scores", 10);
        for (int i = 0; i < scoreList.size(); ++i) {
            CompoundTag scoreTag = scoreList.getCompound(i);
            UUID playerId = scoreTag.getUUID("playerId");
            int score = scoreTag.getInt("score");
            this.playerScores.put(playerId, score);
        }
        this.rankingListEnabled = nbt.getBoolean("rankingListEnabled");
        this.cardComboKillDurationTime = nbt.getInt("cardComboKillDurationTime");
        if (this.cardComboKillDurationTime < 0) {
            this.cardComboKillDurationTime = 60;
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag scoreList = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.playerScores.entrySet()) {
            CompoundTag scoreTag = new CompoundTag();
            scoreTag.putUUID("playerId", entry.getKey());
            scoreTag.putInt("score", entry.getValue().intValue());
            scoreList.add((Object)scoreTag);
        }
        compound.put("scores", (Tag)scoreList);
        compound.putBoolean("rankingListEnabled", this.rankingListEnabled);
        compound.putInt("cardComboKillDurationTime", this.cardComboKillDurationTime);
        return compound;
    }

    public static ScoreData get() {
        return (ScoreData)Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD)).getDataStorage().computeIfAbsent(new SavedData.Factory(ScoreData::new, ScoreData::loadFromNbt, DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES), DATA_NAME);
    }

    private static ScoreData loadFromNbt(CompoundTag nbt, HolderLookup.Provider provider) {
        return new ScoreData(nbt);
    }

    public int getScore(UUID playerId) {
        return this.playerScores.getOrDefault(playerId, 0);
    }

    public void addScore(UUID playerId, float points) {
        int roundedPoints = Math.round(points);
        this.playerScores.compute(playerId, (key, current) -> (current == null ? 0 : current) + roundedPoints);
        this.setDirty();
        this.syncToScoreboard(playerId);
    }

    public void reduceScore(UUID playerId, float points) {
        int currentScore = this.getScore(playerId);
        int roundedPoints = Math.round(points);
        int newScore = Math.max(0, currentScore - roundedPoints);
        this.playerScores.put(playerId, newScore);
        this.setDirty();
        this.syncToScoreboard(playerId);
    }

    public void setScore(UUID playerId, int score) {
        int newScore = Math.max(0, score);
        this.playerScores.put(playerId, newScore);
        this.setDirty();
        this.syncToScoreboard(playerId);
    }

    private void syncToScoreboard(UUID playerId) {
        ServerPlayer player;
        ServerScoreboard scoreboard;
        Objective objective;
        ScoreboardBindingData bindingData;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (bindingData = ScoreboardBindingData.get()).isBound() && (objective = (scoreboard = server.getScoreboard()).getObjective(bindingData.getObjectiveName())) != null && (player = server.getPlayerList().getPlayer(playerId)) != null) {
            int score = this.getScore(playerId);
            ScoreHolder scoreHolder = ScoreHolder.forNameOnly((String)player.getScoreboardName());
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            scoreAccess.set(score);
        }
    }

    public boolean getRankingListEnabled() {
        return !this.rankingListEnabled;
    }

    public void setRankingListEnabled(boolean enabled) {
        this.rankingListEnabled = enabled;
        this.setDirty();
    }

    public int getCardComboKillDurationTime() {
        return this.cardComboKillDurationTime;
    }

    public void setCardComboKillDurationTime(int duration) {
        this.cardComboKillDurationTime = Math.max(0, Math.min(duration, 3600));
        this.setDirty();
    }

    public Map<UUID, Integer> getAllScores() {
        return new HashMap<UUID, Integer>(this.playerScores);
    }
}

