/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.configmenu.HistoryRecordScreen;

public class DamageScorePacket {
    private final float damage;
    private final String reason;

    public DamageScorePacket(float damage, String reason) {
        this.damage = damage;
        this.reason = reason;
    }

    public DamageScorePacket(FriendlyByteBuf buf) {
        this.damage = buf.readFloat();
        this.reason = buf.readUtf();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.damage);
        buf.writeUtf(this.reason);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            KillIconRenderer.addScore(this.damage, this.reason, false);
            if (this.reason.contains("\u52a9\u653b") || this.reason.contains("assist")) {
                String weaponName = "\u672a\u77e5\u6b66\u5668";
                String targetName = "\u672a\u77e5\u76ee\u6807";
                HistoryRecordScreen.addHistoryRecord(targetName, "\u52a9\u653b +" + Math.round(this.damage), weaponName, false, false);
            }
        });
        ctx.setPacketHandled(true);
    }
}

