/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("gd656killicon.json");
    private static Config INSTANCE;
    public int SCROLL_ICON_X;
    public int SCROLL_ICON_Y;
    public int SCROLL_SUBTITLE_X;
    public int SCROLL_SUBTITLE_Y;
    public int SCROLL_SCORE_X;
    public int SCROLL_SCORE_Y;
    public int SCROLL_BONUS_X;
    public int SCROLL_BONUS_Y;
    public int COMBO_ICON_X;
    public int COMBO_ICON_Y;
    public int COMBO_SUBTITLE_X;
    public int COMBO_SUBTITLE_Y;
    public int COMBO_SCORE_X;
    public int COMBO_SCORE_Y;
    public int COMBO_BONUS_X;
    public int COMBO_BONUS_Y;
    public int CARD_ICON_X;
    public int CARD_ICON_Y;
    public int CARD_SUBTITLE_X;
    public int CARD_SUBTITLE_Y;
    public int CARD_SCORE_X;
    public int CARD_SCORE_Y;
    public int CARD_BONUS_X;
    public int CARD_BONUS_Y;
    public int SCROLL_ICON_SIZE;
    public int SCROLL_SUBTITLE_SIZE;
    public int SCROLL_SCORE_SIZE;
    public int SCROLL_BONUS_SIZE;
    public boolean SCROLL_ICON_VISIBLE;
    public boolean SCROLL_SUBTITLE_VISIBLE;
    public boolean SCROLL_SCORE_VISIBLE;
    public boolean SCROLL_BONUS_VISIBLE;
    public int COMBO_ICON_SIZE;
    public int COMBO_SUBTITLE_SIZE;
    public int COMBO_SCORE_SIZE;
    public int COMBO_BONUS_SIZE;
    public boolean COMBO_ICON_VISIBLE;
    public boolean COMBO_SUBTITLE_VISIBLE;
    public boolean COMBO_SCORE_VISIBLE;
    public boolean COMBO_BONUS_VISIBLE;
    public int CARD_ICON_SIZE;
    public int CARD_SUBTITLE_SIZE;
    public int CARD_SCORE_SIZE;
    public int CARD_BONUS_SIZE;
    public boolean CARD_ICON_VISIBLE;
    public boolean CARD_SUBTITLE_VISIBLE;
    public boolean CARD_SCORE_VISIBLE;
    public boolean CARD_BONUS_VISIBLE;
    public String KILL_BONUS_DISPLAY;
    public String ASSIST_BONUS_DISPLAY;
    public String CRITICAL_BONUS_DISPLAY;
    public String LONGRANGE_BONUS_DISPLAY;
    public String MAGIC_BONUS_DISPLAY;
    public String HAND_BONUS_DISPLAY;
    public String COMBO_BONUS_DISPLAY;
    public String DAMAGE_BONUS_DISPLAY;
    public IconStyle CARD_ICON_STYLE;
    public int KILL_ICON_DURATION;
    public int KILL_ICON_SIZE;
    public static String WEAPON_COLOR;
    public static String TARGET_COLOR;
    public String CUSTOM_SUBTITLE_FORMAT;
    public int SOUND_VOLUME;
    public static String CRITICAL_COLOR;
    public IconMode ICON_MODE;
    public int COMBO_SCORE_DURATION;
    public int COMBO_SCORE_FONT_SCALE;
    public static String FLASHING_COLOR;
    public static String HIGH_SCORE_COLOR;
    public int COMBO_TIMEOUT;
    public double SCROLL_ANIMATION_SPEED;
    public String ASSIST_SUBTITLE_FORMAT;
    public boolean DEBUG_SHOW_INFO;
    public static double SCROLL_SENSITIVITY;
    public IconStyle ICON_STYLE;
    public int KILL_ICON_ANIMATION_DURATION;
    public int KILL_ICON_SPACING;
    public int FORCE_HIDE_COUNT;
    public int MAX_DISPLAY_COUNT;
    public int BONUS_LINE_SPACING;
    public boolean ENABLE_SOUND_EFFECTS;
    public int CARD_BOTTOMBAR_SIZE;
    public int CARD_BOTTOMBAR_OFFSET_Y;
    public boolean CARD_BOTTOMBAR_VISIBLE;
    public boolean COMBO_ICON_ANIMATION_ENABLED;
    public int COMBO_ICON_ANIMATION_DURATION;
    public int COMBO_ICON_ANIMATION_TOTAL_FRAMES;
    public static int scrollIconX;
    public static int scrollIconY;
    public static int scrollSubtitleX;
    public static int scrollSubtitleY;
    public static int scrollScoreX;
    public static int scrollScoreY;
    public static int scrollBonusX;
    public static int scrollBonusY;
    public static int comboIconX;
    public static int comboIconY;
    public static int comboSubtitleX;
    public static int comboSubtitleY;
    public static int comboScoreX;
    public static int comboScoreY;
    public static int comboBonusX;
    public static int comboBonusY;
    public static int cardIconX;
    public static int cardIconY;
    public static int cardSubtitleX;
    public static int cardSubtitleY;
    public static int cardScoreX;
    public static int cardScoreY;
    public static int cardBonusX;
    public static int cardBonusY;
    public static int scrollIconSize;
    public static int scrollSubtitleSize;
    public static int scrollScoreSize;
    public static int scrollBonusSize;
    public static boolean scrollIconVisible;
    public static boolean scrollSubtitleVisible;
    public static boolean scrollScoreVisible;
    public static boolean scrollBonusVisible;
    public static int comboIconSize;
    public static int comboSubtitleSize;
    public static int comboScoreSize;
    public static int comboBonusSize;
    public static boolean comboIconVisible;
    public static boolean comboSubtitleVisible;
    public static boolean comboScoreVisible;
    public static boolean comboBonusVisible;
    public static int cardIconSize;
    public static int cardSubtitleSize;
    public static int cardScoreSize;
    public static int cardBonusSize;
    public static boolean cardIconVisible;
    public static boolean cardSubtitleVisible;
    public static boolean cardScoreVisible;
    public static boolean cardBonusVisible;
    public static int cardBottombarSize;
    public static int cardBottombarOffsetY;
    public static boolean cardBottombarVisible;
    public static int killIconDuration;
    public static int killIconSize;
    public static int weaponColor;
    public static int targetColor;
    public static boolean showKillIcons;
    public static boolean showKillSubtitles;
    public static String customSubtitleFormat;
    public static int soundVolume;
    public static IconMode iconMode;
    public static IconStyle iconStyle;
    public static IconStyle cardIconStyle;
    public static boolean showComboScore;
    public static int comboScoreDuration;
    public static int comboScoreFontScale;
    public static int flashingColor;
    public static int highScoreColor;
    public static int comboTimeout;
    public static double scrollAnimationSpeed;
    public static int comboTimeoutMs;
    public static int criticalColor;
    public static String assistSubtitleFormat;
    public static boolean debugShowInfo;
    public static int weaponColorHex;
    public static int targetColorHex;
    public static int criticalColorHex;
    public static int flashingColorHex;
    public static int highScoreColorHex;
    public static String killBonusDisplay;
    public static String assistBonusDisplay;
    public static String criticalBonusDisplay;
    public static String longrangeBonusDisplay;
    public static String magicBonusDisplay;
    public static String handBonusDisplay;
    public static String comboBonusDisplay;
    public static String damageBonusDisplay;
    public static int killIconAnimationDuration;
    public static int killIconSpacing;
    public static int forceHideCount;
    public static int maxDisplayCount;
    public static int bonusLineSpacing;
    public static boolean enableSoundEffects;
    public static boolean comboIconAnimationEnabled;
    public static int comboIconAnimationDuration;
    public static int comboIconAnimationTotalFrames;

    public Config() {
        this.setupDefaultValues();
    }

    private void setupDefaultValues() {
        this.KILL_ICON_DURATION = 60;
        this.KILL_ICON_SIZE = 32;
        this.CUSTOM_SUBTITLE_FORMAT = "\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}";
        this.ASSIST_SUBTITLE_FORMAT = "\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}";
        this.ICON_MODE = IconMode.SCROLLING;
        this.ICON_STYLE = IconStyle.MODERN;
        this.CARD_ICON_STYLE = IconStyle.MODERN;
        this.KILL_ICON_ANIMATION_DURATION = 300;
        this.KILL_ICON_SPACING = 10;
        this.FORCE_HIDE_COUNT = 9;
        this.MAX_DISPLAY_COUNT = 30;
        this.setupDefaultPositionValues();
        this.setupDefaultElementValues();
        this.setupDefaultBonusValues();
        this.setupDefaultColorValues();
        this.setupDefaultSoundValues();
        this.setupDefaultComboValues();
        this.setupDefaultDebugValues();
    }

    private void setupDefaultPositionValues() {
        this.SCROLL_ICON_X = 0;
        this.SCROLL_ICON_Y = -140;
        this.SCROLL_SUBTITLE_X = 0;
        this.SCROLL_SUBTITLE_Y = -100;
        this.SCROLL_SCORE_X = 0;
        this.SCROLL_SCORE_Y = -80;
        this.SCROLL_BONUS_X = 0;
        this.SCROLL_BONUS_Y = -60;
        this.COMBO_ICON_X = 0;
        this.COMBO_ICON_Y = -140;
        this.COMBO_SUBTITLE_X = 0;
        this.COMBO_SUBTITLE_Y = -100;
        this.COMBO_SCORE_X = 0;
        this.COMBO_SCORE_Y = -80;
        this.COMBO_BONUS_X = 0;
        this.COMBO_BONUS_Y = -60;
        this.CARD_ICON_X = 0;
        this.CARD_ICON_Y = -70;
        this.CARD_SUBTITLE_X = 0;
        this.CARD_SUBTITLE_Y = -100;
        this.CARD_SCORE_X = 0;
        this.CARD_SCORE_Y = -80;
        this.CARD_BONUS_X = 0;
        this.CARD_BONUS_Y = -60;
    }

    private void setupDefaultElementValues() {
        this.SCROLL_ICON_SIZE = 32;
        this.SCROLL_ICON_VISIBLE = true;
        this.SCROLL_SUBTITLE_SIZE = 100;
        this.SCROLL_SUBTITLE_VISIBLE = true;
        this.SCROLL_SCORE_SIZE = 250;
        this.SCROLL_SCORE_VISIBLE = true;
        this.SCROLL_BONUS_SIZE = 100;
        this.SCROLL_BONUS_VISIBLE = true;
        this.COMBO_ICON_SIZE = 32;
        this.COMBO_ICON_VISIBLE = true;
        this.COMBO_SUBTITLE_SIZE = 100;
        this.COMBO_SUBTITLE_VISIBLE = true;
        this.COMBO_SCORE_SIZE = 250;
        this.COMBO_SCORE_VISIBLE = true;
        this.COMBO_BONUS_SIZE = 100;
        this.COMBO_BONUS_VISIBLE = true;
        this.COMBO_ICON_ANIMATION_ENABLED = false;
        this.COMBO_ICON_ANIMATION_DURATION = 2000;
        this.COMBO_ICON_ANIMATION_TOTAL_FRAMES = 11;
        this.CARD_ICON_SIZE = 48;
        this.CARD_ICON_VISIBLE = true;
        this.CARD_SUBTITLE_SIZE = 100;
        this.CARD_SUBTITLE_VISIBLE = false;
        this.CARD_SCORE_SIZE = 250;
        this.CARD_SCORE_VISIBLE = false;
        this.CARD_BONUS_SIZE = 100;
        this.CARD_BONUS_VISIBLE = false;
        this.CARD_BOTTOMBAR_SIZE = 80;
        this.CARD_BOTTOMBAR_VISIBLE = true;
        this.CARD_BOTTOMBAR_OFFSET_Y = 30;
    }

    private void setupDefaultBonusValues() {
        this.KILL_BONUS_DISPLAY = "\u51fb\u8d25\u751f\u7269 +{score}";
        this.ASSIST_BONUS_DISPLAY = "\u52a9\u653b\u51fb\u8d25 +{score}";
        this.CRITICAL_BONUS_DISPLAY = "\u66b4\u51fb\u52a0\u6210 +{score}";
        this.MAGIC_BONUS_DISPLAY = "\u9b54\u6cd5\u4f24\u5bb3 +{score}";
        this.HAND_BONUS_DISPLAY = "\u7a7a\u624b\u653b\u51fb +{score}";
        this.DAMAGE_BONUS_DISPLAY = "\u9020\u6210\u4f24\u5bb3 +{score}";
        this.LONGRANGE_BONUS_DISPLAY = "\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}";
        this.COMBO_BONUS_DISPLAY = "[6]{combo}[f] \u8fde\u6740 ! +{score}";
        this.BONUS_LINE_SPACING = 12;
    }

    private void setupDefaultColorValues() {
        WEAPON_COLOR = "008080";
        TARGET_COLOR = "008080";
        CRITICAL_COLOR = "FFD700";
        FLASHING_COLOR = "DCDCDC";
        HIGH_SCORE_COLOR = "FFD700";
    }

    private void setupDefaultSoundValues() {
        this.ENABLE_SOUND_EFFECTS = true;
        this.SOUND_VOLUME = 100;
    }

    private void setupDefaultComboValues() {
        this.COMBO_SCORE_DURATION = 2000;
        this.COMBO_SCORE_FONT_SCALE = 250;
        this.COMBO_TIMEOUT = 3;
        this.SCROLL_ANIMATION_SPEED = 0.2;
    }

    private void setupDefaultDebugValues() {
        this.DEBUG_SHOW_INFO = false;
        SCROLL_SENSITIVITY = 1.0;
    }

    public static void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(CONFIG_PATH);
                INSTANCE = (Config)GSON.fromJson(content, Config.class);
            } else {
                INSTANCE = new Config();
                Config.saveConfig();
            }
            Config.loadRuntimeVariables();
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u52a0\u8f7d\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            INSTANCE = new Config();
            Config.loadRuntimeVariables();
        }
    }

    public static void resetAllToDefaults() {
        try {
            INSTANCE = new Config();
            Config.loadRuntimeVariables();
            Config.safeSaveConfig();
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u91cd\u7f6e\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Config.loadConfig();
        }
    }

    private static int parseColor(String hex) {
        if (hex == null || hex.isEmpty()) {
            return -16744320;
        }
        try {
            Object cleanHex = hex.replace("#", "");
            if (((String)cleanHex).length() == 3) {
                cleanHex = "" + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(2) + ((String)cleanHex).charAt(2);
            }
            return (int)Long.parseLong("FF" + (String)cleanHex, 16);
        }
        catch (Exception e) {
            LOGGER.error("Invalid color format: {}", (Object)hex);
            return -16744320;
        }
    }

    public static void reloadCriticalColor() {
        criticalColor = Config.parseColor(CRITICAL_COLOR);
    }

    private static void safeSaveConfig() {
        try {
            if (INSTANCE == null) {
                INSTANCE = new Config();
            }
            String json = GSON.toJson((Object)INSTANCE);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u4fdd\u5b58\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
        }
    }

    public static void saveConfig() {
        Config.safeSaveConfig();
    }

    public static void loadRuntimeVariables() {
        if (INSTANCE == null) {
            return;
        }
        Config.loadGeneralConfigs();
        Config.loadPositionConfigs();
        Config.loadElementConfigs();
        Config.loadColorConfigs();
        Config.loadSoundConfigs();
        Config.reloadCriticalColor();
    }

    private static void loadGeneralConfigs() {
        killIconDuration = Config.INSTANCE.KILL_ICON_DURATION;
        killIconSize = Config.INSTANCE.KILL_ICON_SIZE;
        customSubtitleFormat = Config.INSTANCE.CUSTOM_SUBTITLE_FORMAT;
        soundVolume = Config.INSTANCE.SOUND_VOLUME;
        iconMode = Config.INSTANCE.ICON_MODE;
        iconStyle = Config.INSTANCE.ICON_STYLE;
        comboScoreDuration = Config.INSTANCE.COMBO_SCORE_DURATION;
        comboScoreFontScale = Config.INSTANCE.COMBO_SCORE_FONT_SCALE;
        comboTimeout = Config.INSTANCE.COMBO_TIMEOUT * 1000;
        scrollAnimationSpeed = Config.INSTANCE.SCROLL_ANIMATION_SPEED;
        comboTimeoutMs = Config.INSTANCE.COMBO_TIMEOUT * 1000;
        assistSubtitleFormat = Config.INSTANCE.ASSIST_SUBTITLE_FORMAT;
        killBonusDisplay = Config.INSTANCE.KILL_BONUS_DISPLAY;
        assistBonusDisplay = Config.INSTANCE.ASSIST_BONUS_DISPLAY;
        criticalBonusDisplay = Config.INSTANCE.CRITICAL_BONUS_DISPLAY;
        magicBonusDisplay = Config.INSTANCE.MAGIC_BONUS_DISPLAY;
        handBonusDisplay = Config.INSTANCE.HAND_BONUS_DISPLAY;
        damageBonusDisplay = Config.INSTANCE.DAMAGE_BONUS_DISPLAY;
        longrangeBonusDisplay = Config.INSTANCE.LONGRANGE_BONUS_DISPLAY;
        comboBonusDisplay = Config.INSTANCE.COMBO_BONUS_DISPLAY;
        killIconAnimationDuration = Config.INSTANCE.KILL_ICON_ANIMATION_DURATION;
        killIconSpacing = Config.INSTANCE.KILL_ICON_SPACING;
        forceHideCount = Config.INSTANCE.FORCE_HIDE_COUNT;
        maxDisplayCount = Config.INSTANCE.MAX_DISPLAY_COUNT;
        bonusLineSpacing = Config.INSTANCE.BONUS_LINE_SPACING;
        cardIconStyle = Config.INSTANCE.CARD_ICON_STYLE;
        enableSoundEffects = Config.INSTANCE.ENABLE_SOUND_EFFECTS;
        cardBottombarSize = Config.INSTANCE.CARD_BOTTOMBAR_SIZE;
        cardBottombarVisible = Config.INSTANCE.CARD_BOTTOMBAR_VISIBLE;
        cardBottombarOffsetY = Config.INSTANCE.CARD_BOTTOMBAR_OFFSET_Y;
        comboIconAnimationEnabled = Config.INSTANCE.COMBO_ICON_ANIMATION_ENABLED;
        comboIconAnimationDuration = Config.INSTANCE.COMBO_ICON_ANIMATION_DURATION;
        comboIconAnimationTotalFrames = Config.INSTANCE.COMBO_ICON_ANIMATION_TOTAL_FRAMES;
    }

    private static void loadPositionConfigs() {
        scrollIconX = Config.INSTANCE.SCROLL_ICON_X;
        scrollIconY = Config.INSTANCE.SCROLL_ICON_Y;
        scrollSubtitleX = Config.INSTANCE.SCROLL_SUBTITLE_X;
        scrollSubtitleY = Config.INSTANCE.SCROLL_SUBTITLE_Y;
        scrollScoreX = Config.INSTANCE.SCROLL_SCORE_X;
        scrollScoreY = Config.INSTANCE.SCROLL_SCORE_Y;
        scrollBonusX = Config.INSTANCE.SCROLL_BONUS_X;
        scrollBonusY = Config.INSTANCE.SCROLL_BONUS_Y;
        comboIconX = Config.INSTANCE.COMBO_ICON_X;
        comboIconY = Config.INSTANCE.COMBO_ICON_Y;
        comboSubtitleX = Config.INSTANCE.COMBO_SUBTITLE_X;
        comboSubtitleY = Config.INSTANCE.COMBO_SUBTITLE_Y;
        comboScoreX = Config.INSTANCE.COMBO_SCORE_X;
        comboScoreY = Config.INSTANCE.COMBO_SCORE_Y;
        comboBonusX = Config.INSTANCE.COMBO_BONUS_X;
        comboBonusY = Config.INSTANCE.COMBO_BONUS_Y;
        cardIconX = Config.INSTANCE.CARD_ICON_X;
        cardIconY = Config.INSTANCE.CARD_ICON_Y;
        cardSubtitleX = Config.INSTANCE.CARD_SUBTITLE_X;
        cardSubtitleY = Config.INSTANCE.CARD_SUBTITLE_Y;
        cardScoreX = Config.INSTANCE.CARD_SCORE_X;
        cardScoreY = Config.INSTANCE.CARD_SCORE_Y;
        cardBonusX = Config.INSTANCE.CARD_BONUS_X;
        cardBonusY = Config.INSTANCE.CARD_BONUS_Y;
    }

    private static void loadElementConfigs() {
        scrollIconSize = Config.INSTANCE.SCROLL_ICON_SIZE;
        scrollIconVisible = Config.INSTANCE.SCROLL_ICON_VISIBLE;
        scrollSubtitleSize = Config.INSTANCE.SCROLL_SUBTITLE_SIZE;
        scrollSubtitleVisible = Config.INSTANCE.SCROLL_SUBTITLE_VISIBLE;
        scrollScoreSize = Config.INSTANCE.SCROLL_SCORE_SIZE;
        scrollScoreVisible = Config.INSTANCE.SCROLL_SCORE_VISIBLE;
        scrollBonusSize = Config.INSTANCE.SCROLL_BONUS_SIZE;
        scrollBonusVisible = Config.INSTANCE.SCROLL_BONUS_VISIBLE;
        comboIconSize = Config.INSTANCE.COMBO_ICON_SIZE;
        comboIconVisible = Config.INSTANCE.COMBO_ICON_VISIBLE;
        comboSubtitleSize = Config.INSTANCE.COMBO_SUBTITLE_SIZE;
        comboSubtitleVisible = Config.INSTANCE.COMBO_SUBTITLE_VISIBLE;
        comboScoreSize = Config.INSTANCE.COMBO_SCORE_SIZE;
        comboScoreVisible = Config.INSTANCE.COMBO_SCORE_VISIBLE;
        comboBonusSize = Config.INSTANCE.COMBO_BONUS_SIZE;
        comboBonusVisible = Config.INSTANCE.COMBO_BONUS_VISIBLE;
        cardIconSize = Config.INSTANCE.CARD_ICON_SIZE;
        cardIconVisible = Config.INSTANCE.CARD_ICON_VISIBLE;
        cardSubtitleSize = Config.INSTANCE.CARD_SUBTITLE_SIZE;
        cardSubtitleVisible = Config.INSTANCE.CARD_SUBTITLE_VISIBLE;
        cardScoreSize = Config.INSTANCE.CARD_SCORE_SIZE;
        cardScoreVisible = Config.INSTANCE.CARD_SCORE_VISIBLE;
        cardBonusSize = Config.INSTANCE.CARD_BONUS_SIZE;
        cardBonusVisible = Config.INSTANCE.CARD_BONUS_VISIBLE;
    }

    private static void loadColorConfigs() {
        weaponColor = Config.parseColor(WEAPON_COLOR);
        targetColor = Config.parseColor(TARGET_COLOR);
        criticalColor = Config.parseColor(CRITICAL_COLOR);
        flashingColor = Config.parseColor(FLASHING_COLOR);
        highScoreColor = Config.parseColor(HIGH_SCORE_COLOR);
        weaponColorHex = Config.parseColor(WEAPON_COLOR);
        targetColorHex = Config.parseColor(TARGET_COLOR);
        criticalColorHex = Config.parseColor(CRITICAL_COLOR);
        flashingColorHex = Config.parseColor(FLASHING_COLOR);
        highScoreColorHex = Config.parseColor(HIGH_SCORE_COLOR);
    }

    private static void loadSoundConfigs() {
        enableSoundEffects = Config.INSTANCE.ENABLE_SOUND_EFFECTS;
        soundVolume = Config.INSTANCE.SOUND_VOLUME;
    }

    public static Config getInstance() {
        if (INSTANCE == null) {
            Config.loadConfig();
        }
        return INSTANCE;
    }

    public static void initialize() {
        Config.loadConfig();
    }

    static {
        weaponColor = -16744320;
        targetColor = -16744320;
        showKillIcons = true;
        showKillSubtitles = true;
        customSubtitleFormat = "\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}";
        soundVolume = 100;
        iconMode = IconMode.SCROLLING;
        iconStyle = IconStyle.MODERN;
        cardIconStyle = IconStyle.MODERN;
        showComboScore = true;
        comboScoreDuration = 2000;
        comboScoreFontScale = 250;
        flashingColor = -2302756;
        highScoreColor = -10496;
        comboTimeout = 3;
        scrollAnimationSpeed = 0.2;
        assistSubtitleFormat = "\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}";
        debugShowInfo = false;
        weaponColorHex = -16744320;
        targetColorHex = -16744320;
        criticalColorHex = -10496;
        flashingColorHex = -2302756;
        highScoreColorHex = -10496;
        enableSoundEffects = true;
    }

    public static enum IconMode {
        SCROLLING("gd656killicon.config.mode.scrolling"),
        COMBO("gd656killicon.config.mode.combo"),
        CARD("gd656killicon.config.mode.card");

        private final String translationKey;

        private IconMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum IconStyle {
        VANILLA("gd656killicon.config.style.vanilla"),
        MODERN("gd656killicon.config.style.modern");

        private final String translationKey;

        private IconStyle(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

