/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.configmodules.BonusConfigModule;
import org.mods.gd656killicon.client.configmodules.CardIconConfigModule;
import org.mods.gd656killicon.client.configmodules.ComboKillIconConfigModule;
import org.mods.gd656killicon.client.configmodules.KillIconConfigModule;
import org.mods.gd656killicon.client.configmodules.ScoreConfigModule;
import org.mods.gd656killicon.client.configmodules.SubtitleConfigModule;

public class ElementConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ModConfigScreen.DraggableElement element;
    private OptionsList list;
    public OptionsList.BooleanOptionEntry elementVisible;
    public OptionsList.SliderOptionEntry elementSize;
    private KillIconConfigModule killIconConfigModule;
    private SubtitleConfigModule subtitleConfigModule;
    private ScoreConfigModule scoreConfigModule;
    private BonusConfigModule bonusConfigModule;
    private CardIconConfigModule cardIconConfigModule;
    private ComboKillIconConfigModule comboKillIconConfigModule;
    private static final int ITEM_HEIGHT = 15;
    private static final int SLIDER_WIDTH = 100;
    private static final int SLIDER_HEIGHT = 20;

    public ElementConfigScreen(class_437 parent, ModConfigScreen.DraggableElement element) {
        super((class_2561)class_2561.method_43471((String)"gd656killicon.elementconfig.title"));
        this.parent = parent;
        this.element = element;
    }

    protected void method_25426() {
        super.method_25426();
        int listTop = 32;
        int listBottom = this.field_22790 - 64;
        int listHeight = listBottom - listTop;
        this.list = new OptionsList(this.field_22787, this.field_22789, listHeight, listTop, 15);
        this.method_25429((class_364)this.list);
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)("\u5143\u7d20\u914d\u7f6e: " + this.element.name))));
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        int minSize = 16;
        int maxSize = 500;
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            maxSize = 96;
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            minSize = 50;
            maxSize = 200;
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            minSize = 100;
        }
        this.elementSize = new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u5143\u7d20\u5927\u5c0f"), minSize, maxSize, this.getCurrentElementSize(this.element.type));
        this.list.addEntryPublic(this.elementSize);
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.elementVisible = new OptionsList.BooleanOptionEntry((class_2561)class_2561.method_43470((String)"\u6e38\u620f\u4e2d\u663e\u793a"), this.getCurrentElementVisible(this.element.type));
        this.list.addEntryPublic(this.elementVisible);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            this.addPrivateConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE) {
            this.addSubtitleConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            this.addScoreConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.BONUS) {
            this.addBonusConfigOptions();
        }
        int buttonWidth = 100;
        int buttonSpacing = 10;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.saveConfig();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(startX, buttonY, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(startX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).method_46431());
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            String sharedText = switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> "\u6eda\u52a8\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
                case Config.IconMode.COMBO -> "\u8fde\u6740\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
                case Config.IconMode.CARD -> "\u5361\u724c\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
            };
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51433(this.field_22793, sharedText, 10, this.field_22790 - 9 - 10, 0x888888, true);
        }
        if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.SCORE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51433(this.field_22793, "\u4e09\u6a21\u5f0f\u5171\u7528", 10, this.field_22790 - 9 - 10, 0x888888, true);
        }
        if (this.list != null) {
            this.list.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void addPrivateConfigOptions() {
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            switch (Config.iconMode) {
                case CARD: {
                    this.cardIconConfigModule = new CardIconConfigModule(this.list);
                    this.cardIconConfigModule.addConfigOptions();
                    break;
                }
                case COMBO: {
                    this.comboKillIconConfigModule = new ComboKillIconConfigModule(this.list);
                    this.comboKillIconConfigModule.addConfigOptions();
                    break;
                }
                default: {
                    this.killIconConfigModule = new KillIconConfigModule(this.list);
                    this.killIconConfigModule.addConfigOptions();
                }
            }
        }
    }

    private void addSubtitleConfigOptions() {
        this.subtitleConfigModule = new SubtitleConfigModule(this.list);
        this.subtitleConfigModule.addConfigOptions();
    }

    private void addScoreConfigOptions() {
        this.scoreConfigModule = new ScoreConfigModule(this.list);
        this.scoreConfigModule.addConfigOptions();
    }

    private void addBonusConfigOptions() {
        this.bonusConfigModule = new BonusConfigModule(this.list);
        this.bonusConfigModule.addConfigOptions();
    }

    private int getCurrentElementSize(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconSize;
                case Config.IconMode.COMBO -> Config.comboIconSize;
                case Config.IconMode.CARD -> Config.cardIconSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleSize;
                case Config.IconMode.COMBO -> Config.comboSubtitleSize;
                case Config.IconMode.CARD -> Config.cardSubtitleSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreSize;
                case Config.IconMode.COMBO -> Config.comboScoreSize;
                case Config.IconMode.CARD -> Config.cardScoreSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusSize;
                case Config.IconMode.COMBO -> Config.comboBonusSize;
                case Config.IconMode.CARD -> Config.cardBonusSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BOTTOMBAR) {
            return Config.cardBottombarSize;
        }
        return 100;
    }

    private boolean getCurrentElementVisible(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconVisible;
                case Config.IconMode.COMBO -> Config.comboIconVisible;
                case Config.IconMode.CARD -> Config.cardIconVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleVisible;
                case Config.IconMode.COMBO -> Config.comboSubtitleVisible;
                case Config.IconMode.CARD -> Config.cardSubtitleVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreVisible;
                case Config.IconMode.COMBO -> Config.comboScoreVisible;
                case Config.IconMode.CARD -> Config.cardScoreVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusVisible;
                case Config.IconMode.COMBO -> Config.comboBonusVisible;
                case Config.IconMode.CARD -> Config.cardBonusVisible;
            };
        }
        return true;
    }

    private void saveConfig() {
        int newSize = this.elementSize.getValue();
        boolean newVisible = this.elementVisible.getValue();
        Config config = Config.getInstance();
        switch (this.element.type) {
            case ICON: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        config.SCROLL_ICON_SIZE = newSize;
                        config.SCROLL_ICON_VISIBLE = newVisible;
                        Config.scrollIconSize = newSize;
                        Config.scrollIconVisible = newVisible;
                        if (this.killIconConfigModule == null) break;
                        this.killIconConfigModule.saveConfig();
                        break;
                    }
                    case COMBO: {
                        config.COMBO_ICON_SIZE = newSize;
                        config.COMBO_ICON_VISIBLE = newVisible;
                        Config.comboIconSize = newSize;
                        Config.comboIconVisible = newVisible;
                        if (this.comboKillIconConfigModule == null) break;
                        this.comboKillIconConfigModule.saveConfig();
                        break;
                    }
                    case CARD: {
                        config.CARD_ICON_SIZE = newSize;
                        config.CARD_ICON_VISIBLE = newVisible;
                        Config.cardIconSize = newSize;
                        Config.cardIconVisible = newVisible;
                        if (this.cardIconConfigModule == null) break;
                        this.cardIconConfigModule.saveConfig();
                        if (this.cardIconConfigModule.bottombarVisibleEntry == null || this.cardIconConfigModule.bottombarSizeEntry == null) break;
                        config.CARD_BOTTOMBAR_VISIBLE = this.cardIconConfigModule.bottombarVisibleEntry.getValue();
                        config.CARD_BOTTOMBAR_SIZE = this.cardIconConfigModule.bottombarSizeEntry.getValue();
                        Config.cardBottombarVisible = this.cardIconConfigModule.bottombarVisibleEntry.getValue();
                        Config.cardBottombarSize = this.cardIconConfigModule.bottombarSizeEntry.getValue();
                    }
                }
                break;
            }
            case SUBTITLE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        config.SCROLL_SUBTITLE_SIZE = newSize;
                        config.SCROLL_SUBTITLE_VISIBLE = newVisible;
                        Config.scrollSubtitleSize = newSize;
                        Config.scrollSubtitleVisible = newVisible;
                        break;
                    }
                    case COMBO: {
                        config.COMBO_SUBTITLE_SIZE = newSize;
                        config.COMBO_SUBTITLE_VISIBLE = newVisible;
                        Config.comboSubtitleSize = newSize;
                        Config.comboSubtitleVisible = newVisible;
                        break;
                    }
                    case CARD: {
                        config.CARD_SUBTITLE_SIZE = newSize;
                        config.CARD_SUBTITLE_VISIBLE = newVisible;
                        Config.cardSubtitleSize = newSize;
                        Config.cardSubtitleVisible = newVisible;
                    }
                }
                if (this.subtitleConfigModule == null) break;
                this.subtitleConfigModule.saveConfig();
                break;
            }
            case SCORE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        config.SCROLL_SCORE_SIZE = newSize;
                        config.SCROLL_SCORE_VISIBLE = newVisible;
                        Config.scrollScoreSize = newSize;
                        Config.scrollScoreVisible = newVisible;
                        break;
                    }
                    case COMBO: {
                        config.COMBO_SCORE_SIZE = newSize;
                        config.COMBO_SCORE_VISIBLE = newVisible;
                        Config.comboScoreSize = newSize;
                        Config.comboScoreVisible = newVisible;
                        break;
                    }
                    case CARD: {
                        config.CARD_SCORE_SIZE = newSize;
                        config.CARD_SCORE_VISIBLE = newVisible;
                        Config.cardScoreSize = newSize;
                        Config.cardScoreVisible = newVisible;
                    }
                }
                if (this.scoreConfigModule == null) break;
                this.scoreConfigModule.saveConfig();
                break;
            }
            case BONUS: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        config.SCROLL_BONUS_SIZE = newSize;
                        config.SCROLL_BONUS_VISIBLE = newVisible;
                        Config.scrollBonusSize = newSize;
                        Config.scrollBonusVisible = newVisible;
                        break;
                    }
                    case COMBO: {
                        config.COMBO_BONUS_SIZE = newSize;
                        config.COMBO_BONUS_VISIBLE = newVisible;
                        Config.comboBonusSize = newSize;
                        Config.comboBonusVisible = newVisible;
                        break;
                    }
                    case CARD: {
                        config.CARD_BONUS_SIZE = newSize;
                        config.CARD_BONUS_VISIBLE = newVisible;
                        Config.cardBonusSize = newSize;
                        Config.cardBonusVisible = newVisible;
                    }
                }
                if (this.bonusConfigModule == null) break;
                this.bonusConfigModule.saveConfig();
            }
        }
        Config.saveConfig();
        Config.loadConfig();
        if (this.parent instanceof ModConfigScreen) {
            ((ModConfigScreen)this.parent).updateElementSizes();
        }
    }

    public static class OptionsList
    extends class_4265<Entry> {
        public OptionsList(class_310 minecraft, int width, int height, int y0, int itemHeight) {
            super(minecraft, width, height, y0, y0 + height, itemHeight);
            this.method_31322(false);
            this.method_31323(false);
        }

        public void addEntryPublic(Entry entry) {
            this.method_25321((class_350.class_351)entry);
        }

        public static class EditBoxOptionEntry
        extends Entry {
            private final class_342 editBox;
            private final class_2561 label;
            private final boolean isColorOption;

            public EditBoxOptionEntry(class_2561 label, String initialValue, int width) {
                this(label, initialValue, width, false);
            }

            public EditBoxOptionEntry(class_2561 label, String initialValue, int width, boolean isColorOption) {
                this.label = label;
                this.isColorOption = isColorOption;
                this.editBox = new class_342(class_310.method_1551().field_1772, 0, 0, width, 20, (class_2561)class_2561.method_43473());
                this.editBox.method_1852(initialValue);
                this.editBox.method_1880(isColorOption ? 6 : 256);
                this.editBox.method_25365(true);
                this.editBox.method_1856(true);
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.method_27535(class_310.method_1551().field_1772, this.label, left + 10, top + 5, 0xFFFFFF);
                if (this.isColorOption) {
                    int colorValue;
                    this.editBox.method_46421(left + width - 150 + 75);
                    this.editBox.method_46419(top + -2);
                    this.editBox.method_25358(75);
                    this.editBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    int colorBoxX = left + width - 150 + 130;
                    int colorBoxSize = 20;
                    int colorBoxY = top + -2;
                    String colorText = this.editBox.method_1882();
                    try {
                        String colorStr = "FF" + colorText.replace("#", "");
                        colorValue = (int)Long.parseLong(colorStr, 16);
                    }
                    catch (Exception e) {
                        colorValue = -1;
                    }
                    guiGraphics.method_25294(colorBoxX, colorBoxY, colorBoxX + colorBoxSize, colorBoxY + colorBoxSize, colorValue);
                    guiGraphics.method_49601(colorBoxX, colorBoxY, colorBoxSize, colorBoxSize, -16777216);
                } else {
                    this.editBox.method_46421(left + width - 150 + 50);
                    this.editBox.method_46419(top + -2);
                    this.editBox.method_25358(100);
                    this.editBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            public String getValue() {
                return this.editBox.method_1882();
            }

            @NotNull
            public List<class_339> method_25396() {
                return List.of(this.editBox);
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of(this.editBox);
            }
        }

        public static class IconStyleOptionEntry
        extends Entry {
            private final class_5676<Config.IconStyle> styleButton;
            private final class_2561 label;

            public IconStyleOptionEntry(class_2561 label, Config.IconStyle initialValue) {
                this.label = label;
                this.styleButton = class_5676.method_32606(style -> class_2561.method_43471((String)style.getTranslationKey())).method_32624((Object[])Config.IconStyle.values()).method_32619((Object)initialValue).method_32617(0, 0, 100, 20, (class_2561)class_2561.method_43473(), (button, style) -> class_2561.method_43471((String)style.getTranslationKey()));
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.method_27535(class_310.method_1551().field_1772, this.label, left + 10, top + 5, 0xFFFFFF);
                this.styleButton.method_46421(left + width - 100 - 10);
                this.styleButton.method_46419(top + -2);
                this.styleButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconStyle getValue() {
                return (Config.IconStyle)((Object)this.styleButton.method_32603());
            }

            @NotNull
            public List<class_339> method_25396() {
                return List.of(this.styleButton);
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of(this.styleButton);
            }
        }

        public static class SliderOptionEntry
        extends Entry {
            private final CustomSlider slider;
            private final class_2561 label;

            public SliderOptionEntry(class_2561 label, int min, int max, int initialValue) {
                this.label = label;
                this.slider = new CustomSlider(0, 0, 100, 20, (class_2561)class_2561.method_43473(), (double)(initialValue - min) / (double)(max - min), min, max);
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.method_27535(class_310.method_1551().field_1772, this.label, left + 10, top + 5, 0xFFFFFF);
                this.slider.method_46421(left + width - 100 - 10);
                this.slider.method_46419(top + -2);
                this.slider.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            public int getValue() {
                return this.slider.getIntValue();
            }

            @NotNull
            public List<class_339> method_25396() {
                return List.of(this.slider);
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of(this.slider);
            }

            public static class CustomSlider
            extends class_357 {
                private final int min;
                private final int max;

                public CustomSlider(int x, int y, int width, int height, class_2561 message, double value, int min, int max) {
                    super(x, y, width, height, message, value);
                    this.min = min;
                    this.max = max;
                    this.method_25346();
                }

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.getIntValue())));
                }

                protected void method_25344() {
                }

                public int getIntValue() {
                    return this.min + (int)(this.field_22753 * (double)(this.max - this.min));
                }
            }
        }

        public static class BooleanOptionEntry
        extends Entry {
            private final class_4286 checkbox;
            private final class_2561 label;

            public BooleanOptionEntry(class_2561 label, boolean initialValue) {
                this.label = label;
                this.checkbox = new class_4286(0, 0, 20, 20, (class_2561)class_2561.method_43473(), initialValue);
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.method_27535(class_310.method_1551().field_1772, this.label, left + 10, top + 5, 0xFFFFFF);
                this.checkbox.method_46421(left + width - 30);
                this.checkbox.method_46419(top);
                this.checkbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean getValue() {
                return this.checkbox.method_20372();
            }

            @NotNull
            public List<class_339> method_25396() {
                return List.of(this.checkbox);
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of(this.checkbox);
            }
        }

        public static class CategoryEntry
        extends Entry {
            private final class_2561 text;

            public CategoryEntry(class_2561 text) {
                this.text = text;
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.method_27534(class_310.method_1551().field_1772, this.text, left + width / 2, top + 5, 0xFFFFFF);
            }

            @NotNull
            public List<class_339> method_25396() {
                return List.of();
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        public static class SpacerEntry
        extends Entry {
            public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            }

            @NotNull
            public List<class_339> method_25396() {
                return List.of();
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        public static abstract class Entry
        extends class_4265.class_4266<Entry> {
        }
    }
}

