/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ConfigScreen;
import org.mods.gd656killicon.client.ElementConfigScreen;
import org.mods.gd656killicon.client.MenuManager;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.ScoreRequestPacket;

public class ModConfigScreen
extends class_437 {
    private final class_437 parent;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 80;
    private static final int MAX_UNDO_HISTORY = 10;
    private static final int MENU_BUTTON_SIZE = 20;
    private static final int MODE_BUTTON_HEIGHT = 20;
    private static final int MODE_BUTTON_WIDTH = 60;
    private static final int PADDING = 10;
    private static final int TITLE_HEIGHT = 20;
    private static final long RESET_CONFIRMATION_TIMEOUT = 3000L;
    private static final long SCORE_UPDATE_INTERVAL = 5000L;
    private final List<CustomButton> customMenuButtons = new ArrayList<CustomButton>();
    private final List<DraggableElement> draggableElements = new ArrayList<DraggableElement>();
    private final class_4185[] modeButtons = new class_4185[3];
    private final List<MoveOperation> undoHistory = new ArrayList<MoveOperation>();
    private class_4185 menuButton;
    private class_4185 resetButton;
    private class_4185 undoButton;
    private DraggableElement selectedElement = null;
    private EditMode currentEditMode = EditMode.SCROLL;
    private int currentScore = 0;
    private boolean canUndo = false;
    private boolean isMenuExpanded = false;
    private boolean resetConfirmation = false;
    private long lastScoreUpdateTime = 0L;
    private long resetConfirmationTime = 0L;

    public ModConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.requestScoreUpdate();
        this.initializeDraggableElements();
        this.menuButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2261"), button -> this.toggleMenu()).method_46434(10, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.menuButton);
        this.updateScoreText();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.details"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConfigScreen(this));
            }
        }).method_46434(this.field_22789 - 80 - 10, 10, 80, 20).method_46431());
        this.initCustomMenuButtons();
        int modeButtonsStartX = this.field_22789 - 60 - 10;
        int modeButtonsStartY = 40;
        this.modeButtons[0] = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u6eda\u52a8"), button -> this.switchEditMode(EditMode.SCROLL)).method_46434(modeButtonsStartX, modeButtonsStartY, 60, 20).method_46431();
        this.modeButtons[1] = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u8fde\u6740"), button -> this.switchEditMode(EditMode.COMBO)).method_46434(modeButtonsStartX, modeButtonsStartY + 20 + 5, 60, 20).method_46431();
        this.modeButtons[2] = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u5361\u724c"), button -> this.switchEditMode(EditMode.CARD)).method_46434(modeButtonsStartX, modeButtonsStartY + 50, 60, 20).method_46431();
        this.updateModeButtons();
        for (class_4185 button2 : this.modeButtons) {
            this.method_37063((class_364)button2);
        }
        int bottomButtonY = this.field_22790 - 20 - 10;
        int buttonSpacing = 10;
        int totalButtonsWidth = 240 + buttonSpacing * 2;
        int buttonsStartX = this.field_22789 - totalButtonsWidth - 10;
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.reset"), button -> this.handleResetButton()).method_46434(buttonsStartX, bottomButtonY, 80, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.undoButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.undo"), button -> this.handleUndoButton()).method_46434(buttonsStartX + 80 + buttonSpacing, bottomButtonY, 80, 20).method_46431();
        this.method_37063((class_364)this.undoButton);
        this.updateUndoButtonState();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.save"), button -> {
            this.savePositionsToConfig();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(buttonsStartX + (80 + buttonSpacing) * 2, bottomButtonY, 80, 20).method_46431());
    }

    public void method_25419() {
        this.savePositionsToConfig();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        if (System.currentTimeMillis() - this.lastScoreUpdateTime > 5000L) {
            this.requestScoreUpdate();
        }
        if (this.resetConfirmation && System.currentTimeMillis() - this.resetConfirmationTime > 3000L) {
            this.resetConfirmation = false;
            this.resetButton.method_25355((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.reset"));
        }
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        String modeText = "\u5f53\u524d\u6a21\u5f0f: " + this.currentEditMode.displayName;
        guiGraphics.method_51433(this.field_22793, modeText, this.field_22789 / 2 - this.field_22793.method_1727(modeText) / 2, 40, this.currentEditMode.color, true);
        class_5250 label = class_2561.method_43470((String)"\u60a8\u5728\u6b64\u670d\u52a1\u5668\u7684\u603b\u5206\u6570: ").method_27694(style -> style.method_36139(-1));
        String scoreText = String.valueOf(this.currentScore);
        int labelX = 40;
        int scoreX = labelX + this.field_22793.method_27525((class_5348)label) + 5;
        guiGraphics.method_51439(this.field_22793, (class_2561)label, labelX, 16, -1, true);
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)scoreText).method_27694(style -> style.method_36139(-65536).method_10982(Boolean.valueOf(true))), scoreX, 16, -65536, true);
        if (this.isMenuExpanded) {
            this.renderCustomButtons(guiGraphics, mouseX, mouseY);
        }
        this.renderDraggableElements(guiGraphics, mouseX, mouseY);
        String versionText = "v1.0.0 \u516c\u6d4b\u7248 RC5 *Fabric*";
        Objects.requireNonNull(this.field_22793);
        guiGraphics.method_51433(this.field_22793, versionText, 10, this.field_22790 - 9 - 10, 0x888888, true);
        String instruction = "\u5de6\u952e\u62d6\u52a8\u8c03\u6574\u4f4d\u7f6e | \u53f3\u952e\u70b9\u51fb\u914d\u7f6e\u5143\u7d20";
        Objects.requireNonNull(this.field_22793);
        guiGraphics.method_51433(this.field_22793, instruction, 10, this.field_22790 - 9 * 2 - 10 - 5, 0xCCCCCC, true);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMenuExpanded && button == 0) {
            boolean clickedOnButton = false;
            for (CustomButton customButton : this.customMenuButtons) {
                if (!customButton.contains((int)mouseX, (int)mouseY)) continue;
                customButton.onClick.run();
                clickedOnButton = true;
                break;
            }
            if (!clickedOnButton) {
                boolean clickedMenuButton;
                boolean bl = clickedMenuButton = mouseX >= 10.0 && mouseX <= 30.0 && mouseY >= 10.0 && mouseY <= 30.0;
                if (!clickedMenuButton) {
                    this.toggleMenu();
                    return true;
                }
            }
            if (clickedOnButton) {
                return true;
            }
        }
        if (button == 1) {
            for (DraggableElement element : this.draggableElements) {
                if (!element.contains((int)mouseX, (int)mouseY, this.field_22789, this.field_22790)) continue;
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new ElementConfigScreen(this, element));
                }
                return true;
            }
        }
        if (button == 0) {
            for (DraggableElement element : this.draggableElements) {
                if (!element.contains((int)mouseX, (int)mouseY, this.field_22789, this.field_22790)) continue;
                this.selectedElement = element;
                int oldX = element.x;
                int oldY = element.y;
                element.setDragOffset((int)mouseX, (int)mouseY, this.field_22789, this.field_22790);
                this.selectedElement.setUserData(new int[]{oldX, oldY});
                return true;
            }
            this.selectedElement = null;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.selectedElement != null && button == 0) {
            this.selectedElement.setPositionFromMouse((int)mouseX, (int)mouseY, this.field_22789, this.field_22790);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.selectedElement != null && button == 0) {
            int[] oldPos = (int[])this.selectedElement.getUserData();
            if (oldPos != null) {
                int oldX = oldPos[0];
                int oldY = oldPos[1];
                int newX = this.selectedElement.x;
                int newY = this.selectedElement.y;
                this.recordMoveOperation(this.selectedElement.type, oldX, oldY, newX, newY);
                this.selectedElement.setUserData(null);
            }
            this.savePositionsToConfig();
            this.selectedElement = null;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void updateCurrentScore(int score) {
        this.currentScore = score;
    }

    private void clearUndoHistory() {
        this.undoHistory.clear();
        this.updateUndoButtonState();
    }

    private int getCurrentPosition(ElementType type, boolean isX) {
        return switch (this.currentEditMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.getScrollPosition(type, isX);
            case 1 -> this.getComboPosition(type, isX);
            case 2 -> this.getCardPosition(type, isX);
        };
    }

    private EditMode getEditModeForIndex(int index) {
        return switch (index) {
            case 1 -> EditMode.COMBO;
            case 2 -> EditMode.CARD;
            default -> EditMode.SCROLL;
        };
    }

    private int getElementSize(ElementType type) {
        return switch (this.currentEditMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 2: {
                        yield Config.scrollIconSize;
                    }
                    case 4: {
                        yield Config.scrollSubtitleSize;
                    }
                    case 3: {
                        yield Config.scrollScoreSize;
                    }
                    case 0: {
                        yield Config.scrollBonusSize;
                    }
                    case 1: 
                }
                yield 100;
            }
            case 1 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 2: {
                        yield Config.comboIconSize;
                    }
                    case 4: {
                        yield Config.comboSubtitleSize;
                    }
                    case 3: {
                        yield Config.comboScoreSize;
                    }
                    case 0: {
                        yield Config.comboBonusSize;
                    }
                    case 1: 
                }
                yield 100;
            }
            case 2 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 2: {
                        yield Config.cardIconSize;
                    }
                    case 4: {
                        yield Config.cardSubtitleSize;
                    }
                    case 3: {
                        yield Config.cardScoreSize;
                    }
                    case 0: {
                        yield Config.cardBonusSize;
                    }
                    case 1: 
                }
                yield Config.cardBottombarSize;
            }
        };
    }

    private boolean getElementVisible(ElementType type) {
        return switch (this.currentEditMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 2: {
                        yield Config.scrollIconVisible;
                    }
                    case 4: {
                        yield Config.scrollSubtitleVisible;
                    }
                    case 3: {
                        yield Config.scrollScoreVisible;
                    }
                    case 0: {
                        yield Config.scrollBonusVisible;
                    }
                    case 1: 
                }
                yield false;
            }
            case 1 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 2: {
                        yield Config.comboIconVisible;
                    }
                    case 4: {
                        yield Config.comboSubtitleVisible;
                    }
                    case 3: {
                        yield Config.comboScoreVisible;
                    }
                    case 0: {
                        yield Config.comboBonusVisible;
                    }
                    case 1: 
                }
                yield false;
            }
            case 2 -> {
                switch (type.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 2: {
                        yield Config.cardIconVisible;
                    }
                    case 4: {
                        yield Config.cardSubtitleVisible;
                    }
                    case 3: {
                        yield Config.cardScoreVisible;
                    }
                    case 0: {
                        yield Config.cardBonusVisible;
                    }
                    case 1: 
                }
                yield Config.cardBottombarVisible;
            }
        };
    }

    private void handleCustomMenuButtonClick(String buttonLabel) {
        MenuManager menuManager = MenuManager.getInstance();
        switch (buttonLabel) {
            case "\u6392\u884c\u699c": {
                menuManager.openRankingList(this);
                break;
            }
            case "\u5386\u53f2\u8bb0\u5f55": {
                menuManager.openHistoryRecord(this);
                break;
            }
            case "\u8bbe\u7f6e": {
                menuManager.openMoreSettings(this);
                break;
            }
            case "\u5e2e\u52a9": {
                menuManager.openHelp(this);
                break;
            }
            case "\u5173\u4e8e": {
                menuManager.openAbout(this);
                break;
            }
            case "\u53cd\u9988": {
                menuManager.openFeedback(this);
            }
        }
        this.toggleMenu();
    }

    private void handleResetButton() {
        if (this.resetConfirmation) {
            Config.resetAllToDefaults();
            this.clearUndoHistory();
            this.initializeDraggableElements();
            this.resetConfirmation = false;
            this.resetButton.method_25355((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.reset"));
        } else {
            this.resetConfirmation = true;
            this.resetConfirmationTime = System.currentTimeMillis();
            this.resetButton.method_25355((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.reset_confirm"));
        }
    }

    private void handleUndoButton() {
        if (this.canUndo && !this.undoHistory.isEmpty()) {
            this.undoLastMove();
        }
    }

    private void initCustomMenuButtons() {
        this.customMenuButtons.clear();
        int buttonY = 40;
        int buttonHeight = 20;
        int buttonWidth = buttonHeight * 5;
        String[] buttonLabels = new String[]{"\u6392\u884c\u699c", "\u5386\u53f2\u8bb0\u5f55", "\u8bbe\u7f6e", "\u5e2e\u52a9", "\u5173\u4e8e", "\u53cd\u9988"};
        int i = 0;
        while (i < buttonLabels.length) {
            int currentY = buttonY + i * buttonHeight;
            int finalI = i++;
            CustomButton button = new CustomButton(buttonLabels[finalI], 10, currentY, buttonWidth, buttonHeight, () -> this.handleCustomMenuButtonClick(buttonLabels[finalI]));
            this.customMenuButtons.add(button);
        }
    }

    private void initializeDraggableElements() {
        this.draggableElements.clear();
        int iconBaseWidth = 70;
        int iconBaseHeight = 70;
        int subtitleBaseWidth = 200;
        int subtitleBaseHeight = 40;
        int scoreBaseWidth = 60;
        int scoreBaseHeight = 40;
        int bonusBaseWidth = 60;
        int bonusBaseHeight = 50;
        int iconConfigSize = this.getElementSize(ElementType.ICON);
        int subtitleConfigSize = this.getElementSize(ElementType.SUBTITLE);
        int scoreConfigSize = this.getElementSize(ElementType.SCORE);
        int bonusConfigSize = this.getElementSize(ElementType.BONUS);
        float iconScale = (float)iconConfigSize / 32.0f;
        float subtitleScale = (float)subtitleConfigSize / 100.0f;
        float scoreScale = (float)scoreConfigSize / 250.0f;
        float bonusScale = (float)bonusConfigSize / 100.0f;
        int iconWidth = (int)((float)iconBaseWidth * iconScale);
        int iconHeight = (int)((float)iconBaseHeight * iconScale);
        int subtitleWidth = (int)((float)subtitleBaseWidth * subtitleScale);
        int subtitleHeight = (int)((float)subtitleBaseHeight * subtitleScale);
        int scoreWidth = (int)((float)scoreBaseWidth * scoreScale);
        int scoreHeight = (int)((float)scoreBaseHeight * scoreScale);
        int bonusWidth = (int)((float)bonusBaseWidth * bonusScale);
        int bonusHeight = (int)((float)bonusBaseHeight * bonusScale);
        this.draggableElements.add(new DraggableElement("\u51fb\u6740\u56fe\u6807", ElementType.ICON, this.getCurrentPosition(ElementType.ICON, true), this.getCurrentPosition(ElementType.ICON, false), iconWidth, iconHeight, true));
        this.draggableElements.add(new DraggableElement("\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55", ElementType.SUBTITLE, this.getCurrentPosition(ElementType.SUBTITLE, true), this.getCurrentPosition(ElementType.SUBTITLE, false), subtitleWidth, subtitleHeight, true));
        this.draggableElements.add(new DraggableElement("\u5206\u6570\u5b57\u5e55", ElementType.SCORE, this.getCurrentPosition(ElementType.SCORE, true), this.getCurrentPosition(ElementType.SCORE, false), scoreWidth, scoreHeight, true));
        this.draggableElements.add(new DraggableElement("\u52a0\u5206\u9879\u5b57\u5e55", ElementType.BONUS, this.getCurrentPosition(ElementType.BONUS, true), this.getCurrentPosition(ElementType.BONUS, false), bonusWidth, bonusHeight, true));
        switch (Config.iconMode) {
            case SCROLLING: {
                this.currentEditMode = EditMode.SCROLL;
                break;
            }
            case COMBO: {
                this.currentEditMode = EditMode.COMBO;
                break;
            }
            case CARD: {
                this.currentEditMode = EditMode.CARD;
            }
        }
        this.loadPositionsFromConfig();
    }

    private void loadPositionsFromConfig() {
        for (DraggableElement element : this.draggableElements) {
            switch (this.currentEditMode.ordinal()) {
                case 0: {
                    element.x = this.getScrollPosition(element.type, true);
                    element.y = this.getScrollPosition(element.type, false);
                    break;
                }
                case 1: {
                    element.x = this.getComboPosition(element.type, true);
                    element.y = this.getComboPosition(element.type, false);
                    break;
                }
                case 2: {
                    element.x = this.getCardPosition(element.type, true);
                    element.y = this.getCardPosition(element.type, false);
                }
            }
        }
    }

    private void recordMoveOperation(ElementType elementType, int oldX, int oldY, int newX, int newY) {
        if (oldX == newX && oldY == newY) {
            return;
        }
        MoveOperation operation = new MoveOperation(this.currentEditMode, elementType, oldX, oldY, newX, newY);
        this.undoHistory.add(operation);
        if (this.undoHistory.size() > 10) {
            this.undoHistory.remove(0);
        }
        this.updateUndoButtonState();
    }

    private void renderCustomButtons(class_332 guiGraphics, int mouseX, int mouseY) {
        for (CustomButton button : this.customMenuButtons) {
            button.render(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderDraggableElements(class_332 guiGraphics, int mouseX, int mouseY) {
        for (DraggableElement element : this.draggableElements) {
            int drawX = this.field_22789 / 2 + element.x - element.width / 2;
            int drawY = this.field_22790 + element.y - element.height / 2;
            int borderColor = this.currentEditMode.color;
            int fillColor = borderColor & 0xFFFFFF | Integer.MIN_VALUE;
            boolean isVisible = this.getElementVisible(element.type);
            if (!isVisible) {
                fillColor = borderColor & 0xFFFFFF | 0x40000000;
            }
            guiGraphics.method_25294(drawX, drawY, drawX + element.width, drawY + element.height, fillColor);
            guiGraphics.method_49601(drawX, drawY, element.width, element.height, borderColor);
            String nameText = element.name;
            String coordText = "(" + element.x + ", " + element.y + ")";
            int nameWidth = this.field_22793.method_1727(nameText);
            int coordWidth = this.field_22793.method_1727(coordText);
            Objects.requireNonNull(this.field_22793);
            int totalTextHeight = 9 * 2 + 5;
            int textStartY = drawY + (element.height - totalTextHeight) / 2;
            guiGraphics.method_51433(this.field_22793, nameText, drawX + element.width / 2 - nameWidth / 2, textStartY, -1, true);
            int n = drawX + element.width / 2 - coordWidth / 2;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51433(this.field_22793, coordText, n, textStartY + 9 + 5, -1, true);
            this.drawEyeIcon(guiGraphics, drawX, drawY, element.width, isVisible);
            if (element.contains(mouseX, mouseY, this.field_22789, this.field_22790)) {
                guiGraphics.method_49601(drawX - 1, drawY - 1, element.width + 2, element.height + 2, -1);
            }
            if (element == this.selectedElement) {
                guiGraphics.method_49601(drawX - 2, drawY - 2, element.width + 4, element.height + 4, -256);
            }
            if (!this.isElementOutOfBounds(element, this.field_22789, this.field_22790)) continue;
            String warningText = "!";
            int warningWidth = this.field_22793.method_1727(warningText);
            guiGraphics.method_51433(this.field_22793, warningText, drawX + element.width - warningWidth - 2, drawY + 2, -65536, true);
        }
    }

    private void savePositionsToConfig() {
        for (DraggableElement element : this.draggableElements) {
            switch (this.currentEditMode.ordinal()) {
                case 0: {
                    this.setScrollPosition(element.type, element.x, element.y);
                    break;
                }
                case 1: {
                    this.setComboPosition(element.type, element.x, element.y);
                    break;
                }
                case 2: {
                    this.setCardPosition(element.type, element.x, element.y);
                }
            }
        }
        Config.saveConfig();
        Config.loadConfig();
    }

    private void switchEditMode(EditMode newMode) {
        if (this.currentEditMode != newMode) {
            this.savePositionsToConfig();
            this.currentEditMode = newMode;
            this.loadPositionsFromConfig();
            this.clearUndoHistory();
            Config config = Config.getInstance();
            switch (newMode.ordinal()) {
                case 0: {
                    config.ICON_MODE = Config.IconMode.SCROLLING;
                    Config.iconMode = Config.IconMode.SCROLLING;
                    break;
                }
                case 1: {
                    config.ICON_MODE = Config.IconMode.COMBO;
                    Config.iconMode = Config.IconMode.COMBO;
                    break;
                }
                case 2: {
                    config.ICON_MODE = Config.IconMode.CARD;
                    Config.iconMode = Config.IconMode.CARD;
                }
            }
            Config.saveConfig();
            Config.loadConfig();
        }
        boolean isCardMode = newMode == EditMode.CARD;
        for (DraggableElement element : this.draggableElements) {
            if (element.type == ElementType.ICON) continue;
            element.visibleInGame = !isCardMode;
        }
        this.updateElementSizes();
        this.updateModeButtons();
    }

    private void toggleMenu() {
        boolean bl = this.isMenuExpanded = !this.isMenuExpanded;
        if (this.isMenuExpanded) {
            this.menuButton.method_25355((class_2561)class_2561.method_43470((String)"<"));
        } else {
            this.menuButton.method_25355((class_2561)class_2561.method_43470((String)"\u2261"));
        }
    }

    private void undoLastMove() {
        if (this.undoHistory.isEmpty()) {
            return;
        }
        MoveOperation lastOperation = this.undoHistory.remove(this.undoHistory.size() - 1);
        for (DraggableElement element : this.draggableElements) {
            if (element.type != lastOperation.elementType) continue;
            element.x = lastOperation.oldX;
            element.y = lastOperation.oldY;
            break;
        }
        this.savePositionsToConfig();
        this.updateUndoButtonState();
    }

    void updateElementSizes() {
        int iconBaseWidth = 70;
        int iconBaseHeight = 70;
        int subtitleBaseWidth = 200;
        int subtitleBaseHeight = 40;
        int scoreBaseWidth = 60;
        int scoreBaseHeight = 40;
        int bonusBaseWidth = 60;
        int bonusBaseHeight = 50;
        int iconConfigSize = this.getElementSize(ElementType.ICON);
        int subtitleConfigSize = this.getElementSize(ElementType.SUBTITLE);
        int scoreConfigSize = this.getElementSize(ElementType.SCORE);
        int bonusConfigSize = this.getElementSize(ElementType.BONUS);
        float iconScale = (float)iconConfigSize / 32.0f;
        float subtitleScale = (float)subtitleConfigSize / 100.0f;
        float scoreScale = (float)scoreConfigSize / 250.0f;
        float bonusScale = (float)bonusConfigSize / 100.0f;
        for (DraggableElement element : this.draggableElements) {
            switch (element.type.ordinal()) {
                case 2: {
                    element.width = (int)((float)iconBaseWidth * iconScale);
                    element.height = (int)((float)iconBaseHeight * iconScale);
                    break;
                }
                case 4: {
                    element.width = (int)((float)subtitleBaseWidth * subtitleScale);
                    element.height = (int)((float)subtitleBaseHeight * subtitleScale);
                    break;
                }
                case 3: {
                    element.width = (int)((float)scoreBaseWidth * scoreScale);
                    element.height = (int)((float)scoreBaseHeight * scoreScale);
                    break;
                }
                case 0: {
                    element.width = (int)((float)bonusBaseWidth * bonusScale);
                    element.height = (int)((float)bonusBaseHeight * bonusScale);
                }
            }
        }
    }

    private void updateModeButtons() {
        for (int i = 0; i < this.modeButtons.length; ++i) {
            class_4185 button = this.modeButtons[i];
            EditMode buttonMode = this.getEditModeForIndex(i);
            if (buttonMode == this.currentEditMode) {
                button.method_25355((class_2561)class_2561.method_43470((String)buttonMode.displayName).method_27694(style -> style.method_36139(-256)));
                continue;
            }
            button.method_25355((class_2561)class_2561.method_43470((String)buttonMode.displayName).method_27694(style -> style.method_36139(-1)));
        }
    }

    private void updateScoreText() {
        class_2561.method_43470((String)"\u60a8\u5728\u6b64\u670d\u52a1\u5668\u4e0a\u7684\u5206\u6570: ").method_27661().method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.currentScore)).method_27694(style -> style.method_36139(-65536).method_10982(Boolean.valueOf(true))));
    }

    private void updateUndoButtonState() {
        boolean bl = this.canUndo = !this.undoHistory.isEmpty();
        if (this.undoButton != null) {
            this.undoButton.field_22763 = this.canUndo;
            if (this.canUndo) {
                this.undoButton.method_25355((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.undo").method_27694(style -> style.method_36139(-1)));
            } else {
                this.undoButton.method_25355((class_2561)class_2561.method_43471((String)"gd656killicon.modconfig.undo").method_27694(style -> style.method_36139(-7829368)));
            }
        }
    }

    private void requestScoreUpdate() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_2960)NetworkHandler.SCORE_REQUEST_PACKET_ID, (class_2540)new ScoreRequestPacket().toBuf());
            this.lastScoreUpdateTime = System.currentTimeMillis();
        }
    }

    private int getScrollPosition(ElementType type, boolean isX) {
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> {
                if (isX) {
                    yield Config.scrollIconX;
                }
                yield Config.scrollIconY;
            }
            case 4 -> {
                if (isX) {
                    yield Config.scrollSubtitleX;
                }
                yield Config.scrollSubtitleY;
            }
            case 3 -> {
                if (isX) {
                    yield Config.scrollScoreX;
                }
                yield Config.scrollScoreY;
            }
            case 0 -> {
                if (isX) {
                    yield Config.scrollBonusX;
                }
                yield Config.scrollBonusY;
            }
            case 1 -> 0;
        };
    }

    private int getComboPosition(ElementType type, boolean isX) {
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> {
                if (isX) {
                    yield Config.comboIconX;
                }
                yield Config.comboIconY;
            }
            case 4 -> {
                if (isX) {
                    yield Config.comboSubtitleX;
                }
                yield Config.comboSubtitleY;
            }
            case 3 -> {
                if (isX) {
                    yield Config.comboScoreX;
                }
                yield Config.comboScoreY;
            }
            case 0 -> {
                if (isX) {
                    yield Config.comboBonusX;
                }
                yield Config.comboBonusY;
            }
            case 1 -> 0;
        };
    }

    private int getCardPosition(ElementType type, boolean isX) {
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> {
                if (isX) {
                    yield Config.cardIconX;
                }
                yield Config.cardIconY;
            }
            case 4 -> {
                if (isX) {
                    yield Config.cardSubtitleX;
                }
                yield Config.cardSubtitleY;
            }
            case 3 -> {
                if (isX) {
                    yield Config.cardScoreX;
                }
                yield Config.cardScoreY;
            }
            case 0 -> {
                if (isX) {
                    yield Config.cardBonusX;
                }
                yield Config.cardBonusY;
            }
            case 1 -> 0;
        };
    }

    private void setScrollPosition(ElementType type, int x, int y) {
        Config config = Config.getInstance();
        switch (type.ordinal()) {
            case 2: {
                config.SCROLL_ICON_X = x;
                config.SCROLL_ICON_Y = y;
                Config.scrollIconX = x;
                Config.scrollIconY = y;
                break;
            }
            case 4: {
                config.SCROLL_SUBTITLE_X = x;
                config.SCROLL_SUBTITLE_Y = y;
                Config.scrollSubtitleX = x;
                Config.scrollSubtitleY = y;
                break;
            }
            case 3: {
                config.SCROLL_SCORE_X = x;
                config.SCROLL_SCORE_Y = y;
                Config.scrollScoreX = x;
                Config.scrollScoreY = y;
                break;
            }
            case 0: {
                config.SCROLL_BONUS_X = x;
                config.SCROLL_BONUS_Y = y;
                Config.scrollBonusX = x;
                Config.scrollBonusY = y;
            }
        }
        Config.saveConfig();
    }

    private void setComboPosition(ElementType type, int x, int y) {
        Config config = Config.getInstance();
        switch (type.ordinal()) {
            case 2: {
                config.COMBO_ICON_X = x;
                config.COMBO_ICON_Y = y;
                Config.comboIconX = x;
                Config.comboIconY = y;
                break;
            }
            case 4: {
                config.COMBO_SUBTITLE_X = x;
                config.COMBO_SUBTITLE_Y = y;
                Config.comboSubtitleX = x;
                Config.comboSubtitleY = y;
                break;
            }
            case 3: {
                config.COMBO_SCORE_X = x;
                config.COMBO_SCORE_Y = y;
                Config.comboScoreX = x;
                Config.comboScoreY = y;
                break;
            }
            case 0: {
                config.COMBO_BONUS_X = x;
                config.COMBO_BONUS_Y = y;
                Config.comboBonusX = x;
                Config.comboBonusY = y;
            }
        }
        Config.saveConfig();
    }

    private void setCardPosition(ElementType type, int x, int y) {
        Config config = Config.getInstance();
        switch (type.ordinal()) {
            case 2: {
                config.CARD_ICON_X = x;
                config.CARD_ICON_Y = y;
                Config.cardIconX = x;
                Config.cardIconY = y;
                break;
            }
            case 4: {
                config.CARD_SUBTITLE_X = x;
                config.CARD_SUBTITLE_Y = y;
                Config.cardSubtitleX = x;
                Config.cardSubtitleY = y;
                break;
            }
            case 3: {
                config.CARD_SCORE_X = x;
                config.CARD_SCORE_Y = y;
                Config.cardScoreX = x;
                Config.cardScoreY = y;
                break;
            }
            case 0: {
                config.CARD_BONUS_X = x;
                config.CARD_BONUS_Y = y;
                Config.cardBonusX = x;
                Config.cardBonusY = y;
                break;
            }
        }
        Config.saveConfig();
    }

    private void drawEyeIcon(class_332 guiGraphics, int drawX, int drawY, int elementWidth, boolean isVisible) {
        class_2960 eyeIcon = isVisible ? new class_2960("minecraft", "textures/mob_effect/conduit_power.png") : new class_2960("minecraft", "textures/mob_effect/blindness.png");
        try {
            int iconSize = 16;
            int iconX = drawX + elementWidth - iconSize - 3;
            int iconY = drawY + 3;
            guiGraphics.method_25290(eyeIcon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        catch (Exception e) {
            String eyeText = isVisible ? "\u25cb" : "\u00d7";
            int textWidth = this.field_22793.method_1727(eyeText);
            int textX = drawX + elementWidth - textWidth - 3;
            int textY = drawY + 3;
            int textColor = isVisible ? -16711936 : -65536;
            guiGraphics.method_51433(this.field_22793, eyeText, textX, textY, textColor, true);
        }
    }

    private boolean isElementOutOfBounds(DraggableElement element, int screenWidth, int screenHeight) {
        int drawX = screenWidth / 2 + element.x - element.width / 2;
        int drawY = screenHeight + element.y - element.height / 2;
        return drawX < 0 || drawX + element.width > screenWidth || drawY < 0 || drawY + element.height > screenHeight;
    }

    public static class DraggableElement {
        public final int defaultX;
        public final int defaultY;
        public final ElementType type;
        public final String name;
        public int dragOffsetX;
        public int dragOffsetY;
        public int height;
        public int width;
        public int x;
        public int y;
        public boolean visibleInGame;
        private Object userData;

        public DraggableElement(String name, ElementType type, int defaultX, int defaultY, int width, int height, boolean visibleInGame) {
            this.name = name;
            this.type = type;
            this.x = defaultX;
            this.y = defaultY;
            this.defaultX = defaultX;
            this.defaultY = defaultY;
            this.width = width;
            this.height = height;
            this.visibleInGame = visibleInGame;
        }

        public boolean contains(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int drawX = screenWidth / 2 + this.x - this.width / 2;
            int drawY = screenHeight + this.y - this.height / 2;
            return mouseX >= drawX && mouseX <= drawX + this.width && mouseY >= drawY && mouseY <= drawY + this.height;
        }

        public void setDragOffset(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int drawX = screenWidth / 2 + this.x - this.width / 2;
            int drawY = screenHeight + this.y - this.height / 2;
            this.dragOffsetX = mouseX - drawX;
            this.dragOffsetY = mouseY - drawY;
        }

        public void setPositionFromMouse(int mouseX, int mouseY, int screenWidth, int screenHeight) {
            int newX = mouseX - screenWidth / 2 - this.dragOffsetX + this.width / 2;
            int newY = mouseY - screenHeight - this.dragOffsetY + this.height / 2;
            this.x = this.clampToScreenBounds(newX, screenWidth, true);
            this.y = this.clampToScreenBounds(newY, screenHeight, false);
        }

        private int clampToScreenBounds(int coordinate, int screenSize, boolean isX) {
            int margin = 20;
            if (isX) {
                int maxX = screenSize / 2 - this.width / 2 - margin;
                int minX = -screenSize / 2 + this.width / 2 + margin;
                return class_3532.method_15340((int)coordinate, (int)minX, (int)maxX);
            }
            int maxY = -this.height / 2 - margin;
            int minY = -screenSize + this.height / 2 + margin;
            return class_3532.method_15340((int)coordinate, (int)minY, (int)maxY);
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }
    }

    private static enum EditMode {
        SCROLL("\u6eda\u52a8\u6a21\u5f0f", -65536),
        COMBO("\u8fde\u6740\u6a21\u5f0f", -16711936),
        CARD("\u5361\u724c\u6a21\u5f0f", -256);

        public final String displayName;
        public final int color;

        private EditMode(String displayName, int color) {
            this.displayName = displayName;
            this.color = color;
        }
    }

    public static class CustomButton {
        public final int height;
        public final int width;
        public final int x;
        public final int y;
        public final Runnable onClick;
        public final String label;
        public boolean isHovered = false;

        public CustomButton(String label, int x, int y, int width, int height, Runnable onClick) {
            this.label = label;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.onClick = onClick;
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }

        public void render(class_332 guiGraphics, int mouseX, int mouseY) {
            this.isHovered = this.contains(mouseX, mouseY);
            int fillColor = this.isHovered ? -12566464 : -16777216;
            int borderColor = -8355712;
            guiGraphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
            guiGraphics.method_49601(this.x, this.y, this.width, this.height, borderColor);
            class_310 mc = class_310.method_1551();
            int textWidth = mc.field_1772.method_1727(this.label);
            int textX = this.x + (this.width - textWidth) / 2;
            Objects.requireNonNull(mc.field_1772);
            int textY = this.y + (this.height - 9) / 2 + 1;
            guiGraphics.method_51433(mc.field_1772, this.label, textX, textY, 0xFFFFFF, true);
        }
    }

    public static enum ElementType {
        BONUS,
        BOTTOMBAR,
        ICON,
        SCORE,
        SUBTITLE;

    }

    public static class MoveOperation {
        public final EditMode editMode;
        public final ElementType elementType;
        public final int newX;
        public final int newY;
        public final int oldX;
        public final int oldY;
        public final long timestamp;

        public MoveOperation(EditMode editMode, ElementType elementType, int oldX, int oldY, int newX, int newY) {
            this.editMode = editMode;
            this.elementType = elementType;
            this.oldX = oldX;
            this.oldY = oldY;
            this.newX = newX;
            this.newY = newY;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

