/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.subtitlerenderer;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.RenderHelper;

@Environment(value=EnvType.CLIENT)
public class SubtitleRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderSubtitles(class_332 guiGraphics, long currentTime) {
        class_5250 fullText;
        if (!RenderHelper.isElementVisible(ModConfigScreen.ElementType.SUBTITLE)) {
            return;
        }
        if (KillIconRenderer.latestWeaponName.isEmpty() && KillIconRenderer.latestTargetName.isEmpty()) {
            return;
        }
        if (KillIconRenderer.textHideTime > 0L && currentTime >= KillIconRenderer.textHideTime) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        String format = KillIconRenderer.latestIsAssist ? Config.assistSubtitleFormat : Config.customSubtitleFormat;
        String localizedWeapon = SubtitleRenderer.translateKey(KillIconRenderer.latestWeaponName);
        String localizedTarget = SubtitleRenderer.translateKey(KillIconRenderer.latestTargetName);
        String formattedText = format;
        if (format.contains("{weapon}") && !localizedWeapon.isEmpty()) {
            formattedText = formattedText.replace("{weapon}", localizedWeapon);
        }
        if (format.contains("{target}") && !localizedTarget.isEmpty()) {
            formattedText = formattedText.replace("{target}", localizedTarget);
        }
        int weaponColorValue = KillIconRenderer.latestIsCritical ? Config.criticalColorHex : Config.weaponColorHex;
        int targetColorValue = KillIconRenderer.latestIsCritical ? Config.criticalColorHex : Config.targetColorHex;
        long elapsedSubtitle = currentTime - KillIconRenderer.subtitleAnimationStartTime;
        if (elapsedSubtitle < 250L) {
            float progress = class_3532.method_15363((float)((float)elapsedSubtitle / 250.0f), (float)0.0f, (float)1.0f);
            float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
            KillIconRenderer.subtitleScale = class_3532.method_16439((float)easedProgress, (float)1.5f, (float)1.0f);
            KillIconRenderer.subtitleBrightness = class_3532.method_16439((float)easedProgress, (float)10.0f, (float)1.0f);
        } else {
            KillIconRenderer.subtitleScale = 1.0f;
            KillIconRenderer.subtitleBrightness = 1.0f;
        }
        boolean hasWeaponPlaceholder = format.contains("{weapon}");
        boolean hasTargetPlaceholder = format.contains("{target}");
        if (hasWeaponPlaceholder && hasTargetPlaceholder) {
            weaponIndex = formattedText.indexOf(localizedWeapon);
            int targetIndex = formattedText.indexOf(localizedTarget);
            if (weaponIndex >= 0 && targetIndex >= 0) {
                if (weaponIndex < targetIndex) {
                    String beforeWeapon = formattedText.substring(0, weaponIndex);
                    between = formattedText.substring(Math.min(weaponIndex + localizedWeapon.length(), targetIndex), targetIndex);
                    String afterTarget = formattedText.substring(Math.min(targetIndex + localizedTarget.length(), formattedText.length()));
                    fullText = class_2561.method_43470((String)beforeWeapon).method_10852((class_2561)class_2561.method_43470((String)localizedWeapon).method_27696(class_2583.field_24360.method_36139(SubtitleRenderer.applyBrightness(weaponColorValue, KillIconRenderer.subtitleBrightness)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)between)).method_10852((class_2561)class_2561.method_43470((String)localizedTarget).method_27696(class_2583.field_24360.method_36139(SubtitleRenderer.applyBrightness(targetColorValue, KillIconRenderer.subtitleBrightness)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)afterTarget));
                } else {
                    String beforeTarget = formattedText.substring(0, targetIndex);
                    between = formattedText.substring(Math.min(targetIndex + localizedTarget.length(), weaponIndex), weaponIndex);
                    String afterWeapon = formattedText.substring(Math.min(weaponIndex + localizedWeapon.length(), formattedText.length()));
                    fullText = class_2561.method_43470((String)beforeTarget).method_10852((class_2561)class_2561.method_43470((String)localizedTarget).method_27696(class_2583.field_24360.method_36139(SubtitleRenderer.applyBrightness(targetColorValue, KillIconRenderer.subtitleBrightness)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)between)).method_10852((class_2561)class_2561.method_43470((String)localizedWeapon).method_27696(class_2583.field_24360.method_36139(SubtitleRenderer.applyBrightness(weaponColorValue, KillIconRenderer.subtitleBrightness)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)afterWeapon));
                }
            } else {
                fullText = class_2561.method_43470((String)formattedText);
            }
        } else if (hasWeaponPlaceholder) {
            weaponIndex = formattedText.indexOf(localizedWeapon);
            if (weaponIndex >= 0) {
                String beforeWeapon = formattedText.substring(0, weaponIndex);
                String afterWeapon = formattedText.substring(Math.min(weaponIndex + localizedWeapon.length(), formattedText.length()));
                fullText = class_2561.method_43470((String)beforeWeapon).method_10852((class_2561)class_2561.method_43470((String)localizedWeapon).method_27696(class_2583.field_24360.method_36139(SubtitleRenderer.applyBrightness(weaponColorValue, KillIconRenderer.subtitleBrightness)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)afterWeapon));
            } else {
                fullText = class_2561.method_43470((String)formattedText);
            }
        } else if (hasTargetPlaceholder) {
            int targetIndex = formattedText.indexOf(localizedTarget);
            if (targetIndex >= 0) {
                String beforeTarget = formattedText.substring(0, targetIndex);
                String afterTarget = formattedText.substring(Math.min(targetIndex + localizedTarget.length(), formattedText.length()));
                fullText = class_2561.method_43470((String)beforeTarget).method_10852((class_2561)class_2561.method_43470((String)localizedTarget).method_27696(class_2583.field_24360.method_36139(SubtitleRenderer.applyBrightness(targetColorValue, KillIconRenderer.subtitleBrightness)).method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)afterTarget));
            } else {
                fullText = class_2561.method_43470((String)formattedText);
            }
        } else {
            fullText = class_2561.method_43470((String)formattedText);
        }
        int textY = screenHeight + pos.subtitleY;
        int textWidth = font.method_27525((class_5348)fullText);
        int textX = screenWidth / 2 + pos.subtitleX - textWidth / 2;
        float subtitleSizeScale = (float)RenderHelper.getElementSize(ModConfigScreen.ElementType.SUBTITLE) / 100.0f;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        try {
            float centerX = (float)textX + (float)textWidth / 2.0f;
            float f = textY;
            Objects.requireNonNull(font);
            float centerY = f + 9.0f / 2.0f;
            poseStack.method_46416(centerX, centerY, 0.0f);
            poseStack.method_22905(KillIconRenderer.subtitleScale * subtitleSizeScale, KillIconRenderer.subtitleScale * subtitleSizeScale, 1.0f);
            poseStack.method_46416(-centerX, -centerY, 0.0f);
            guiGraphics.method_51439(font, (class_2561)fullText, textX, textY, SubtitleRenderer.applyBrightness(-1, KillIconRenderer.subtitleBrightness), true);
        }
        finally {
            poseStack.method_22909();
        }
    }

    private static int applyBrightness(int color, float brightness) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * brightness);
        int g = (int)((float)(color >> 8 & 0xFF) * brightness);
        int b = (int)((float)(color & 0xFF) * brightness);
        r = class_3532.method_15340((int)r, (int)0, (int)255);
        g = class_3532.method_15340((int)g, (int)0, (int)255);
        b = class_3532.method_15340((int)b, (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static String translateKey(String key) {
        try {
            class_5250 translated = class_2561.method_43471((String)key);
            return translated.getString();
        }
        catch (Exception e) {
            if (key.contains(".")) {
                return key.substring(key.lastIndexOf(".") + 1);
            }
            return key;
        }
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                config.subtitleX = Config.scrollSubtitleX;
                config.subtitleY = Config.scrollSubtitleY;
                config.scoreX = Config.scrollScoreX;
                config.scoreY = Config.scrollScoreY;
                config.bonusX = Config.scrollBonusX;
                config.bonusY = Config.scrollBonusY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                config.subtitleX = Config.comboSubtitleX;
                config.subtitleY = Config.comboSubtitleY;
                config.scoreX = Config.comboScoreX;
                config.scoreY = Config.comboScoreY;
                config.bonusX = Config.comboBonusX;
                config.bonusY = Config.comboBonusY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
                config.subtitleX = Config.cardSubtitleX;
                config.subtitleY = Config.cardSubtitleY;
                config.scoreX = Config.cardScoreX;
                config.scoreY = Config.cardScoreY;
                config.bonusX = Config.cardBonusX;
                config.bonusY = Config.cardBonusY;
            }
        }
        return config;
    }
}

