/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_266;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.data.BanListData;
import org.mods.gd656killicon.data.ScoreData;
import org.mods.gd656killicon.data.ScoreExpressionManager;
import org.mods.gd656killicon.data.ScoreboardBindingData;
import org.mods.gd656killicon.network.CardComboKillDurationPacket;
import org.mods.gd656killicon.network.NetworkHandler;

public class ScoreCommand {
    private static final SuggestionProvider<class_2168> ENTITY_SUGGESTIONS = (context, builder) -> {
        builder.suggest("all");
        return builder.buildFuture();
    };
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^[a-zA-Z0-9\\s+\\-*/.]+$");
    private static final Map<String, String> SCORE_TYPE_NAMES = new HashMap<String, String>();
    private static final List<List<class_2561>> HELP_PAGES = new ArrayList<List<class_2561>>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gdscore").requires(source -> source.method_9259(0))).executes(ScoreCommand::getOwnScore)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(context -> ScoreCommand.showHelp((CommandContext<class_2168>)context, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ScoreCommand.showHelp((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"page")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"top").requires(source -> source.method_9259(0))).executes(ScoreCommand::getTopScores))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ScoreCommand::getPlayerScore)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"points", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ScoreCommand::addScore))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reduce").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"points", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ScoreCommand::reduceScore))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ScoreCommand::setScore))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"limit").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"maxScore", (ArgumentType)IntegerArgumentType.integer((int)1, (int)0x7FFFFFFE)).executes(ScoreCommand::setScoreLimit)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ban").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"entityId", (ArgumentType)StringArgumentType.greedyString()).suggests(ENTITY_SUGGESTIONS).executes(ScoreCommand::banEntity)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"allow").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"entityId", (ArgumentType)StringArgumentType.greedyString()).suggests(ENTITY_SUGGESTIONS).executes(ScoreCommand::allowEntity)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"banlist").requires(source -> source.method_9259(2))).executes(ScoreCommand::showBanList))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bonuspoints").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"list").executes(ScoreCommand::listScoreExpressions))).then(class_2170.method_9247((String)"reset").executes(ScoreCommand::resetScoreExpressions))).then(class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"scoreType", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ScoreExpressionManager manager = ScoreExpressionManager.get(((class_2168)context.getSource()).method_9211());
            Map<String, String> expressions = manager.getAllExpressions();
            for (String key : expressions.keySet()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(ScoreCommand::editScoreExpression)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rule").requires(source -> source.method_9259(3))).then(class_2170.method_9247((String)"RankingList").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ScoreCommand::setRankingListRule)))).then(class_2170.method_9247((String)"CardComboKillDurationTime").then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3600)).executes(ScoreCommand::setCardComboKillDurationTime))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scoreboard").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"binding").then(class_2170.method_9244((String)"objective", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"displayName", (ArgumentType)StringArgumentType.greedyString()).executes(ScoreCommand::bindScoreboard))))).then(class_2170.method_9247((String)"unbind").executes(ScoreCommand::unbindScoreboard)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cardclear").requires(source -> source.method_9259(2))).executes(ScoreCommand::clearCardCombo)));
    }

    public static void syncScoresToScoreboard(MinecraftServer server) {
        ScoreboardBindingData bindingData = ScoreboardBindingData.get(server);
        if (!bindingData.isBound()) {
            return;
        }
        ScoreData scoreData = ScoreData.get(server);
        class_2995 scoreboard = server.method_3845();
        class_266 objective = scoreboard.method_1170(bindingData.getObjectiveName());
        if (objective == null) {
            objective = scoreboard.method_1168(bindingData.getObjectiveName(), class_274.field_1468, (class_2561)class_2561.method_43470((String)bindingData.getDisplayName()), class_274.class_275.field_1472);
        }
        for (Map.Entry<UUID, Integer> entry : scoreData.getAllScores().entrySet()) {
            class_3222 player = server.method_3760().method_14602(entry.getKey());
            if (player == null) continue;
            scoreboard.method_1180(player.method_5820(), objective).method_1128(entry.getValue().intValue());
        }
    }

    private static int setScoreLimit(CommandContext<class_2168> context) {
        int maxScore = IntegerArgumentType.getInteger(context, (String)"maxScore");
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        scoreData.setScoreLimit(maxScore);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5355\u6b21\u52a0\u5206\u4e0a\u9650\u5df2\u8bbe\u7f6e\u4e3a: " + maxScore)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int clearCardCombo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() != null) {
            class_310.method_1551().execute(KillIconRenderer::clearCardCombo);
            source.method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u5df2\u5f3a\u5236\u6e05\u9664\u6240\u6709\u5361\u724c\u8fde\u6740").method_27692(class_124.field_1060));
        } else {
            source.method_45068((class_2561)class_2561.method_43470((String)"\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u6267\u884c\u6b64\u6307\u4ee4").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int setCardComboKillDurationTime(CommandContext<class_2168> context) {
        int duration = IntegerArgumentType.getInteger(context, (String)"duration");
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        scoreData.setCardComboKillDurationTime(duration);
        CardComboKillDurationPacket packet = new CardComboKillDurationPacket(duration);
        for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            NetworkHandler.sendToClient(NetworkHandler.CARD_COMBO_KILL_DURATION_PACKET_ID, packet.toBuf(), player);
        }
        class_2168 source = (class_2168)context.getSource();
        if (duration == 0) {
            source.method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u5361\u724c\u8fde\u6740\u5224\u5b9a\u65f6\u95f4\u5df2\u8bbe\u7f6e\u4e3a\u6c38\u4e45").method_27692(class_124.field_1060));
        } else {
            source.method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5361\u724c\u8fde\u6740\u5224\u5b9a\u65f6\u95f4\u5df2\u8bbe\u7f6e\u4e3a: " + duration + " \u79d2")).method_27692(class_124.field_1060));
        }
        return 1;
    }

    private static int setRankingListRule(CommandContext<class_2168> context) {
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        scoreData.setRankingListEnabled(enabled);
        class_2168 source = (class_2168)context.getSource();
        if (enabled) {
            source.method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u699c\u5355\u5df2\u5f00\u542f").method_27692(class_124.field_1060));
        } else {
            source.method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int bindScoreboard(CommandContext<class_2168> context) {
        ScoreboardBindingData bindingData = ScoreboardBindingData.get(((class_2168)context.getSource()).method_9211());
        if (bindingData.isBound()) {
            String currentBinding = bindingData.getObjectiveName() + " (" + bindingData.getDisplayName() + ")";
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u8ba1\u5206\u677f\u7ed1\u5b9a\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\u3002\u5f53\u524d\u5df2\u7ed1\u5b9a: " + currentBinding + "\u3002\u8bf7\u5148\u4f7f\u7528 /gdscore scoreboard unbind \u89e3\u7ed1\u5f53\u524d\u8ba1\u5206\u677f")).method_27692(class_124.field_1061));
            return 0;
        }
        String objectiveName = StringArgumentType.getString(context, (String)"objective");
        String displayName = StringArgumentType.getString(context, (String)"displayName");
        if (!ScoreCommand.isValidObjectiveName(objectiveName)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u8ba1\u5206\u677f\u540d\u79f0\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf").method_27692(class_124.field_1061));
            return 0;
        }
        bindingData.bind(objectiveName, displayName);
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective == null) {
            scoreboard.method_1168(objectiveName, class_274.field_1468, (class_2561)class_2561.method_43470((String)displayName), class_274.class_275.field_1472);
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u7ed1\u5b9a\u6a21\u7ec4\u5206\u6570\u5230\u8ba1\u5206\u677f: " + objectiveName)).method_27692(class_124.field_1060));
        ScoreCommand.syncScoresToScoreboard(((class_2168)context.getSource()).method_9211());
        return 1;
    }

    private static int unbindScoreboard(CommandContext<class_2168> context) {
        ScoreboardBindingData bindingData = ScoreboardBindingData.get(((class_2168)context.getSource()).method_9211());
        if (!bindingData.isBound()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u5f53\u524d\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u8ba1\u5206\u677f").method_27692(class_124.field_1061));
            return 0;
        }
        String objectiveName = bindingData.getObjectiveName();
        bindingData.unbind();
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        class_266 objective = scoreboard.method_1170(objectiveName);
        if (objective != null) {
            scoreboard.method_1194(objective);
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u89e3\u7ed1\u8ba1\u5206\u677f: " + objectiveName)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context, int page) {
        class_2168 source = (class_2168)context.getSource();
        int totalPages = HELP_PAGES.size();
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        List<class_2561> pageContent = HELP_PAGES.get(page - 1);
        for (class_2561 line : pageContent) {
            source.method_45068(line);
        }
        source.method_45068((class_2561)class_2561.method_43470((String)""));
        class_5250 navigation = class_2561.method_43470((String)"");
        if (page > 1) {
            int finalPage = page;
            navigation.method_10852((class_2561)class_2561.method_43470((String)"\u00ab \u4e0a\u4e00\u9875").method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/gdscore help " + (finalPage - 1))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u70b9\u51fb\u67e5\u770b\u4e0a\u4e00\u9875")))));
        } else {
            navigation.method_10852((class_2561)class_2561.method_43470((String)"\u00ab \u4e0a\u4e00\u9875").method_27692(class_124.field_1080));
        }
        navigation.method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080));
        navigation.method_10852((class_2561)class_2561.method_43470((String)(page + "/" + totalPages)).method_27692(class_124.field_1068));
        navigation.method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080));
        if (page < totalPages) {
            int finalPage1 = page;
            navigation.method_10852((class_2561)class_2561.method_43470((String)"\u4e0b\u4e00\u9875 \u00bb").method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/gdscore help " + (finalPage1 + 1))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u70b9\u51fb\u67e5\u770b\u4e0b\u4e00\u9875")))));
        } else {
            navigation.method_10852((class_2561)class_2561.method_43470((String)"\u4e0b\u4e00\u9875 \u00bb").method_27692(class_124.field_1080));
        }
        source.method_45068((class_2561)navigation);
        return 1;
    }

    private static int listScoreExpressions(CommandContext<class_2168> context) {
        ScoreExpressionManager manager = ScoreExpressionManager.get(((class_2168)context.getSource()).method_9211());
        Map<String, String> expressions = manager.getAllExpressions();
        class_2168 source = (class_2168)context.getSource();
        source.method_45068((class_2561)class_2561.method_43470((String)"====== \u52a0\u5206\u9879\u8868\u8fbe\u5f0f\u5217\u8868 =====").method_27692(class_124.field_1065));
        source.method_45068((class_2561)class_2561.method_43470((String)""));
        for (Map.Entry<String, String> entry : expressions.entrySet()) {
            String scoreType = entry.getKey();
            String displayName = SCORE_TYPE_NAMES.getOrDefault(scoreType, scoreType);
            String expression = entry.getValue();
            class_5250 scoreTypeComponent = class_2561.method_43470((String)scoreType).method_27692(class_124.field_1067);
            class_5250 fullLine = class_2561.method_43470((String)"").method_10852((class_2561)scoreTypeComponent).method_27693(" (" + displayName + "): ").method_10852((class_2561)class_2561.method_43470((String)expression).method_27692(class_124.field_1068));
            source.method_45068((class_2561)fullLine);
        }
        return 1;
    }

    private static int resetScoreExpressions(CommandContext<class_2168> context) {
        ScoreExpressionManager manager = ScoreExpressionManager.get(((class_2168)context.getSource()).method_9211());
        manager.resetToDefaults();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u6240\u6709\u52a0\u5206\u9879\u8868\u8fbe\u5f0f\u5df2\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c").method_27692(class_124.field_1060));
        return 1;
    }

    private static int editScoreExpression(CommandContext<class_2168> context) {
        String scoreType = StringArgumentType.getString(context, (String)"scoreType");
        String expression = StringArgumentType.getString(context, (String)"expression");
        ScoreExpressionManager manager = ScoreExpressionManager.get(((class_2168)context.getSource()).method_9211());
        Map<String, String> expressions = manager.getAllExpressions();
        if (!expressions.containsKey(scoreType)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u52a0\u5206\u9879\u540d\u79f0").method_27692(class_124.field_1061));
            return 0;
        }
        if (!ScoreCommand.validateExpressionFormat(expression)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u8fd0\u7b97\u7b26\u548c\u7a7a\u683c").method_27692(class_124.field_1061));
            return 0;
        }
        if (!ScoreCommand.validateExpression(scoreType, expression)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef").method_27692(class_124.field_1061));
            return 0;
        }
        manager.setExpression(scoreType, expression);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u52a0\u5206\u9879 " + scoreType + " \u7684\u8868\u8fbe\u5f0f\u5df2\u66f4\u65b0\u4e3a: " + expression)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int banEntity(CommandContext<class_2168> context) {
        String entityId = StringArgumentType.getString(context, (String)"entityId");
        BanListData banListData = BanListData.get(((class_2168)context.getSource()).method_9211());
        if ("all".equals(entityId)) {
            banListData.clearAll();
            banListData.banEntity("all");
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u5df2\u7981\u6b62\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570"));
        } else {
            if (ScoreCommand.isValidEntityId(entityId)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u5b9e\u4f53ID: " + entityId)));
                return 0;
            }
            banListData.banEntity(entityId);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u7981\u6b62\u5b9e\u4f53 " + entityId + " \u7206\u51fa\u5206\u6570")));
        }
        return 1;
    }

    private static int allowEntity(CommandContext<class_2168> context) {
        String entityId = StringArgumentType.getString(context, (String)"entityId");
        BanListData banListData = BanListData.get(((class_2168)context.getSource()).method_9211());
        if ("all".equals(entityId)) {
            banListData.clearAll();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u5df2\u5141\u8bb8\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570"));
        } else {
            if (ScoreCommand.isValidEntityId(entityId)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u5b9e\u4f53ID: " + entityId)));
                return 0;
            }
            banListData.unbanEntity(entityId);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u5141\u8bb8\u5b9e\u4f53 " + entityId + " \u7206\u51fa\u5206\u6570")));
        }
        return 1;
    }

    private static int showBanList(CommandContext<class_2168> context) {
        BanListData banListData = BanListData.get(((class_2168)context.getSource()).method_9211());
        Set<String> bannedEntities = banListData.getBannedEntities();
        if (bannedEntities.isEmpty()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u5f53\u524d\u6ca1\u6709\u5b9e\u4f53\u88ab\u7981\u6b62\u7206\u51fa\u5206\u6570"));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"====== \u7981\u6b62\u7206\u5206\u6570\u7684\u5b9e\u4f53\u5217\u8868 ====="));
            for (String entityId : bannedEntities) {
                String displayName = ScoreCommand.getEntityDisplayName(entityId);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("- " + entityId + (String)(displayName != null ? " (" + displayName + ")" : ""))));
            }
        }
        return 1;
    }

    private static int getOwnScore(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            int score = ScoreData.get(((class_2168)context.getSource()).method_9211()).getScore(player.method_5667());
            player.method_43496((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u60a8\u7684\u5f53\u524d\u5206\u6570: " + score)));
        }
        return 1;
    }

    private static int getPlayerScore(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"target");
        int score = ScoreData.get(((class_2168)context.getSource()).method_9211()).getScore(target.method_5667());
        class_2168 source = (class_2168)context.getSource();
        source.method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u73a9\u5bb6 " + target.method_5477().getString() + " \u7684\u5206\u6570: " + score)));
        return 1;
    }

    private static int getTopScores(CommandContext<class_2168> context) {
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        if (scoreData.getRankingListEnabled()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed").method_27692(class_124.field_1061));
            return 0;
        }
        Map<UUID, Integer> allScores = scoreData.getAllScores();
        List topScores = allScores.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).limit(10L).toList();
        class_2168 source = (class_2168)context.getSource();
        source.method_45068((class_2561)class_2561.method_43470((String)"========== \u5206\u6570\u6392\u884c\u699c =========="));
        int rank = 1;
        for (Map.Entry entry : topScores) {
            class_3222 player = source.method_9211().method_3760().method_14602((UUID)entry.getKey());
            if (player == null) continue;
            source.method_45068((class_2561)class_2561.method_43470((String)(rank + ". " + player.method_5477().getString() + ": " + String.valueOf(entry.getValue()))));
            ++rank;
        }
        return 1;
    }

    private static int addScore(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        int points = IntegerArgumentType.getInteger(context, (String)"points");
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        class_2168 source = (class_2168)context.getSource();
        for (class_3222 player : targets) {
            scoreData.addScore(player.method_5667(), points, ((class_2168)context.getSource()).method_9211());
            source.method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u7ed9\u73a9\u5bb6 " + player.method_5477().getString() + " \u589e\u52a0 " + points + " \u5206")));
        }
        return 1;
    }

    private static int reduceScore(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        int points = IntegerArgumentType.getInteger(context, (String)"points");
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        class_2168 source = (class_2168)context.getSource();
        for (class_3222 player : targets) {
            scoreData.reduceScore(player.method_5667(), points, ((class_2168)context.getSource()).method_9211());
            source.method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u7ed9\u73a9\u5bb6 " + player.method_5477().getString() + " \u51cf\u5c11 " + points + " \u5206")));
        }
        return 1;
    }

    private static int setScore(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        int points = IntegerArgumentType.getInteger(context, (String)"points");
        ScoreData scoreData = ScoreData.get(((class_2168)context.getSource()).method_9211());
        class_2168 source = (class_2168)context.getSource();
        for (class_3222 player : targets) {
            scoreData.setScore(player.method_5667(), points, ((class_2168)context.getSource()).method_9211());
            source.method_45068((class_2561)class_2561.method_43470((String)("[\u516d\u4e94\u516d] \u5df2\u8bbe\u7f6e\u73a9\u5bb6 " + player.method_5477().getString() + " \u7684\u5206\u6570\u4e3a " + points)));
        }
        return 1;
    }

    private static boolean validateExpressionFormat(String expression) {
        return EXPRESSION_PATTERN.matcher(expression).matches();
    }

    private static boolean validateExpression(String scoreType, String expression) {
        String[] tokens = expression.split(" ");
        if (tokens.length % 2 != 1) {
            return false;
        }
        if (scoreType.equals("kill") && expression.contains("killscore")) {
            return false;
        }
        Set<String> allowedOperators = Set.of("+", "-", "*", "/");
        for (int i = 1; i < tokens.length; i += 2) {
            if (allowedOperators.contains(tokens[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidEntityId(String entityId) {
        try {
            class_2960 location = class_2960.method_12829((String)entityId);
            return location == null || !class_7923.field_41177.method_10250(location);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static String getEntityDisplayName(String entityId) {
        try {
            class_2960 location = class_2960.method_12829((String)entityId);
            if (location != null && class_7923.field_41177.method_10250(location)) {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(location);
                return entityType.method_5897().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isValidObjectiveName(String name) {
        return name.matches("[a-zA-Z0-9_]+");
    }

    private static void initializeHelpPages() {
        ArrayList<class_5250> page1 = new ArrayList<class_5250>();
        page1.add(class_2561.method_43470((String)"====== GD656Killicon \u5e2e\u52a9 - \u7b2c1\u9875/\u51712\u9875 =====").method_27692(class_124.field_1065));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"\u5e2e\u52a9\u5df2\u7ecf\u8fc1\u79fb\u5230\u6a21\u7ec4\u914d\u7f6e\u83dc\u5355\u4e2d\u7684\u5e2e\u52a9\u9875\u9762").method_27692(class_124.field_1061));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page1.add(class_2561.method_43470((String)""));
        HELP_PAGES.add(page1);
        ArrayList<class_5250> page2 = new ArrayList<class_5250>();
        page2.add(class_2561.method_43470((String)"====== GD656Killicon \u5e2e\u52a9 - \u7b2c2\u9875/\u51712\u9875 =====").method_27692(class_124.field_1065));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)"").method_27692(class_124.field_1063));
        page2.add(class_2561.method_43470((String)""));
        HELP_PAGES.add(page2);
    }

    static {
        SCORE_TYPE_NAMES.put("kill", "\u51fb\u6740");
        SCORE_TYPE_NAMES.put("critical", "\u66b4\u51fb\u52a0\u6210");
        SCORE_TYPE_NAMES.put("longrange", "\u8fdc\u8ddd\u79bb\u51fb\u8d25");
        SCORE_TYPE_NAMES.put("damage", "\u9020\u6210\u4f24\u5bb3");
        SCORE_TYPE_NAMES.put("magic", "\u9b54\u6cd5\u4f24\u5bb3");
        SCORE_TYPE_NAMES.put("hand", "\u7a7a\u624b\u653b\u51fb");
        SCORE_TYPE_NAMES.put("assist", "\u52a9\u653b");
        ScoreCommand.initializeHelpPages();
    }
}

