/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class BanListData
extends class_18 {
    private static final String DATA_NAME = "gd656killicon_banlist";
    private final Set<String> bannedEntities = new HashSet<String>();

    public BanListData() {
    }

    public BanListData(class_2487 nbt) {
        class_2499 banList = nbt.method_10554("bannedEntities", 8);
        for (int i = 0; i < banList.size(); ++i) {
            this.bannedEntities.add(banList.method_10608(i));
        }
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compound) {
        class_2499 banList = new class_2499();
        for (String entityId : this.bannedEntities) {
            banList.add((Object)class_2519.method_23256((String)entityId));
        }
        compound.method_10566("bannedEntities", (class_2520)banList);
        return compound;
    }

    public static BanListData get() {
        MinecraftServer server = BanListData.getCurrentServer();
        if (server == null) {
            return new BanListData();
        }
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            return new BanListData();
        }
        return (BanListData)overworld.method_17983().method_17924(BanListData::new, BanListData::new, DATA_NAME);
    }

    public boolean isBanned(String entityId) {
        return this.bannedEntities.contains(entityId) || this.bannedEntities.contains("all");
    }

    public void banEntity(String entityId) {
        if ("all".equals(entityId)) {
            this.bannedEntities.clear();
        }
        this.bannedEntities.add(entityId);
        this.method_80();
    }

    public void unbanEntity(String entityId) {
        if ("all".equals(entityId)) {
            this.bannedEntities.clear();
        } else {
            this.bannedEntities.remove(entityId);
        }
        this.method_80();
    }

    public Set<String> getBannedEntities() {
        return new HashSet<String>(this.bannedEntities);
    }

    public void clearAll() {
        this.bannedEntities.clear();
        this.method_80();
    }

    private static MinecraftServer getCurrentServer() {
        return null;
    }

    public static BanListData get(MinecraftServer server) {
        if (server == null) {
            return new BanListData();
        }
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            return new BanListData();
        }
        return (BanListData)overworld.method_17983().method_17924(BanListData::new, BanListData::new, DATA_NAME);
    }
}

