/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ScoreExpressionManager
extends class_18 {
    private static final String DATA_NAME = "gd656killicon_score_expressions";
    private final Map<String, String> expressions = new HashMap<String, String>();

    public ScoreExpressionManager() {
        this.resetToDefaults();
    }

    public ScoreExpressionManager(class_2487 nbt) {
        class_2487 expressionsTag = nbt.method_10562("expressions");
        for (String key : expressionsTag.method_10541()) {
            this.expressions.put(key, expressionsTag.method_10558(key));
        }
        if (this.expressions.isEmpty()) {
            this.resetToDefaults();
        }
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compound) {
        class_2487 expressionsTag = new class_2487();
        for (Map.Entry<String, String> entry : this.expressions.entrySet()) {
            expressionsTag.method_10582(entry.getKey(), entry.getValue());
        }
        compound.method_10566("expressions", (class_2520)expressionsTag);
        return compound;
    }

    public static ScoreExpressionManager get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            return new ScoreExpressionManager();
        }
        return (ScoreExpressionManager)overworld.method_17983().method_17924(ScoreExpressionManager::new, ScoreExpressionManager::new, DATA_NAME);
    }

    public void resetToDefaults() {
        this.expressions.clear();
        this.expressions.put("kill", "health * 5");
        this.expressions.put("critical", "killscore * 0.25");
        this.expressions.put("longrange", "distance");
        this.expressions.put("damage", "damage");
        this.expressions.put("magic", "damage");
        this.expressions.put("hand", "damage");
        this.expressions.put("assist", "damagedealt * 5");
        this.expressions.put("combobonus", "combo * 8");
        this.method_80();
    }

    public String getExpression(String scoreType) {
        return this.expressions.getOrDefault(scoreType, "");
    }

    public void setExpression(String scoreType, String expression) {
        this.expressions.put(scoreType, expression);
        this.method_80();
    }

    public Map<String, String> getAllExpressions() {
        return new HashMap<String, String>(this.expressions);
    }
}

