/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;

public class ConfigScreen
extends Screen {
    private final Screen parent;
    private OptionsList list;
    private static ConfigScreen instance;
    private static final int TITLE_HEIGHT = 10;
    private static final int OPTIONS_LIST_TOP_HEIGHT = 26;
    private static final int OPTIONS_LIST_BOTTOM_OFFSET = 32;
    private static final int OPTIONS_LIST_ITEM_HEIGHT = 25;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BACK_BUTTON_WIDTH = 80;
    private static final int BACK_BUTTON_HEIGHT = 20;
    private static final int BACK_PADDING = 10;
    private Button resetButton;
    private boolean resetConfirmation = false;
    private long resetConfirmationTime = 0L;
    private static final long RESET_CONFIRMATION_TIMEOUT = 3000L;

    public ConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"gd656killicon.config.title"));
        this.parent = parent;
    }

    public static ConfigScreen getInstance() {
        return instance;
    }

    public void onClose() {
        instance = null;
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    protected void init() {
        super.init();
        int listTop = 26;
        int listBottom = this.height - 32;
        int listHeight = listBottom - listTop;
        if (this.list == null) {
            this.list = new OptionsList(this.minecraft, this.width, listHeight, listTop, 25);
        } else {
            this.list.setSize(this.width, listHeight);
            this.list.setPosition(0, listTop);
        }
        this.clearWidgets();
        this.addWidget((GuiEventListener)this.list);
        instance = this;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gd656killicon.modconfig.back"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(this.width - 80 - 10, 10, 80, 20).build());
        int totalButtonsWidth = 410;
        int startX = (this.width - totalButtonsWidth) / 2;
        int buttonY = this.height - 20 - 6;
        this.resetButton = Button.builder((Component)Component.translatable((String)"gd656killicon.config.reset"), button -> {
            if (this.resetConfirmation) {
                this.resetToDefaults();
                this.resetConfirmation = false;
                this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.config.reset"));
            } else {
                this.resetConfirmation = true;
                this.resetConfirmationTime = System.currentTimeMillis();
                this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.config.reset_confirm"));
            }
        }).bounds(startX, buttonY, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.saveConfig();
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(startX + 200 + 10, buttonY, 200, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.list != null) {
            try {
                this.list.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Error rendering options list: {}", (Object)e.getMessage());
            }
        }
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        if (this.resetConfirmation && System.currentTimeMillis() - this.resetConfirmationTime > 3000L) {
            this.resetConfirmation = false;
            if (this.resetButton != null) {
                this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.config.reset"));
            }
        }
    }

    private void saveConfig() {
        Config.KILL_BONUS_DISPLAY.set((Object)this.list.killBonusDisplay.getValue());
        Config.ASSIST_BONUS_DISPLAY.set((Object)this.list.assistBonusDisplay.getValue());
        Config.CRITICAL_BONUS_DISPLAY.set((Object)this.list.criticalBonusDisplay.getValue());
        Config.LONGRANGE_BONUS_DISPLAY.set((Object)this.list.longrangeBonusDisplay.getValue());
        Config.MAGIC_BONUS_DISPLAY.set((Object)this.list.magicBonusDisplay.getValue());
        Config.HAND_BONUS_DISPLAY.set((Object)this.list.handBonusDisplay.getValue());
        Config.COMBO_BONUS_DISPLAY.set((Object)this.list.comboBonusDisplay.getValue());
        Config.DAMAGE_BONUS_DISPLAY.set((Object)this.list.damageBonusDisplay.getValue());
        Config.KILL_ICON_DURATION.set((Object)this.list.killIconDuration.getValue());
        Config.KILL_ICON_SIZE.set((Object)this.list.killIconSize.getValue());
        Config.WEAPON_COLOR.set((Object)this.list.weaponColor.getValue());
        Config.TARGET_COLOR.set((Object)this.list.targetColor.getValue());
        Config.CUSTOM_SUBTITLE_FORMAT.set((Object)this.list.customSubtitleFormat.getValue());
        Config.SOUND_VOLUME.set((Object)this.list.soundVolume.getValue());
        Config.CRITICAL_COLOR.set((Object)this.list.criticalColor.getValue());
        Config.ICON_MODE.set((Object)this.list.iconMode.getValue());
        Config.COMBO_SCORE_FONT_SCALE.set((Object)this.list.comboScoreFontScale.getValue());
        Config.FLASHING_COLOR.set((Object)this.list.flashingColor.getValue());
        Config.HIGH_SCORE_COLOR.set((Object)this.list.highScoreColor.getValue());
        Config.COMBO_TIMEOUT.set((Object)this.list.comboTimeout.getValue());
        Config.SCROLL_ANIMATION_SPEED.set((Object)((double)this.list.scrollAnimationSpeed.getValue() / 100.0));
        Config.ASSIST_SUBTITLE_FORMAT.set((Object)this.list.assistSubtitleFormat.getValue());
        Config.SCROLL_SENSITIVITY.set((Object)((double)this.list.scrollSensitivity.getValue() / 100.0));
        Config.FORCE_HIDE_COUNT.set((Object)this.list.forceHideCount.getValue());
        Config.MAX_DISPLAY_COUNT.set((Object)this.list.maxDisplayCount.getValue());
        Config.ICON_STYLE.set((Object)this.list.iconStyle.getValue());
        Config.CARD_ICON_STYLE.set((Object)this.list.cardIconStyle.getValue());
        Config.ENABLE_SOUND_EFFECTS.set((Object)this.list.enableSoundEffects.getValue());
        Config.SPEC.save();
        Config.loadConfig();
        this.resetConfirmation = false;
        this.resetButton.setMessage((Component)Component.translatable((String)"gd656killicon.config.reset"));
    }

    private void resetToDefaults() {
        Config.resetAllToDefaults();
        if (this.list != null) {
            this.list.killBonusDisplay.setValue("\u51fb\u8d25\u751f\u7269 +{score}");
            this.list.assistBonusDisplay.setValue("\u52a9\u653b\u51fb\u8d25 +{score}");
            this.list.criticalBonusDisplay.setValue("\u66b4\u51fb\u52a0\u6210 +{score}");
            this.list.magicBonusDisplay.setValue("\u9b54\u6cd5\u4f24\u5bb3 +{score}");
            this.list.handBonusDisplay.setValue("\u7a7a\u624b\u653b\u51fb +{score}");
            this.list.damageBonusDisplay.setValue("\u9020\u6210\u4f24\u5bb3 +{score}");
            this.list.longrangeBonusDisplay.setValue("\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}");
            this.list.comboBonusDisplay.setValue("[6]{combo}[f] \u8fde\u6740 ! +{score}");
            this.list.killIconDuration.setValue(60);
            this.list.killIconSize.setValue(32);
            this.list.weaponColor.setValue("008080");
            this.list.targetColor.setValue("008080");
            this.list.customSubtitleFormat.setValue("\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}");
            this.list.assistSubtitleFormat.setValue("\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}");
            this.list.soundVolume.setValue(100);
            this.list.criticalColor.setValue("FFD700");
            this.list.iconMode.setValue(Config.IconMode.SCROLLING);
            this.list.comboScoreFontScale.setValue(250);
            this.list.flashingColor.setValue("DCDCDC");
            this.list.highScoreColor.setValue("FFD700");
            this.list.comboTimeout.setValue(3);
            this.list.scrollAnimationSpeed.setValue(20);
            this.list.scrollSensitivity.setValue(100);
            this.list.iconStyle.setValue(Config.IconStyle.MODERN);
            this.list.cardIconStyle.setValue(Config.IconStyle.MODERN);
            this.list.forceHideCount.setValue(9);
            this.list.maxDisplayCount.setValue(30);
            this.list.enableSoundEffects.setValue(true);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        double adjustedDelta = scrollY * (Double)Config.SCROLL_SENSITIVITY.get();
        if (this.list != null && this.list.isMouseOver(mouseX, mouseY)) {
            return this.list.mouseScrolled(mouseX, mouseY, scrollX, adjustedDelta);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, adjustedDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickedEditBox = false;
        if (this.list != null && this.list.isMouseOver(mouseX, mouseY)) {
            for (OptionsList.Entry entry : this.list.children()) {
                if (!(entry instanceof OptionsList.EditBoxOptionEntry)) continue;
                OptionsList.EditBoxOptionEntry editBoxEntry = (OptionsList.EditBoxOptionEntry)entry;
                if (!editBoxEntry.editBox.isMouseOver(mouseX, mouseY)) continue;
                this.setFocused((GuiEventListener)editBoxEntry.editBox);
                clickedEditBox = editBoxEntry.editBox.mouseClicked(mouseX, mouseY, button);
                break;
            }
        }
        if (clickedEditBox) {
            return true;
        }
        this.setFocused(null);
        if (this.list != null && this.list.isMouseOver(mouseX, mouseY)) {
            return this.list.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.list != null && this.list.isMouseOver(mouseX, mouseY)) {
            return this.list.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.list != null && this.list.isMouseOver(mouseX, mouseY)) {
            return this.list.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    class OptionsList
    extends ContainerObjectSelectionList<Entry> {
        public EditBoxOptionEntry killBonusDisplay;
        public EditBoxOptionEntry assistBonusDisplay;
        public EditBoxOptionEntry criticalBonusDisplay;
        public EditBoxOptionEntry longrangeBonusDisplay;
        public EditBoxOptionEntry magicBonusDisplay;
        public EditBoxOptionEntry handBonusDisplay;
        public EditBoxOptionEntry comboBonusDisplay;
        public EditBoxOptionEntry damageBonusDisplay;
        public SliderOptionEntry killIconDuration;
        public SliderOptionEntry killIconSize;
        public EditBoxOptionEntry customSubtitleFormat;
        public SliderOptionEntry soundVolume;
        public EditBoxOptionEntry weaponColor;
        public EditBoxOptionEntry targetColor;
        public EditBoxOptionEntry criticalColor;
        public ModeOptionEntry iconMode;
        public SliderOptionEntry comboScoreFontScale;
        public EditBoxOptionEntry flashingColor;
        public EditBoxOptionEntry highScoreColor;
        public SliderOptionEntry comboTimeout;
        public SliderOptionEntry scrollAnimationSpeed;
        public EditBoxOptionEntry assistSubtitleFormat;
        public SliderOptionEntry scrollSensitivity;
        public IconStyleOptionEntry iconStyle;
        public SliderOptionEntry forceHideCount;
        public SliderOptionEntry maxDisplayCount;
        public IconStyleOptionEntry cardIconStyle;
        public BooleanOptionEntry enableSoundEffects;

        public OptionsList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
            this.setRenderBackground(false);
            this.addEntry((AbstractSelectionList.Entry)new SpacerEntry());
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)"gd656killicon.config.category.sound")));
            this.enableSoundEffects = new BooleanOptionEntry((Component)Component.translatable((String)"gd656killicon.config.enableSoundEffects"), (Boolean)Config.ENABLE_SOUND_EFFECTS.get());
            this.addEntry((AbstractSelectionList.Entry)this.enableSoundEffects);
            this.soundVolume = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.soundVolume"), 0, 125, (Integer)Config.SOUND_VOLUME.get());
            this.addEntry((AbstractSelectionList.Entry)this.soundVolume);
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)"gd656killicon.config.category.bonus_display")));
            this.killBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.killBonusDisplay"), Config.killBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.killBonusDisplay);
            this.assistBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.assistBonusDisplay"), Config.assistBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.assistBonusDisplay);
            this.criticalBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.criticalBonusDisplay"), Config.criticalBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.criticalBonusDisplay);
            this.magicBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.magicBonusDisplay"), Config.magicBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.magicBonusDisplay);
            this.handBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.handBonusDisplay"), Config.handBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.handBonusDisplay);
            this.comboBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.comboBonusDisplay"), Config.comboBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.comboBonusDisplay);
            this.damageBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.damageBonusDisplay"), Config.damageBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.damageBonusDisplay);
            this.longrangeBonusDisplay = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.longrangeBonusDisplay"), Config.longrangeBonusDisplay, 200);
            this.addEntry((AbstractSelectionList.Entry)this.longrangeBonusDisplay);
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)"gd656killicon.config.category.combo_score")));
            this.comboScoreFontScale = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.comboScoreFontScale"), 100, 500, (Integer)Config.COMBO_SCORE_FONT_SCALE.get());
            this.addEntry((AbstractSelectionList.Entry)this.comboScoreFontScale);
            this.comboTimeout = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.comboTimeout"), 1, 10, (Integer)Config.COMBO_TIMEOUT.get());
            this.addEntry((AbstractSelectionList.Entry)this.comboTimeout);
            this.scrollAnimationSpeed = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.scrollAnimationSpeed"), 10, 100, (int)((Double)Config.SCROLL_ANIMATION_SPEED.get() * 100.0));
            this.addEntry((AbstractSelectionList.Entry)this.scrollAnimationSpeed);
            this.addEntry((AbstractSelectionList.Entry)new SpacerEntry());
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)"gd656killicon.config.category.kill_icon")));
            this.killIconDuration = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.killIconDuration"), 20, 200, (Integer)Config.KILL_ICON_DURATION.get());
            this.addEntry((AbstractSelectionList.Entry)this.killIconDuration);
            this.killIconSize = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.killIconSize"), 16, 64, (Integer)Config.KILL_ICON_SIZE.get());
            this.addEntry((AbstractSelectionList.Entry)this.killIconSize);
            this.iconMode = new ModeOptionEntry((Component)Component.translatable((String)"gd656killicon.config.iconMode"), (Config.IconMode)((Object)Config.ICON_MODE.get()));
            this.addEntry((AbstractSelectionList.Entry)this.iconMode);
            this.iconStyle = new IconStyleOptionEntry((Component)Component.translatable((String)"gd656killicon.config.iconStyle"), (Config.IconStyle)((Object)Config.ICON_STYLE.get()));
            this.addEntry((AbstractSelectionList.Entry)this.iconStyle);
            this.cardIconStyle = new IconStyleOptionEntry((Component)Component.translatable((String)"gd656killicon.config.cardIconStyle"), (Config.IconStyle)((Object)Config.CARD_ICON_STYLE.get()));
            this.addEntry((AbstractSelectionList.Entry)this.cardIconStyle);
            this.forceHideCount = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.forceHideCount"), 3, 20, (Integer)Config.FORCE_HIDE_COUNT.get());
            this.addEntry((AbstractSelectionList.Entry)this.forceHideCount);
            this.maxDisplayCount = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.maxDisplayCount"), 5, 30, (Integer)Config.MAX_DISPLAY_COUNT.get());
            this.addEntry((AbstractSelectionList.Entry)this.maxDisplayCount);
            this.addEntry((AbstractSelectionList.Entry)new SpacerEntry());
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)"gd656killicon.config.category.display_control")));
            this.scrollSensitivity = new SliderOptionEntry((Component)Component.translatable((String)"gd656killicon.config.scrollSensitivity"), 10, 200, (int)((Double)Config.SCROLL_SENSITIVITY.get() * 100.0));
            this.addEntry((AbstractSelectionList.Entry)this.scrollSensitivity);
            this.customSubtitleFormat = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.customSubtitleFormat"), (String)Config.CUSTOM_SUBTITLE_FORMAT.get(), 200);
            this.addEntry((AbstractSelectionList.Entry)this.customSubtitleFormat);
            this.assistSubtitleFormat = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.assistSubtitleFormat"), (String)Config.ASSIST_SUBTITLE_FORMAT.get(), 200);
            this.addEntry((AbstractSelectionList.Entry)this.assistSubtitleFormat);
            this.addEntry((AbstractSelectionList.Entry)new SpacerEntry());
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)"gd656killicon.config.category.text_colors")));
            this.weaponColor = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.weaponColor"), (String)Config.WEAPON_COLOR.get());
            this.addEntry((AbstractSelectionList.Entry)this.weaponColor);
            this.targetColor = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.targetColor"), (String)Config.TARGET_COLOR.get());
            this.addEntry((AbstractSelectionList.Entry)this.targetColor);
            this.criticalColor = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.criticalColor"), (String)Config.CRITICAL_COLOR.get());
            this.addEntry((AbstractSelectionList.Entry)this.criticalColor);
            this.highScoreColor = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.highScoreColor"), (String)Config.HIGH_SCORE_COLOR.get());
            this.addEntry((AbstractSelectionList.Entry)this.highScoreColor);
            this.flashingColor = new EditBoxOptionEntry((Component)Component.translatable((String)"gd656killicon.config.flashingColor"), (String)Config.FLASHING_COLOR.get());
            this.addEntry((AbstractSelectionList.Entry)this.flashingColor);
            this.addEntry((AbstractSelectionList.Entry)new SpacerEntry());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            if (this.getMaxScroll() <= 0) {
                return false;
            }
            double scrollAmount = -scrollY * (Double)Config.SCROLL_SENSITIVITY.get() * (double)this.itemHeight / 2.0;
            this.setScrollAmount(this.getScrollAmount() + scrollAmount);
            return true;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight()) && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth());
        }

        static class SpacerEntry
        extends Entry {
            SpacerEntry() {
            }

            public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of();
            }
        }

        class CategoryEntry
        extends Entry {
            private final Component text;

            public CategoryEntry(Component text) {
                this.text = text;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(ConfigScreen.this.font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawCenteredString(ConfigScreen.this.font, this.text, left + width / 2, textY, 0xFFFFFF);
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of();
            }
        }

        class BooleanOptionEntry
        extends Entry {
            private final Checkbox checkbox;
            private final Component label;

            public BooleanOptionEntry(Component label, boolean initialValue) {
                this.label = label;
                this.checkbox = Checkbox.builder((Component)Component.empty(), (Font)ConfigScreen.this.font).pos(0, 0).selected(initialValue).build();
            }

            public void setValue(boolean value) {
                if (this.checkbox.selected() != value) {
                    this.checkbox.onPress();
                }
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(ConfigScreen.this.font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(ConfigScreen.this.font, this.label, left, textY, 0xFFFFFF);
                this.checkbox.setX(left + width - 150);
                this.checkbox.setY(top);
                this.checkbox.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean getValue() {
                return this.checkbox.selected();
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.checkbox);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.checkbox);
            }
        }

        class SliderOptionEntry
        extends Entry {
            private final CustomSlider slider;
            private final Component label;

            public SliderOptionEntry(Component label, int min, int max, int initialValue) {
                this.label = label;
                this.slider = new CustomSlider(0, 0, 150, 20, (Component)Component.empty(), (double)(initialValue - min) / (double)(max - min), min, max);
            }

            public void setValue(int value) {
                this.slider.setIntValue(value);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(ConfigScreen.this.font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(ConfigScreen.this.font, this.label, left, textY, 0xFFFFFF);
                this.slider.setX(left + width - 150);
                this.slider.setY(top);
                this.slider.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public int getValue() {
                return this.slider.getIntValue();
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.slider);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.slider);
            }

            static class CustomSlider
            extends AbstractSliderButton {
                private final int min;
                private final int max;

                public CustomSlider(int x, int y, int width, int height, Component message, double value, int min, int max) {
                    super(x, y, width, height, message, value);
                    this.min = min;
                    this.max = max;
                    this.updateMessage();
                }

                protected void updateMessage() {
                    this.setMessage((Component)Component.literal((String)(this.getIntValue() + "%")));
                }

                protected void applyValue() {
                }

                public int getIntValue() {
                    return this.min + (int)(this.value * (double)(this.max - this.min));
                }

                public void setIntValue(int value) {
                    this.value = Mth.clamp((double)((double)(value - this.min) / (double)(this.max - this.min)), (double)0.0, (double)1.0);
                    this.updateMessage();
                }
            }
        }

        class EditBoxOptionEntry
        extends Entry {
            private final EditBox editBox;
            private final Component label;
            private final boolean isColorOption;

            public EditBoxOptionEntry(Component label, String initialValue) {
                this(label, initialValue, 100, true);
            }

            public EditBoxOptionEntry(Component label, String initialValue, int width) {
                this(label, initialValue, width, false);
            }

            public EditBoxOptionEntry(Component label, String initialValue, int width, boolean isColorOption) {
                this.label = label;
                this.isColorOption = isColorOption;
                this.editBox = new EditBox(ConfigScreen.this.font, 0, 0, width, 20, (Component)Component.empty());
                this.editBox.setValue(initialValue);
                this.editBox.setMaxLength(isColorOption ? 6 : 256);
                this.editBox.setFocused(true);
                this.editBox.setCanLoseFocus(true);
            }

            public void setValue(String value) {
                this.editBox.setValue(value);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(ConfigScreen.this.font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(ConfigScreen.this.font, this.label, left, textY, 0xFFFFFF);
                if (this.isColorOption) {
                    int colorValue;
                    this.editBox.setX(left + width - 150 + 75);
                    this.editBox.setY(top);
                    this.editBox.setWidth(75);
                    this.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
                    int colorBoxX = left + width - 150 + 130;
                    int colorBoxSize = 20;
                    String colorText = this.editBox.getValue();
                    try {
                        String colorStr = "FF" + colorText.replace("#", "");
                        colorValue = (int)Long.parseLong(colorStr, 16);
                    }
                    catch (Exception e) {
                        colorValue = -1;
                    }
                    guiGraphics.fill(colorBoxX, top, colorBoxX + colorBoxSize, top + colorBoxSize, colorValue);
                    guiGraphics.fill(colorBoxX, top, colorBoxX + 1, top + colorBoxSize, -16777216);
                    guiGraphics.fill(colorBoxX + colorBoxSize - 1, top, colorBoxX + colorBoxSize, top + colorBoxSize, -16777216);
                    guiGraphics.fill(colorBoxX, top, colorBoxX + colorBoxSize, top + 1, -16777216);
                    guiGraphics.fill(colorBoxX, top + colorBoxSize - 1, colorBoxX + colorBoxSize, top + colorBoxSize, -16777216);
                } else {
                    this.editBox.setX(left + width - 150 + 50);
                    this.editBox.setY(top);
                    this.editBox.setWidth(100);
                    this.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            public String getValue() {
                return this.editBox.getValue();
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.editBox);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.editBox);
            }
        }

        class ModeOptionEntry
        extends Entry {
            private final CycleButton<Config.IconMode> modeButton;
            private final Component label;

            public ModeOptionEntry(Component label, Config.IconMode initialValue) {
                this.label = label;
                this.modeButton = CycleButton.builder(mode -> Component.translatable((String)mode.getTranslationKey())).withValues((Object[])Config.IconMode.values()).withInitialValue((Object)initialValue).create(0, 0, 150, 20, (Component)Component.empty(), (button, mode) -> Component.translatable((String)mode.getTranslationKey()));
            }

            public void setValue(Config.IconMode value) {
                this.modeButton.setValue((Object)value);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(ConfigScreen.this.font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(ConfigScreen.this.font, this.label, left, textY, 0xFFFFFF);
                this.modeButton.setX(left + width - 150);
                this.modeButton.setY(top);
                this.modeButton.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconMode getValue() {
                return (Config.IconMode)((Object)this.modeButton.getValue());
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.modeButton);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.modeButton);
            }
        }

        class IconStyleOptionEntry
        extends Entry {
            private final CycleButton<Config.IconStyle> styleButton;
            private final Component label;

            public IconStyleOptionEntry(Component label, Config.IconStyle initialValue) {
                this.label = label;
                this.styleButton = CycleButton.builder(style -> Component.translatable((String)style.getTranslationKey())).withValues((Object[])Config.IconStyle.values()).withInitialValue((Object)initialValue).create(0, 0, 150, 20, (Component)Component.empty(), (button, style) -> Component.translatable((String)style.getTranslationKey()));
            }

            public void setValue(Config.IconStyle value) {
                this.styleButton.setValue((Object)value);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Objects.requireNonNull(ConfigScreen.this.font);
                int textY = top + (height - 9) / 2;
                guiGraphics.drawString(ConfigScreen.this.font, this.label, left, textY, 0xFFFFFF);
                this.styleButton.setX(left + width - 150);
                this.styleButton.setY(top);
                this.styleButton.render(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconStyle getValue() {
                return (Config.IconStyle)((Object)this.styleButton.getValue());
            }

            @NotNull
            public List<AbstractWidget> children() {
                return List.of(this.styleButton);
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return List.of(this.styleButton);
            }
        }

        static abstract class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            Entry() {
            }
        }
    }
}

