/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.data.BanListData;
import org.mods.gd656killicon.data.ScoreData;
import org.mods.gd656killicon.data.ScoreExpressionManager;
import org.mods.gd656killicon.data.ScoreboardBindingData;
import org.mods.gd656killicon.network.CardComboKillDurationPacket;
import org.mods.gd656killicon.network.NetworkHandler;
import org.slf4j.LoggerFactory;

public class ScoreCommand {
    private static final SuggestionProvider<CommandSourceStack> ENTITY_SUGGESTIONS = (context, builder) -> {
        builder.suggest("all");
        return builder.buildFuture();
    };
    private static final Map<String, String> SCORE_TYPE_NAMES = new HashMap<String, String>();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^[a-zA-Z0-9\\s+\\-*/.]+$");
    private static final List<List<Component>> HELP_PAGES = new ArrayList<List<Component>>();

    private static void initializeHelpPages() {
        ArrayList<MutableComponent> page1 = new ArrayList<MutableComponent>();
        page1.add(Component.literal((String)"====== GD656Killicon \u5e2e\u52a9 - \u7b2c1\u9875/\u51712\u9875 =====").withStyle(ChatFormatting.GOLD));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"\u5e2e\u52a9\u5df2\u7ecf\u8fc1\u79fb\u5230\u6a21\u7ec4\u914d\u7f6e\u83dc\u5355\u4e2d\u7684\u5e2e\u52a9\u9875\u9762").withStyle(ChatFormatting.RED));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page1.add(Component.literal((String)""));
        HELP_PAGES.add(page1);
        ArrayList<MutableComponent> page2 = new ArrayList<MutableComponent>();
        page2.add(Component.literal((String)"====== GD656Killicon \u5e2e\u52a9 - \u7b2c2\u9875/\u51712\u9875 =====").withStyle(ChatFormatting.GOLD));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)"").withStyle(ChatFormatting.DARK_GRAY));
        page2.add(Component.literal((String)""));
        HELP_PAGES.add(page2);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gdscore").requires(source -> source.hasPermission(0))).executes(ScoreCommand::getOwnScore)).then(((LiteralArgumentBuilder)Commands.literal((String)"help").executes(context -> ScoreCommand.showHelp((CommandContext<CommandSourceStack>)context, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ScoreCommand.showHelp((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"page")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"top").requires(source -> source.hasPermission(0))).executes(ScoreCommand::getTopScores))).then(((LiteralArgumentBuilder)Commands.literal((String)"get").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ScoreCommand::getPlayerScore)))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ScoreCommand::addScore))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reduce").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ScoreCommand::reduceScore))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ScoreCommand::setScore))))).then(((LiteralArgumentBuilder)Commands.literal((String)"ban").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"entityId", (ArgumentType)StringArgumentType.greedyString()).suggests(ENTITY_SUGGESTIONS).executes(ScoreCommand::banEntity)))).then(((LiteralArgumentBuilder)Commands.literal((String)"allow").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"entityId", (ArgumentType)StringArgumentType.greedyString()).suggests(ENTITY_SUGGESTIONS).executes(ScoreCommand::allowEntity)))).then(((LiteralArgumentBuilder)Commands.literal((String)"banlist").requires(source -> source.hasPermission(2))).executes(ScoreCommand::showBanList))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bonuspoints").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"list").executes(ScoreCommand::listScoreExpressions))).then(Commands.literal((String)"reset").executes(ScoreCommand::resetScoreExpressions))).then(Commands.literal((String)"edit").then(Commands.argument((String)"scoreType", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ScoreExpressionManager manager = ScoreExpressionManager.get();
            Map<String, String> expressions = manager.getAllExpressions();
            for (String key : expressions.keySet()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(ScoreCommand::editScoreExpression)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rule").requires(source -> source.hasPermission(3))).then(Commands.literal((String)"RankingList").then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ScoreCommand::setRankingListRule)))).then(Commands.literal((String)"CardComboKillDurationTime").then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3600)).executes(ScoreCommand::setCardComboKillDurationTime))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"scoreboard").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"binding").then(Commands.argument((String)"objective", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"displayName", (ArgumentType)StringArgumentType.greedyString()).executes(ScoreCommand::bindScoreboard))))).then(Commands.literal((String)"unbind").executes(ScoreCommand::unbindScoreboard)))).then(((LiteralArgumentBuilder)Commands.literal((String)"cardclear").requires(source -> source.hasPermission(2))).executes(ScoreCommand::clearCardCombo)));
    }

    private static int clearCardCombo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.getPlayer() != null) {
            Minecraft.getInstance().execute(() -> KillIconRenderer.clearCardCombo());
            source.sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u5df2\u5f3a\u5236\u6e05\u9664\u6240\u6709\u5361\u724c\u8fde\u6740").withStyle(ChatFormatting.GREEN));
            LoggerFactory.getLogger(ScoreCommand.class).info("\u73a9\u5bb6 {} \u6267\u884c\u4e86\u5361\u724c\u6e05\u9664\u6307\u4ee4", (Object)source.getTextName());
        } else {
            source.sendSystemMessage((Component)Component.literal((String)"\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u6267\u884c\u6b64\u6307\u4ee4").withStyle(ChatFormatting.RED));
        }
        return 1;
    }

    private static int setCardComboKillDurationTime(CommandContext<CommandSourceStack> context) {
        int duration = IntegerArgumentType.getInteger(context, (String)"duration");
        ScoreData scoreData = ScoreData.get();
        scoreData.setCardComboKillDurationTime(duration);
        NetworkHandler.sendToAllPlayers(new CardComboKillDurationPacket(duration));
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (duration == 0) {
            source.sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u5361\u724c\u8fde\u6740\u5224\u5b9a\u65f6\u95f4\u5df2\u8bbe\u7f6e\u4e3a\u6c38\u4e45").withStyle(ChatFormatting.GREEN));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5361\u724c\u8fde\u6740\u5224\u5b9a\u65f6\u95f4\u5df2\u8bbe\u7f6e\u4e3a: " + duration + " \u79d2")).withStyle(ChatFormatting.GREEN));
        }
        return 1;
    }

    private static int setRankingListRule(CommandContext<CommandSourceStack> context) {
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        ScoreData scoreData = ScoreData.get();
        scoreData.setRankingListEnabled(enabled);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (enabled) {
            source.sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u699c\u5355\u5df2\u5f00\u542f").withStyle(ChatFormatting.GREEN));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed").withStyle(ChatFormatting.RED));
        }
        return 1;
    }

    private static int bindScoreboard(CommandContext<CommandSourceStack> context) {
        ScoreboardBindingData bindingData = ScoreboardBindingData.get();
        if (bindingData.isBound()) {
            String currentBinding = bindingData.getObjectiveName() + " (" + bindingData.getDisplayName() + ")";
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u8ba1\u5206\u677f\u7ed1\u5b9a\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\u3002\u5f53\u524d\u5df2\u7ed1\u5b9a: " + currentBinding + "\u3002\u8bf7\u5148\u4f7f\u7528 /gdscore scoreboard unbind \u89e3\u7ed1\u5f53\u524d\u8ba1\u5206\u677f")).withStyle(ChatFormatting.RED));
            return 0;
        }
        String objectiveName = StringArgumentType.getString(context, (String)"objective");
        String displayName = StringArgumentType.getString(context, (String)"displayName");
        if (!ScoreCommand.isValidObjectiveName(objectiveName)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u8ba1\u5206\u677f\u540d\u79f0\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf").withStyle(ChatFormatting.RED));
            return 0;
        }
        bindingData.bind(objectiveName, displayName);
        ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
        Objective objective = scoreboard.getObjective(objectiveName);
        if (objective == null) {
            scoreboard.addObjective(objectiveName, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)displayName), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u7ed1\u5b9a\u6a21\u7ec4\u5206\u6570\u5230\u8ba1\u5206\u677f: " + objectiveName)).withStyle(ChatFormatting.GREEN));
        ScoreCommand.syncScoresToScoreboard(((CommandSourceStack)context.getSource()).getServer());
        return 1;
    }

    private static int unbindScoreboard(CommandContext<CommandSourceStack> context) {
        ScoreboardBindingData bindingData = ScoreboardBindingData.get();
        if (!bindingData.isBound()) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u5f53\u524d\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u8ba1\u5206\u677f").withStyle(ChatFormatting.RED));
            return 0;
        }
        String objectiveName = bindingData.getObjectiveName();
        bindingData.unbind();
        ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
        Objective objective = scoreboard.getObjective(objectiveName);
        if (objective != null) {
            scoreboard.removeObjective(objective);
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u89e3\u7ed1\u8ba1\u5206\u677f: " + objectiveName)).withStyle(ChatFormatting.GREEN));
        return 1;
    }

    private static boolean isValidObjectiveName(String name) {
        return name.matches("[a-zA-Z0-9_]+");
    }

    public static void syncScoresToScoreboard(MinecraftServer server) {
        ScoreboardBindingData bindingData = ScoreboardBindingData.get();
        if (!bindingData.isBound()) {
            return;
        }
        ScoreData scoreData = ScoreData.get();
        ServerScoreboard scoreboard = server.getScoreboard();
        Objective objective = scoreboard.getObjective(bindingData.getObjectiveName());
        if (objective == null) {
            objective = scoreboard.addObjective(bindingData.getObjectiveName(), ObjectiveCriteria.DUMMY, (Component)Component.literal((String)bindingData.getDisplayName()), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
        for (Map.Entry<UUID, Integer> entry : scoreData.getAllScores().entrySet()) {
            ServerPlayer player = server.getPlayerList().getPlayer(entry.getKey());
            if (player == null) continue;
            ScoreHolder scoreHolder = ScoreHolder.forNameOnly((String)player.getScoreboardName());
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            scoreAccess.set(entry.getValue().intValue());
        }
    }

    private static int showHelp(CommandContext<CommandSourceStack> context, int page) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int totalPages = HELP_PAGES.size();
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        List<Component> pageContent = HELP_PAGES.get(page - 1);
        for (Component line : pageContent) {
            source.sendSystemMessage(line);
        }
        source.sendSystemMessage((Component)Component.literal((String)""));
        MutableComponent navigation = Component.literal((String)"");
        if (page > 1) {
            int finalPage = page;
            navigation.append((Component)Component.literal((String)"\u00ab \u4e0a\u4e00\u9875").withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/gdscore help " + (finalPage - 1)))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"\u70b9\u51fb\u67e5\u770b\u4e0a\u4e00\u9875")))));
        } else {
            navigation.append((Component)Component.literal((String)"\u00ab \u4e0a\u4e00\u9875").withStyle(ChatFormatting.GRAY));
        }
        navigation.append((Component)Component.literal((String)" | ").withStyle(ChatFormatting.GRAY));
        navigation.append((Component)Component.literal((String)(page + "/" + totalPages)).withStyle(ChatFormatting.WHITE));
        navigation.append((Component)Component.literal((String)" | ").withStyle(ChatFormatting.GRAY));
        if (page < totalPages) {
            int finalPage1 = page;
            navigation.append((Component)Component.literal((String)"\u4e0b\u4e00\u9875 \u00bb").withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/gdscore help " + (finalPage1 + 1)))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"\u70b9\u51fb\u67e5\u770b\u4e0b\u4e00\u9875")))));
        } else {
            navigation.append((Component)Component.literal((String)"\u4e0b\u4e00\u9875 \u00bb").withStyle(ChatFormatting.GRAY));
        }
        source.sendSystemMessage((Component)navigation);
        return 1;
    }

    private static int listScoreExpressions(CommandContext<CommandSourceStack> context) {
        ScoreExpressionManager manager = ScoreExpressionManager.get();
        Map<String, String> expressions = manager.getAllExpressions();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSystemMessage((Component)Component.literal((String)"====== \u52a0\u5206\u9879\u8868\u8fbe\u5f0f\u5217\u8868 =====").withStyle(ChatFormatting.GOLD));
        source.sendSystemMessage((Component)Component.literal((String)""));
        for (Map.Entry<String, String> entry : expressions.entrySet()) {
            String scoreType = entry.getKey();
            String displayName = SCORE_TYPE_NAMES.getOrDefault(scoreType, scoreType);
            String expression = entry.getValue();
            MutableComponent scoreTypeComponent = Component.literal((String)scoreType).withStyle(ChatFormatting.BOLD);
            MutableComponent fullLine = Component.literal((String)"").append((Component)scoreTypeComponent).append(" (" + displayName + "): ").append((Component)Component.literal((String)expression).withStyle(ChatFormatting.WHITE));
            source.sendSystemMessage((Component)fullLine);
        }
        return 1;
    }

    private static int resetScoreExpressions(CommandContext<CommandSourceStack> context) {
        ScoreExpressionManager manager = ScoreExpressionManager.get();
        manager.resetToDefaults();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u6240\u6709\u52a0\u5206\u9879\u8868\u8fbe\u5f0f\u5df2\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c").withStyle(ChatFormatting.GREEN));
        return 1;
    }

    private static int editScoreExpression(CommandContext<CommandSourceStack> context) {
        String scoreType = StringArgumentType.getString(context, (String)"scoreType");
        String expression = StringArgumentType.getString(context, (String)"expression");
        ScoreExpressionManager manager = ScoreExpressionManager.get();
        Map<String, String> expressions = manager.getAllExpressions();
        if (!expressions.containsKey(scoreType)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u52a0\u5206\u9879\u540d\u79f0").withStyle(ChatFormatting.RED));
            return 0;
        }
        if (!ScoreCommand.validateExpressionFormat(expression)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u8fd0\u7b97\u7b26\u548c\u7a7a\u683c").withStyle(ChatFormatting.RED));
            return 0;
        }
        if (!ScoreCommand.validateExpression(scoreType, expression)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef").withStyle(ChatFormatting.RED));
            return 0;
        }
        manager.setExpression(scoreType, expression);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u52a0\u5206\u9879 " + scoreType + " \u7684\u8868\u8fbe\u5f0f\u5df2\u66f4\u65b0\u4e3a: " + expression)).withStyle(ChatFormatting.GREEN));
        return 1;
    }

    private static boolean validateExpressionFormat(String expression) {
        return EXPRESSION_PATTERN.matcher(expression).matches();
    }

    private static boolean validateExpression(String scoreType, String expression) {
        String[] tokens = expression.split(" ");
        if (tokens.length % 2 != 1) {
            return false;
        }
        if (scoreType.equals("kill") && expression.contains("killscore")) {
            return false;
        }
        Set<String> allowedOperators = Set.of("+", "-", "*", "/");
        for (int i = 1; i < tokens.length; i += 2) {
            if (allowedOperators.contains(tokens[i])) continue;
            return false;
        }
        return true;
    }

    private static int banEntity(CommandContext<CommandSourceStack> context) {
        String entityId = StringArgumentType.getString(context, (String)"entityId");
        BanListData banListData = BanListData.get();
        if ("all".equals(entityId)) {
            banListData.clearAll();
            banListData.banEntity("all");
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u5df2\u7981\u6b62\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570"));
        } else {
            if (ScoreCommand.isValidEntityId(entityId)) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u5b9e\u4f53ID: " + entityId)));
                return 0;
            }
            banListData.banEntity(entityId);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u7981\u6b62\u5b9e\u4f53 " + entityId + " \u7206\u51fa\u5206\u6570")));
        }
        return 1;
    }

    private static int allowEntity(CommandContext<CommandSourceStack> context) {
        String entityId = StringArgumentType.getString(context, (String)"entityId");
        BanListData banListData = BanListData.get();
        if ("all".equals(entityId)) {
            banListData.clearAll();
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u5df2\u5141\u8bb8\u6240\u6709\u5b9e\u4f53\u7206\u51fa\u5206\u6570"));
        } else {
            if (ScoreCommand.isValidEntityId(entityId)) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u65e0\u6548\u7684\u5b9e\u4f53ID: " + entityId)));
                return 0;
            }
            banListData.unbanEntity(entityId);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u5141\u8bb8\u5b9e\u4f53 " + entityId + " \u7206\u51fa\u5206\u6570")));
        }
        return 1;
    }

    private static int showBanList(CommandContext<CommandSourceStack> context) {
        BanListData banListData = BanListData.get();
        Set<String> bannedEntities = banListData.getBannedEntities();
        if (bannedEntities.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u5f53\u524d\u6ca1\u6709\u5b9e\u4f53\u88ab\u7981\u6b62\u7206\u51fa\u5206\u6570"));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"====== \u7981\u6b62\u7206\u5206\u6570\u7684\u5b9e\u4f53\u5217\u8868 ====="));
            for (String entityId : bannedEntities) {
                String displayName = ScoreCommand.getEntityDisplayName(entityId);
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("- " + entityId + (String)(displayName != null ? " (" + displayName + ")" : ""))));
            }
        }
        return 1;
    }

    private static boolean isValidEntityId(String entityId) {
        try {
            ResourceLocation location = ResourceLocation.tryParse((String)entityId);
            return location == null || !BuiltInRegistries.ENTITY_TYPE.containsKey(location);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static String getEntityDisplayName(String entityId) {
        try {
            ResourceLocation location = ResourceLocation.tryParse((String)entityId);
            if (location != null && BuiltInRegistries.ENTITY_TYPE.containsKey(location)) {
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(location);
                return entityType.getDescription().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static int getOwnScore(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            int score = ScoreData.get().getScore(player.getUUID());
            player.sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u60a8\u7684\u5f53\u524d\u5206\u6570: " + score)));
        }
        return 1;
    }

    private static int getPlayerScore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        int score = ScoreData.get().getScore(target.getUUID());
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u73a9\u5bb6 " + target.getName().getString() + " \u7684\u5206\u6570: " + score)));
        return 1;
    }

    private static int getTopScores(CommandContext<CommandSourceStack> context) {
        ScoreData scoreData = ScoreData.get();
        if (scoreData.getRankingListEnabled()) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed").withStyle(ChatFormatting.RED));
            return 0;
        }
        Map<UUID, Integer> allScores = scoreData.getAllScores();
        List topScores = allScores.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).limit(10L).toList();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSystemMessage((Component)Component.literal((String)"========== \u5206\u6570\u6392\u884c\u699c =========="));
        int rank = 1;
        for (Map.Entry entry : topScores) {
            ServerPlayer player = source.getServer().getPlayerList().getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            source.sendSystemMessage((Component)Component.literal((String)(rank + ". " + player.getName().getString() + ": " + entry.getValue())));
            ++rank;
        }
        return 1;
    }

    private static int addScore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        int points = IntegerArgumentType.getInteger(context, (String)"points");
        ScoreData scoreData = ScoreData.get();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (ServerPlayer player : targets) {
            scoreData.addScore(player.getUUID(), points);
            source.sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u7ed9\u73a9\u5bb6 " + player.getName().getString() + " \u589e\u52a0 " + points + " \u5206")));
        }
        return 1;
    }

    private static int reduceScore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        int points = IntegerArgumentType.getInteger(context, (String)"points");
        ScoreData scoreData = ScoreData.get();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (ServerPlayer player : targets) {
            scoreData.reduceScore(player.getUUID(), points);
            source.sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u7ed9\u73a9\u5bb6 " + player.getName().getString() + " \u51cf\u5c11 " + points + " \u5206")));
        }
        return 1;
    }

    private static int setScore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        int points = IntegerArgumentType.getInteger(context, (String)"points");
        ScoreData scoreData = ScoreData.get();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (ServerPlayer player : targets) {
            scoreData.setScore(player.getUUID(), points);
            source.sendSystemMessage((Component)Component.literal((String)("[\u516d\u4e94\u516d] \u5df2\u8bbe\u7f6e\u73a9\u5bb6 " + player.getName().getString() + " \u7684\u5206\u6570\u4e3a " + points)));
        }
        return 1;
    }

    static {
        SCORE_TYPE_NAMES.put("kill", "\u51fb\u6740");
        SCORE_TYPE_NAMES.put("critical", "\u66b4\u51fb\u52a0\u6210");
        SCORE_TYPE_NAMES.put("longrange", "\u8fdc\u8ddd\u79bb\u51fb\u8d25");
        SCORE_TYPE_NAMES.put("damage", "\u9020\u6210\u4f24\u5bb3");
        SCORE_TYPE_NAMES.put("magic", "\u9b54\u6cd5\u4f24\u5bb3");
        SCORE_TYPE_NAMES.put("hand", "\u7a7a\u624b\u653b\u51fb");
        SCORE_TYPE_NAMES.put("assist", "\u52a9\u653b");
        ScoreCommand.initializeHelpPages();
    }
}

