/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ScoreboardBindingData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_scoreboard_binding";
    private String objectiveName;
    private String displayName;

    public ScoreboardBindingData() {
    }

    public ScoreboardBindingData(CompoundTag nbt) {
        if (nbt.contains("objectiveName")) {
            this.objectiveName = nbt.getString("objectiveName");
        }
        if (nbt.contains("displayName")) {
            this.displayName = nbt.getString("displayName");
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compound) {
        if (this.objectiveName != null) {
            compound.putString("objectiveName", this.objectiveName);
        }
        if (this.displayName != null) {
            compound.putString("displayName", this.displayName);
        }
        return compound;
    }

    public static ScoreboardBindingData get() {
        return (ScoreboardBindingData)Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD)).getDataStorage().computeIfAbsent(new SavedData.Factory(ScoreboardBindingData::new, ScoreboardBindingData::new, null), DATA_NAME);
    }

    public boolean isBound() {
        return this.objectiveName != null && !this.objectiveName.isEmpty() && this.displayName != null && !this.displayName.isEmpty();
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void bind(String objectiveName, String displayName) {
        this.objectiveName = objectiveName;
        this.displayName = displayName;
        this.setDirty();
    }

    public void unbind() {
        this.objectiveName = null;
        this.displayName = null;
        this.setDirty();
    }
}

