/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.mods.gd656killicon.client.CardModeRenderer;

public class CardComboKillDurationPacket {
    private final int duration;

    public CardComboKillDurationPacket(int duration) {
        this.duration = duration;
    }

    public CardComboKillDurationPacket(FriendlyByteBuf buf) {
        this.duration = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.duration);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            int timeoutMs = this.duration * 1000;
            CardModeRenderer.setKillChainTimeout(timeoutMs);
        });
        context.setPacketHandled(true);
    }

    public int getDuration() {
        return this.duration;
    }
}

