/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.ScrollingIconRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ComboIconRenderer {
    private static Config.IconStyle currentIconStyle = null;
    public static ResourceLocation[] VANALLA_COMBO_ICONS;

    private static SoundEvent[] getComboSounds() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return new SoundEvent[]{(SoundEvent)Gd656killicon.COMBO_1_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_2_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_3_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_4_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_5_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_6_VANILLA.get()};
        }
        return new SoundEvent[]{(SoundEvent)Gd656killicon.COMBO_1_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_2_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_3_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_4_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_5_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_6_MODERN.get()};
    }

    private static RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        config.iconX = Config.comboIconX;
        config.iconY = Config.comboIconY;
        config.subtitleX = Config.comboSubtitleX;
        config.subtitleY = Config.comboSubtitleY;
        config.scoreX = Config.comboScoreX;
        config.scoreY = Config.comboScoreY;
        config.bonusX = Config.comboBonusX;
        config.bonusY = Config.comboBonusY;
        return config;
    }

    public static void handleComboMode(String weaponName, String targetName, boolean isCritical, boolean isAssist) {
        Minecraft mc = Minecraft.m_91087_();
        KillIconRenderer.activeIcons.clear();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int iconSize = Config.killIconSize;
        RenderHelper.PositionConfig pos = ComboIconRenderer.getCurrentPosition();
        float targetX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetY = screenHeight + pos.iconY;
        int comboIndex = Math.min(KillIconRenderer.comboCount, 6) - 1;
        comboIndex = Math.max(comboIndex, 0);
        ScrollingIconRenderer.KillIconInstance newIcon = new ScrollingIconRenderer.KillIconInstance(System.currentTimeMillis(), targetX - (float)iconSize / 2.0f, targetY - (float)iconSize / 2.0f, isCritical);
        newIcon.isCombo = true;
        newIcon.comboIndex = comboIndex;
        newIcon.isAssist = isAssist;
        newIcon.scale = 1.8f;
        newIcon.brightness = 2.0f;
        KillIconRenderer.latestIsCritical = isCritical;
        SoundEvent[] comboSounds = ComboIconRenderer.getComboSounds();
        if (comboIndex < comboSounds.length) {
            try {
                SoundEvent sound = comboSounds[comboIndex];
                float volume = (float)Config.soundVolume / 100.0f;
                mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)volume));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KillIconRenderer.activeIcons.add(newIcon);
        KillIconRenderer.textAnimationStartTime = System.currentTimeMillis();
        KillIconRenderer.textHideTime = 0L;
        KillIconRenderer.lastKillTime = System.currentTimeMillis();
        KillIconRenderer.isFadingOutAll = false;
        KillIconRenderer.latestWeaponName = weaponName;
        KillIconRenderer.latestTargetName = targetName;
    }

    public static void loadResources() {
        if (currentIconStyle == Config.iconStyle) {
            return;
        }
        String stylePath = Config.iconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        VANALLA_COMBO_ICONS = new ResourceLocation[6];
        for (int i = 0; i < 6; ++i) {
            ComboIconRenderer.VANALLA_COMBO_ICONS[i] = new ResourceLocation("gd656killicon", "textures/gui/" + stylePath + "/combomode/combo_" + (i + 1) + ".png");
        }
        currentIconStyle = Config.iconStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderComboIcon(PoseStack poseStack, ScrollingIconRenderer.KillIconInstance icon, int iconSize) {
        if (icon.comboIndex < 0 || icon.comboIndex >= VANALLA_COMBO_ICONS.length) {
            return;
        }
        int scaledSize = (int)((float)iconSize * icon.scale);
        int offsetX = (iconSize - scaledSize) / 2;
        int offsetY = (iconSize - scaledSize) / 2;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)icon.brightness, (float)icon.brightness, (float)icon.brightness, (float)icon.alpha);
        poseStack.m_85836_();
        try {
            poseStack.m_85837_((double)(icon.currentX + (float)offsetX), (double)(icon.currentY + (float)offsetY), 0.0);
            poseStack.m_85841_(icon.scale, icon.scale, 1.0f);
            ResourceLocation iconTexture = VANALLA_COMBO_ICONS[icon.comboIndex];
            if (iconTexture == null) {
                return;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)iconTexture);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
        }
        finally {
            poseStack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

