/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HistoryRecordScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int MAX_RECORDS = 32;
    private static final int PADDING = 10;
    private static final int TITLE_HEIGHT = 30;
    private final int damageColumnWidth = 100;
    private final int entityColumnWidth = 150;
    private final Screen parent;
    private static final CopyOnWriteArrayList<HistoryRecord> historyRecords = new CopyOnWriteArrayList();
    private static HistoryRecordScreen instance;
    private Button clearButton;
    private int currentMouseX;
    private int currentMouseY;
    private int rowHeight;
    private int tableHeight;
    private int tableWidth;
    private int tableX;
    private int tableY;
    private boolean hasRecords = false;

    public HistoryRecordScreen(Screen parent) {
        super((Component)Component.literal((String)"\u5386\u53f2\u8bb0\u5f55"));
        this.parent = parent;
        instance = this;
        this.updateRecordsState();
    }

    public static void addHistoryRecord(String entityName, String damageInfo, String weaponInfo, boolean isPlayer, boolean isKill) {
        HistoryRecord record = new HistoryRecord(entityName, damageInfo, weaponInfo, isPlayer, isKill);
        historyRecords.add(0, record);
        if (historyRecords.size() > 32) {
            historyRecords.remove(historyRecords.size() - 1);
        }
        if (instance != null) {
            instance.updateRecordsState();
            instance.updateButtonStates();
        }
    }

    public static HistoryRecordScreen getInstance() {
        return instance;
    }

    protected void init() {
        super.init();
        this.tableWidth = this.width - 20;
        this.tableHeight = this.height - 30 - 20 - 40;
        this.tableX = 10;
        this.tableY = 40;
        this.rowHeight = 18;
        this.initButtons();
    }

    public void onClose() {
        instance = null;
        Minecraft.getInstance().setScreen(this.parent);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        if (!this.hasRecords) {
            String noRecordsText = "\u6682\u65e0\u5386\u53f2\u8bb0\u5f55";
            guiGraphics.drawCenteredString(this.font, noRecordsText, this.width / 2, this.height / 2, 0x888888);
        } else {
            String countInfo = "\u5171 " + historyRecords.size() + " \u6761\u8bb0\u5f55";
            guiGraphics.drawString(this.font, countInfo, this.width / 2 - this.font.width(countInfo) / 2, 20, 0xCCCCCC, true);
            this.renderHistoryTable(guiGraphics);
        }
    }

    private void clearHistoryRecords() {
        historyRecords.clear();
        this.updateRecordsState();
        this.updateButtonStates();
    }

    private int getMaxVisibleRows() {
        return (this.tableHeight - 30) / this.rowHeight;
    }

    private void initButtons() {
        int bottomY = this.height - 20 - 10;
        this.clearButton = Button.builder((Component)Component.literal((String)"\u6e05\u7a7a\u8bb0\u5f55"), button -> this.clearHistoryRecords()).bounds(10, bottomY, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.clearButton);
        Button backButton = Button.builder((Component)Component.literal((String)"\u8fd4\u56de"), button -> this.onClose()).bounds(this.width - 60 - 10, bottomY, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)backButton);
        this.updateButtonStates();
    }

    private boolean isMouseOverRow(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.tableX && mouseX <= this.tableX + this.tableWidth && mouseY >= rowY && mouseY <= rowY + this.rowHeight;
    }

    private void renderHistoryTable(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + this.tableHeight, Integer.MIN_VALUE);
        this.renderTableHeader(guiGraphics);
        this.renderTableRows(guiGraphics);
    }

    private void renderRowData(GuiGraphics guiGraphics, HistoryRecord record, int rowY) {
        Objects.requireNonNull(this.font);
        int textY = rowY + (this.rowHeight - 9) / 2;
        int entityX = this.tableX + 10;
        int entityColor = record.isPlayer ? -256 : -1;
        guiGraphics.drawString(this.font, record.entityName, entityX, textY, entityColor, true);
        int damageX = this.tableX + 150 + 10;
        int damageColor = record.isKill ? -43691 : -1;
        guiGraphics.drawString(this.font, record.damageInfo, damageX, textY, damageColor, true);
        int weaponX = this.tableX + 150 + 100 + 10;
        guiGraphics.drawString(this.font, record.weaponInfo, weaponX, textY, 0xFFFFFF, true);
    }

    private void renderTableHeader(GuiGraphics guiGraphics) {
        int headerY = this.tableY + 5;
        guiGraphics.fill(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + 25, -2143009724);
        guiGraphics.fill(this.tableX, this.tableY + 25, this.tableX + this.tableWidth, this.tableY + 26, -10066330);
        int entityX = this.tableX + 10;
        int damageX = this.tableX + 150 + 10;
        int weaponX = this.tableX + 150 + 100 + 10;
        guiGraphics.drawString(this.font, "\u5b9e\u4f53\u540d\u79f0", entityX, headerY, 0xFFFFFF, true);
        guiGraphics.drawString(this.font, "\u4f24\u5bb3\u4fe1\u606f", damageX, headerY, 0xFFFFFF, true);
        guiGraphics.drawString(this.font, "\u6b66\u5668\u4fe1\u606f", weaponX, headerY, 0xFFFFFF, true);
        int separator1X = this.tableX + 150;
        int separator2X = separator1X + 100;
        guiGraphics.fill(separator1X, this.tableY, separator1X + 1, this.tableY + this.tableHeight, -10066330);
        guiGraphics.fill(separator2X, this.tableY, separator2X + 1, this.tableY + this.tableHeight, -10066330);
    }

    private void renderTableRows(GuiGraphics guiGraphics) {
        int visibleRows = Math.min(historyRecords.size(), this.getMaxVisibleRows());
        for (int i = 0; i < visibleRows; ++i) {
            HistoryRecord record = historyRecords.get(i);
            int rowY = this.tableY + 30 + i * this.rowHeight;
            if (i % 2 == 0) {
                guiGraphics.fill(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40202020);
            }
            if (this.isMouseOverRow(this.currentMouseX, this.currentMouseY, rowY)) {
                guiGraphics.fill(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40666666);
            }
            guiGraphics.fill(this.tableX, rowY + this.rowHeight, this.tableX + this.tableWidth, rowY + this.rowHeight + 1, 0x40444444);
            this.renderRowData(guiGraphics, record, rowY);
        }
    }

    private void updateButtonStates() {
        this.clearButton.active = this.hasRecords;
    }

    private void updateRecordsState() {
        this.hasRecords = !historyRecords.isEmpty();
    }

    public static class HistoryRecord {
        public final String damageInfo;
        public final String entityName;
        public final boolean isKill;
        public final boolean isPlayer;
        public final long timestamp = System.currentTimeMillis();
        public final String weaponInfo;

        public HistoryRecord(String entityName, String damageInfo, String weaponInfo, boolean isPlayer, boolean isKill) {
            this.entityName = entityName;
            this.damageInfo = damageInfo;
            this.weaponInfo = weaponInfo;
            this.isPlayer = isPlayer;
            this.isKill = isKill;
        }
    }
}

