/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BanListData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_banlist";
    private final Set<String> bannedEntities = new HashSet<String>();

    public BanListData() {
    }

    public BanListData(CompoundTag nbt) {
        ListTag banList = nbt.getList("bannedEntities", 8);
        for (int i = 0; i < banList.size(); ++i) {
            this.bannedEntities.add(banList.getString(i));
        }
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag banList = new ListTag();
        for (String entityId : this.bannedEntities) {
            banList.add((Object)StringTag.valueOf((String)entityId));
        }
        compound.put("bannedEntities", (Tag)banList);
        return compound;
    }

    public static BanListData get() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return new BanListData();
        }
        ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD);
        if (overworld == null) {
            return new BanListData();
        }
        SavedData.Factory factory = new SavedData.Factory(() -> new BanListData(), (tag, lookup) -> new BanListData((CompoundTag)tag), null);
        return (BanListData)overworld.getDataStorage().computeIfAbsent(factory, DATA_NAME);
    }

    public boolean isBanned(String entityId) {
        return this.bannedEntities.contains(entityId) || this.bannedEntities.contains("all");
    }

    public void banEntity(String entityId) {
        if ("all".equals(entityId)) {
            this.bannedEntities.clear();
        }
        this.bannedEntities.add(entityId);
        this.setDirty();
    }

    public void unbanEntity(String entityId) {
        if ("all".equals(entityId)) {
            this.bannedEntities.clear();
        } else {
            this.bannedEntities.remove(entityId);
        }
        this.setDirty();
    }

    public Set<String> getBannedEntities() {
        return new HashSet<String>(this.bannedEntities);
    }

    public void clearAll() {
        this.bannedEntities.clear();
        this.setDirty();
    }
}

