/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.mods.gd656killicon.data.ScoreboardBindingData;

public class ScoreData
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_scores";
    private boolean rankingListEnabled = true;
    private final ConcurrentHashMap<UUID, Integer> playerScores = new ConcurrentHashMap();
    private int cardComboKillDurationTime = 60;
    private int scoreLimit = 1024;

    public ScoreData() {
    }

    public ScoreData(CompoundTag nbt) {
        ListTag scoreList = nbt.getList("scores", 10);
        for (int i = 0; i < scoreList.size(); ++i) {
            CompoundTag scoreTag = scoreList.getCompound(i);
            UUID playerId = scoreTag.getUUID("playerId");
            int score = scoreTag.getInt("score");
            this.playerScores.put(playerId, score);
        }
        this.rankingListEnabled = nbt.getBoolean("rankingListEnabled");
        this.cardComboKillDurationTime = nbt.getInt("cardComboKillDurationTime");
        if (this.cardComboKillDurationTime < 0) {
            this.cardComboKillDurationTime = 60;
        }
        this.scoreLimit = nbt.getInt("scoreLimit");
        if (this.scoreLimit < 1) {
            this.scoreLimit = 1024;
        }
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag scoreList = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.playerScores.entrySet()) {
            CompoundTag scoreTag = new CompoundTag();
            scoreTag.putUUID("playerId", entry.getKey());
            scoreTag.putInt("score", entry.getValue().intValue());
            scoreList.add((Object)scoreTag);
        }
        compound.put("scores", (Tag)scoreList);
        compound.putBoolean("rankingListEnabled", this.rankingListEnabled);
        compound.putInt("cardComboKillDurationTime", this.cardComboKillDurationTime);
        compound.putInt("scoreLimit", this.scoreLimit);
        return compound;
    }

    public static ScoreData get() {
        SavedData.Factory factory = new SavedData.Factory(() -> new ScoreData(), (tag, lookup) -> new ScoreData((CompoundTag)tag), null);
        return (ScoreData)Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD)).getDataStorage().computeIfAbsent(factory, DATA_NAME);
    }

    public int getScore(UUID playerId) {
        return this.playerScores.getOrDefault(playerId, 0);
    }

    public void addScore(UUID playerId, float points) {
        int currentScore = this.getScore(playerId);
        if (currentScore >= 0x3FFFFFFF) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(playerId);
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u60a8\u7684\u5206\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u589e\u52a0").withStyle(ChatFormatting.RED));
            }
            return;
        }
        int roundedPoints = Math.round(points);
        if (roundedPoints > this.scoreLimit) {
            roundedPoints = this.scoreLimit;
        }
        int finalPoints = roundedPoints;
        this.playerScores.compute(playerId, (key, current) -> {
            int newScore = (current == null ? 0 : current) + finalPoints;
            if (newScore >= 0x3FFFFFFF) {
                ServerPlayer player;
                newScore = 0x3FFFFFFF;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null && (player = server.getPlayerList().getPlayer(playerId)) != null) {
                    player.sendSystemMessage((Component)Component.literal((String)"[\u516d\u4e94\u516d] \u60a8\u7684\u5206\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u589e\u52a0").withStyle(ChatFormatting.RED));
                }
            }
            return newScore;
        });
        this.setDirty();
        this.syncToScoreboard(playerId);
    }

    public void reduceScore(UUID playerId, float points) {
        int currentScore = this.getScore(playerId);
        int roundedPoints = Math.round(points);
        int newScore = Math.max(0, currentScore - roundedPoints);
        this.playerScores.put(playerId, newScore);
        this.setDirty();
        this.syncToScoreboard(playerId);
    }

    public void setScore(UUID playerId, int score) {
        int newScore = Math.max(0, score);
        this.playerScores.put(playerId, newScore);
        this.setDirty();
        this.syncToScoreboard(playerId);
    }

    private void syncToScoreboard(UUID playerId) {
        ServerPlayer player;
        ServerScoreboard scoreboard;
        Objective objective;
        ScoreboardBindingData bindingData;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (bindingData = ScoreboardBindingData.get()).isBound() && (objective = (scoreboard = server.getScoreboard()).getObjective(bindingData.getObjectiveName())) != null && (player = server.getPlayerList().getPlayer(playerId)) != null) {
            int score = this.getScore(playerId);
            scoreboard.getOrCreatePlayerScore((ScoreHolder)player, objective, true).set(score);
        }
    }

    public boolean getRankingListEnabled() {
        return !this.rankingListEnabled;
    }

    public void setRankingListEnabled(boolean enabled) {
        this.rankingListEnabled = enabled;
        this.setDirty();
    }

    public int getCardComboKillDurationTime() {
        return this.cardComboKillDurationTime;
    }

    public void setCardComboKillDurationTime(int duration) {
        this.cardComboKillDurationTime = Math.max(0, Math.min(duration, 3600));
        this.setDirty();
    }

    public void setScoreLimit(int limit) {
        this.scoreLimit = Math.max(1, Math.min(limit, 0x7FFFFFFE));
        this.setDirty();
    }

    public Map<UUID, Integer> getAllScores() {
        return new HashMap<UUID, Integer>(this.playerScores);
    }
}

