/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.mods.gd656killicon.client.KillIconRenderer;

public class KillPacket {
    private final String targetName;
    private final boolean isCritical;
    private final boolean playUltimateSound;
    private final int killScore;
    private final boolean isAssist;
    private final byte damageType;

    public KillPacket(String targetName, boolean isCritical, boolean playUltimateSound, int killScore, boolean isAssist, byte damageType) {
        this.targetName = targetName;
        this.isCritical = isCritical;
        this.playUltimateSound = playUltimateSound;
        this.killScore = killScore;
        this.isAssist = isAssist;
        this.damageType = damageType;
    }

    public KillPacket(FriendlyByteBuf buf) {
        this.targetName = buf.readUtf();
        this.isCritical = buf.readBoolean();
        this.playUltimateSound = buf.readBoolean();
        this.killScore = buf.readInt();
        this.isAssist = buf.readBoolean();
        this.damageType = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUtf(this.targetName);
        buf.writeBoolean(this.isCritical);
        buf.writeBoolean(this.playUltimateSound);
        buf.writeInt(this.killScore);
        buf.writeBoolean(this.isAssist);
        buf.writeByte((int)this.damageType);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            String weaponName = "\u62f3\u5934";
            if (this.damageType == 1) {
                weaponName = "\u9b54\u6cd5\u4f24\u5bb3";
            } else if (this.damageType == 0 && mc.player != null && !mc.player.getMainHandItem().isEmpty()) {
                weaponName = mc.player.getMainHandItem().getDisplayName().getString();
                weaponName = weaponName.replace("[", "").replace("]", "");
            }
            KillIconRenderer.triggerKillIcon(weaponName, this.targetName, this.isCritical, this.playUltimateSound, this.killScore, this.isAssist);
        });
        context.setPacketHandled(true);
    }
}

