/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.RankingDataRequestPacket;

public class RankingListScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int PADDING = 10;
    private static final int ROWS_PER_PAGE = 32;
    private static final int TITLE_HEIGHT = 30;
    private final int rankColumnWidth = 60;
    private final int playerColumnWidth = 200;
    private int rowHeight;
    private int tableHeight;
    private int tableWidth;
    private int tableX;
    private int tableY;
    private Button nextPageButton;
    private Button prevPageButton;
    private int currentPage = 0;
    private boolean hasData = false;
    private boolean isLoading = true;
    private final boolean isInGame;
    private boolean rankingEnabled = true;
    private int totalPages = 0;
    private int currentMouseX;
    private int currentMouseY;
    private static RankingListScreen instance;
    private final Screen parent;
    private final List<RankingEntry> rankingEntries = new ArrayList<RankingEntry>();

    public RankingListScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"\u51fb\u6740\u56fe\u6807\u6392\u884c\u699c"));
        this.parent = parent;
        instance = this;
        this.isInGame = Minecraft.m_91087_().f_91074_ != null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tableWidth = this.f_96543_ - 20;
        this.tableHeight = this.f_96544_ - 30 - 20 - 30;
        this.tableX = 10;
        this.tableY = 40;
        this.rowHeight = 18;
        this.initButtons();
        this.loadRankingData();
    }

    private void initButtons() {
        int bottomY = this.f_96544_ - 20 - 10;
        Button backButton = new Button(this.f_96543_ / 2 - 30, bottomY, 60, 20, (Component)Component.m_237113_((String)"\u8fd4\u56de"), button -> this.m_7379_());
        this.m_142416_((GuiEventListener)backButton);
        this.nextPageButton = new Button(this.f_96543_ - 60 - 10, bottomY, 60, 20, (Component)Component.m_237113_((String)"\u4e0b\u4e00\u9875"), button -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.updateButtonStates();
            }
        });
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.prevPageButton = new Button(10, bottomY, 60, 20, (Component)Component.m_237113_((String)"\u4e0a\u4e00\u9875"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateButtonStates();
            }
        });
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.updateButtonStates();
    }

    private boolean isMouseOverRow(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.tableX && mouseX <= this.tableX + this.tableWidth && mouseY >= rowY && mouseY <= rowY + this.rowHeight;
    }

    private void loadRankingData() {
        this.isLoading = true;
        this.hasData = false;
        this.rankingEnabled = true;
        if (!this.isInGame) {
            this.isLoading = false;
            return;
        }
        NetworkHandler.sendToServer(new RankingDataRequestPacket());
    }

    public void m_7379_() {
        instance = null;
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        RankingListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)0xFFFFFF);
        if (!this.isInGame) {
            String notInGameText = "\u8bf7\u5728\u6e38\u620f\u5185\u67e5\u770b\u6392\u884c\u699c";
            RankingListScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)notInGameText, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFF5555);
            super.m_6305_(poseStack, mouseX, mouseY, partialTick);
            return;
        }
        if (this.isLoading) {
            String loadingText = "\u6b63\u5728\u52a0\u8f7d\u6392\u884c\u699c\u6570\u636e...";
            RankingListScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)loadingText, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
        } else if (!this.rankingEnabled) {
            String disabledText = "\u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed";
            RankingListScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)disabledText, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFF5555);
        } else if (!this.hasData) {
            String noDataText = "\u6682\u65e0\u6570\u636e";
            RankingListScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)noDataText, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0x888888);
        } else {
            String pageInfo = "\u7b2c " + (this.currentPage + 1) + " \u9875 / \u5171 " + this.totalPages + " \u9875";
            RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)pageInfo, (int)(this.f_96543_ / 2 - this.f_96547_.m_92895_(pageInfo) / 2), (int)20, (int)0xCCCCCC);
            this.renderRankingTable(poseStack);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void renderRankingTable(PoseStack poseStack) {
        RankingListScreen.m_93172_((PoseStack)poseStack, (int)this.tableX, (int)this.tableY, (int)(this.tableX + this.tableWidth), (int)(this.tableY + this.tableHeight), (int)Integer.MIN_VALUE);
        this.renderTableHeader(poseStack);
        this.renderTableRows(poseStack);
    }

    private void renderTableHeader(PoseStack poseStack) {
        int headerY = this.tableY + 5;
        RankingListScreen.m_93172_((PoseStack)poseStack, (int)this.tableX, (int)this.tableY, (int)(this.tableX + this.tableWidth), (int)(this.tableY + 25), (int)-2143009724);
        RankingListScreen.m_93172_((PoseStack)poseStack, (int)this.tableX, (int)(this.tableY + 25), (int)(this.tableX + this.tableWidth), (int)(this.tableY + 26), (int)-10066330);
        int rankX = this.tableX + 10;
        int playerX = this.tableX + 60 + 10;
        int scoreX = this.tableX + 60 + 200 + 10;
        RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u6392\u540d", (int)rankX, (int)headerY, (int)0xFFFFFF);
        RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u73a9\u5bb6\u540d\u79f0", (int)playerX, (int)headerY, (int)0xFFFFFF);
        RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u5206\u6570", (int)scoreX, (int)headerY, (int)0xFFFFFF);
        int separator1X = this.tableX + 60;
        int separator2X = separator1X + 200;
        RankingListScreen.m_93172_((PoseStack)poseStack, (int)separator1X, (int)this.tableY, (int)(separator1X + 1), (int)(this.tableY + this.tableHeight), (int)-10066330);
        RankingListScreen.m_93172_((PoseStack)poseStack, (int)separator2X, (int)this.tableY, (int)(separator2X + 1), (int)(this.tableY + this.tableHeight), (int)-10066330);
    }

    private void renderTableRows(PoseStack poseStack) {
        int startIndex = this.currentPage * 32;
        int endIndex = Math.min(startIndex + 32, this.rankingEntries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            RankingEntry entry = this.rankingEntries.get(i);
            int rowY = this.tableY + 30 + (i - startIndex) * this.rowHeight;
            if ((i - startIndex) % 2 == 0) {
                RankingListScreen.m_93172_((PoseStack)poseStack, (int)this.tableX, (int)rowY, (int)(this.tableX + this.tableWidth), (int)(rowY + this.rowHeight), (int)0x40202020);
            }
            if (this.isMouseOverRow(this.currentMouseX, this.currentMouseY, rowY)) {
                RankingListScreen.m_93172_((PoseStack)poseStack, (int)this.tableX, (int)rowY, (int)(this.tableX + this.tableWidth), (int)(rowY + this.rowHeight), (int)0x40666666);
            }
            RankingListScreen.m_93172_((PoseStack)poseStack, (int)this.tableX, (int)(rowY + this.rowHeight), (int)(this.tableX + this.tableWidth), (int)(rowY + this.rowHeight + 1), (int)0x40444444);
            this.renderRowData(poseStack, entry, rowY);
        }
    }

    private void renderRowData(PoseStack poseStack, RankingEntry entry, int rowY) {
        Objects.requireNonNull(this.f_96547_);
        int textY = rowY + (this.rowHeight - 9) / 2;
        int rankX = this.tableX + 10;
        String rankText = String.valueOf(entry.rank);
        int rankColor = this.getRankColor(entry.rank);
        RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)rankText, (int)rankX, (int)textY, (int)rankColor);
        int playerX = this.tableX + 60 + 10;
        RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)entry.playerName, (int)playerX, (int)textY, (int)0xFFFFFF);
        int scoreX = this.tableX + 60 + 200 + 10;
        String scoreText = String.format("%,d", entry.score);
        RankingListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)scoreText, (int)scoreX, (int)textY, (int)0xFFFFFF);
    }

    private void updateButtonStates() {
        this.prevPageButton.f_93623_ = this.currentPage > 0 && this.hasData && this.rankingEnabled;
        this.nextPageButton.f_93623_ = this.currentPage < this.totalPages - 1 && this.hasData && this.rankingEnabled;
    }

    public void updateRankingData(Map<UUID, Integer> serverRankingData, boolean rankingEnabled) {
        this.rankingEntries.clear();
        this.rankingEnabled = rankingEnabled;
        if (!rankingEnabled) {
            this.hasData = false;
            this.isLoading = false;
            this.updateButtonStates();
            return;
        }
        if (serverRankingData != null && !serverRankingData.isEmpty()) {
            ArrayList<Map.Entry<UUID, Integer>> sortedEntries = new ArrayList<Map.Entry<UUID, Integer>>(serverRankingData.entrySet());
            sortedEntries.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
            int rank = 1;
            for (Map.Entry entry : sortedEntries) {
                UUID playerId = (UUID)entry.getKey();
                int score = (Integer)entry.getValue();
                String playerName = this.getPlayerName(playerId);
                this.rankingEntries.add(new RankingEntry(rank, playerName, playerId, score));
                ++rank;
            }
            this.hasData = true;
        } else {
            this.hasData = false;
        }
        this.totalPages = this.hasData ? (int)Math.ceil((double)this.rankingEntries.size() / 32.0) : 0;
        this.isLoading = false;
        this.updateButtonStates();
    }

    public static RankingListScreen getInstance() {
        return instance;
    }

    private String getPlayerName(UUID playerId) {
        try {
            Player player;
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (player = this.f_96541_.f_91073_.m_46003_(playerId)) != null) {
                return player.m_36316_().getName();
            }
            return "\u73a9\u5bb6_" + playerId.toString().substring(0, 8);
        }
        catch (Exception e) {
            return "\u672a\u77e5\u73a9\u5bb6";
        }
    }

    private int getRankColor(int rank) {
        return switch (rank) {
            case 1 -> -10496;
            case 2 -> -4144960;
            case 3 -> -3309774;
            default -> -1;
        };
    }

    private record RankingEntry(int rank, String playerName, UUID playerId, int score) {
    }
}

