/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.mods.gd656killicon.client.KillIconRenderer;

public class KillPacket {
    private final String targetName;
    private final boolean isCritical;
    private final boolean playUltimateSound;
    private final int killScore;
    private final boolean isAssist;
    private final byte damageType;

    public KillPacket(String targetName, boolean isCritical, boolean playUltimateSound, int killScore, boolean isAssist, byte damageType) {
        this.targetName = targetName;
        this.isCritical = isCritical;
        this.playUltimateSound = playUltimateSound;
        this.killScore = killScore;
        this.isAssist = isAssist;
        this.damageType = damageType;
    }

    public KillPacket(FriendlyByteBuf buf) {
        this.targetName = buf.m_130277_();
        this.isCritical = buf.readBoolean();
        this.playUltimateSound = buf.readBoolean();
        this.killScore = buf.readInt();
        this.isAssist = buf.readBoolean();
        this.damageType = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.targetName);
        buf.writeBoolean(this.isCritical);
        buf.writeBoolean(this.playUltimateSound);
        buf.writeInt(this.killScore);
        buf.writeBoolean(this.isAssist);
        buf.writeByte((int)this.damageType);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            String weaponName = "\u7a7a\u624b";
            if (mc.f_91074_ != null) {
                ItemStack mainHandItem = mc.f_91074_.m_21205_();
                if (!mainHandItem.m_41619_()) {
                    weaponName = mainHandItem.m_41786_().getString();
                    weaponName = weaponName.replace("[", "").replace("]", "");
                } else {
                    ItemStack offHandItem = mc.f_91074_.m_21206_();
                    if (!offHandItem.m_41619_()) {
                        weaponName = offHandItem.m_41786_().getString();
                        weaponName = weaponName.replace("[", "").replace("]", "");
                    }
                }
            }
            KillIconRenderer.triggerKillIcon(weaponName, this.targetName, this.isCritical, this.playUltimateSound, this.killScore, this.isAssist);
        });
        ctx.setPacketHandled(true);
    }
}

