/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon;

import com.mojang.logging.LogUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="gd656killicon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.IntValue SCROLL_ICON_X;
    public static ForgeConfigSpec.IntValue SCROLL_ICON_Y;
    public static ForgeConfigSpec.IntValue SCROLL_SUBTITLE_X;
    public static ForgeConfigSpec.IntValue SCROLL_SUBTITLE_Y;
    public static ForgeConfigSpec.IntValue SCROLL_SCORE_X;
    public static ForgeConfigSpec.IntValue SCROLL_SCORE_Y;
    public static ForgeConfigSpec.IntValue SCROLL_BONUS_X;
    public static ForgeConfigSpec.IntValue SCROLL_BONUS_Y;
    public static ForgeConfigSpec.IntValue COMBO_ICON_X;
    public static ForgeConfigSpec.IntValue COMBO_ICON_Y;
    public static ForgeConfigSpec.IntValue COMBO_SUBTITLE_X;
    public static ForgeConfigSpec.IntValue COMBO_SUBTITLE_Y;
    public static ForgeConfigSpec.IntValue COMBO_SCORE_X;
    public static ForgeConfigSpec.IntValue COMBO_SCORE_Y;
    public static ForgeConfigSpec.IntValue COMBO_BONUS_X;
    public static ForgeConfigSpec.IntValue COMBO_BONUS_Y;
    public static ForgeConfigSpec.IntValue CARD_ICON_X;
    public static ForgeConfigSpec.IntValue CARD_ICON_Y;
    public static ForgeConfigSpec.IntValue CARD_SUBTITLE_X;
    public static ForgeConfigSpec.IntValue CARD_SUBTITLE_Y;
    public static ForgeConfigSpec.IntValue CARD_SCORE_X;
    public static ForgeConfigSpec.IntValue CARD_SCORE_Y;
    public static ForgeConfigSpec.IntValue CARD_BONUS_X;
    public static ForgeConfigSpec.IntValue CARD_BONUS_Y;
    public static ForgeConfigSpec.IntValue SCROLL_ICON_SIZE;
    public static ForgeConfigSpec.IntValue SCROLL_SUBTITLE_SIZE;
    public static ForgeConfigSpec.IntValue SCROLL_SCORE_SIZE;
    public static ForgeConfigSpec.IntValue SCROLL_BONUS_SIZE;
    public static ForgeConfigSpec.BooleanValue SCROLL_ICON_VISIBLE;
    public static ForgeConfigSpec.BooleanValue SCROLL_SUBTITLE_VISIBLE;
    public static ForgeConfigSpec.BooleanValue SCROLL_SCORE_VISIBLE;
    public static ForgeConfigSpec.BooleanValue SCROLL_BONUS_VISIBLE;
    public static ForgeConfigSpec.IntValue COMBO_ICON_SIZE;
    public static ForgeConfigSpec.IntValue COMBO_SUBTITLE_SIZE;
    public static ForgeConfigSpec.IntValue COMBO_SCORE_SIZE;
    public static ForgeConfigSpec.IntValue COMBO_BONUS_SIZE;
    public static ForgeConfigSpec.BooleanValue COMBO_ICON_VISIBLE;
    public static ForgeConfigSpec.BooleanValue COMBO_SUBTITLE_VISIBLE;
    public static ForgeConfigSpec.BooleanValue COMBO_SCORE_VISIBLE;
    public static ForgeConfigSpec.BooleanValue COMBO_BONUS_VISIBLE;
    public static ForgeConfigSpec.IntValue CARD_ICON_SIZE;
    public static ForgeConfigSpec.IntValue CARD_SUBTITLE_SIZE;
    public static ForgeConfigSpec.IntValue CARD_SCORE_SIZE;
    public static ForgeConfigSpec.IntValue CARD_BONUS_SIZE;
    public static ForgeConfigSpec.BooleanValue CARD_ICON_VISIBLE;
    public static ForgeConfigSpec.BooleanValue CARD_SUBTITLE_VISIBLE;
    public static ForgeConfigSpec.BooleanValue CARD_SCORE_VISIBLE;
    public static ForgeConfigSpec.BooleanValue CARD_BONUS_VISIBLE;
    public static ForgeConfigSpec.ConfigValue<String> KILL_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> ASSIST_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> CRITICAL_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> LONGRANGE_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> MAGIC_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> HAND_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> COMBO_BONUS_DISPLAY;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_BONUS_DISPLAY;
    public static ForgeConfigSpec.EnumValue<IconStyle> CARD_ICON_STYLE;
    public static ForgeConfigSpec.IntValue KILL_ICON_DURATION;
    public static ForgeConfigSpec.IntValue KILL_ICON_SIZE;
    public static ForgeConfigSpec.ConfigValue<String> WEAPON_COLOR;
    public static ForgeConfigSpec.ConfigValue<String> TARGET_COLOR;
    public static ForgeConfigSpec.ConfigValue<String> CUSTOM_SUBTITLE_FORMAT;
    public static ForgeConfigSpec.IntValue SOUND_VOLUME;
    public static ForgeConfigSpec.ConfigValue<String> CRITICAL_COLOR;
    public static ForgeConfigSpec.EnumValue<IconMode> ICON_MODE;
    public static ForgeConfigSpec.IntValue COMBO_SCORE_DURATION;
    public static ForgeConfigSpec.IntValue COMBO_SCORE_FONT_SCALE;
    public static ForgeConfigSpec.ConfigValue<String> FLASHING_COLOR;
    public static ForgeConfigSpec.ConfigValue<String> HIGH_SCORE_COLOR;
    public static ForgeConfigSpec.IntValue COMBO_TIMEOUT;
    public static ForgeConfigSpec.DoubleValue SCROLL_ANIMATION_SPEED;
    public static ForgeConfigSpec.ConfigValue<String> ASSIST_SUBTITLE_FORMAT;
    public static ForgeConfigSpec.DoubleValue SCROLL_SENSITIVITY;
    public static ForgeConfigSpec.EnumValue<IconStyle> ICON_STYLE;
    public static ForgeConfigSpec.IntValue KILL_ICON_ANIMATION_DURATION;
    public static ForgeConfigSpec.IntValue KILL_ICON_SPACING;
    public static ForgeConfigSpec.IntValue FORCE_HIDE_COUNT;
    public static ForgeConfigSpec.IntValue MAX_DISPLAY_COUNT;
    public static ForgeConfigSpec.IntValue BONUS_LINE_SPACING;
    public static ForgeConfigSpec.BooleanValue ENABLE_SOUND_EFFECTS;
    public static ForgeConfigSpec.IntValue CARD_BOTTOMBAR_SIZE;
    public static ForgeConfigSpec.IntValue CARD_BOTTOMBAR_OFFSET_Y;
    public static ForgeConfigSpec.BooleanValue CARD_BOTTOMBAR_VISIBLE;
    public static ForgeConfigSpec.BooleanValue COMBO_ICON_ANIMATION_ENABLED;
    public static ForgeConfigSpec.IntValue COMBO_ICON_ANIMATION_DURATION;
    public static ForgeConfigSpec.IntValue COMBO_ICON_ANIMATION_TOTAL_FRAMES;
    public static ForgeConfigSpec.IntValue NUMBER_ANIMATION_UPDATE_INTERVAL;
    public static ForgeConfigSpec.IntValue SCORE_ANIMATION_DURATION_NORMAL;
    public static ForgeConfigSpec.BooleanValue COMBO_ICON_ANIMATION_HORIZONTAL;
    public static ForgeConfigSpec.IntValue ICON_PROCESS_INTERVAL;
    public static int scrollIconX;
    public static int scrollIconY;
    public static int scrollSubtitleX;
    public static int scrollSubtitleY;
    public static int scrollScoreX;
    public static int scrollScoreY;
    public static int scrollBonusX;
    public static int scrollBonusY;
    public static int comboIconX;
    public static int comboIconY;
    public static int comboSubtitleX;
    public static int comboSubtitleY;
    public static int comboScoreX;
    public static int comboScoreY;
    public static int comboBonusX;
    public static int comboBonusY;
    public static int cardIconX;
    public static int cardIconY;
    public static int cardSubtitleX;
    public static int cardSubtitleY;
    public static int cardScoreX;
    public static int cardScoreY;
    public static int cardBonusX;
    public static int cardBonusY;
    public static int scrollIconSize;
    public static int scrollSubtitleSize;
    public static int scrollScoreSize;
    public static int scrollBonusSize;
    public static boolean scrollIconVisible;
    public static boolean scrollSubtitleVisible;
    public static boolean scrollScoreVisible;
    public static boolean scrollBonusVisible;
    public static int comboIconSize;
    public static int comboSubtitleSize;
    public static int comboScoreSize;
    public static int comboBonusSize;
    public static boolean comboIconVisible;
    public static boolean comboSubtitleVisible;
    public static boolean comboScoreVisible;
    public static boolean comboBonusVisible;
    public static int cardIconSize;
    public static int cardSubtitleSize;
    public static int cardScoreSize;
    public static int cardBonusSize;
    public static boolean cardIconVisible;
    public static boolean cardSubtitleVisible;
    public static boolean cardScoreVisible;
    public static boolean cardBonusVisible;
    public static int cardBottombarSize;
    public static int cardBottombarOffsetY;
    public static boolean cardBottombarVisible;
    public static int killIconDuration;
    public static int killIconSize;
    public static int weaponColor;
    public static int targetColor;
    public static boolean showKillIcons;
    public static boolean showKillSubtitles;
    public static String customSubtitleFormat;
    public static int soundVolume;
    public static IconMode iconMode;
    public static IconStyle iconStyle;
    public static IconStyle cardIconStyle;
    public static boolean showComboScore;
    public static int comboScoreDuration;
    public static int comboScoreFontScale;
    public static int flashingColor;
    public static int highScoreColor;
    public static int comboTimeout;
    public static double scrollAnimationSpeed;
    public static int comboTimeoutMs;
    public static int criticalColor;
    public static String assistSubtitleFormat;
    public static int weaponColorHex;
    public static int targetColorHex;
    public static int criticalColorHex;
    public static int flashingColorHex;
    public static int highScoreColorHex;
    public static String killBonusDisplay;
    public static String assistBonusDisplay;
    public static String criticalBonusDisplay;
    public static String longrangeBonusDisplay;
    public static String magicBonusDisplay;
    public static String handBonusDisplay;
    public static String comboBonusDisplay;
    public static String damageBonusDisplay;
    public static int killIconAnimationDuration;
    public static int killIconSpacing;
    public static int forceHideCount;
    public static int maxDisplayCount;
    public static int bonusLineSpacing;
    public static boolean enableSoundEffects;
    public static boolean comboIconAnimationEnabled;
    public static int comboIconAnimationDuration;
    public static int comboIconAnimationTotalFrames;
    public static int numberAnimationUpdateInterval;
    public static int scoreAnimationDurationNormal;
    public static boolean comboIconAnimationHorizontal;
    public static int iconProcessInterval;

    public static void loadConfig() {
        Config.loadGeneralConfigs();
        Config.loadPositionConfigs();
        Config.loadElementConfigs();
        Config.loadColorConfigs();
        Config.loadSoundConfigs();
    }

    public static void resetAllToDefaults() {
        try {
            Config.resetBonusConfigs();
            Config.resetGeneralConfigs();
            Config.resetPositionConfigs();
            Config.resetElementConfigs();
            Config.resetStyleConfigs();
            Config.safeSaveConfig();
            Config.loadConfig();
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u91cd\u7f6e\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Config.loadConfig();
        }
    }

    private static int parseColor(String hex) {
        if (hex == null || hex.isEmpty()) {
            return -16744320;
        }
        try {
            Object cleanHex = hex.replace("#", "");
            if (((String)cleanHex).length() == 3) {
                cleanHex = "" + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(2) + ((String)cleanHex).charAt(2);
            }
            return (int)Long.parseLong("FF" + (String)cleanHex, 16);
        }
        catch (Exception e) {
            LOGGER.error("Invalid color format: {}", (Object)hex);
            return -16744320;
        }
    }

    public static void reloadCriticalColor() {
        criticalColor = Config.parseColor((String)CRITICAL_COLOR.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        Config.loadConfig();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        Config.loadConfig();
        Config.reloadCriticalColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeSaveConfig() {
        try {
            ForgeConfigSpec forgeConfigSpec = SPEC;
            synchronized (forgeConfigSpec) {
                SPEC.save();
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u4fdd\u5b58\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
        }
    }

    private static void setupPositionConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u6eda\u52a8\u6a21\u5f0f\u4f4d\u7f6e\u8bbe\u7f6e").push("scroll_mode_positions");
        SCROLL_ICON_X = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u51fb\u6740\u56fe\u6807X\u8f74").defineInRange("scrollIconX", 0, -1000, 1000);
        SCROLL_ICON_Y = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u51fb\u6740\u56fe\u6807Y\u8f74").defineInRange("scrollIconY", -140, -1000, 1000);
        SCROLL_SUBTITLE_X = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55X\u8f74").defineInRange("scrollSubtitleX", 0, -1000, 1000);
        SCROLL_SUBTITLE_Y = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55Y\u8f74").defineInRange("scrollSubtitleY", -100, -1000, 1000);
        SCROLL_SCORE_X = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55X\u8f74").defineInRange("scrollScoreX", 0, -1000, 1000);
        SCROLL_SCORE_Y = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55Y\u8f74").defineInRange("scrollScoreY", -80, -1000, 1000);
        SCROLL_BONUS_X = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55X\u8f74").defineInRange("scrollBonusX", 0, -1000, 1000);
        SCROLL_BONUS_Y = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55Y\u8f74").defineInRange("scrollBonusY", -60, -1000, 1000);
        builder.pop();
        builder.comment("\u8fde\u6740\u6a21\u5f0f\u4f4d\u7f6e\u8bbe\u7f6e").push("combo_mode_positions");
        COMBO_ICON_X = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u51fb\u6740\u56fe\u6807X\u8f74").defineInRange("comboIconX", -9, -1000, 1000);
        COMBO_ICON_Y = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u51fb\u6740\u56fe\u6807Y\u8f74").defineInRange("comboIconY", -139, -1000, 1000);
        COMBO_SUBTITLE_X = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55X\u8f74").defineInRange("comboSubtitleX", 0, -1000, 1000);
        COMBO_SUBTITLE_Y = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55Y\u8f74").defineInRange("comboSubtitleY", -100, -1000, 1000);
        COMBO_SCORE_X = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55X\u8f74").defineInRange("comboScoreX", 0, -1000, 1000);
        COMBO_SCORE_Y = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55Y\u8f74").defineInRange("comboScoreY", -80, -1000, 1000);
        COMBO_BONUS_X = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55X\u8f74").defineInRange("comboBonusX", 0, -1000, 1000);
        COMBO_BONUS_Y = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55Y\u8f74").defineInRange("comboBonusY", -60, -1000, 1000);
        builder.pop();
        builder.comment("\u5361\u724c\u6a21\u5f0f\u4f4d\u7f6e\u8bbe\u7f6e").push("card_mode_positions");
        CARD_ICON_X = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5361\u724c\u539f\u70b9X\u8f74").defineInRange("cardIconX", 0, -1000, 1000);
        CARD_ICON_Y = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5361\u724c\u539f\u70b9Y\u8f74").defineInRange("cardIconY", -90, -1000, 1000);
        CARD_SUBTITLE_X = builder.comment("\u5361\u724c\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55X\u8f74").defineInRange("cardSubtitleX", 0, -1000, 1000);
        CARD_SUBTITLE_Y = builder.comment("\u5361\u724c\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55Y\u8f74").defineInRange("cardSubtitleY", -160, -1000, 1000);
        CARD_SCORE_X = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55X\u8f74").defineInRange("cardScoreX", -80, -1000, 1000);
        CARD_SCORE_Y = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55Y\u8f74").defineInRange("cardScoreY", -105, -1000, 1000);
        CARD_BONUS_X = builder.comment("\u5361\u724c\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55X\u8f74").defineInRange("cardBonusX", 80, -1000, 1000);
        CARD_BONUS_Y = builder.comment("\u5361\u724c\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55Y\u8f74").defineInRange("cardBonusY", -100, -1000, 1000);
        builder.pop();
    }

    private static void setupElementConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u6eda\u52a8\u6a21\u5f0f\u5143\u7d20\u8bbe\u7f6e").push("scroll_mode_elements");
        SCROLL_ICON_SIZE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u51fb\u6740\u56fe\u6807\u5927\u5c0f").defineInRange("scrollIconSize", 32, 16, 64);
        SCROLL_ICON_VISIBLE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u51fb\u6740\u56fe\u6807").define("scrollIconVisible", true);
        SCROLL_SUBTITLE_SIZE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55\u5927\u5c0f").defineInRange("scrollSubtitleSize", 100, 50, 200);
        SCROLL_SUBTITLE_VISIBLE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55").define("scrollSubtitleVisible", true);
        SCROLL_SCORE_SIZE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55\u5927\u5c0f").defineInRange("scrollScoreSize", 250, 100, 500);
        SCROLL_SCORE_VISIBLE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u5206\u6570\u5b57\u5e55").define("scrollScoreVisible", true);
        SCROLL_BONUS_SIZE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55\u5927\u5c0f").defineInRange("scrollBonusSize", 100, 50, 200);
        SCROLL_BONUS_VISIBLE = builder.comment("\u6eda\u52a8\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u52a0\u5206\u9879\u5b57\u5e55").define("scrollBonusVisible", true);
        builder.pop();
        builder.comment("\u8fde\u6740\u6a21\u5f0f\u5143\u7d20\u8bbe\u7f6e").push("combo_mode_elements");
        COMBO_ICON_SIZE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u51fb\u6740\u56fe\u6807\u5927\u5c0f").defineInRange("comboIconSize", 48, 16, 64);
        COMBO_ICON_VISIBLE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u51fb\u6740\u56fe\u6807").define("comboIconVisible", true);
        COMBO_SUBTITLE_SIZE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55\u5927\u5c0f").defineInRange("comboSubtitleSize", 100, 50, 200);
        COMBO_SUBTITLE_VISIBLE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55").define("comboSubtitleVisible", true);
        COMBO_SCORE_SIZE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55\u5927\u5c0f").defineInRange("comboScoreSize", 250, 100, 500);
        COMBO_SCORE_VISIBLE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u5206\u6570\u5b57\u5e55").define("comboScoreVisible", true);
        COMBO_BONUS_SIZE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55\u5927\u5c0f").defineInRange("comboBonusSize", 100, 50, 200);
        COMBO_BONUS_VISIBLE = builder.comment("\u8fde\u6740\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u52a0\u5206\u9879\u5b57\u5e55").define("comboBonusVisible", true);
        COMBO_ICON_ANIMATION_ENABLED = builder.comment("\u662f\u5426\u542f\u7528\u8fde\u6740\u56fe\u6807\u52a8\u56fe").define("comboIconAnimationEnabled", true);
        COMBO_ICON_ANIMATION_DURATION = builder.comment("\u8fde\u6740\u56fe\u6807\u52a8\u753b\u663e\u793a\u65f6\u957f\uff08\u6beb\u79d2\uff09").defineInRange("comboIconAnimationDuration", 1000, 100, 5000);
        COMBO_ICON_ANIMATION_TOTAL_FRAMES = builder.comment("\u8fde\u6740\u56fe\u6807\u52a8\u753b\u603b\u5e27\u6570").defineInRange("comboIconAnimationTotalFrames", 15, 10, 60);
        COMBO_ICON_ANIMATION_HORIZONTAL = builder.comment("\u8fde\u6740\u56fe\u6807\u52a8\u753b\u5e27\u6c34\u5e73\u6392\u5217\uff08true=\u4ece\u5de6\u5230\u53f3\uff0cfalse=\u4ece\u4e0a\u5230\u4e0b\uff09").define("comboIconAnimationHorizontal", true);
        builder.pop();
        builder.comment("\u5361\u724c\u6a21\u5f0f\u5143\u7d20\u8bbe\u7f6e").push("card_mode_elements");
        CARD_ICON_SIZE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5361\u724c\u5927\u5c0f").defineInRange("cardIconSize", 48, 24, 96);
        CARD_ICON_VISIBLE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u5361\u724c").define("cardIconVisible", true);
        CARD_SUBTITLE_SIZE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55\u5927\u5c0f").defineInRange("cardSubtitleSize", 100, 50, 200);
        CARD_SUBTITLE_VISIBLE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u51fb\u8d25\u4fe1\u606f\u5b57\u5e55").define("cardSubtitleVisible", false);
        CARD_SCORE_SIZE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5206\u6570\u5b57\u5e55\u5927\u5c0f").defineInRange("cardScoreSize", 250, 100, 500);
        CARD_SCORE_VISIBLE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u5206\u6570\u5b57\u5e55").define("cardScoreVisible", false);
        CARD_BONUS_SIZE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u52a0\u5206\u9879\u5b57\u5e55\u5927\u5c0f").defineInRange("cardBonusSize", 100, 50, 200);
        CARD_BONUS_VISIBLE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u52a0\u5206\u9879\u5b57\u5e55").define("cardBonusVisible", false);
        CARD_BOTTOMBAR_SIZE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5e95\u90e8\u680f\u5927\u5c0f").defineInRange("cardBottombarSize", 80, 50, 200);
        CARD_BOTTOMBAR_VISIBLE = builder.comment("\u5361\u724c\u6a21\u5f0f-\u662f\u5426\u663e\u793a\u5e95\u90e8\u680f").define("cardBottombarVisible", true);
        CARD_BOTTOMBAR_OFFSET_Y = builder.comment("\u5361\u724c\u6a21\u5f0f-\u5e95\u90e8\u680f\u5782\u76f4\u504f\u79fb").defineInRange("cardBottombarOffsetY", 30, -100, 100);
        builder.pop();
    }

    private static void setupBonusConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0\u8bbe\u7f6e").push("bonus_display_names");
        KILL_BONUS_DISPLAY = builder.comment("\u51fb\u8d25\u751f\u7269\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("killBonusDisplay", (Object)"\u51fb\u8d25\u751f\u7269 +{score}");
        ASSIST_BONUS_DISPLAY = builder.comment("\u52a9\u653b\u51fb\u8d25\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("assistBonusDisplay", (Object)"\u52a9\u653b\u51fb\u8d25 +{score}");
        CRITICAL_BONUS_DISPLAY = builder.comment("\u66b4\u51fb\u52a0\u6210\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("criticalBonusDisplay", (Object)"\u66b4\u51fb\u52a0\u6210 +{score}");
        MAGIC_BONUS_DISPLAY = builder.comment("\u9b54\u6cd5\u4f24\u5bb3\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("magicBonusDisplay", (Object)"\u9b54\u6cd5\u4f24\u5bb3 +{score}");
        HAND_BONUS_DISPLAY = builder.comment("\u7a7a\u624b\u653b\u51fb\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("handBonusDisplay", (Object)"\u7a7a\u624b\u653b\u51fb +{score}");
        DAMAGE_BONUS_DISPLAY = builder.comment("\u9020\u6210\u4f24\u5bb3\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("damageBonusDisplay", (Object)"\u9020\u6210\u4f24\u5bb3 +{score}");
        LONGRANGE_BONUS_DISPLAY = builder.comment("\u8fdc\u8ddd\u79bb\u51fb\u8d25\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("longrangeBonusDisplay", (Object)"\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}");
        COMBO_BONUS_DISPLAY = builder.comment("\u8fde\u6740\u52a0\u5206\u9879\u663e\u793a\u540d\u79f0").define("comboBonusDisplay", (Object)"[6]{combo}[f] \u8fde\u6740 ! +{score}");
        BONUS_LINE_SPACING = builder.comment("\u52a0\u5206\u9879\u5b57\u5e55\u884c\u95f4\u8ddd\uff08\u50cf\u7d20\uff09").defineInRange("bonusLineSpacing", 12, 1, 60);
        builder.pop();
    }

    private static void setupColorConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u6587\u5b57\u989c\u8272\u8bbe\u7f6e").push("text_colors");
        WEAPON_COLOR = builder.comment("\u6b66\u5668\u6587\u5b57\u989c\u8272").define("weaponColor", (Object)"008080");
        TARGET_COLOR = builder.comment("\u76ee\u6807\u6587\u5b57\u989c\u8272").define("targetColor", (Object)"008080");
        CRITICAL_COLOR = builder.comment("\u66b4\u51fb\u6587\u5b57\u989c\u8272").define("criticalColor", (Object)"FFD700");
        FLASHING_COLOR = builder.comment("\u95ea\u70c1\u989c\u8272").define("flashingColor", (Object)"DCDCDC");
        HIGH_SCORE_COLOR = builder.comment("\u9ad8\u5206\u989c\u8272").define("highScoreColor", (Object)"FFD700");
        builder.pop();
    }

    private static void setupSoundConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u97f3\u6548\u8bbe\u7f6e").push("sound");
        ENABLE_SOUND_EFFECTS = builder.comment("\u662f\u5426\u542f\u7528\u6a21\u7ec4\u97f3\u6548").define("enableSoundEffects", true);
        SOUND_VOLUME = builder.comment("\u97f3\u6548\u97f3\u91cf (0-125%)").defineInRange("volume", 100, 0, 125);
        builder.pop();
    }

    private static void setupComboConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u8fde\u51fb\u5206\u6570\u8bbe\u7f6e").push("combo_score");
        COMBO_SCORE_DURATION = builder.comment("\u8fde\u51fb\u5206\u6570\u663e\u793a\u65f6\u957f(\u6beb\u79d2)").defineInRange("comboScoreDuration", 2000, 500, 5000);
        COMBO_SCORE_FONT_SCALE = builder.comment("\u8fde\u51fb\u5206\u6570\u5b57\u4f53\u7f29\u653e\u767e\u5206\u6bd4").defineInRange("comboScoreFontScale", 250, 100, 500);
        COMBO_TIMEOUT = builder.comment("\u8fde\u6740\u5224\u5b9a\u65f6\u95f4\uff08\u79d2\uff09").defineInRange("comboTimeout", 3, 1, 10);
        SCROLL_ANIMATION_SPEED = builder.comment("\u6eda\u52a8\u52a8\u753b\u901f\u5ea6\uff08\u79d2\uff09").defineInRange("scrollAnimationSpeed", 0.2, 0.1, 1.0);
        NUMBER_ANIMATION_UPDATE_INTERVAL = builder.comment("\u52a8\u753b\u66f4\u65b0\u95f4\u9694(\u6beb\u79d2)").defineInRange("numberAnimationUpdateInterval", 33, 1, 2048);
        SCORE_ANIMATION_DURATION_NORMAL = builder.comment("\u666e\u901a\u5206\u6570\u52a8\u753b\u65f6\u957f(\u6beb\u79d2)").defineInRange("scoreAnimationDurationNormal", 2000, 500, 5000);
        builder.pop();
    }

    private static void setupDebugConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("\u754c\u9762\u8bbe\u7f6e").push("ui");
        SCROLL_SENSITIVITY = builder.comment("\u5217\u8868\u6eda\u52a8\u7075\u654f\u5ea6 (0.1-2.0)").defineInRange("scrollSensitivity", 1.0, 0.1, 2.0);
        builder.pop();
    }

    private static void loadGeneralConfigs() {
        killIconDuration = (Integer)KILL_ICON_DURATION.get();
        killIconSize = (Integer)KILL_ICON_SIZE.get();
        customSubtitleFormat = (String)CUSTOM_SUBTITLE_FORMAT.get();
        soundVolume = (Integer)SOUND_VOLUME.get();
        iconMode = (IconMode)((Object)ICON_MODE.get());
        iconStyle = (IconStyle)((Object)ICON_STYLE.get());
        comboScoreDuration = (Integer)COMBO_SCORE_DURATION.get();
        comboScoreFontScale = (Integer)COMBO_SCORE_FONT_SCALE.get();
        comboTimeout = (Integer)COMBO_TIMEOUT.get() * 1000;
        scrollAnimationSpeed = (Double)SCROLL_ANIMATION_SPEED.get();
        comboTimeoutMs = (Integer)COMBO_TIMEOUT.get() * 1000;
        assistSubtitleFormat = (String)ASSIST_SUBTITLE_FORMAT.get();
        killBonusDisplay = (String)KILL_BONUS_DISPLAY.get();
        assistBonusDisplay = (String)ASSIST_BONUS_DISPLAY.get();
        criticalBonusDisplay = (String)CRITICAL_BONUS_DISPLAY.get();
        magicBonusDisplay = (String)MAGIC_BONUS_DISPLAY.get();
        handBonusDisplay = (String)HAND_BONUS_DISPLAY.get();
        damageBonusDisplay = (String)DAMAGE_BONUS_DISPLAY.get();
        longrangeBonusDisplay = (String)LONGRANGE_BONUS_DISPLAY.get();
        comboBonusDisplay = (String)COMBO_BONUS_DISPLAY.get();
        killIconAnimationDuration = (Integer)KILL_ICON_ANIMATION_DURATION.get();
        killIconSpacing = (Integer)KILL_ICON_SPACING.get();
        forceHideCount = (Integer)FORCE_HIDE_COUNT.get();
        maxDisplayCount = (Integer)MAX_DISPLAY_COUNT.get();
        bonusLineSpacing = (Integer)BONUS_LINE_SPACING.get();
        cardIconStyle = (IconStyle)((Object)CARD_ICON_STYLE.get());
        enableSoundEffects = (Boolean)ENABLE_SOUND_EFFECTS.get();
        cardBottombarSize = (Integer)CARD_BOTTOMBAR_SIZE.get();
        cardBottombarVisible = (Boolean)CARD_BOTTOMBAR_VISIBLE.get();
        cardBottombarOffsetY = (Integer)CARD_BOTTOMBAR_OFFSET_Y.get();
        comboIconAnimationEnabled = (Boolean)COMBO_ICON_ANIMATION_ENABLED.get();
        comboIconAnimationDuration = (Integer)COMBO_ICON_ANIMATION_DURATION.get();
        comboIconAnimationTotalFrames = (Integer)COMBO_ICON_ANIMATION_TOTAL_FRAMES.get();
        numberAnimationUpdateInterval = (Integer)NUMBER_ANIMATION_UPDATE_INTERVAL.get();
        scoreAnimationDurationNormal = (Integer)SCORE_ANIMATION_DURATION_NORMAL.get();
        comboIconAnimationHorizontal = (Boolean)COMBO_ICON_ANIMATION_HORIZONTAL.get();
        iconProcessInterval = (Integer)ICON_PROCESS_INTERVAL.get();
    }

    private static void loadPositionConfigs() {
        scrollIconX = (Integer)SCROLL_ICON_X.get();
        scrollIconY = (Integer)SCROLL_ICON_Y.get();
        scrollSubtitleX = (Integer)SCROLL_SUBTITLE_X.get();
        scrollSubtitleY = (Integer)SCROLL_SUBTITLE_Y.get();
        scrollScoreX = (Integer)SCROLL_SCORE_X.get();
        scrollScoreY = (Integer)SCROLL_SCORE_Y.get();
        scrollBonusX = (Integer)SCROLL_BONUS_X.get();
        scrollBonusY = (Integer)SCROLL_BONUS_Y.get();
        comboIconX = (Integer)COMBO_ICON_X.get();
        comboIconY = (Integer)COMBO_ICON_Y.get();
        comboSubtitleX = (Integer)COMBO_SUBTITLE_X.get();
        comboSubtitleY = (Integer)COMBO_SUBTITLE_Y.get();
        comboScoreX = (Integer)COMBO_SCORE_X.get();
        comboScoreY = (Integer)COMBO_SCORE_Y.get();
        comboBonusX = (Integer)COMBO_BONUS_X.get();
        comboBonusY = (Integer)COMBO_BONUS_Y.get();
        cardIconX = (Integer)CARD_ICON_X.get();
        cardIconY = (Integer)CARD_ICON_Y.get();
        cardSubtitleX = (Integer)CARD_SUBTITLE_X.get();
        cardSubtitleY = (Integer)CARD_SUBTITLE_Y.get();
        cardScoreX = (Integer)CARD_SCORE_X.get();
        cardScoreY = (Integer)CARD_SCORE_Y.get();
        cardBonusX = (Integer)CARD_BONUS_X.get();
        cardBonusY = (Integer)CARD_BONUS_Y.get();
    }

    private static void loadElementConfigs() {
        scrollIconSize = (Integer)SCROLL_ICON_SIZE.get();
        scrollIconVisible = (Boolean)SCROLL_ICON_VISIBLE.get();
        scrollSubtitleSize = (Integer)SCROLL_SUBTITLE_SIZE.get();
        scrollSubtitleVisible = (Boolean)SCROLL_SUBTITLE_VISIBLE.get();
        scrollScoreSize = (Integer)SCROLL_SCORE_SIZE.get();
        scrollScoreVisible = (Boolean)SCROLL_SCORE_VISIBLE.get();
        scrollBonusSize = (Integer)SCROLL_BONUS_SIZE.get();
        scrollBonusVisible = (Boolean)SCROLL_BONUS_VISIBLE.get();
        comboIconSize = (Integer)COMBO_ICON_SIZE.get();
        comboIconVisible = (Boolean)COMBO_ICON_VISIBLE.get();
        comboSubtitleSize = (Integer)COMBO_SUBTITLE_SIZE.get();
        comboSubtitleVisible = (Boolean)COMBO_SUBTITLE_VISIBLE.get();
        comboScoreSize = (Integer)COMBO_SCORE_SIZE.get();
        comboScoreVisible = (Boolean)COMBO_SCORE_VISIBLE.get();
        comboBonusSize = (Integer)COMBO_BONUS_SIZE.get();
        comboBonusVisible = (Boolean)COMBO_BONUS_VISIBLE.get();
        cardIconSize = (Integer)CARD_ICON_SIZE.get();
        cardIconVisible = (Boolean)CARD_ICON_VISIBLE.get();
        cardSubtitleSize = (Integer)CARD_SUBTITLE_SIZE.get();
        cardSubtitleVisible = (Boolean)CARD_SUBTITLE_VISIBLE.get();
        cardScoreSize = (Integer)CARD_SCORE_SIZE.get();
        cardScoreVisible = (Boolean)CARD_SCORE_VISIBLE.get();
        cardBonusSize = (Integer)CARD_BONUS_SIZE.get();
        cardBonusVisible = (Boolean)CARD_BONUS_VISIBLE.get();
    }

    private static void loadColorConfigs() {
        weaponColor = Config.parseColor((String)WEAPON_COLOR.get());
        targetColor = Config.parseColor((String)TARGET_COLOR.get());
        criticalColor = Config.parseColor((String)CRITICAL_COLOR.get());
        flashingColor = Config.parseColor((String)FLASHING_COLOR.get());
        highScoreColor = Config.parseColor((String)HIGH_SCORE_COLOR.get());
        weaponColorHex = Config.parseColor((String)WEAPON_COLOR.get());
        targetColorHex = Config.parseColor((String)TARGET_COLOR.get());
        criticalColorHex = Config.parseColor((String)CRITICAL_COLOR.get());
        flashingColorHex = Config.parseColor((String)FLASHING_COLOR.get());
        highScoreColorHex = Config.parseColor((String)HIGH_SCORE_COLOR.get());
    }

    private static void loadSoundConfigs() {
        enableSoundEffects = (Boolean)ENABLE_SOUND_EFFECTS.get();
        soundVolume = (Integer)SOUND_VOLUME.get();
    }

    private static void resetBonusConfigs() {
        KILL_BONUS_DISPLAY.set((Object)"\u51fb\u8d25\u751f\u7269 +{score}");
        ASSIST_BONUS_DISPLAY.set((Object)"\u52a9\u653b\u51fb\u8d25 +{score}");
        CRITICAL_BONUS_DISPLAY.set((Object)"\u66b4\u51fb\u52a0\u6210 +{score}");
        MAGIC_BONUS_DISPLAY.set((Object)"\u9b54\u6cd5\u4f24\u5bb3 +{score}");
        HAND_BONUS_DISPLAY.set((Object)"\u7a7a\u624b\u653b\u51fb +{score}");
        DAMAGE_BONUS_DISPLAY.set((Object)"\u9020\u6210\u4f24\u5bb3 +{score}");
        LONGRANGE_BONUS_DISPLAY.set((Object)"\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}");
        COMBO_BONUS_DISPLAY.set((Object)"[6]{combo}[f] \u8fde\u6740 ! +{score}");
        BONUS_LINE_SPACING.set((Object)12);
        CARD_BOTTOMBAR_SIZE.set((Object)80);
        CARD_BOTTOMBAR_VISIBLE.set((Object)true);
    }

    private static void resetGeneralConfigs() {
        KILL_ICON_DURATION.set((Object)60);
        KILL_ICON_SIZE.set((Object)32);
        WEAPON_COLOR.set((Object)"008080");
        TARGET_COLOR.set((Object)"008080");
        CUSTOM_SUBTITLE_FORMAT.set((Object)"\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}");
        ASSIST_SUBTITLE_FORMAT.set((Object)"\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}");
        SOUND_VOLUME.set((Object)100);
        CRITICAL_COLOR.set((Object)"FFD700");
        ICON_MODE.set((Object)IconMode.SCROLLING);
        COMBO_SCORE_FONT_SCALE.set((Object)250);
        FLASHING_COLOR.set((Object)"DCDCDC");
        HIGH_SCORE_COLOR.set((Object)"FFD700");
        COMBO_TIMEOUT.set((Object)3);
        SCROLL_ANIMATION_SPEED.set((Object)0.2);
        SCROLL_SENSITIVITY.set((Object)1.0);
        KILL_ICON_ANIMATION_DURATION.set((Object)300);
        KILL_ICON_SPACING.set((Object)10);
        FORCE_HIDE_COUNT.set((Object)9);
        MAX_DISPLAY_COUNT.set((Object)30);
        ENABLE_SOUND_EFFECTS.set((Object)true);
        CARD_BOTTOMBAR_OFFSET_Y.set((Object)30);
        COMBO_ICON_ANIMATION_ENABLED.set((Object)true);
        COMBO_ICON_ANIMATION_DURATION.set((Object)1000);
        COMBO_ICON_ANIMATION_TOTAL_FRAMES.set((Object)15);
        NUMBER_ANIMATION_UPDATE_INTERVAL.set((Object)33);
        SCORE_ANIMATION_DURATION_NORMAL.set((Object)2000);
        COMBO_ICON_ANIMATION_HORIZONTAL.set((Object)true);
        ICON_PROCESS_INTERVAL.set((Object)150);
    }

    private static void resetPositionConfigs() {
        Config.resetScrollPositions();
        Config.resetComboPositions();
        Config.resetCardPositions();
    }

    private static void resetElementConfigs() {
        Config.resetScrollElements();
        Config.resetComboElements();
        Config.resetCardElements();
    }

    private static void resetStyleConfigs() {
        ICON_STYLE.set((Object)IconStyle.MODERN);
        CARD_ICON_STYLE.set((Object)IconStyle.MODERN);
    }

    private static void resetScrollPositions() {
        SCROLL_ICON_X.set((Object)0);
        SCROLL_ICON_Y.set((Object)-140);
        SCROLL_SUBTITLE_X.set((Object)0);
        SCROLL_SUBTITLE_Y.set((Object)-100);
        SCROLL_SCORE_X.set((Object)0);
        SCROLL_SCORE_Y.set((Object)-80);
        SCROLL_BONUS_X.set((Object)0);
        SCROLL_BONUS_Y.set((Object)-60);
    }

    private static void resetComboPositions() {
        COMBO_ICON_X.set((Object)-9);
        COMBO_ICON_Y.set((Object)-139);
        COMBO_SUBTITLE_X.set((Object)0);
        COMBO_SUBTITLE_Y.set((Object)-100);
        COMBO_SCORE_X.set((Object)0);
        COMBO_SCORE_Y.set((Object)-80);
        COMBO_BONUS_X.set((Object)0);
        COMBO_BONUS_Y.set((Object)-60);
    }

    private static void resetCardPositions() {
        CARD_ICON_X.set((Object)0);
        CARD_ICON_Y.set((Object)-90);
        CARD_SUBTITLE_X.set((Object)0);
        CARD_SUBTITLE_Y.set((Object)-160);
        CARD_SCORE_X.set((Object)-80);
        CARD_SCORE_Y.set((Object)-105);
        CARD_BONUS_X.set((Object)80);
        CARD_BONUS_Y.set((Object)-100);
    }

    private static void resetScrollElements() {
        SCROLL_ICON_SIZE.set((Object)32);
        SCROLL_ICON_VISIBLE.set((Object)true);
        SCROLL_SUBTITLE_SIZE.set((Object)100);
        SCROLL_SUBTITLE_VISIBLE.set((Object)true);
        SCROLL_SCORE_SIZE.set((Object)250);
        SCROLL_SCORE_VISIBLE.set((Object)true);
        SCROLL_BONUS_SIZE.set((Object)100);
        SCROLL_BONUS_VISIBLE.set((Object)true);
    }

    private static void resetComboElements() {
        COMBO_ICON_SIZE.set((Object)48);
        COMBO_ICON_VISIBLE.set((Object)true);
        COMBO_SUBTITLE_SIZE.set((Object)100);
        COMBO_SUBTITLE_VISIBLE.set((Object)true);
        COMBO_SCORE_SIZE.set((Object)250);
        COMBO_SCORE_VISIBLE.set((Object)true);
        COMBO_BONUS_SIZE.set((Object)100);
        COMBO_BONUS_VISIBLE.set((Object)true);
    }

    private static void resetCardElements() {
        CARD_ICON_SIZE.set((Object)48);
        CARD_ICON_VISIBLE.set((Object)true);
        CARD_SUBTITLE_SIZE.set((Object)100);
        CARD_SUBTITLE_VISIBLE.set((Object)false);
        CARD_SCORE_SIZE.set((Object)250);
        CARD_SCORE_VISIBLE.set((Object)false);
        CARD_BONUS_SIZE.set((Object)100);
        CARD_BONUS_VISIBLE.set((Object)false);
    }

    static {
        weaponColor = -16744320;
        targetColor = -16744320;
        showKillIcons = true;
        showKillSubtitles = true;
        customSubtitleFormat = "\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}";
        soundVolume = 100;
        iconMode = IconMode.SCROLLING;
        iconStyle = IconStyle.MODERN;
        cardIconStyle = IconStyle.MODERN;
        showComboScore = true;
        comboScoreDuration = 2000;
        comboScoreFontScale = 250;
        flashingColor = -2302756;
        highScoreColor = -10496;
        comboTimeout = 3;
        scrollAnimationSpeed = 0.2;
        assistSubtitleFormat = "\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}";
        weaponColorHex = -16744320;
        targetColorHex = -16744320;
        criticalColorHex = -10496;
        flashingColorHex = -2302756;
        highScoreColorHex = -10496;
        enableSoundEffects = true;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("GD656Killicon-\u6a21\u7ec4\u4f5c\u8005\uff1aMinecraft_GD656\u516d\u4e94\u516d-\u672c\u6a21\u7ec4\u5b8c\u5168\u514d\u8d39\uff0c\u7981\u6b62\u5404\u79cd\u5f62\u5f0f\u7684\u5012\u5356\u76d7\u642c\uff01");
        builder.comment("\u56fe\u6807\u8bbe\u7f6e").push("kill_icon");
        KILL_ICON_DURATION = builder.comment("\u51fb\u6740\u56fe\u6807\u663e\u793a\u65f6\u957f\uff08\u6e38\u620f\u523b\uff09").defineInRange("duration", 60, 20, 200);
        KILL_ICON_SIZE = builder.comment("\u51fb\u6740\u56fe\u6807\u5c3a\u5bf8").defineInRange("size", 32, 16, 64);
        CUSTOM_SUBTITLE_FORMAT = builder.comment("\u81ea\u5b9a\u4e49\u51fb\u6740\u5b57\u5e55\u683c\u5f0f").define("customSubtitleFormat", (Object)"\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}");
        ASSIST_SUBTITLE_FORMAT = builder.comment("\u81ea\u5b9a\u4e49\u52a9\u653b\u5b57\u5e55\u683c\u5f0f").define("assistSubtitleFormat", (Object)"\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}");
        ICON_MODE = builder.comment("\u56fe\u6807\u663e\u793a\u6a21\u5f0f").defineEnum("iconMode", (Enum)IconMode.SCROLLING);
        ICON_STYLE = builder.comment("\u56fe\u6807\u663e\u793a\u98ce\u683c").defineEnum("iconStyle", (Enum)IconStyle.MODERN);
        CARD_ICON_STYLE = builder.comment("\u5361\u724c\u56fe\u6807\u663e\u793a\u98ce\u683c").defineEnum("cardIconStyle", (Enum)IconStyle.MODERN);
        KILL_ICON_ANIMATION_DURATION = builder.comment("\u56fe\u6807\u52a8\u753b\u6267\u884c\u65f6\u95f4\uff08\u6beb\u79d2\uff09").defineInRange("iconAnimationDuration", 300, 100, 2000);
        KILL_ICON_SPACING = builder.comment("\u56fe\u6807\u95f4\u9694\uff08\u50cf\u7d20\uff09").defineInRange("iconSpacing", 10, 10, 100);
        FORCE_HIDE_COUNT = builder.comment("\u56fe\u6807\u5f3a\u5236\u9690\u85cf\u6570\u91cf").defineInRange("forceHideCount", 9, 3, 100);
        MAX_DISPLAY_COUNT = builder.comment("\u56fe\u6807\u6700\u5927\u663e\u793a\u6570\u91cf").defineInRange("maxDisplayCount", 30, 5, 100);
        ICON_PROCESS_INTERVAL = builder.comment("\u56fe\u6807\u5904\u7406\u95f4\u9694\uff08\u6beb\u79d2\uff09\uff0c\u63a7\u5236\u56fe\u6807\u961f\u5217\u5904\u7406\u7684\u9891\u7387").defineInRange("iconProcessInterval", 150, 0, 1000);
        builder.pop();
        Config.setupPositionConfigs(builder);
        Config.setupElementConfigs(builder);
        Config.setupBonusConfigs(builder);
        Config.setupColorConfigs(builder);
        Config.setupSoundConfigs(builder);
        Config.setupComboConfigs(builder);
        Config.setupDebugConfigs(builder);
        SPEC = builder.build();
    }

    public static enum IconMode {
        SCROLLING("gd656killicon.config.mode.scrolling"),
        COMBO("gd656killicon.config.mode.combo"),
        CARD("gd656killicon.config.mode.card");

        private final String translationKey;

        private IconMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum IconStyle {
        VANILLA("gd656killicon.config.style.vanilla"),
        MODERN("gd656killicon.config.style.modern");

        private final String translationKey;

        private IconStyle(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

