/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.configmenu.HistoryRecordScreen;
import org.mods.gd656killicon.client.iconrenderer.CardModeRenderer;
import org.mods.gd656killicon.client.iconrenderer.ComboIconRenderer;
import org.mods.gd656killicon.client.iconrenderer.ScrollingIconRenderer;
import org.mods.gd656killicon.client.subtitlerenderer.ComboScoreRenderer;
import org.mods.gd656killicon.client.subtitlerenderer.ScoreItemRenderer;
import org.mods.gd656killicon.client.subtitlerenderer.SubtitleRenderer;
import org.mods.gd656killicon.util.ClientUtil;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class KillIconRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final List<ScrollingIconRenderer.KillIconInstance> activeIcons = new ArrayList<ScrollingIconRenderer.KillIconInstance>();
    public static final List<CardModeRenderer.CardInstance> activeCards = new ArrayList<CardModeRenderer.CardInstance>();
    public static final List<ScoreItemRenderer.ScoreItem> activeScoreItems = new ArrayList<ScoreItemRenderer.ScoreItem>();
    public static final Queue<ScoreItemRenderer.ScoreItem> scoreItems = new LinkedList<ScoreItemRenderer.ScoreItem>();
    public static Config.IconStyle currentIconStyle = null;
    public static Config.IconStyle currentCardIconStyle = null;
    public static ResourceLocation[] currentCardIcons;
    public static String latestWeaponName;
    public static String latestTargetName;
    public static boolean latestIsCritical;
    public static boolean latestIsAssist;
    public static int comboCount;
    public static int lastComboCount;
    public static int comboScore;
    public static int displayedComboScore;
    public static int targetComboScore;
    public static int cardComboCount;
    public static int longRangeDistance;
    public static int longRangeBonus;
    public static int scoreAnimationStart;
    public static int flashCount;
    public static long comboKillAnimationStart;
    public static long textAnimationStartTime;
    public static long textHideTime;
    public static long lastKillTime;
    public static long lastComboTime;
    public static long lastScoreUpdateTime;
    public static long comboScoreShowTime;
    public static long lastDamageTime;
    public static long lastFlashTime;
    public static long longRangeShowTime;
    public static long groupDisplayStartTime;
    public static long renderTimeSum;
    public static long subtitleAnimationStartTime;
    public static boolean isFadingOutAll;
    public static boolean isComboScoreVisible;
    public static boolean isFlashing;
    public static boolean isGroupDisplaying;
    public static boolean shouldStartFadeOut;
    public static float subtitleBrightness;
    public static float subtitleScale;
    public static ScoreItemRenderer.ScoreItem comboKillItem;
    private static boolean isRendering;
    private static final int KILL_CHAIN_TIMEOUT = 3000;
    private static final int COMBO_KILL_BONUS_MULTIPLIER = 8;
    private static final long LONG_RANGE_DISPLAY_DURATION = 3000L;
    private static int renderCount;
    static ScrollingIconRenderer scrollingRenderer;
    static ComboIconRenderer comboRenderer;
    private static final CardModeRenderer cardRenderer;
    private static final SubtitleRenderer subtitleRenderer;
    private static final ComboScoreRenderer comboScoreRenderer;
    private static final RenderHelper renderHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void renderKillIcon(CustomizeGuiOverlayEvent.Chat event) {
        long startTime = System.nanoTime();
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (currentIconStyle != Config.iconStyle || currentCardIconStyle != Config.cardIconStyle) {
            renderHelper.loadResources();
            ComboIconRenderer.loadResources();
        }
        if (!ClientUtil.isClient()) {
            return;
        }
        if (isRendering) {
            return;
        }
        isRendering = true;
        try {
            boolean chainEnded;
            Gd656killicon.cleanupExpiredSoundCooldowns();
            if (!(Config.showKillIcons || Config.showKillSubtitles || Config.showComboScore)) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack poseStack = guiGraphics.m_280168_();
            long currentTime = System.currentTimeMillis();
            KillIconRenderer.updateGroupDisplayTimer(currentTime);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (Config.iconMode == Config.IconMode.CARD) {
                cardRenderer.renderCards(guiGraphics, poseStack, currentTime);
                if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SUBTITLE)) {
                    subtitleRenderer.renderSubtitles(guiGraphics, currentTime);
                }
                if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SCORE)) {
                    comboScoreRenderer.renderComboScore(guiGraphics, currentTime);
                    KillIconRenderer.renderLongRangeBonus(guiGraphics, currentTime);
                }
                if (Config.cardBottombarVisible) {
                    CardModeRenderer.renderBottomBar(guiGraphics, poseStack);
                }
                RenderSystem.disableBlend();
                return;
            }
            boolean bl = chainEnded = currentTime - lastKillTime > 3000L;
            if (chainEnded && !isGroupDisplaying) {
                groupDisplayStartTime = currentTime;
                isGroupDisplaying = true;
            }
            if (textAnimationStartTime > 0L) {
                long displayTime = Config.comboTimeoutMs + 500;
                if (currentTime - textAnimationStartTime > displayTime && textHideTime == 0L) {
                    textHideTime = currentTime;
                }
                if (textHideTime > 0L && currentTime >= textHideTime) {
                    latestWeaponName = "";
                    latestTargetName = "";
                    latestIsAssist = false;
                    textAnimationStartTime = 0L;
                    textHideTime = 0L;
                }
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.ICON)) {
                if (Config.iconMode == Config.IconMode.SCROLLING) {
                    scrollingRenderer.renderIcons(guiGraphics, poseStack, currentTime);
                } else if (Config.iconMode == Config.IconMode.COMBO) {
                    scrollingRenderer.renderIcons(guiGraphics, poseStack, currentTime);
                }
            }
            if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SUBTITLE)) {
                subtitleRenderer.renderSubtitles(guiGraphics, currentTime);
            }
            if (RenderHelper.isElementVisible(ModConfigScreen.ElementType.SCORE)) {
                comboScoreRenderer.renderComboScore(guiGraphics, currentTime);
                KillIconRenderer.renderLongRangeBonus(guiGraphics, currentTime);
            }
            RenderSystem.disableBlend();
        }
        finally {
            isRendering = false;
        }
        long endTime = System.nanoTime();
        long renderTime = endTime - startTime;
        renderTimeSum += renderTime;
        ++renderCount;
    }

    public static void triggerKillIcon(String weaponName, String targetName, boolean isCritical, boolean playUltimateSound, int killScore, boolean isAssist) {
        String reason;
        if (Config.iconMode != Config.IconMode.CARD) {
            subtitleBrightness = 4.0f;
            subtitleScale = 1.5f;
            subtitleAnimationStartTime = System.currentTimeMillis();
        }
        long currentTime = System.currentTimeMillis();
        KillIconRenderer.addHistoryRecord(weaponName, targetName, isCritical, isAssist, killScore);
        if (!isAssist) {
            if (currentTime - lastComboTime > (long)Config.comboTimeoutMs) {
                comboCount = 0;
                lastComboCount = 0;
                KillIconRenderer.resetComboIfNeeded();
                if (comboKillItem != null) {
                    activeScoreItems.remove(comboKillItem);
                    comboKillItem = null;
                }
            }
            lastComboTime = currentTime;
            if (++comboCount >= 2 && Config.iconMode != Config.IconMode.CARD) {
                int comboBonus = comboCount * 8;
                if (comboKillItem == null) {
                    comboKillItem = new ScoreItemRenderer.ScoreItem("\u8fde\u6740 ! +", comboBonus, currentTime, false);
                    KillIconRenderer.comboKillItem.isComboKill = true;
                    KillIconRenderer.comboKillItem.comboNumber = comboCount;
                    KillIconRenderer.comboKillItem.displayDuration = 3000L;
                    activeScoreItems.add(0, comboKillItem);
                } else {
                    KillIconRenderer.comboKillItem.targetPoints = comboBonus;
                    KillIconRenderer.comboKillItem.animationStartTime = currentTime;
                    KillIconRenderer.comboKillItem.initialPoints = KillIconRenderer.comboKillItem.currentPoints;
                    KillIconRenderer.comboKillItem.comboNumber = comboCount;
                    KillIconRenderer.comboKillItem.startTime = currentTime;
                }
            }
        }
        latestIsAssist = isAssist;
        latestIsCritical = isCritical;
        String string = reason = isAssist ? "\u52a9\u653b\u51fb\u8d25" : "\u51fb\u8d25\u751f\u7269";
        if (Config.iconMode != Config.IconMode.CARD) {
            KillIconRenderer.addScore(killScore, reason, isCritical);
        }
        KillIconRenderer.resetGroupDisplayTimer();
        switch (Config.iconMode) {
            case SCROLLING: {
                scrollingRenderer.handleScrollingMode(weaponName, targetName, isCritical, playUltimateSound, isAssist);
                break;
            }
            case COMBO: {
                ComboIconRenderer.handleComboMode(weaponName, targetName, isCritical, isAssist);
                break;
            }
            case CARD: {
                cardRenderer.handleCardMode();
            }
        }
        if (Config.iconMode == Config.IconMode.SCROLLING) {
            scrollingRenderer.updateAllIconTargetPositions();
        }
        lastKillTime = System.currentTimeMillis();
        isFadingOutAll = false;
        if (Config.iconMode != Config.IconMode.CARD) {
            latestWeaponName = weaponName;
            latestTargetName = targetName;
            textAnimationStartTime = currentTime;
        } else {
            latestWeaponName = "";
            latestTargetName = "";
            textAnimationStartTime = 0L;
        }
        textHideTime = 0L;
    }

    public static void addScore(float points, String reason, boolean isCritical) {
        long currentTime;
        if (points <= 0.0f) {
            return;
        }
        if (!Config.showComboScore) {
            return;
        }
        lastDamageTime = currentTime = System.currentTimeMillis();
        scoreAnimationStart = displayedComboScore == targetComboScore ? displayedComboScore : targetComboScore;
        int roundedPoints = Math.round(points);
        targetComboScore = comboScore += roundedPoints;
        lastScoreUpdateTime = currentTime;
        boolean isLongRange = reason.startsWith("\u8fdc\u8ddd\u79bb\u51fb\u8d25");
        String expectedBaseText = RenderHelper.getString(reason);
        boolean found = false;
        for (ScoreItemRenderer.ScoreItem item : activeScoreItems) {
            String[] parts;
            if (!item.baseText.equals(expectedBaseText) || (!item.isLongRange || !isLongRange) && (item.isLongRange || isLongRange)) continue;
            item.initialPoints = item.currentPoints;
            item.targetPoints += points;
            item.animationStartTime = currentTime;
            item.lastUpdateTime = currentTime;
            item.startTime = currentTime;
            if (isLongRange && (parts = reason.split(" ")).length >= 2) {
                item.distance = parts[1].replace("\u7c73", "m");
            }
            found = true;
            break;
        }
        if (!found) {
            String[] parts;
            ScoreItemRenderer.ScoreItem newItem = new ScoreItemRenderer.ScoreItem(expectedBaseText, points, currentTime, isLongRange);
            newItem.initialPoints = 0.0f;
            newItem.animationStartTime = currentTime;
            if (isLongRange && (parts = reason.split(" ")).length >= 2) {
                newItem.distance = parts[1].replace("\u7c73", "m");
            }
            scoreItems.offer(newItem);
        }
        if (isCritical && (reason.equals("\u51fb\u8d25\u751f\u7269") || reason.equals("\u52a9\u653b\u51fb\u8d25"))) {
            float critBonus = points * 0.25f;
            int roundedCritBonus = Math.round(critBonus);
            targetComboScore = comboScore += roundedCritBonus;
            boolean critFound = false;
            for (ScoreItemRenderer.ScoreItem item : activeScoreItems) {
                if (!item.baseText.equals("\u66b4\u51fb\u52a0\u6210 +")) continue;
                item.initialPoints = item.currentPoints;
                item.targetPoints += critBonus;
                item.animationStartTime = currentTime;
                item.lastUpdateTime = currentTime;
                item.startTime = currentTime;
                critFound = true;
                break;
            }
            if (!critFound) {
                ScoreItemRenderer.ScoreItem critItem = new ScoreItemRenderer.ScoreItem("\u66b4\u51fb\u52a0\u6210 +", critBonus, currentTime, false);
                critItem.initialPoints = 0.0f;
                critItem.animationStartTime = currentTime;
                activeScoreItems.add(critItem);
            }
        }
        if (!isComboScoreVisible) {
            isComboScoreVisible = true;
            comboScoreShowTime = currentTime;
        }
    }

    public static void showLongRangeBonus(int distance, int bonusPoints) {
        longRangeDistance = distance;
        longRangeBonus = bonusPoints;
        longRangeShowTime = System.currentTimeMillis();
    }

    public static void clearCardCombo() {
        activeCards.clear();
        cardComboCount = 0;
        lastKillTime = 0L;
    }

    public static void resetComboIfNeeded() {
        if (KillIconRenderer.shouldResetCombo()) {
            cardComboCount = 0;
            lastKillTime = 0L;
        }
    }

    public static boolean shouldResetCombo() {
        if (Config.iconMode == Config.IconMode.CARD) {
            if (CardModeRenderer.getKillChainTimeout() == 0) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            return currentTime - lastKillTime > (long)CardModeRenderer.getKillChainTimeout();
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - lastKillTime > 3000L;
    }

    private static void addHistoryRecord(String weaponName, String targetName, boolean isCritical, boolean isAssist, int killScore) {
        try {
            Object damageInfo = isAssist ? "\u52a9\u653b" : (isCritical ? "\u66b4\u51fb\u51fb\u6740" : "\u51fb\u6740");
            if (killScore > 0) {
                damageInfo = (String)damageInfo + " +" + killScore;
            }
            boolean isPlayer = KillIconRenderer.isPlayerTarget(targetName);
            HistoryRecordScreen.addHistoryRecord(targetName, (String)damageInfo, weaponName, isPlayer, !isAssist);
        }
        catch (Exception e) {
            LOGGER.warn("[\u516d\u4e94\u516d] \u6dfb\u52a0\u5386\u53f2\u8bb0\u5f55\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private static boolean isPlayerTarget(String targetName) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null) {
                if (targetName.equals(mc.f_91074_.m_36316_().getName())) {
                    return true;
                }
                List players = mc.f_91073_.m_6907_();
                for (AbstractClientPlayer player : players) {
                    if (!targetName.equals(player.m_36316_().getName())) continue;
                    return true;
                }
            }
            return targetName.length() <= 16 && !targetName.contains(" ") && !targetName.contains(".") && !targetName.contains("_" + UUID.randomUUID().toString().substring(0, 8));
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void renderLongRangeBonus(GuiGraphics guiGraphics, long currentTime) {
        if (currentTime - longRangeShowTime > 3000L) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        float progress = (float)(currentTime - longRangeShowTime) / 3000.0f;
        float alpha = 1.0f;
        if (progress > 0.8f) {
            alpha = 1.0f - (progress - 0.8f) / 0.2f;
        }
        int textY = screenHeight - 100;
        String text = "\u8fdc\u8ddd\u79bb\u51fb\u8d25";
        String distanceText = longRangeDistance + "m";
        String bonusText = " +" + longRangeBonus;
        int textWidth = font.m_92895_(text);
        int distanceWidth = font.m_92895_(distanceText);
        int bonusWidth = font.m_92895_(bonusText);
        int totalWidth = textWidth + distanceWidth + bonusWidth;
        int textX = screenWidth / 2 - totalWidth / 2;
        int whiteColor = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        guiGraphics.m_280056_(font, text, textX, textY, whiteColor, true);
        int goldColor = -10496;
        goldColor = goldColor & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        guiGraphics.m_280056_(font, distanceText, textX += textWidth, textY, goldColor, true);
        guiGraphics.m_280056_(font, bonusText, textX += distanceWidth, textY, whiteColor, true);
    }

    private static void resetGroupDisplayTimer() {
        groupDisplayStartTime = System.currentTimeMillis();
        isGroupDisplaying = true;
        shouldStartFadeOut = false;
        isFadingOutAll = false;
        for (ScrollingIconRenderer.KillIconInstance icon : activeIcons) {
            icon.fadeStartTime = -1L;
            icon.alpha = 1.0f;
        }
    }

    private static void updateGroupDisplayTimer(long currentTime) {
        if (!isGroupDisplaying || activeIcons.isEmpty()) {
            return;
        }
        long displayDuration = (long)Config.killIconDuration * 50L;
        if (currentTime - groupDisplayStartTime > displayDuration && !shouldStartFadeOut) {
            shouldStartFadeOut = true;
            scrollingRenderer.startFadeOutSequence(currentTime);
        }
    }

    static {
        latestWeaponName = "";
        latestTargetName = "";
        latestIsCritical = false;
        latestIsAssist = false;
        comboCount = 0;
        lastComboCount = 0;
        comboScore = 0;
        displayedComboScore = 0;
        targetComboScore = 0;
        cardComboCount = 0;
        longRangeDistance = 0;
        longRangeBonus = 0;
        scoreAnimationStart = 0;
        flashCount = 0;
        comboKillAnimationStart = 0L;
        textAnimationStartTime = 0L;
        textHideTime = 0L;
        lastKillTime = 0L;
        lastComboTime = 0L;
        lastScoreUpdateTime = 0L;
        comboScoreShowTime = 0L;
        lastDamageTime = 0L;
        lastFlashTime = 0L;
        longRangeShowTime = 0L;
        groupDisplayStartTime = 0L;
        renderTimeSum = 0L;
        subtitleAnimationStartTime = 0L;
        isFadingOutAll = false;
        isComboScoreVisible = false;
        isFlashing = false;
        isGroupDisplaying = false;
        shouldStartFadeOut = false;
        subtitleBrightness = 1.0f;
        subtitleScale = 1.0f;
        comboKillItem = null;
        isRendering = false;
        renderCount = 0;
        cardRenderer = new CardModeRenderer();
        subtitleRenderer = new SubtitleRenderer();
        comboScoreRenderer = new ComboScoreRenderer();
        renderHelper = new RenderHelper();
        scrollingRenderer = new ScrollingIconRenderer();
        comboRenderer = new ComboIconRenderer();
    }
}

