/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.iconrenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.iconrenderer.ScrollingIconRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ComboIconRenderer {
    private static Config.IconStyle currentIconStyle = null;
    public static ResourceLocation[] VANALLA_COMBO_ICONS;
    public static ResourceLocation[] VANALLA_COMBO_STATIC_ICONS;

    public static void handleComboMode(String weaponName, String targetName, boolean isCritical, boolean isAssist) {
        Minecraft mc = Minecraft.m_91087_();
        if (isAssist) {
            if (Config.enableSoundEffects) {
                float volume = (float)Config.soundVolume / 100.0f;
                SoundEvent assistSound = ComboIconRenderer.getAssistKillSound();
                Gd656killicon.playSoundWithCooldown(assistSound, volume);
            }
            return;
        }
        KillIconRenderer.activeIcons.clear();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int iconSize = Config.killIconSize;
        RenderHelper.PositionConfig pos = ComboIconRenderer.getCurrentPosition();
        float targetX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetY = screenHeight + pos.iconY;
        int comboIndex = Math.min(KillIconRenderer.comboCount, 6) - 1;
        comboIndex = Math.max(comboIndex, 0);
        ScrollingIconRenderer.KillIconInstance newIcon = new ScrollingIconRenderer.KillIconInstance(System.currentTimeMillis(), targetX - (float)iconSize / 2.0f, targetY - (float)iconSize / 2.0f, isCritical);
        newIcon.isCombo = true;
        newIcon.comboIndex = comboIndex;
        newIcon.isAssist = isAssist;
        if (Config.comboIconAnimationEnabled) {
            newIcon.animationStartTime = System.currentTimeMillis();
            newIcon.currentFrame = 0;
            newIcon.isAnimating = true;
            newIcon.scale = 1.8f;
            newIcon.brightness = 2.0f;
        } else {
            newIcon.isAnimating = false;
            newIcon.currentFrame = 0;
            newIcon.scale = 1.0f;
            newIcon.brightness = 1.0f;
        }
        KillIconRenderer.latestIsCritical = isCritical;
        SoundEvent[] comboSounds = ComboIconRenderer.getComboSounds();
        if (comboIndex < comboSounds.length) {
            try {
                SoundEvent sound = comboSounds[comboIndex];
                float volume = (float)Config.soundVolume / 100.0f;
                Gd656killicon.playSoundWithCooldown(sound, volume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KillIconRenderer.activeIcons.add(newIcon);
        KillIconRenderer.textAnimationStartTime = System.currentTimeMillis();
        KillIconRenderer.textHideTime = 0L;
        KillIconRenderer.lastKillTime = System.currentTimeMillis();
        KillIconRenderer.isFadingOutAll = false;
        KillIconRenderer.latestWeaponName = weaponName;
        KillIconRenderer.latestTargetName = targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderComboIcon(GuiGraphics guiGraphics, PoseStack poseStack, ScrollingIconRenderer.KillIconInstance icon, int iconSize) {
        if (icon.comboIndex < 0 || icon.comboIndex >= VANALLA_COMBO_ICONS.length) {
            return;
        }
        if (icon.isAnimating) {
            ComboIconRenderer.updateAnimationFrame(icon);
        }
        int scaledSize = (int)((float)iconSize * icon.scale);
        int offsetX = (iconSize - scaledSize) / 2;
        int offsetY = (iconSize - scaledSize) / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)icon.brightness, (float)icon.brightness, (float)icon.brightness, (float)icon.alpha);
        poseStack.m_85836_();
        try {
            poseStack.m_252880_(icon.currentX + (float)offsetX, icon.currentY + (float)offsetY, 0.0f);
            poseStack.m_85841_(icon.scale, icon.scale, 1.0f);
            if (Config.comboIconAnimationEnabled && icon.isAnimating) {
                ResourceLocation iconTexture = VANALLA_COMBO_ICONS[icon.comboIndex];
                ComboIconRenderer.renderAnimationFrame(guiGraphics, iconTexture, icon, iconSize);
            } else {
                ResourceLocation iconTexture = VANALLA_COMBO_STATIC_ICONS[icon.comboIndex];
                ComboIconRenderer.renderStaticIcon(guiGraphics, iconTexture, iconSize);
            }
        }
        finally {
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void loadResources() {
        if (currentIconStyle == Config.iconStyle) {
            return;
        }
        String stylePath = Config.iconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        VANALLA_COMBO_ICONS = new ResourceLocation[6];
        VANALLA_COMBO_STATIC_ICONS = new ResourceLocation[6];
        for (int i = 0; i < 6; ++i) {
            ComboIconRenderer.VANALLA_COMBO_ICONS[i] = new ResourceLocation("gd656killicon", "textures/gui/" + stylePath + "/combomode/combo_" + (i + 1) + ".png");
            ComboIconRenderer.VANALLA_COMBO_STATIC_ICONS[i] = new ResourceLocation("gd656killicon", "textures/gui/" + stylePath + "/combomode/static_combo_" + (i + 1) + ".png");
        }
        currentIconStyle = Config.iconStyle;
    }

    private static void updateAnimationFrame(ScrollingIconRenderer.KillIconInstance icon) {
        if (!icon.isAnimating) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - icon.animationStartTime;
        float progress = Mth.m_14036_((float)((float)elapsed / (float)Config.comboIconAnimationDuration), (float)0.0f, (float)1.0f);
        int targetFrame = (int)(progress * (float)(Config.comboIconAnimationTotalFrames - 1));
        if (targetFrame >= Config.comboIconAnimationTotalFrames - 1) {
            icon.isAnimating = false;
            icon.currentFrame = Config.comboIconAnimationTotalFrames - 1;
        } else {
            icon.currentFrame = targetFrame;
        }
    }

    private static void renderAnimationFrame(GuiGraphics guiGraphics, ResourceLocation texture, ScrollingIconRenderer.KillIconInstance icon, int iconSize) {
        int frameY;
        int frameX;
        int textureHeight;
        int textureWidth;
        if (texture == null) {
            return;
        }
        if (Config.comboIconAnimationHorizontal) {
            textureWidth = iconSize * Config.comboIconAnimationTotalFrames;
            textureHeight = iconSize;
            frameX = icon.currentFrame * iconSize;
            frameY = 0;
        } else {
            textureWidth = iconSize;
            textureHeight = iconSize * Config.comboIconAnimationTotalFrames;
            frameX = 0;
            frameY = icon.currentFrame * iconSize;
        }
        guiGraphics.m_280411_(texture, 0, 0, iconSize, iconSize, (float)frameX, (float)frameY, iconSize, iconSize, textureWidth, textureHeight);
    }

    private static void renderStaticIcon(GuiGraphics guiGraphics, ResourceLocation texture, int iconSize) {
        if (texture == null) {
            return;
        }
        guiGraphics.m_280411_(texture, 0, 0, iconSize, iconSize, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    private static SoundEvent[] getComboSounds() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return new SoundEvent[]{(SoundEvent)Gd656killicon.COMBO_1_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_2_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_3_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_4_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_5_VANILLA.get(), (SoundEvent)Gd656killicon.COMBO_6_VANILLA.get()};
        }
        return new SoundEvent[]{(SoundEvent)Gd656killicon.COMBO_1_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_2_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_3_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_4_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_5_MODERN.get(), (SoundEvent)Gd656killicon.COMBO_6_MODERN.get()};
    }

    private static SoundEvent getAssistKillSound() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return (SoundEvent)Gd656killicon.ASSIST_KILL_VANILLA.get();
        }
        return (SoundEvent)Gd656killicon.ASSIST_KILL_MODERN.get();
    }

    private static RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        config.iconX = Config.comboIconX;
        config.iconY = Config.comboIconY;
        config.subtitleX = Config.comboSubtitleX;
        config.subtitleY = Config.comboSubtitleY;
        config.scoreX = Config.comboScoreX;
        config.scoreY = Config.comboScoreY;
        config.bonusX = Config.comboBonusX;
        config.bonusY = Config.comboBonusY;
        return config;
    }
}

