/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.subtitlerenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.subtitlerenderer.ScoreItemRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ComboScoreRenderer {
    private String cachedScoreText = "";
    private RenderHelper.PositionConfig cachedPositionConfig;
    private int lastDisplayedScore = -1;
    private long lastConfigCheckTime;
    private long lastNumberAnimationUpdate;
    private final ScoreItemRenderer scoreItemRenderer = new ScoreItemRenderer();
    private int currentAnimationTarget = 0;
    private int currentAnimationStart = 0;
    private long currentAnimationStartTime = 0L;
    private boolean isAnimating = false;
    private int lastStableValue = 0;

    public void renderComboScore(GuiGraphics guiGraphics, long currentTime) {
        if (!RenderHelper.isElementVisible(ModConfigScreen.ElementType.SCORE)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        this.updateScoreAnimation(currentTime);
        this.updateScoreItems(currentTime);
        int scoreY = screenHeight + pos.scoreY;
        long timeSinceLastDamage = currentTime - KillIconRenderer.lastDamageTime;
        if (timeSinceLastDamage > (long)Config.comboTimeoutMs) {
            this.resetComboScore();
            return;
        }
        float scoreAlpha = this.calculateScoreAlpha(currentTime);
        boolean shouldFlash = this.shouldFlash(currentTime, timeSinceLastDamage);
        if (this.lastDisplayedScore != KillIconRenderer.displayedComboScore) {
            this.cachedScoreText = String.valueOf(KillIconRenderer.displayedComboScore);
            this.lastDisplayedScore = KillIconRenderer.displayedComboScore;
        }
        int textWidth = font.m_92895_(this.cachedScoreText);
        int textX = screenWidth / 2 + pos.scoreX - textWidth / 2;
        float scoreSizeScale = (float)RenderHelper.getElementSize(ModConfigScreen.ElementType.SCORE) / 100.0f;
        int scoreColor = this.getScoreColor(shouldFlash);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float centerX = (float)textX + (float)textWidth / 2.0f;
        float f = scoreY;
        Objects.requireNonNull(font);
        float centerY = f + 9.0f / 2.0f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_85841_(scoreSizeScale, scoreSizeScale, 1.0f);
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        float[] animationValues = this.calculateAnimationValues(currentTime);
        float animScale = animationValues[0];
        float brightness = animationValues[1];
        poseStack.m_85836_();
        poseStack.m_252880_(centerX, centerY, 0.0f);
        poseStack.m_85841_(animScale, animScale, 1.0f);
        poseStack.m_252880_(-centerX, -centerY, 0.0f);
        this.applyColorWithBrightness(scoreColor, brightness, scoreAlpha);
        guiGraphics.m_280056_(font, this.cachedScoreText, textX, scoreY, scoreColor, true);
        poseStack.m_85849_();
        poseStack.m_85849_();
        this.scoreItemRenderer.renderScoreItems(guiGraphics, currentTime);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void resetComboScore() {
        KillIconRenderer.comboScore = 0;
        KillIconRenderer.displayedComboScore = 0;
        KillIconRenderer.targetComboScore = 0;
        KillIconRenderer.isComboScoreVisible = false;
        KillIconRenderer.scoreItems.clear();
        KillIconRenderer.activeScoreItems.clear();
        KillIconRenderer.isFlashing = false;
        KillIconRenderer.flashCount = 0;
        KillIconRenderer.lastKillTime = 0L;
        this.lastDisplayedScore = -1;
        this.lastNumberAnimationUpdate = 0L;
        this.currentAnimationTarget = 0;
        this.currentAnimationStart = 0;
        this.currentAnimationStartTime = 0L;
        this.isAnimating = false;
        this.lastStableValue = 0;
    }

    private void updateScoreAnimation(long currentTime) {
        if (currentTime - this.lastNumberAnimationUpdate < (long)Config.numberAnimationUpdateInterval) {
            return;
        }
        this.lastNumberAnimationUpdate = currentTime;
        if (KillIconRenderer.targetComboScore != this.currentAnimationTarget) {
            this.smoothAdjustAnimation(currentTime);
        }
        if (this.isAnimating) {
            this.updateCurrentAnimation(currentTime);
        }
        if (currentTime - KillIconRenderer.lastDamageTime > (long)Config.comboTimeoutMs && KillIconRenderer.isComboScoreVisible) {
            this.resetComboScore();
        }
    }

    private void smoothAdjustAnimation(long currentTime) {
        int newTarget = KillIconRenderer.targetComboScore;
        if (newTarget < KillIconRenderer.displayedComboScore) {
            KillIconRenderer.targetComboScore = newTarget = KillIconRenderer.displayedComboScore;
        }
        if (this.isAnimating) {
            long elapsed = currentTime - this.currentAnimationStartTime;
            float progress = Math.min((float)elapsed / (float)Config.scoreAnimationDurationNormal, 1.0f);
            int expectedValue = this.calculateExpectedValue(this.currentAnimationStart, this.currentAnimationTarget, progress);
            this.currentAnimationStart = KillIconRenderer.displayedComboScore;
            this.currentAnimationTarget = newTarget;
            this.currentAnimationStartTime = currentTime;
            this.lastStableValue = Math.max(this.lastStableValue, KillIconRenderer.displayedComboScore);
        } else {
            this.currentAnimationStart = KillIconRenderer.displayedComboScore;
            this.currentAnimationTarget = newTarget;
            this.currentAnimationStartTime = currentTime;
            this.isAnimating = true;
            this.lastStableValue = KillIconRenderer.displayedComboScore;
        }
        KillIconRenderer.scoreAnimationStart = this.currentAnimationStart;
        KillIconRenderer.lastScoreUpdateTime = currentTime;
    }

    private void updateCurrentAnimation(long currentTime) {
        long elapsed = currentTime - this.currentAnimationStartTime;
        if (elapsed >= (long)Config.scoreAnimationDurationNormal) {
            KillIconRenderer.displayedComboScore = this.currentAnimationTarget;
            this.isAnimating = false;
            this.lastStableValue = this.currentAnimationTarget;
        } else {
            float progress = (float)elapsed / (float)Config.scoreAnimationDurationNormal;
            float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
            int calculatedValue = this.currentAnimationStart + Math.round((float)(this.currentAnimationTarget - this.currentAnimationStart) * easedProgress);
            KillIconRenderer.displayedComboScore = Math.max(calculatedValue, this.lastStableValue);
        }
    }

    private int calculateExpectedValue(int start, int target, float progress) {
        float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        return start + Math.round((float)(target - start) * easedProgress);
    }

    private void updateScoreItems(long currentTime) {
        this.scoreItemRenderer.updateScoreItems(currentTime);
    }

    private void applyColorWithBrightness(int color, float brightness, float alpha) {
        int a = (int)((float)(color >> 24 & 0xFF) * alpha);
        int r = (int)((float)(color >> 16 & 0xFF) * brightness);
        int g = (int)((float)(color >> 8 & 0xFF) * brightness);
        int b = (int)((float)(color & 0xFF) * brightness);
        r = Mth.m_14045_((int)r, (int)0, (int)255);
        g = Mth.m_14045_((int)g, (int)0, (int)255);
        b = Mth.m_14045_((int)b, (int)0, (int)255);
        a = Mth.m_14045_((int)a, (int)0, (int)255);
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
    }

    private float[] calculateAnimationValues(long currentTime) {
        float animScale = 1.0f;
        float brightness = 1.0f;
        long elapsed = currentTime - KillIconRenderer.comboScoreShowTime;
        if (elapsed < 300L) {
            float progress = Mth.m_14036_((float)((float)elapsed / 300.0f), (float)0.0f, (float)1.0f);
            float easedProgress = progress * progress;
            animScale = 1.0f + 0.5f * (1.0f - easedProgress);
            brightness = 1.0f + 3.0f * (1.0f - easedProgress);
        }
        return new float[]{animScale, brightness};
    }

    private float calculateScoreAlpha(long currentTime) {
        float progress;
        long elapsed = currentTime - KillIconRenderer.comboScoreShowTime;
        if (elapsed < 1000L && (progress = Mth.m_14036_((float)((float)elapsed / 1000.0f), (float)0.0f, (float)1.0f)) < 0.2f) {
            return System.currentTimeMillis() % 200L > 100L ? 1.0f : 0.5f;
        }
        return 1.0f;
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedPositionConfig == null || currentTime - this.lastConfigCheckTime > 1000L) {
            this.cachedPositionConfig = this.createPositionConfig();
            this.lastConfigCheckTime = currentTime;
        }
        return this.cachedPositionConfig;
    }

    private int getScoreColor(boolean shouldFlash) {
        if (shouldFlash) {
            return Config.flashingColor;
        }
        return KillIconRenderer.comboScore >= 1000 ? Config.highScoreColor : -1;
    }

    private boolean shouldFlash(long currentTime, long timeSinceLastDamage) {
        if (timeSinceLastDamage > (long)(Config.comboTimeoutMs - 1500) && timeSinceLastDamage <= (long)Config.comboTimeoutMs) {
            if (!KillIconRenderer.isFlashing) {
                KillIconRenderer.isFlashing = true;
                KillIconRenderer.flashCount = 0;
                KillIconRenderer.lastFlashTime = currentTime;
            }
            if (currentTime - KillIconRenderer.lastFlashTime > 375L) {
                KillIconRenderer.lastFlashTime = currentTime;
                if (++KillIconRenderer.flashCount >= 4) {
                    KillIconRenderer.isFlashing = false;
                }
            }
            return KillIconRenderer.isFlashing && KillIconRenderer.flashCount % 2 == 0;
        }
        KillIconRenderer.isFlashing = false;
        return false;
    }

    private RenderHelper.PositionConfig createPositionConfig() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
                config.subtitleX = Config.cardSubtitleX;
                config.subtitleY = Config.cardSubtitleY;
                config.scoreX = Config.cardScoreX;
                config.scoreY = Config.cardScoreY;
                config.bonusX = Config.cardBonusX;
                config.bonusY = Config.cardBonusY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                config.subtitleX = Config.comboSubtitleX;
                config.subtitleY = Config.comboSubtitleY;
                config.scoreX = Config.comboScoreX;
                config.scoreY = Config.comboScoreY;
                config.bonusX = Config.comboBonusX;
                config.bonusY = Config.comboBonusY;
                break;
            }
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                config.subtitleX = Config.scrollSubtitleX;
                config.subtitleY = Config.scrollSubtitleY;
                config.scoreX = Config.scrollScoreX;
                config.scoreY = Config.scrollScoreY;
                config.bonusX = Config.scrollBonusX;
                config.bonusY = Config.scrollBonusY;
            }
        }
        return config;
    }
}

