/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.network.NetworkEvent;
import org.mods.gd656killicon.client.KillIconRenderer;

public class KillPacket {
    private final String targetName;
    private final boolean isCritical;
    private final boolean playUltimateSound;
    private final int killScore;
    private final boolean isAssist;
    private final byte damageType;

    public KillPacket(String targetName, boolean isCritical, boolean playUltimateSound, int killScore, boolean isAssist, byte damageType) {
        this.targetName = targetName;
        this.isCritical = isCritical;
        this.playUltimateSound = playUltimateSound;
        this.killScore = killScore;
        this.isAssist = isAssist;
        this.damageType = damageType;
    }

    public KillPacket(FriendlyByteBuf buf) {
        this.targetName = buf.m_130277_();
        this.isCritical = buf.readBoolean();
        this.playUltimateSound = buf.readBoolean();
        this.killScore = buf.readInt();
        this.isAssist = buf.readBoolean();
        this.damageType = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.targetName);
        buf.writeBoolean(this.isCritical);
        buf.writeBoolean(this.playUltimateSound);
        buf.writeInt(this.killScore);
        buf.writeBoolean(this.isAssist);
        buf.writeByte((int)this.damageType);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            String weaponName = "\u62f3\u5934";
            if (this.damageType == 1) {
                weaponName = "\u9b54\u6cd5\u4f24\u5bb3";
            } else if (this.damageType == 0 && mc.f_91074_ != null && !mc.f_91074_.m_21205_().m_41619_()) {
                weaponName = mc.f_91074_.m_21205_().m_41611_().getString().replace("[", "").replace("]", "");
            }
            String localizedTargetName = this.localizeEntityName(this.targetName);
            KillIconRenderer.triggerKillIcon(weaponName, localizedTargetName, this.isCritical, this.playUltimateSound, this.killScore, this.isAssist);
        });
        ctx.setPacketHandled(true);
    }

    private String localizeEntityName(String entityId) {
        try {
            if (entityId.contains(":")) {
                String translationKey = "entity." + entityId.replace(":", ".");
                MutableComponent translated = Component.m_237115_((String)translationKey);
                return translated.getString();
            }
            return entityId;
        }
        catch (Exception e) {
            if (entityId.contains(":")) {
                String path = entityId.substring(entityId.indexOf(":") + 1);
                return Arrays.stream(path.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
            }
            return entityId;
        }
    }
}

