/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.mods.gd656killicon.data.ScoreData;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.RankingDataResponsePacket;

public class RankingDataRequestPacket {
    public RankingDataRequestPacket() {
    }

    public RankingDataRequestPacket(FriendlyByteBuf ignoredBuf) {
    }

    public void toBytes(FriendlyByteBuf ignoredBuf) {
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                ScoreData scoreData = ScoreData.get();
                HashMap<String, Integer> rankingData = new HashMap<String, Integer>();
                if (!scoreData.getRankingListEnabled()) {
                    scoreData.getAllScores().forEach((uuid, score) -> {
                        String playerName = this.getPlayerName((UUID)uuid);
                        rankingData.put(playerName, (Integer)score);
                    });
                }
                RankingDataResponsePacket response = new RankingDataResponsePacket(rankingData, !scoreData.getRankingListEnabled());
                NetworkHandler.sendToClient(response, context.getSender());
            }
        });
    }

    private String getPlayerName(UUID playerId) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                ServerPlayer player = server.m_6846_().m_11259_(playerId);
                if (player != null) {
                    return player.m_36316_().getName();
                }
                GameProfile profile = server.m_129927_().m_11002_(playerId).orElse(null);
                if (profile != null) {
                    return profile.getName();
                }
            }
            return "\u73a9\u5bb6_" + playerId.toString().substring(0, 8);
        }
        catch (Exception e) {
            return "\u672a\u77e5\u73a9\u5bb6";
        }
    }
}

