/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "gd656killicon.properties");
    private static final Properties PROPERTIES = new Properties();
    public static int scrollIconX;
    public static int scrollIconY;
    public static int scrollSubtitleX;
    public static int scrollSubtitleY;
    public static int scrollScoreX;
    public static int scrollScoreY;
    public static int scrollBonusX;
    public static int scrollBonusY;
    public static int comboIconX;
    public static int comboIconY;
    public static int comboSubtitleX;
    public static int comboSubtitleY;
    public static int comboScoreX;
    public static int comboScoreY;
    public static int comboBonusX;
    public static int comboBonusY;
    public static int cardIconX;
    public static int cardIconY;
    public static int cardSubtitleX;
    public static int cardSubtitleY;
    public static int cardScoreX;
    public static int cardScoreY;
    public static int cardBonusX;
    public static int cardBonusY;
    public static int scrollIconSize;
    public static int scrollSubtitleSize;
    public static int scrollScoreSize;
    public static int scrollBonusSize;
    public static boolean scrollIconVisible;
    public static boolean scrollSubtitleVisible;
    public static boolean scrollScoreVisible;
    public static boolean scrollBonusVisible;
    public static int comboIconSize;
    public static int comboSubtitleSize;
    public static int comboScoreSize;
    public static int comboBonusSize;
    public static boolean comboIconVisible;
    public static boolean comboSubtitleVisible;
    public static boolean comboScoreVisible;
    public static boolean comboBonusVisible;
    public static int cardIconSize;
    public static int cardSubtitleSize;
    public static int cardScoreSize;
    public static int cardBonusSize;
    public static boolean cardIconVisible;
    public static boolean cardSubtitleVisible;
    public static boolean cardScoreVisible;
    public static boolean cardBonusVisible;
    public static int cardBottombarSize;
    public static int cardBottombarOffsetY;
    public static boolean cardBottombarVisible;
    public static int killIconDuration;
    public static int killIconSize;
    public static int weaponColor;
    public static int targetColor;
    public static boolean showKillIcons;
    public static boolean showKillSubtitles;
    public static String customSubtitleFormat;
    public static int soundVolume;
    public static IconMode iconMode;
    public static IconStyle iconStyle;
    public static IconStyle cardIconStyle;
    public static boolean showComboScore;
    public static int comboScoreDuration;
    public static int comboScoreFontScale;
    public static int flashingColor;
    public static int highScoreColor;
    public static int comboTimeout;
    public static double scrollAnimationSpeed;
    public static int comboTimeoutMs;
    public static int criticalColor;
    public static String assistSubtitleFormat;
    public static boolean debugShowInfo;
    public static int weaponColorHex;
    public static int targetColorHex;
    public static int criticalColorHex;
    public static int flashingColorHex;
    public static int highScoreColorHex;
    public static String killBonusDisplay;
    public static String assistBonusDisplay;
    public static String criticalBonusDisplay;
    public static String longrangeBonusDisplay;
    public static String magicBonusDisplay;
    public static String handBonusDisplay;
    public static String comboBonusDisplay;
    public static String damageBonusDisplay;
    public static int killIconAnimationDuration;
    public static int killIconSpacing;
    public static int forceHideCount;
    public static int maxDisplayCount;
    public static int bonusLineSpacing;
    public static boolean enableSoundEffects;
    public static boolean comboIconAnimationEnabled;
    public static int comboIconAnimationDuration;
    public static int comboIconAnimationTotalFrames;

    public static void loadConfig() {
        try {
            if (!CONFIG_FILE.exists()) {
                Config.createDefaultConfig();
            }
            try (FileInputStream input = new FileInputStream(CONFIG_FILE);){
                PROPERTIES.load(input);
            }
            Config.loadGeneralConfigs();
            Config.loadPositionConfigs();
            Config.loadElementConfigs();
            Config.loadColorConfigs();
            Config.loadSoundConfigs();
            LOGGER.info("[\u516d\u4e94\u516d] \u914d\u7f6e\u52a0\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u52a0\u8f7d\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Config.createDefaultConfig();
        }
    }

    private static void createDefaultConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            Config.setDefaultProperties();
            try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
                PROPERTIES.store(output, "GD656Killicon Configuration - \u6a21\u7ec4\u4f5c\u8005\uff1aMinecraft_GD656\u516d\u4e94\u516d-\u672c\u6a21\u7ec4\u5b8c\u5168\u514d\u8d39\uff0c\u7981\u6b62\u5404\u79cd\u5f62\u5f0f\u7684\u5012\u5356\u76d7\u642c\uff01");
            }
            LOGGER.info("[\u516d\u4e94\u516d] \u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u5df2\u521b\u5efa");
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
        }
    }

    private static void setDefaultProperties() {
        Config.setPositionDefaults();
        Config.setElementDefaults();
        Config.setGeneralDefaults();
        Config.setColorDefaults();
        Config.setSoundDefaults();
    }

    public static void resetAllToDefaults() {
        try {
            LOGGER.info("[\u516d\u4e94\u516d] \u5f00\u59cb\u91cd\u7f6e\u6240\u6709\u914d\u7f6e\u5230\u9ed8\u8ba4\u503c");
            PROPERTIES.clear();
            Config.setDefaultProperties();
            Config.saveConfig();
            Config.loadConfig();
            LOGGER.info("[\u516d\u4e94\u516d] \u91cd\u7f6e\u540e\u6eda\u52a8\u56fe\u6807\u4f4d\u7f6e: ({}, {})", (Object)scrollIconX, (Object)scrollIconY);
            LOGGER.info("[\u516d\u4e94\u516d] \u91cd\u7f6e\u540e\u6eda\u52a8\u5b57\u5e55\u4f4d\u7f6e: ({}, {})", (Object)scrollSubtitleX, (Object)scrollSubtitleY);
            LOGGER.info("[\u516d\u4e94\u516d] \u91cd\u7f6e\u540e\u6eda\u52a8\u5206\u6570\u4f4d\u7f6e: ({}, {})", (Object)scrollScoreX, (Object)scrollScoreY);
            LOGGER.info("[\u516d\u4e94\u516d] \u91cd\u7f6e\u540e\u6eda\u52a8\u5956\u52b1\u4f4d\u7f6e: ({}, {})", (Object)scrollBonusX, (Object)scrollBonusY);
            LOGGER.info("[\u516d\u4e94\u516d] \u91cd\u7f6e\u540e\u6eda\u52a8\u56fe\u6807\u5927\u5c0f: {}", (Object)scrollIconSize);
            LOGGER.info("[\u516d\u4e94\u516d] \u91cd\u7f6e\u540e\u6eda\u52a8\u56fe\u6807\u53ef\u89c1: {}", (Object)scrollIconVisible);
            LOGGER.info("[\u516d\u4e94\u516d] \u6240\u6709\u914d\u7f6e\u5df2\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c");
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u91cd\u7f6e\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            Config.savePositionConfigs();
            Config.saveElementConfigs();
            Config.saveGeneralConfigs();
            Config.saveColorConfigs();
            Config.saveSoundConfigs();
            try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
                PROPERTIES.store(output, "GD656Killicon Configuration");
            }
            LOGGER.info("[\u516d\u4e94\u516d] \u914d\u7f6e\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("[\u516d\u4e94\u516d] \u4fdd\u5b58\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
        }
    }

    public static int parseColor(String hex) {
        if (hex == null || hex.isEmpty()) {
            return -16744320;
        }
        try {
            Object cleanHex = hex.replace("#", "");
            if (((String)cleanHex).length() == 3) {
                cleanHex = "" + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(2) + ((String)cleanHex).charAt(2);
            }
            return (int)Long.parseLong("FF" + (String)cleanHex, 16);
        }
        catch (Exception e) {
            LOGGER.error("Invalid color format: {}", (Object)hex);
            return -16744320;
        }
    }

    public static void reloadCriticalColor() {
        criticalColor = Config.parseColor(PROPERTIES.getProperty("criticalColor", "FFD700"));
    }

    private static int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(PROPERTIES.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(PROPERTIES.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static double getDoubleProperty(String key, double defaultValue) {
        try {
            return Double.parseDouble(PROPERTIES.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static String getStringProperty(String key, String defaultValue) {
        return PROPERTIES.getProperty(key, defaultValue);
    }

    private static IconMode getIconModeProperty(String key, IconMode defaultValue) {
        try {
            return IconMode.valueOf(PROPERTIES.getProperty(key, defaultValue.name()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static IconStyle getIconStyleProperty(String key, IconStyle defaultValue) {
        try {
            return IconStyle.valueOf(PROPERTIES.getProperty(key, defaultValue.name()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static void loadGeneralConfigs() {
        killIconDuration = Config.getIntProperty("killIconDuration", 60);
        killIconSize = Config.getIntProperty("killIconSize", 32);
        customSubtitleFormat = Config.getStringProperty("customSubtitleFormat", "\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}");
        soundVolume = Config.getIntProperty("soundVolume", 100);
        iconMode = Config.getIconModeProperty("iconMode", IconMode.SCROLLING);
        iconStyle = Config.getIconStyleProperty("iconStyle", IconStyle.MODERN);
        comboScoreDuration = Config.getIntProperty("comboScoreDuration", 2000);
        comboScoreFontScale = Config.getIntProperty("comboScoreFontScale", 250);
        comboTimeout = Config.getIntProperty("comboTimeout", 3);
        scrollAnimationSpeed = Config.getDoubleProperty("scrollAnimationSpeed", 0.2);
        comboTimeoutMs = comboTimeout * 1000;
        assistSubtitleFormat = Config.getStringProperty("assistSubtitleFormat", "\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}");
        killBonusDisplay = Config.getStringProperty("killBonusDisplay", "\u51fb\u8d25\u751f\u7269 +{score}");
        assistBonusDisplay = Config.getStringProperty("assistBonusDisplay", "\u52a9\u653b\u51fb\u8d25 +{score}");
        criticalBonusDisplay = Config.getStringProperty("criticalBonusDisplay", "\u66b4\u51fb\u52a0\u6210 +{score}");
        magicBonusDisplay = Config.getStringProperty("magicBonusDisplay", "\u9b54\u6cd5\u4f24\u5bb3 +{score}");
        handBonusDisplay = Config.getStringProperty("handBonusDisplay", "\u7a7a\u624b\u653b\u51fb +{score}");
        damageBonusDisplay = Config.getStringProperty("damageBonusDisplay", "\u9020\u6210\u4f24\u5bb3 +{score}");
        longrangeBonusDisplay = Config.getStringProperty("longrangeBonusDisplay", "\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}");
        comboBonusDisplay = Config.getStringProperty("comboBonusDisplay", "[6]{combo}[f] \u8fde\u6740 ! +{score}");
        killIconAnimationDuration = Config.getIntProperty("killIconAnimationDuration", 300);
        killIconSpacing = Config.getIntProperty("killIconSpacing", 10);
        forceHideCount = Config.getIntProperty("forceHideCount", 9);
        maxDisplayCount = Config.getIntProperty("maxDisplayCount", 30);
        bonusLineSpacing = Config.getIntProperty("bonusLineSpacing", 12);
        cardIconStyle = Config.getIconStyleProperty("cardIconStyle", IconStyle.MODERN);
        enableSoundEffects = Config.getBooleanProperty("enableSoundEffects", true);
        cardBottombarSize = Config.getIntProperty("cardBottombarSize", 80);
        cardBottombarVisible = Config.getBooleanProperty("cardBottombarVisible", true);
        cardBottombarOffsetY = Config.getIntProperty("cardBottombarOffsetY", 30);
        comboIconAnimationEnabled = Config.getBooleanProperty("comboIconAnimationEnabled", false);
        comboIconAnimationDuration = Config.getIntProperty("comboIconAnimationDuration", 2000);
        comboIconAnimationTotalFrames = Config.getIntProperty("comboIconAnimationTotalFrames", 11);
    }

    private static void loadPositionConfigs() {
        scrollIconX = Config.getIntProperty("scrollIconX", 0);
        scrollIconY = Config.getIntProperty("scrollIconY", -140);
        scrollSubtitleX = Config.getIntProperty("scrollSubtitleX", 0);
        scrollSubtitleY = Config.getIntProperty("scrollSubtitleY", -100);
        scrollScoreX = Config.getIntProperty("scrollScoreX", 0);
        scrollScoreY = Config.getIntProperty("scrollScoreY", -80);
        scrollBonusX = Config.getIntProperty("scrollBonusX", 0);
        scrollBonusY = Config.getIntProperty("scrollBonusY", -60);
        comboIconX = Config.getIntProperty("comboIconX", 0);
        comboIconY = Config.getIntProperty("comboIconY", -140);
        comboSubtitleX = Config.getIntProperty("comboSubtitleX", 0);
        comboSubtitleY = Config.getIntProperty("comboSubtitleY", -100);
        comboScoreX = Config.getIntProperty("comboScoreX", 0);
        comboScoreY = Config.getIntProperty("comboScoreY", -80);
        comboBonusX = Config.getIntProperty("comboBonusX", 0);
        comboBonusY = Config.getIntProperty("comboBonusY", -60);
        cardIconX = Config.getIntProperty("cardIconX", 0);
        cardIconY = Config.getIntProperty("cardIconY", -70);
        cardSubtitleX = Config.getIntProperty("cardSubtitleX", 0);
        cardSubtitleY = Config.getIntProperty("cardSubtitleY", -100);
        cardScoreX = Config.getIntProperty("cardScoreX", 0);
        cardScoreY = Config.getIntProperty("cardScoreY", -80);
        cardBonusX = Config.getIntProperty("cardBonusX", 0);
        cardBonusY = Config.getIntProperty("cardBonusY", -60);
    }

    private static void loadElementConfigs() {
        scrollIconSize = Config.getIntProperty("scrollIconSize", 32);
        scrollIconVisible = Config.getBooleanProperty("scrollIconVisible", true);
        scrollSubtitleSize = Config.getIntProperty("scrollSubtitleSize", 100);
        scrollSubtitleVisible = Config.getBooleanProperty("scrollSubtitleVisible", true);
        scrollScoreSize = Config.getIntProperty("scrollScoreSize", 250);
        scrollScoreVisible = Config.getBooleanProperty("scrollScoreVisible", true);
        scrollBonusSize = Config.getIntProperty("scrollBonusSize", 100);
        scrollBonusVisible = Config.getBooleanProperty("scrollBonusVisible", true);
        comboIconSize = Config.getIntProperty("comboIconSize", 32);
        comboIconVisible = Config.getBooleanProperty("comboIconVisible", true);
        comboSubtitleSize = Config.getIntProperty("comboSubtitleSize", 100);
        comboSubtitleVisible = Config.getBooleanProperty("comboSubtitleVisible", true);
        comboScoreSize = Config.getIntProperty("comboScoreSize", 250);
        comboScoreVisible = Config.getBooleanProperty("comboScoreVisible", true);
        comboBonusSize = Config.getIntProperty("comboBonusSize", 100);
        comboBonusVisible = Config.getBooleanProperty("comboBonusVisible", true);
        cardIconSize = Config.getIntProperty("cardIconSize", 48);
        cardIconVisible = Config.getBooleanProperty("cardIconVisible", true);
        cardSubtitleSize = Config.getIntProperty("cardSubtitleSize", 100);
        cardSubtitleVisible = Config.getBooleanProperty("cardSubtitleVisible", false);
        cardScoreSize = Config.getIntProperty("cardScoreSize", 250);
        cardScoreVisible = Config.getBooleanProperty("cardScoreVisible", false);
        cardBonusSize = Config.getIntProperty("cardBonusSize", 100);
        cardBonusVisible = Config.getBooleanProperty("cardBonusVisible", false);
    }

    private static void loadColorConfigs() {
        weaponColor = Config.parseColor(Config.getStringProperty("weaponColor", "008080"));
        targetColor = Config.parseColor(Config.getStringProperty("targetColor", "008080"));
        criticalColor = Config.parseColor(Config.getStringProperty("criticalColor", "FFD700"));
        flashingColor = Config.parseColor(Config.getStringProperty("flashingColor", "DCDCDC"));
        highScoreColor = Config.parseColor(Config.getStringProperty("highScoreColor", "FFD700"));
        weaponColorHex = weaponColor;
        targetColorHex = targetColor;
        criticalColorHex = criticalColor;
        flashingColorHex = flashingColor;
        highScoreColorHex = highScoreColor;
    }

    private static void loadSoundConfigs() {
        enableSoundEffects = Config.getBooleanProperty("enableSoundEffects", true);
        soundVolume = Config.getIntProperty("soundVolume", 100);
    }

    private static void saveGeneralConfigs() {
        PROPERTIES.setProperty("killIconDuration", String.valueOf(killIconDuration));
        PROPERTIES.setProperty("killIconSize", String.valueOf(killIconSize));
        PROPERTIES.setProperty("customSubtitleFormat", customSubtitleFormat);
        PROPERTIES.setProperty("soundVolume", String.valueOf(soundVolume));
        PROPERTIES.setProperty("iconMode", iconMode.name());
        PROPERTIES.setProperty("iconStyle", iconStyle.name());
        PROPERTIES.setProperty("comboScoreDuration", String.valueOf(comboScoreDuration));
        PROPERTIES.setProperty("comboScoreFontScale", String.valueOf(comboScoreFontScale));
        PROPERTIES.setProperty("comboTimeout", String.valueOf(comboTimeout));
        PROPERTIES.setProperty("scrollAnimationSpeed", String.valueOf(scrollAnimationSpeed));
        PROPERTIES.setProperty("assistSubtitleFormat", assistSubtitleFormat);
        PROPERTIES.setProperty("killBonusDisplay", killBonusDisplay);
        PROPERTIES.setProperty("assistBonusDisplay", assistBonusDisplay);
        PROPERTIES.setProperty("criticalBonusDisplay", criticalBonusDisplay);
        PROPERTIES.setProperty("magicBonusDisplay", magicBonusDisplay);
        PROPERTIES.setProperty("handBonusDisplay", handBonusDisplay);
        PROPERTIES.setProperty("damageBonusDisplay", damageBonusDisplay);
        PROPERTIES.setProperty("longrangeBonusDisplay", longrangeBonusDisplay);
        PROPERTIES.setProperty("comboBonusDisplay", comboBonusDisplay);
        PROPERTIES.setProperty("killIconAnimationDuration", String.valueOf(killIconAnimationDuration));
        PROPERTIES.setProperty("killIconSpacing", String.valueOf(killIconSpacing));
        PROPERTIES.setProperty("forceHideCount", String.valueOf(forceHideCount));
        PROPERTIES.setProperty("maxDisplayCount", String.valueOf(maxDisplayCount));
        PROPERTIES.setProperty("bonusLineSpacing", String.valueOf(bonusLineSpacing));
        PROPERTIES.setProperty("cardIconStyle", cardIconStyle.name());
        PROPERTIES.setProperty("enableSoundEffects", String.valueOf(enableSoundEffects));
        PROPERTIES.setProperty("cardBottombarSize", String.valueOf(cardBottombarSize));
        PROPERTIES.setProperty("cardBottombarVisible", String.valueOf(cardBottombarVisible));
        PROPERTIES.setProperty("cardBottombarOffsetY", String.valueOf(cardBottombarOffsetY));
        PROPERTIES.setProperty("comboIconAnimationEnabled", String.valueOf(comboIconAnimationEnabled));
        PROPERTIES.setProperty("comboIconAnimationDuration", String.valueOf(comboIconAnimationDuration));
        PROPERTIES.setProperty("comboIconAnimationTotalFrames", String.valueOf(comboIconAnimationTotalFrames));
    }

    private static void savePositionConfigs() {
        PROPERTIES.setProperty("scrollIconX", String.valueOf(scrollIconX));
        PROPERTIES.setProperty("scrollIconY", String.valueOf(scrollIconY));
        PROPERTIES.setProperty("scrollSubtitleX", String.valueOf(scrollSubtitleX));
        PROPERTIES.setProperty("scrollSubtitleY", String.valueOf(scrollSubtitleY));
        PROPERTIES.setProperty("scrollScoreX", String.valueOf(scrollScoreX));
        PROPERTIES.setProperty("scrollScoreY", String.valueOf(scrollScoreY));
        PROPERTIES.setProperty("scrollBonusX", String.valueOf(scrollBonusX));
        PROPERTIES.setProperty("scrollBonusY", String.valueOf(scrollBonusY));
        PROPERTIES.setProperty("comboIconX", String.valueOf(comboIconX));
        PROPERTIES.setProperty("comboIconY", String.valueOf(comboIconY));
        PROPERTIES.setProperty("comboSubtitleX", String.valueOf(comboSubtitleX));
        PROPERTIES.setProperty("comboSubtitleY", String.valueOf(comboSubtitleY));
        PROPERTIES.setProperty("comboScoreX", String.valueOf(comboScoreX));
        PROPERTIES.setProperty("comboScoreY", String.valueOf(comboScoreY));
        PROPERTIES.setProperty("comboBonusX", String.valueOf(comboBonusX));
        PROPERTIES.setProperty("comboBonusY", String.valueOf(comboBonusY));
        PROPERTIES.setProperty("cardIconX", String.valueOf(cardIconX));
        PROPERTIES.setProperty("cardIconY", String.valueOf(cardIconY));
        PROPERTIES.setProperty("cardSubtitleX", String.valueOf(cardSubtitleX));
        PROPERTIES.setProperty("cardSubtitleY", String.valueOf(cardSubtitleY));
        PROPERTIES.setProperty("cardScoreX", String.valueOf(cardScoreX));
        PROPERTIES.setProperty("cardScoreY", String.valueOf(cardScoreY));
        PROPERTIES.setProperty("cardBonusX", String.valueOf(cardBonusX));
        PROPERTIES.setProperty("cardBonusY", String.valueOf(cardBonusY));
    }

    private static void saveElementConfigs() {
        PROPERTIES.setProperty("scrollIconSize", String.valueOf(scrollIconSize));
        PROPERTIES.setProperty("scrollIconVisible", String.valueOf(scrollIconVisible));
        PROPERTIES.setProperty("scrollSubtitleSize", String.valueOf(scrollSubtitleSize));
        PROPERTIES.setProperty("scrollSubtitleVisible", String.valueOf(scrollSubtitleVisible));
        PROPERTIES.setProperty("scrollScoreSize", String.valueOf(scrollScoreSize));
        PROPERTIES.setProperty("scrollScoreVisible", String.valueOf(scrollScoreVisible));
        PROPERTIES.setProperty("scrollBonusSize", String.valueOf(scrollBonusSize));
        PROPERTIES.setProperty("scrollBonusVisible", String.valueOf(scrollBonusVisible));
        PROPERTIES.setProperty("comboIconSize", String.valueOf(comboIconSize));
        PROPERTIES.setProperty("comboIconVisible", String.valueOf(comboIconVisible));
        PROPERTIES.setProperty("comboSubtitleSize", String.valueOf(comboSubtitleSize));
        PROPERTIES.setProperty("comboSubtitleVisible", String.valueOf(comboSubtitleVisible));
        PROPERTIES.setProperty("comboScoreSize", String.valueOf(comboScoreSize));
        PROPERTIES.setProperty("comboScoreVisible", String.valueOf(comboScoreVisible));
        PROPERTIES.setProperty("comboBonusSize", String.valueOf(comboBonusSize));
        PROPERTIES.setProperty("comboBonusVisible", String.valueOf(comboBonusVisible));
        PROPERTIES.setProperty("cardIconSize", String.valueOf(cardIconSize));
        PROPERTIES.setProperty("cardIconVisible", String.valueOf(cardIconVisible));
        PROPERTIES.setProperty("cardSubtitleSize", String.valueOf(cardSubtitleSize));
        PROPERTIES.setProperty("cardSubtitleVisible", String.valueOf(cardSubtitleVisible));
        PROPERTIES.setProperty("cardScoreSize", String.valueOf(cardScoreSize));
        PROPERTIES.setProperty("cardScoreVisible", String.valueOf(cardScoreVisible));
        PROPERTIES.setProperty("cardBonusSize", String.valueOf(cardBonusSize));
        PROPERTIES.setProperty("cardBonusVisible", String.valueOf(cardBonusVisible));
    }

    private static void saveColorConfigs() {
        PROPERTIES.setProperty("weaponColor", String.format("%06X", weaponColor & 0xFFFFFF));
        PROPERTIES.setProperty("targetColor", String.format("%06X", targetColor & 0xFFFFFF));
        PROPERTIES.setProperty("criticalColor", String.format("%06X", criticalColor & 0xFFFFFF));
        PROPERTIES.setProperty("flashingColor", String.format("%06X", flashingColor & 0xFFFFFF));
        PROPERTIES.setProperty("highScoreColor", String.format("%06X", highScoreColor & 0xFFFFFF));
    }

    private static void saveSoundConfigs() {
        PROPERTIES.setProperty("enableSoundEffects", String.valueOf(enableSoundEffects));
        PROPERTIES.setProperty("soundVolume", String.valueOf(soundVolume));
    }

    private static void setPositionDefaults() {
        PROPERTIES.setProperty("scrollIconX", "0");
        PROPERTIES.setProperty("scrollIconY", "-140");
        PROPERTIES.setProperty("scrollSubtitleX", "0");
        PROPERTIES.setProperty("scrollSubtitleY", "-100");
        PROPERTIES.setProperty("scrollScoreX", "0");
        PROPERTIES.setProperty("scrollScoreY", "-80");
        PROPERTIES.setProperty("scrollBonusX", "0");
        PROPERTIES.setProperty("scrollBonusY", "-60");
        PROPERTIES.setProperty("comboIconX", "0");
        PROPERTIES.setProperty("comboIconY", "-140");
        PROPERTIES.setProperty("comboSubtitleX", "0");
        PROPERTIES.setProperty("comboSubtitleY", "-100");
        PROPERTIES.setProperty("comboScoreX", "0");
        PROPERTIES.setProperty("comboScoreY", "-80");
        PROPERTIES.setProperty("comboBonusX", "0");
        PROPERTIES.setProperty("comboBonusY", "-60");
        PROPERTIES.setProperty("cardIconX", "0");
        PROPERTIES.setProperty("cardIconY", "-70");
        PROPERTIES.setProperty("cardSubtitleX", "0");
        PROPERTIES.setProperty("cardSubtitleY", "-100");
        PROPERTIES.setProperty("cardScoreX", "0");
        PROPERTIES.setProperty("cardScoreY", "-80");
        PROPERTIES.setProperty("cardBonusX", "0");
        PROPERTIES.setProperty("cardBonusY", "-60");
    }

    private static void setElementDefaults() {
        PROPERTIES.setProperty("scrollIconSize", "32");
        PROPERTIES.setProperty("scrollIconVisible", "true");
        PROPERTIES.setProperty("scrollSubtitleSize", "100");
        PROPERTIES.setProperty("scrollSubtitleVisible", "true");
        PROPERTIES.setProperty("scrollScoreSize", "250");
        PROPERTIES.setProperty("scrollScoreVisible", "true");
        PROPERTIES.setProperty("scrollBonusSize", "100");
        PROPERTIES.setProperty("scrollBonusVisible", "true");
        PROPERTIES.setProperty("comboIconSize", "32");
        PROPERTIES.setProperty("comboIconVisible", "true");
        PROPERTIES.setProperty("comboSubtitleSize", "100");
        PROPERTIES.setProperty("comboSubtitleVisible", "true");
        PROPERTIES.setProperty("comboScoreSize", "250");
        PROPERTIES.setProperty("comboScoreVisible", "true");
        PROPERTIES.setProperty("comboBonusSize", "100");
        PROPERTIES.setProperty("comboBonusVisible", "true");
        PROPERTIES.setProperty("cardIconSize", "48");
        PROPERTIES.setProperty("cardIconVisible", "true");
        PROPERTIES.setProperty("cardSubtitleSize", "100");
        PROPERTIES.setProperty("cardSubtitleVisible", "false");
        PROPERTIES.setProperty("cardScoreSize", "250");
        PROPERTIES.setProperty("cardScoreVisible", "false");
        PROPERTIES.setProperty("cardBonusSize", "100");
        PROPERTIES.setProperty("cardBonusVisible", "false");
    }

    private static void setGeneralDefaults() {
        PROPERTIES.setProperty("killIconDuration", "60");
        PROPERTIES.setProperty("killIconSize", "32");
        PROPERTIES.setProperty("customSubtitleFormat", "\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}");
        PROPERTIES.setProperty("assistSubtitleFormat", "\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}");
        PROPERTIES.setProperty("soundVolume", "100");
        PROPERTIES.setProperty("iconMode", "SCROLLING");
        PROPERTIES.setProperty("comboScoreFontScale", "250");
        PROPERTIES.setProperty("comboTimeout", "3");
        PROPERTIES.setProperty("scrollAnimationSpeed", "0.2");
        PROPERTIES.setProperty("forceHideCount", "9");
        PROPERTIES.setProperty("maxDisplayCount", "30");
        PROPERTIES.setProperty("enableSoundEffects", "true");
        PROPERTIES.setProperty("cardBottombarOffsetY", "30");
        PROPERTIES.setProperty("comboIconAnimationEnabled", "false");
        PROPERTIES.setProperty("comboIconAnimationDuration", "2000");
        PROPERTIES.setProperty("comboIconAnimationTotalFrames", "11");
        PROPERTIES.setProperty("killBonusDisplay", "\u51fb\u8d25\u751f\u7269 +{score}");
        PROPERTIES.setProperty("assistBonusDisplay", "\u52a9\u653b\u51fb\u8d25 +{score}");
        PROPERTIES.setProperty("criticalBonusDisplay", "\u66b4\u51fb\u52a0\u6210 +{score}");
        PROPERTIES.setProperty("magicBonusDisplay", "\u9b54\u6cd5\u4f24\u5bb3 +{score}");
        PROPERTIES.setProperty("handBonusDisplay", "\u7a7a\u624b\u653b\u51fb +{score}");
        PROPERTIES.setProperty("damageBonusDisplay", "\u9020\u6210\u4f24\u5bb3 +{score}");
        PROPERTIES.setProperty("longrangeBonusDisplay", "\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}");
        PROPERTIES.setProperty("comboBonusDisplay", "[6]{combo}[f] \u8fde\u6740 ! +{score}");
        PROPERTIES.setProperty("bonusLineSpacing", "12");
        PROPERTIES.setProperty("cardBottombarSize", "80");
        PROPERTIES.setProperty("cardBottombarVisible", "true");
    }

    private static void setColorDefaults() {
        PROPERTIES.setProperty("weaponColor", "008080");
        PROPERTIES.setProperty("targetColor", "008080");
        PROPERTIES.setProperty("criticalColor", "FFD700");
        PROPERTIES.setProperty("flashingColor", "DCDCDC");
        PROPERTIES.setProperty("highScoreColor", "FFD700");
    }

    private static void setSoundDefaults() {
        PROPERTIES.setProperty("enableSoundEffects", "true");
        PROPERTIES.setProperty("soundVolume", "100");
    }

    private static void setStyleDefaults() {
        PROPERTIES.setProperty("iconStyle", "MODERN");
        PROPERTIES.setProperty("cardIconStyle", "MODERN");
    }

    static {
        weaponColor = -16744320;
        targetColor = -16744320;
        showKillIcons = true;
        showKillSubtitles = true;
        customSubtitleFormat = "\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}";
        soundVolume = 100;
        iconMode = IconMode.SCROLLING;
        iconStyle = IconStyle.MODERN;
        cardIconStyle = IconStyle.MODERN;
        showComboScore = true;
        comboScoreDuration = 2000;
        comboScoreFontScale = 250;
        flashingColor = -2302756;
        highScoreColor = -10496;
        comboTimeout = 3;
        scrollAnimationSpeed = 0.2;
        assistSubtitleFormat = "\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}";
        debugShowInfo = false;
        weaponColorHex = -16744320;
        targetColorHex = -16744320;
        criticalColorHex = -10496;
        flashingColorHex = -2302756;
        highScoreColorHex = -10496;
        enableSoundEffects = true;
        Config.loadConfig();
    }

    public static enum IconMode {
        SCROLLING("gd656killicon.config.mode.scrolling"),
        COMBO("gd656killicon.config.mode.combo"),
        CARD("gd656killicon.config.mode.card");

        private final String translationKey;

        private IconMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum IconStyle {
        VANILLA("gd656killicon.config.style.vanilla"),
        MODERN("gd656killicon.config.style.modern");

        private final String translationKey;

        private IconStyle(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

