/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.iconrenderer.CardModeRenderer;

public class ElementConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ModConfigScreen.DraggableElement element;
    private OptionsList list;
    public OptionsList.BooleanOptionEntry elementVisible;
    public OptionsList.SliderOptionEntry elementSize;
    private static final int ITEM_HEIGHT = 25;
    private static final int SLIDER_WIDTH = 100;
    private static final int SLIDER_HEIGHT = 20;

    public ElementConfigScreen(class_437 parent, ModConfigScreen.DraggableElement element) {
        super((class_2561)class_2561.method_43471((String)"gd656killicon.elementconfig.title"));
        this.parent = parent;
        this.element = element;
    }

    private void resetElementToDefaults() {
        try {
            this.resetElementConfigToDefaults();
            Config.saveConfig();
            if (this.field_22787 != null) {
                class_437 currentParent = this.parent;
                this.field_22787.method_1507(null);
                this.field_22787.method_1507((class_437)new ElementConfigScreen(currentParent, this.element));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetElementConfigToDefaults() {
        block0 : switch (this.element.type) {
            case ICON: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollIconSize = 32;
                        Config.scrollIconVisible = true;
                        Config.scrollIconX = 0;
                        Config.scrollIconY = -140;
                        break;
                    }
                    case COMBO: {
                        Config.comboIconSize = 32;
                        Config.comboIconVisible = true;
                        Config.comboIconX = 0;
                        Config.comboIconY = -140;
                        break;
                    }
                    case CARD: {
                        Config.cardIconSize = 48;
                        Config.cardIconVisible = true;
                        Config.cardIconX = 0;
                        Config.cardIconY = -70;
                    }
                }
                break;
            }
            case SUBTITLE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollSubtitleSize = 100;
                        Config.scrollSubtitleVisible = true;
                        Config.scrollSubtitleX = 0;
                        Config.scrollSubtitleY = -100;
                        break;
                    }
                    case COMBO: {
                        Config.comboSubtitleSize = 100;
                        Config.comboSubtitleVisible = true;
                        Config.comboSubtitleX = 0;
                        Config.comboSubtitleY = -100;
                        break;
                    }
                    case CARD: {
                        Config.cardSubtitleSize = 100;
                        Config.cardSubtitleVisible = false;
                        Config.cardSubtitleX = 0;
                        Config.cardSubtitleY = -100;
                    }
                }
                break;
            }
            case SCORE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollScoreSize = 250;
                        Config.scrollScoreVisible = true;
                        Config.scrollScoreX = 0;
                        Config.scrollScoreY = -80;
                        break;
                    }
                    case COMBO: {
                        Config.comboScoreSize = 250;
                        Config.comboScoreVisible = true;
                        Config.comboScoreX = 0;
                        Config.comboScoreY = -80;
                        break;
                    }
                    case CARD: {
                        Config.cardScoreSize = 250;
                        Config.cardScoreVisible = false;
                        Config.cardScoreX = 0;
                        Config.cardScoreY = -80;
                    }
                }
                break;
            }
            case BONUS: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollBonusSize = 100;
                        Config.scrollBonusVisible = true;
                        Config.scrollBonusX = 0;
                        Config.scrollBonusY = -60;
                        break block0;
                    }
                    case COMBO: {
                        Config.comboBonusSize = 100;
                        Config.comboBonusVisible = true;
                        Config.comboBonusX = 0;
                        Config.comboBonusY = -60;
                        break block0;
                    }
                    case CARD: {
                        Config.cardBonusSize = 100;
                        Config.cardBonusVisible = false;
                        Config.cardBonusX = 0;
                        Config.cardBonusY = -60;
                    }
                }
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        int listTop = 32;
        int listBottom = this.field_22790 - 64;
        int listHeight = listBottom - listTop;
        this.list = new OptionsList(this.field_22787, this.field_22789, listHeight, listTop, 25);
        this.method_37063((class_364)this.list);
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)("\u5143\u7d20\u914d\u7f6e: " + this.element.name))));
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        int minSize = 16;
        int maxSize = 500;
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            maxSize = 96;
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            minSize = 50;
            maxSize = 200;
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            minSize = 100;
        }
        this.elementSize = new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u5143\u7d20\u5927\u5c0f"), minSize, maxSize, this.getCurrentElementSize(this.element.type));
        this.list.addEntryPublic(this.elementSize);
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.elementVisible = new OptionsList.BooleanOptionEntry((class_2561)class_2561.method_43470((String)"\u6e38\u620f\u4e2d\u663e\u793a"), this.getCurrentElementVisible(this.element.type));
        this.list.addEntryPublic(this.elementVisible);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            this.addPrivateConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE) {
            this.addSubtitleConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            this.addScoreConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.BONUS) {
            this.addBonusConfigOptions();
        }
        int buttonWidth = 100;
        int buttonSpacing = 10;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            this.saveConfig();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(startX, buttonY, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(startX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).method_46431());
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float partialTick) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            String sharedText = switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> "\u6eda\u52a8\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
                case Config.IconMode.COMBO -> "\u8fde\u6740\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
                case Config.IconMode.CARD -> "\u5361\u724c\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
            };
            Objects.requireNonNull(this.field_22793);
            context.method_25303(this.field_22793, sharedText, 10, this.field_22790 - 9 - 10, 0x888888);
        }
        if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.SCORE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            Objects.requireNonNull(this.field_22793);
            context.method_25303(this.field_22793, "\u4e09\u6a21\u5f0f\u5171\u7528", 10, this.field_22790 - 9 - 10, 0x888888);
        }
        if (this.list != null) {
            this.list.method_25394(context, mouseX, mouseY, partialTick);
        }
        super.method_25394(context, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void addPrivateConfigOptions() {
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            switch (Config.iconMode) {
                case CARD: {
                    this.addCardIconConfigOptions();
                    break;
                }
                case COMBO: {
                    this.addComboKillIconConfigOptions();
                    break;
                }
                default: {
                    this.addKillIconConfigOptions();
                }
            }
        }
    }

    private void addSubtitleConfigOptions() {
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)"\u5b57\u5e55\u914d\u7f6e")));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u81ea\u5b9a\u4e49\u52a9\u653b\u5b57\u5e55"), Config.assistSubtitleFormat, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u81ea\u5b9a\u4e49\u6dd8\u6c70\u5b57\u5e55"), Config.customSubtitleFormat, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u66b4\u51fb\u6587\u5b57\u989c\u8272"), String.format("#%06X", Config.criticalColor & 0xFFFFFF), 100, true));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u76ee\u6807\u6587\u5b57\u989c\u8272"), String.format("#%06X", Config.targetColor & 0xFFFFFF), 100, true));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u6b66\u5668\u6587\u5b57\u989c\u8272"), String.format("#%06X", Config.weaponColor & 0xFFFFFF), 100, true));
    }

    private void addScoreConfigOptions() {
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)"\u5206\u6570\u914d\u7f6e")));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u79ef\u5206\u95ea\u70c1\u989c\u8272"), String.format("#%06X", Config.flashingColor & 0xFFFFFF), 100, true));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u79ef\u5206\u9ad8\u5206\u989c\u8272"), String.format("#%06X", Config.highScoreColor & 0xFFFFFF), 100, true));
    }

    private void addBonusConfigOptions() {
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)"\u52a0\u5206\u9879\u914d\u7f6e")));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u52a9\u653b\u51fb\u8d25\u663e\u793a\u540d\u79f0"), Config.assistBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u5b57\u5e55\u884c\u95f4\u8ddd"), 1, 60, Config.bonusLineSpacing));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u8fde\u6740\u663e\u793a\u540d\u79f0"), Config.comboBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u66b4\u51fb\u52a0\u6210\u663e\u793a\u540d\u79f0"), Config.criticalBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u9020\u6210\u4f24\u5bb3\u663e\u793a\u540d\u79f0"), Config.damageBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u7a7a\u624b\u653b\u51fb\u663e\u793a\u540d\u79f0"), Config.handBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u51fb\u8d25\u751f\u7269\u663e\u793a\u540d\u79f0"), Config.killBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u8fdc\u8ddd\u79bb\u51fb\u8d25\u663e\u793a\u540d\u79f0"), Config.longrangeBonusDisplay, 100));
        this.list.addEntryPublic(new OptionsList.EditBoxOptionEntry((class_2561)class_2561.method_43470((String)"\u9b54\u6cd5\u4f24\u5bb3\u663e\u793a\u540d\u79f0"), Config.magicBonusDisplay, 100));
    }

    private void addKillIconConfigOptions() {
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)"\u51fb\u6740\u56fe\u6807\u914d\u7f6e")));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u52a8\u753b\u6267\u884c\u65f6\u95f4"), 100, 2000, Config.killIconAnimationDuration));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u5f3a\u5236\u9690\u85cf\u6570\u91cf"), 3, 100, Config.forceHideCount));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u663e\u793a\u65f6\u957f"), 20, 200, Config.killIconDuration));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u95f4\u9694"), 10, 100, Config.killIconSpacing));
        this.list.addEntryPublic(new OptionsList.IconStyleOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u98ce\u683c\u9884\u8bbe"), Config.iconStyle));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u6700\u5927\u663e\u793a\u6570\u91cf"), 5, 100, Config.maxDisplayCount));
    }

    private void addComboKillIconConfigOptions() {
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)"\u8fde\u6740\u56fe\u6807\u914d\u7f6e")));
        this.list.addEntryPublic(new OptionsList.BooleanOptionEntry((class_2561)class_2561.method_43470((String)"\u542f\u7528\u56fe\u6807\u52a8\u56fe"), Config.comboIconAnimationEnabled));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u52a8\u753b\u663e\u793a\u65f6\u957f"), 500, 5000, Config.comboIconAnimationDuration));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u52a8\u753b\u5e27\u6570"), 10, 60, Config.comboIconAnimationTotalFrames));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u52a8\u753b\u6267\u884c\u65f6\u95f4"), 100, 2000, Config.killIconAnimationDuration));
        this.list.addEntryPublic(new OptionsList.IconStyleOptionEntry((class_2561)class_2561.method_43470((String)"\u56fe\u6807\u98ce\u683c\u9884\u8bbe"), Config.iconStyle));
    }

    private void addCardIconConfigOptions() {
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.list.addEntryPublic(new OptionsList.CategoryEntry((class_2561)class_2561.method_43470((String)"\u5361\u724c\u56fe\u6807\u914d\u7f6e")));
        this.list.addEntryPublic(new OptionsList.IconStyleOptionEntry((class_2561)class_2561.method_43470((String)"\u5361\u724c\u56fe\u6807\u98ce\u683c\u9884\u8bbe"), Config.cardIconStyle));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u8fde\u6740\u8d85\u65f6\u65f6\u95f4(\u79d2)"), 0, 60, CardModeRenderer.getKillChainTimeout() / 1000));
        this.list.addEntryPublic(new OptionsList.BooleanOptionEntry((class_2561)class_2561.method_43470((String)"\u663e\u793a\u5e95\u90e8\u680f"), Config.cardBottombarVisible));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u5e95\u90e8\u680f\u5927\u5c0f"), 50, 200, Config.cardBottombarSize));
        this.list.addEntryPublic(new OptionsList.SliderOptionEntry((class_2561)class_2561.method_43470((String)"\u5e95\u90e8\u680f\u5782\u76f4\u504f\u79fb"), -100, 100, Config.cardBottombarOffsetY));
    }

    private int getCurrentElementSize(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconSize;
                case Config.IconMode.COMBO -> Config.comboIconSize;
                case Config.IconMode.CARD -> Config.cardIconSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleSize;
                case Config.IconMode.COMBO -> Config.comboSubtitleSize;
                case Config.IconMode.CARD -> Config.cardSubtitleSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreSize;
                case Config.IconMode.COMBO -> Config.comboScoreSize;
                case Config.IconMode.CARD -> Config.cardScoreSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusSize;
                case Config.IconMode.COMBO -> Config.comboBonusSize;
                case Config.IconMode.CARD -> Config.cardBonusSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BOTTOMBAR) {
            return Config.cardBottombarSize;
        }
        return 100;
    }

    private boolean getCurrentElementVisible(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconVisible;
                case Config.IconMode.COMBO -> Config.comboIconVisible;
                case Config.IconMode.CARD -> Config.cardIconVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleVisible;
                case Config.IconMode.COMBO -> Config.comboSubtitleVisible;
                case Config.IconMode.CARD -> Config.cardSubtitleVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreVisible;
                case Config.IconMode.COMBO -> Config.comboScoreVisible;
                case Config.IconMode.CARD -> Config.cardScoreVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusVisible;
                case Config.IconMode.COMBO -> Config.comboBonusVisible;
                case Config.IconMode.CARD -> Config.cardBonusVisible;
            };
        }
        return true;
    }

    private void saveConfig() {
        int newSize = this.elementSize.getValue();
        boolean newVisible = this.elementVisible.getValue();
        switch (this.element.type) {
            case ICON: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollIconSize = newSize;
                        Config.scrollIconVisible = newVisible;
                        this.saveKillIconConfig();
                        break;
                    }
                    case COMBO: {
                        Config.comboIconSize = newSize;
                        Config.comboIconVisible = newVisible;
                        this.saveComboKillIconConfig();
                        break;
                    }
                    case CARD: {
                        Config.cardIconSize = newSize;
                        Config.cardIconVisible = newVisible;
                        this.saveCardIconConfig();
                    }
                }
                break;
            }
            case SUBTITLE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollSubtitleSize = newSize;
                        Config.scrollSubtitleVisible = newVisible;
                        break;
                    }
                    case COMBO: {
                        Config.comboSubtitleSize = newSize;
                        Config.comboSubtitleVisible = newVisible;
                        break;
                    }
                    case CARD: {
                        Config.cardSubtitleSize = newSize;
                        Config.cardSubtitleVisible = newVisible;
                    }
                }
                this.saveSubtitleConfig();
                break;
            }
            case SCORE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollScoreSize = newSize;
                        Config.scrollScoreVisible = newVisible;
                        break;
                    }
                    case COMBO: {
                        Config.comboScoreSize = newSize;
                        Config.comboScoreVisible = newVisible;
                        break;
                    }
                    case CARD: {
                        Config.cardScoreSize = newSize;
                        Config.cardScoreVisible = newVisible;
                    }
                }
                this.saveScoreConfig();
                break;
            }
            case BONUS: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.scrollBonusSize = newSize;
                        Config.scrollBonusVisible = newVisible;
                        break;
                    }
                    case COMBO: {
                        Config.comboBonusSize = newSize;
                        Config.comboBonusVisible = newVisible;
                        break;
                    }
                    case CARD: {
                        Config.cardBonusSize = newSize;
                        Config.cardBonusVisible = newVisible;
                    }
                }
                this.saveBonusConfig();
            }
        }
        Config.saveConfig();
        if (this.parent instanceof ModConfigScreen) {
            ((ModConfigScreen)this.parent).updateElementSizes();
        }
    }

    private void saveSubtitleConfig() {
        for (OptionsList.Entry entry : this.list.getConfigEntries()) {
            if (!(entry instanceof OptionsList.EditBoxOptionEntry)) continue;
            OptionsList.EditBoxOptionEntry editBoxEntry = (OptionsList.EditBoxOptionEntry)entry;
            String label = editBoxEntry.label.getString();
            String value = editBoxEntry.getValue();
            switch (label) {
                case "\u81ea\u5b9a\u4e49\u52a9\u653b\u5b57\u5e55": {
                    Config.assistSubtitleFormat = value;
                    break;
                }
                case "\u81ea\u5b9a\u4e49\u6dd8\u6c70\u5b57\u5e55": {
                    Config.customSubtitleFormat = value;
                    break;
                }
                case "\u66b4\u51fb\u6587\u5b57\u989c\u8272": {
                    Config.criticalColor = this.parseColor(value);
                    break;
                }
                case "\u76ee\u6807\u6587\u5b57\u989c\u8272": {
                    Config.targetColor = this.parseColor(value);
                    break;
                }
                case "\u6b66\u5668\u6587\u5b57\u989c\u8272": {
                    Config.weaponColor = this.parseColor(value);
                }
            }
        }
    }

    private void saveScoreConfig() {
        for (OptionsList.Entry entry : this.list.getConfigEntries()) {
            if (!(entry instanceof OptionsList.EditBoxOptionEntry)) continue;
            OptionsList.EditBoxOptionEntry editBoxEntry = (OptionsList.EditBoxOptionEntry)entry;
            String label = editBoxEntry.label.getString();
            String value = editBoxEntry.getValue();
            switch (label) {
                case "\u79ef\u5206\u95ea\u70c1\u989c\u8272": {
                    Config.flashingColor = this.parseColor(value);
                    break;
                }
                case "\u79ef\u5206\u9ad8\u5206\u989c\u8272": {
                    Config.highScoreColor = this.parseColor(value);
                }
            }
        }
    }

    private void saveBonusConfig() {
        for (OptionsList.Entry entry : this.list.getConfigEntries()) {
            String label;
            if (entry instanceof OptionsList.EditBoxOptionEntry) {
                OptionsList.EditBoxOptionEntry editBoxEntry = (OptionsList.EditBoxOptionEntry)entry;
                label = editBoxEntry.label.getString();
                String value = editBoxEntry.getValue();
                switch (label) {
                    case "\u52a9\u653b\u51fb\u8d25\u663e\u793a\u540d\u79f0": {
                        Config.assistBonusDisplay = value;
                        break;
                    }
                    case "\u8fde\u6740\u663e\u793a\u540d\u79f0": {
                        Config.comboBonusDisplay = value;
                        break;
                    }
                    case "\u66b4\u51fb\u52a0\u6210\u663e\u793a\u540d\u79f0": {
                        Config.criticalBonusDisplay = value;
                        break;
                    }
                    case "\u9020\u6210\u4f24\u5bb3\u663e\u793a\u540d\u79f0": {
                        Config.damageBonusDisplay = value;
                        break;
                    }
                    case "\u7a7a\u624b\u653b\u51fb\u663e\u793a\u540d\u79f0": {
                        Config.handBonusDisplay = value;
                        break;
                    }
                    case "\u51fb\u8d25\u751f\u7269\u663e\u793a\u540d\u79f0": {
                        Config.killBonusDisplay = value;
                        break;
                    }
                    case "\u8fdc\u8ddd\u79bb\u51fb\u8d25\u663e\u793a\u540d\u79f0": {
                        Config.longrangeBonusDisplay = value;
                        break;
                    }
                    case "\u9b54\u6cd5\u4f24\u5bb3\u663e\u793a\u540d\u79f0": {
                        Config.magicBonusDisplay = value;
                    }
                }
                continue;
            }
            if (!(entry instanceof OptionsList.SliderOptionEntry)) continue;
            OptionsList.SliderOptionEntry sliderEntry = (OptionsList.SliderOptionEntry)entry;
            label = sliderEntry.label.getString();
            int value = sliderEntry.getValue();
            if (!"\u5b57\u5e55\u884c\u95f4\u8ddd".equals(label)) continue;
            Config.bonusLineSpacing = value;
        }
    }

    private void saveKillIconConfig() {
        for (OptionsList.Entry entry : this.list.getConfigEntries()) {
            String label;
            if (entry instanceof OptionsList.SliderOptionEntry) {
                OptionsList.SliderOptionEntry sliderEntry = (OptionsList.SliderOptionEntry)entry;
                label = sliderEntry.label.getString();
                int value = sliderEntry.getValue();
                switch (label) {
                    case "\u56fe\u6807\u52a8\u753b\u6267\u884c\u65f6\u95f4": {
                        Config.killIconAnimationDuration = value;
                        break;
                    }
                    case "\u56fe\u6807\u5f3a\u5236\u9690\u85cf\u6570\u91cf": {
                        Config.forceHideCount = value;
                        break;
                    }
                    case "\u56fe\u6807\u663e\u793a\u65f6\u957f": {
                        Config.killIconDuration = value;
                        break;
                    }
                    case "\u56fe\u6807\u95f4\u9694": {
                        Config.killIconSpacing = value;
                        break;
                    }
                    case "\u56fe\u6807\u6700\u5927\u663e\u793a\u6570\u91cf": {
                        Config.maxDisplayCount = value;
                    }
                }
                continue;
            }
            if (!(entry instanceof OptionsList.IconStyleOptionEntry)) continue;
            OptionsList.IconStyleOptionEntry styleEntry = (OptionsList.IconStyleOptionEntry)entry;
            label = styleEntry.label.getString();
            if (!"\u56fe\u6807\u98ce\u683c\u9884\u8bbe".equals(label)) continue;
            Config.iconStyle = styleEntry.getValue();
        }
    }

    private void saveComboKillIconConfig() {
        for (OptionsList.Entry entry : this.list.getConfigEntries()) {
            int value;
            String label;
            if (entry instanceof OptionsList.BooleanOptionEntry) {
                OptionsList.BooleanOptionEntry booleanEntry = (OptionsList.BooleanOptionEntry)entry;
                label = booleanEntry.label.getString();
                value = booleanEntry.getValue();
                if (!"\u542f\u7528\u56fe\u6807\u52a8\u56fe".equals(label)) continue;
                Config.comboIconAnimationEnabled = value;
                continue;
            }
            if (entry instanceof OptionsList.SliderOptionEntry) {
                OptionsList.SliderOptionEntry sliderEntry = (OptionsList.SliderOptionEntry)entry;
                label = sliderEntry.label.getString();
                value = sliderEntry.getValue();
                switch (label) {
                    case "\u56fe\u6807\u52a8\u753b\u663e\u793a\u65f6\u957f": {
                        Config.comboIconAnimationDuration = value;
                        break;
                    }
                    case "\u56fe\u6807\u52a8\u753b\u5e27\u6570": {
                        Config.comboIconAnimationTotalFrames = value;
                        break;
                    }
                    case "\u56fe\u6807\u52a8\u753b\u6267\u884c\u65f6\u95f4": {
                        Config.killIconAnimationDuration = value;
                    }
                }
                continue;
            }
            if (!(entry instanceof OptionsList.IconStyleOptionEntry)) continue;
            OptionsList.IconStyleOptionEntry styleEntry = (OptionsList.IconStyleOptionEntry)entry;
            label = styleEntry.label.getString();
            if (!"\u56fe\u6807\u98ce\u683c\u9884\u8bbe".equals(label)) continue;
            Config.iconStyle = styleEntry.getValue();
        }
    }

    private void saveCardIconConfig() {
        for (OptionsList.Entry entry : this.list.getConfigEntries()) {
            int value;
            String label;
            if (entry instanceof OptionsList.BooleanOptionEntry) {
                OptionsList.BooleanOptionEntry booleanEntry = (OptionsList.BooleanOptionEntry)entry;
                label = booleanEntry.label.getString();
                value = booleanEntry.getValue();
                if (!"\u663e\u793a\u5e95\u90e8\u680f".equals(label)) continue;
                Config.cardBottombarVisible = value;
                continue;
            }
            if (entry instanceof OptionsList.SliderOptionEntry) {
                OptionsList.SliderOptionEntry sliderEntry = (OptionsList.SliderOptionEntry)entry;
                label = sliderEntry.label.getString();
                value = sliderEntry.getValue();
                switch (label) {
                    case "\u5e95\u90e8\u680f\u5927\u5c0f": {
                        Config.cardBottombarSize = value;
                        break;
                    }
                    case "\u5e95\u90e8\u680f\u5782\u76f4\u504f\u79fb": {
                        Config.cardBottombarOffsetY = value;
                        break;
                    }
                    case "\u8fde\u6740\u8d85\u65f6\u65f6\u95f4(\u79d2)": {
                        CardModeRenderer.setKillChainTimeout(value * 1000);
                    }
                }
                continue;
            }
            if (!(entry instanceof OptionsList.IconStyleOptionEntry)) continue;
            OptionsList.IconStyleOptionEntry styleEntry = (OptionsList.IconStyleOptionEntry)entry;
            label = styleEntry.label.getString();
            if (!"\u5361\u724c\u56fe\u6807\u98ce\u683c\u9884\u8bbe".equals(label)) continue;
            Config.cardIconStyle = styleEntry.getValue();
        }
    }

    private int parseColor(String hex) {
        if (hex == null || hex.isEmpty()) {
            return -16744320;
        }
        try {
            Object cleanHex = hex.replace("#", "");
            if (((String)cleanHex).length() == 3) {
                cleanHex = "" + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(2) + ((String)cleanHex).charAt(2);
            }
            if (((String)cleanHex).length() == 6) {
                return (int)Long.parseLong("FF" + (String)cleanHex, 16);
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static class OptionsList
    extends class_4265<Entry> {
        private List<Entry> configEntries = new ArrayList<Entry>();

        public OptionsList(class_310 client, int width, int height, int y0, int itemHeight) {
            super(client, width, height, y0, y0 + height, itemHeight);
        }

        public void addEntryPublic(Entry entry) {
            this.method_25321((class_350.class_351)entry);
            this.configEntries.add(entry);
        }

        public List<Entry> getConfigEntries() {
            return this.configEntries;
        }

        public static class EditBoxOptionEntry
        extends Entry {
            private final class_342 editBox;
            private final class_2561 label;
            private final boolean isColorOption;

            public EditBoxOptionEntry(class_2561 label, String initialValue, int width) {
                this(label, initialValue, width, false);
            }

            public EditBoxOptionEntry(class_2561 label, String initialValue, int width, boolean isColorOption) {
                this.label = label;
                this.isColorOption = isColorOption;
                this.editBox = new class_342(class_310.method_1551().field_1772, 0, 0, width, 20, (class_2561)class_2561.method_43473());
                this.editBox.method_1852(initialValue);
                this.editBox.method_1880(isColorOption ? 7 : 256);
                this.editBox.method_25365(true);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_27535(class_310.method_1551().field_1772, this.label, x + 10, y + 8, 0xFFFFFF);
                if (this.isColorOption) {
                    int colorValue;
                    int editBoxWidth = 80;
                    int colorBoxSize = 20;
                    int spacing = 5;
                    this.editBox.method_48229(x + entryWidth - editBoxWidth - colorBoxSize - spacing, y + 2);
                    this.editBox.method_25358(editBoxWidth);
                    this.editBox.method_25394(context, mouseX, mouseY, tickDelta);
                    int colorBoxX = x + entryWidth - colorBoxSize - 10;
                    int colorBoxY = y + 2;
                    String colorText = this.editBox.method_1882();
                    try {
                        Object cleanHex = colorText.replace("#", "");
                        if (((String)cleanHex).length() == 3) {
                            cleanHex = "" + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(0) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(1) + ((String)cleanHex).charAt(2) + ((String)cleanHex).charAt(2);
                        }
                        colorValue = ((String)cleanHex).length() == 6 ? (int)Long.parseLong("FF" + (String)cleanHex, 16) : -1;
                    }
                    catch (Exception e) {
                        colorValue = -1;
                    }
                    context.method_25294(colorBoxX, colorBoxY, colorBoxX + colorBoxSize, colorBoxY + colorBoxSize, colorValue);
                    context.method_49601(colorBoxX, colorBoxY, colorBoxSize, colorBoxSize, -16777216);
                } else {
                    this.editBox.method_48229(x + entryWidth - 150 + 50, y + 2);
                    this.editBox.method_25358(100);
                    this.editBox.method_25394(context, mouseX, mouseY, tickDelta);
                }
            }

            public String getValue() {
                return this.editBox.method_1882();
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.editBox);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.editBox);
            }
        }

        public static class IconStyleOptionEntry
        extends Entry {
            private final class_5676<Config.IconStyle> styleButton;
            private final class_2561 label;

            public IconStyleOptionEntry(class_2561 label, Config.IconStyle initialValue) {
                this.label = label;
                this.styleButton = class_5676.method_32606(style -> class_2561.method_43471((String)style.getTranslationKey())).method_32624((Object[])Config.IconStyle.values()).method_32619((Object)initialValue).method_35723(0, 0, 100, 20, (class_2561)class_2561.method_43473());
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_27535(class_310.method_1551().field_1772, this.label, x + 10, y + 8, 0xFFFFFF);
                this.styleButton.method_48229(x + entryWidth - 100 - 10, y + 2);
                this.styleButton.method_25394(context, mouseX, mouseY, tickDelta);
            }

            public Config.IconStyle getValue() {
                return (Config.IconStyle)((Object)this.styleButton.method_32603());
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.styleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.styleButton);
            }
        }

        public static class SliderOptionEntry
        extends Entry {
            private final CustomSlider slider;
            private final class_2561 label;

            public SliderOptionEntry(class_2561 label, int min, int max, int initialValue) {
                this.label = label;
                this.slider = new CustomSlider(0, 0, 100, 20, (class_2561)class_2561.method_43473(), (double)(initialValue - min) / (double)(max - min), min, max);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_27535(class_310.method_1551().field_1772, this.label, x + 10, y + 8, 0xFFFFFF);
                this.slider.method_48229(x + entryWidth - 100 - 10, y + 2);
                this.slider.method_25394(context, mouseX, mouseY, tickDelta);
            }

            public int getValue() {
                return this.slider.getIntValue();
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.slider);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.slider);
            }

            public static class CustomSlider
            extends class_357 {
                private final int min;
                private final int max;

                public CustomSlider(int x, int y, int width, int height, class_2561 text, double value, int min, int max) {
                    super(x, y, width, height, text, value);
                    this.min = min;
                    this.max = max;
                    this.method_25346();
                }

                protected void method_25346() {
                    this.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.getIntValue())));
                }

                protected void method_25344() {
                }

                public int getIntValue() {
                    return this.min + (int)(this.field_22753 * (double)(this.max - this.min));
                }
            }
        }

        public static class BooleanOptionEntry
        extends Entry {
            private final class_4286 checkbox;
            private final class_2561 label;

            public BooleanOptionEntry(class_2561 label, boolean initialValue) {
                this.label = label;
                this.checkbox = new class_4286(0, 0, 20, 20, (class_2561)class_2561.method_43473(), initialValue);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_27535(class_310.method_1551().field_1772, this.label, x + 10, y + 8, 0xFFFFFF);
                this.checkbox.method_48229(x + entryWidth - 30, y + 2);
                this.checkbox.method_25394(context, mouseX, mouseY, tickDelta);
            }

            public boolean getValue() {
                return this.checkbox.method_20372();
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.checkbox);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.checkbox);
            }
        }

        public static class CategoryEntry
        extends Entry {
            private final class_2561 text;

            public CategoryEntry(class_2561 text) {
                this.text = text;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.method_27534(class_310.method_1551().field_1772, this.text, x + entryWidth / 2, y + 8, 0xFFFFFF);
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        public static class SpacerEntry
        extends Entry {
            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        static abstract class Entry
        extends class_4265.class_4266<Entry> {
            Entry() {
            }
        }
    }
}

