/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class HistoryRecordScreen
extends class_437 {
    private final class_437 parent;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int MAX_RECORDS = 32;
    private static final int PADDING = 10;
    private static final int TITLE_HEIGHT = 30;
    private static final CopyOnWriteArrayList<HistoryRecord> historyRecords = new CopyOnWriteArrayList();
    private static HistoryRecordScreen instance;
    private class_4185 clearButton;
    private int currentMouseX;
    private int currentMouseY;
    private int rowHeight;
    private int tableHeight;
    private int tableWidth;
    private int tableX;
    private int tableY;
    private boolean hasRecords = false;

    public HistoryRecordScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"\u5386\u53f2\u8bb0\u5f55"));
        this.parent = parent;
        instance = this;
        this.updateRecordsState();
    }

    public static void addHistoryRecord(String entityName, String damageInfo, String weaponInfo, boolean isPlayer, boolean isKill) {
        historyRecords.add(0, new HistoryRecord(entityName, damageInfo, weaponInfo, isPlayer, isKill));
        if (historyRecords.size() > 32) {
            historyRecords.remove(historyRecords.size() - 1);
        }
        if (instance != null) {
            instance.updateRecordsState();
            instance.updateButtonStates();
        }
    }

    public static HistoryRecordScreen getInstance() {
        return instance;
    }

    protected void method_25426() {
        super.method_25426();
        this.tableWidth = this.field_22789 - 20;
        this.tableHeight = this.field_22790 - 30 - 20 - 40;
        this.tableX = 10;
        this.tableY = 40;
        this.rowHeight = 18;
        this.initButtons();
    }

    public void method_25419() {
        instance = null;
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float partialTick) {
        this.method_25420(context);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        if (!this.hasRecords) {
            context.method_25300(this.field_22793, "\u6682\u65e0\u5386\u53f2\u8bb0\u5f55", this.field_22789 / 2, this.field_22790 / 2, 0x888888);
        } else {
            String countInfo = "\u5171 " + historyRecords.size() + " \u6761\u8bb0\u5f55";
            context.method_25303(this.field_22793, countInfo, this.field_22789 / 2 - this.field_22793.method_1727(countInfo) / 2, 20, 0xCCCCCC);
            this.renderHistoryTable(context);
        }
        super.method_25394(context, mouseX, mouseY, partialTick);
    }

    private void clearHistoryRecords() {
        historyRecords.clear();
        this.updateRecordsState();
        this.updateButtonStates();
    }

    private int getMaxVisibleRows() {
        return (this.tableHeight - 30) / this.rowHeight;
    }

    private void initButtons() {
        int bottomY = this.field_22790 - 20 - 10;
        this.clearButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u6e05\u7a7a\u8bb0\u5f55"), button -> this.clearHistoryRecords()).method_46434(10, bottomY, 60, 20).method_46431();
        this.method_37063((class_364)this.clearButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u8fd4\u56de"), button -> this.method_25419()).method_46434(this.field_22789 - 60 - 10, bottomY, 60, 20).method_46431());
        this.updateButtonStates();
    }

    private boolean isMouseOverRow(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.tableX && mouseX <= this.tableX + this.tableWidth && mouseY >= rowY && mouseY <= rowY + this.rowHeight;
    }

    private void renderHistoryTable(class_332 context) {
        context.method_25294(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + this.tableHeight, Integer.MIN_VALUE);
        this.renderTableHeader(context);
        this.renderTableRows(context);
    }

    private void renderRowData(class_332 context, HistoryRecord record, int rowY) {
        Objects.requireNonNull(this.field_22793);
        int textY = rowY + (this.rowHeight - 9) / 2;
        context.method_25303(this.field_22793, record.entityName, this.tableX + 10, textY, record.isPlayer ? -256 : -1);
        context.method_25303(this.field_22793, record.damageInfo, this.tableX + 160, textY, record.isKill ? -43691 : -1);
        context.method_25303(this.field_22793, record.weaponInfo, this.tableX + 260, textY, 0xFFFFFF);
    }

    private void renderTableHeader(class_332 context) {
        int headerY = this.tableY + 5;
        context.method_25294(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + 25, -2143009724);
        context.method_25294(this.tableX, this.tableY + 25, this.tableX + this.tableWidth, this.tableY + 26, -10066330);
        context.method_25303(this.field_22793, "\u5b9e\u4f53\u540d\u79f0", this.tableX + 10, headerY, 0xFFFFFF);
        context.method_25303(this.field_22793, "\u4f24\u5bb3\u4fe1\u606f", this.tableX + 160, headerY, 0xFFFFFF);
        context.method_25303(this.field_22793, "\u6b66\u5668\u4fe1\u606f", this.tableX + 260, headerY, 0xFFFFFF);
        context.method_25294(this.tableX + 150, this.tableY, this.tableX + 151, this.tableY + this.tableHeight, -10066330);
        context.method_25294(this.tableX + 250, this.tableY, this.tableX + 251, this.tableY + this.tableHeight, -10066330);
    }

    private void renderTableRows(class_332 context) {
        int visibleRows = Math.min(historyRecords.size(), this.getMaxVisibleRows());
        for (int i = 0; i < visibleRows; ++i) {
            HistoryRecord record = historyRecords.get(i);
            int rowY = this.tableY + 30 + i * this.rowHeight;
            if (i % 2 == 0) {
                context.method_25294(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40202020);
            }
            if (this.isMouseOverRow(this.currentMouseX, this.currentMouseY, rowY)) {
                context.method_25294(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40666666);
            }
            context.method_25294(this.tableX, rowY + this.rowHeight, this.tableX + this.tableWidth, rowY + this.rowHeight + 1, 0x40444444);
            this.renderRowData(context, record, rowY);
        }
    }

    private void updateButtonStates() {
        this.clearButton.field_22763 = this.hasRecords;
    }

    private void updateRecordsState() {
        this.hasRecords = !historyRecords.isEmpty();
    }

    public static class HistoryRecord {
        public final String damageInfo;
        public final String entityName;
        public final boolean isKill;
        public final boolean isPlayer;
        public final long timestamp = System.currentTimeMillis();
        public final String weaponInfo;

        public HistoryRecord(String entityName, String damageInfo, String weaponInfo, boolean isPlayer, boolean isKill) {
            this.entityName = entityName;
            this.damageInfo = damageInfo;
            this.weaponInfo = weaponInfo;
            this.isPlayer = isPlayer;
            this.isKill = isKill;
        }
    }
}

