/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.RankingDataRequestPacket;

public class RankingListScreen
extends class_437 {
    private final class_437 parent;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int PADDING = 10;
    private static final int ROWS_PER_PAGE = 32;
    private static final int TITLE_HEIGHT = 30;
    private static RankingListScreen instance;
    private class_4185 nextPageButton;
    private class_4185 prevPageButton;
    private int currentPage = 0;
    private boolean hasData = false;
    private boolean isLoading = true;
    private final boolean isInGame;
    private boolean rankingEnabled = true;
    private int totalPages = 0;
    private int currentMouseX;
    private int currentMouseY;
    private int rowHeight;
    private int tableHeight;
    private int tableWidth;
    private int tableX;
    private int tableY;
    private final List<RankingEntry> rankingEntries = new ArrayList<RankingEntry>();

    public RankingListScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"\u51fb\u6740\u56fe\u6807\u6392\u884c\u699c"));
        this.parent = parent;
        instance = this;
        this.isInGame = class_310.method_1551().field_1724 != null;
    }

    protected void method_25426() {
        super.method_25426();
        this.tableWidth = this.field_22789 - 20;
        this.tableHeight = this.field_22790 - 30 - 20 - 30;
        this.tableX = 10;
        this.tableY = 40;
        this.rowHeight = 18;
        this.initButtons();
        this.loadRankingData();
    }

    public void method_25419() {
        instance = null;
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float partialTick) {
        this.method_25420(context);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        if (!this.isInGame) {
            context.method_25300(this.field_22793, "\u8bf7\u5728\u6e38\u620f\u5185\u67e5\u770b\u6392\u884c\u699c", this.field_22789 / 2, this.field_22790 / 2, 0xFF5555);
        } else if (this.isLoading) {
            context.method_25300(this.field_22793, "\u6b63\u5728\u52a0\u8f7d\u6392\u884c\u699c\u6570\u636e...", this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
        } else if (!this.rankingEnabled) {
            context.method_25300(this.field_22793, "\u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed", this.field_22789 / 2, this.field_22790 / 2, 0xFF5555);
        } else if (!this.hasData) {
            context.method_25300(this.field_22793, "\u6682\u65e0\u6570\u636e", this.field_22789 / 2, this.field_22790 / 2, 0x888888);
        } else {
            String pageInfo = "\u7b2c " + (this.currentPage + 1) + " \u9875 / \u5171 " + this.totalPages + " \u9875";
            context.method_25303(this.field_22793, pageInfo, this.field_22789 / 2 - this.field_22793.method_1727(pageInfo) / 2, 20, 0xCCCCCC);
            this.renderRankingTable(context);
        }
        super.method_25394(context, mouseX, mouseY, partialTick);
    }

    public static RankingListScreen getInstance() {
        return instance;
    }

    public void updateRankingData(Map<UUID, Integer> serverRankingData, boolean rankingEnabled) {
        this.rankingEntries.clear();
        this.rankingEnabled = rankingEnabled;
        if (!rankingEnabled) {
            this.hasData = false;
            this.isLoading = false;
            this.updateButtonStates();
            return;
        }
        if (serverRankingData != null && !serverRankingData.isEmpty()) {
            ArrayList<Map.Entry<UUID, Integer>> sortedEntries = new ArrayList<Map.Entry<UUID, Integer>>(serverRankingData.entrySet());
            sortedEntries.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
            int rank = 1;
            for (Map.Entry entry : sortedEntries) {
                this.rankingEntries.add(new RankingEntry(rank, this.getPlayerName((UUID)entry.getKey()), (UUID)entry.getKey(), (Integer)entry.getValue()));
                ++rank;
            }
            this.hasData = true;
        } else {
            this.hasData = false;
        }
        this.totalPages = this.hasData ? (int)Math.ceil((double)this.rankingEntries.size() / 32.0) : 0;
        this.isLoading = false;
        this.updateButtonStates();
    }

    private void initButtons() {
        int bottomY = this.field_22790 - 20 - 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u8fd4\u56de"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 30, bottomY, 60, 20).method_46431());
        this.nextPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u4e0b\u4e00\u9875"), button -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.updateButtonStates();
            }
        }).method_46434(this.field_22789 - 60 - 10, bottomY, 60, 20).method_46431();
        this.method_37063((class_364)this.nextPageButton);
        this.prevPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u4e0a\u4e00\u9875"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateButtonStates();
            }
        }).method_46434(10, bottomY, 60, 20).method_46431();
        this.method_37063((class_364)this.prevPageButton);
        this.updateButtonStates();
    }

    private boolean isMouseOverRow(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.tableX && mouseX <= this.tableX + this.tableWidth && mouseY >= rowY && mouseY <= rowY + this.rowHeight;
    }

    private void loadRankingData() {
        this.isLoading = true;
        this.hasData = false;
        this.rankingEnabled = true;
        if (this.isInGame) {
            NetworkHandler.sendToServer(new RankingDataRequestPacket());
        } else {
            this.isLoading = false;
        }
    }

    private void renderRankingTable(class_332 context) {
        context.method_25294(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + this.tableHeight, Integer.MIN_VALUE);
        this.renderTableHeader(context);
        this.renderTableRows(context);
    }

    private void renderRowData(class_332 context, RankingEntry entry, int rowY) {
        Objects.requireNonNull(this.field_22793);
        int textY = rowY + (this.rowHeight - 9) / 2;
        context.method_25303(this.field_22793, String.valueOf(entry.rank), this.tableX + 10, textY, this.getRankColor(entry.rank));
        context.method_25303(this.field_22793, entry.playerName, this.tableX + 80, textY, 0xFFFFFF);
        context.method_25303(this.field_22793, String.format("%,d", entry.score), this.tableX + 290, textY, 0xFFFFFF);
    }

    private void renderTableHeader(class_332 context) {
        int headerY = this.tableY + 5;
        context.method_25294(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + 25, -2143009724);
        context.method_25294(this.tableX, this.tableY + 25, this.tableX + this.tableWidth, this.tableY + 26, -10066330);
        context.method_25303(this.field_22793, "\u6392\u540d", this.tableX + 10, headerY, 0xFFFFFF);
        context.method_25303(this.field_22793, "\u73a9\u5bb6\u540d\u79f0", this.tableX + 80, headerY, 0xFFFFFF);
        context.method_25303(this.field_22793, "\u5206\u6570", this.tableX + 290, headerY, 0xFFFFFF);
        context.method_25294(this.tableX + 70, this.tableY, this.tableX + 71, this.tableY + this.tableHeight, -10066330);
        context.method_25294(this.tableX + 280, this.tableY, this.tableX + 281, this.tableY + this.tableHeight, -10066330);
    }

    private void renderTableRows(class_332 context) {
        int startIndex = this.currentPage * 32;
        int endIndex = Math.min(startIndex + 32, this.rankingEntries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            RankingEntry entry = this.rankingEntries.get(i);
            int rowY = this.tableY + 30 + (i - startIndex) * this.rowHeight;
            if ((i - startIndex) % 2 == 0) {
                context.method_25294(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40202020);
            }
            if (this.isMouseOverRow(this.currentMouseX, this.currentMouseY, rowY)) {
                context.method_25294(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40666666);
            }
            context.method_25294(this.tableX, rowY + this.rowHeight, this.tableX + this.tableWidth, rowY + this.rowHeight + 1, 0x40444444);
            this.renderRowData(context, entry, rowY);
        }
    }

    private void updateButtonStates() {
        this.prevPageButton.field_22763 = this.currentPage > 0 && this.hasData && this.rankingEnabled;
        this.nextPageButton.field_22763 = this.currentPage < this.totalPages - 1 && this.hasData && this.rankingEnabled;
    }

    private String getPlayerName(UUID playerId) {
        try {
            class_1657 player;
            if (this.field_22787 != null && this.field_22787.field_1687 != null && (player = this.field_22787.field_1687.method_18470(playerId)) != null) {
                return player.method_7334().getName();
            }
            return "\u73a9\u5bb6_" + playerId.toString().substring(0, 8);
        }
        catch (Exception e) {
            return "\u672a\u77e5\u73a9\u5bb6";
        }
    }

    private int getRankColor(int rank) {
        return switch (rank) {
            case 1 -> -10496;
            case 2 -> -4144960;
            case 3 -> -3309774;
            default -> -1;
        };
    }

    private record RankingEntry(int rank, String playerName, UUID playerId, int score) {
    }
}

