/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.iconrenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;

@Environment(value=EnvType.CLIENT)
public class CardModeRenderer {
    private static int killChainTimeout = 60000;
    private static long bottomBarFlashStartTime = 0L;
    private static boolean bottomBarFlashing = false;

    public static void setKillChainTimeout(int timeout) {
        killChainTimeout = timeout;
    }

    public static int getKillChainTimeout() {
        return killChainTimeout;
    }

    public void handleCardMode() {
        long currentTime;
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        CardModeRenderer.getCurrentPosition();
        float startX = (float)screenWidth / 2.0f + (float)Config.cardIconX;
        float startY = screenHeight + Config.cardIconY;
        KillIconRenderer.lastKillTime = currentTime = System.currentTimeMillis();
        if (Config.cardBottombarVisible) {
            bottomBarFlashStartTime = currentTime;
            bottomBarFlashing = true;
        }
        for (CardInstance card : KillIconRenderer.activeCards) {
            if (!card.lightVisible) continue;
            this.startLightRemoveAnimation(card, currentTime);
        }
        if (++KillIconRenderer.cardComboCount == 6) {
            this.startAceFormationAnimation(currentTime);
        } else if (KillIconRenderer.cardComboCount >= 7) {
            this.handleAceCardMode(currentTime);
        } else {
            CardInstance newCard = this.createCardInstance(startX, startY, currentTime);
            KillIconRenderer.activeCards.add(newCard);
            this.calculateCardPositions(KillIconRenderer.cardComboCount);
        }
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            class_3414 sound = CardModeRenderer.getCardKillSound();
            CardModeRenderer.playSoundWithCooldown(sound, volume);
        }
        KillIconRenderer.latestWeaponName = "";
        KillIconRenderer.latestTargetName = "";
        KillIconRenderer.textAnimationStartTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderCards(class_332 drawContext, class_4587 matrixStack, long currentTime) {
        KillIconRenderer.resetComboIfNeeded();
        if (KillIconRenderer.activeCards.isEmpty()) {
            return;
        }
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        try {
            boolean chainEnded = false;
            if (killChainTimeout > 0) {
                boolean bl = chainEnded = currentTime - KillIconRenderer.lastKillTime > (long)killChainTimeout;
            }
            if (chainEnded) {
                long fadeElapsed = currentTime - KillIconRenderer.lastKillTime - (long)killChainTimeout;
                float fadeProgress = class_3532.method_15363((float)((float)fadeElapsed / 1000.0f), (float)0.0f, (float)1.0f);
                for (CardInstance card : KillIconRenderer.activeCards) {
                    card.alpha = 1.0f - fadeProgress;
                }
                if (fadeProgress >= 1.0f) {
                    KillIconRenderer.activeCards.clear();
                    return;
                }
            } else {
                for (CardInstance card : KillIconRenderer.activeCards) {
                    if (!(card.alpha < 1.0f)) continue;
                    card.alpha = 1.0f;
                }
            }
            for (CardInstance card : KillIconRenderer.activeCards) {
                long elapsed = currentTime - card.startTime;
                CardModeRenderer.updateCardAnimation(card, elapsed, currentTime);
                if (!card.lightVisible || !(card.lightAlpha > 0.0f)) continue;
                CardModeRenderer.renderLightEffect(drawContext, matrixStack, card);
            }
            for (CardInstance card : KillIconRenderer.activeCards) {
                CardModeRenderer.renderSingleCard(drawContext, matrixStack, card);
            }
        }
        finally {
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderBottomBar(class_332 drawContext, class_4587 matrixStack) {
        if (!Config.cardBottombarVisible) {
            return;
        }
        float brightness = 1.0f;
        if (bottomBarFlashing) {
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - bottomBarFlashStartTime;
            if (elapsed < 100L) {
                progress = class_3532.method_15363((float)((float)elapsed / 100.0f), (float)0.0f, (float)1.0f);
                brightness = 1.0f + 1.5f * progress;
            } else if (elapsed < 200L) {
                progress = class_3532.method_15363((float)((float)(elapsed - 100L) / 100.0f), (float)0.0f, (float)1.0f);
                brightness = 2.5f - 1.5f * progress;
            } else {
                bottomBarFlashing = false;
            }
        }
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.9f);
            matrixStack.method_22903();
            try {
                class_310 mc = class_310.method_1551();
                int screenWidth = mc.method_22683().method_4486();
                int screenHeight = mc.method_22683().method_4502();
                RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
                float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
                float originY = screenHeight + pos.iconY + Config.cardBottombarOffsetY;
                float scale = (float)Config.cardBottombarSize / 100.0f * 0.25f;
                int width = (int)(256.0f * scale);
                int height = (int)(256.0f * scale);
                float renderX = centerX - (float)width / 2.0f;
                float renderY = originY - (float)height / 2.0f;
                class_2960 bottomBarTexture = CardModeRenderer.getBottomBarTexture();
                drawContext.method_25293(bottomBarTexture, (int)renderX, (int)renderY, width, height, 0.0f, 0.0f, 2400, 256, 2400, 256);
            }
            finally {
                matrixStack.method_22909();
            }
        }
        finally {
            modelViewStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    private void handleAceCardMode(long currentTime) {
        if (KillIconRenderer.cardComboCount == 6) {
            this.startAceFormationAnimation(currentTime);
        } else {
            this.handleNormalAceCard(currentTime);
        }
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            class_3414 sound = CardModeRenderer.getCardKillSound();
            CardModeRenderer.playSoundWithCooldown(sound, volume);
        }
        KillIconRenderer.latestWeaponName = "";
        KillIconRenderer.latestTargetName = "";
        KillIconRenderer.textAnimationStartTime = 0L;
    }

    private void calculateCardPositions(int comboCount) {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetBaseY = screenHeight + pos.iconY;
        comboCount = Math.min(comboCount, 5);
        for (CardInstance card : KillIconRenderer.activeCards) {
            card.startX = card.x;
            card.startY = card.y;
            card.startRotation = card.rotation;
            card.animationStartTime = System.currentTimeMillis();
            card.isAnimating = true;
            card.lightOffsetX = 0.0f;
            card.lightOffsetY = 0.0f;
            card.lightRotation = 0.0f;
            switch (comboCount) {
                case 1: {
                    card.targetX = centerX;
                    card.targetY = targetBaseY;
                    card.targetRotation = 0.0f;
                    break;
                }
                case 2: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 10.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -5.0f;
                        card.lightOffsetX = -10.0f;
                        card.lightRotation = -5.0f;
                        break;
                    }
                    card.targetX = centerX + 10.0f;
                    card.targetY = targetBaseY;
                    card.targetRotation = 5.0f;
                    card.lightOffsetX = 1.25f;
                    card.lightRotation = 5.0f;
                    break;
                }
                case 3: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 15.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -10.0f;
                        card.lightOffsetX = -15.0f;
                        card.lightRotation = -10.0f;
                        break;
                    }
                    if (card.comboPosition == 1) {
                        card.targetX = centerX;
                        card.targetY = targetBaseY;
                        card.targetRotation = 0.0f;
                        break;
                    }
                    card.targetX = centerX + 15.0f;
                    card.targetY = targetBaseY;
                    card.targetRotation = 10.0f;
                    card.lightOffsetX = 2.25f;
                    card.lightRotation = 10.0f;
                    break;
                }
                case 4: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 15.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -15.0f;
                        card.lightOffsetX = -15.0f;
                        card.lightRotation = -15.0f;
                        break;
                    }
                    if (card.comboPosition == 1) {
                        card.targetX = centerX - 5.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -5.0f;
                        card.lightOffsetX = -5.0f;
                        card.lightRotation = -5.0f;
                        break;
                    }
                    if (card.comboPosition == 2) {
                        card.targetX = centerX + 5.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = 5.0f;
                        card.lightOffsetX = 5.0f;
                        card.lightRotation = 5.0f;
                        break;
                    }
                    card.targetX = centerX + 15.0f;
                    card.targetY = targetBaseY;
                    card.targetRotation = 15.0f;
                    card.lightOffsetX = 2.75f;
                    card.lightRotation = 15.0f;
                    break;
                }
                case 5: {
                    if (card.comboPosition == 0) {
                        card.targetX = centerX - 20.0f;
                        card.targetY = targetBaseY + 3.0f;
                        card.targetRotation = -30.0f;
                        card.lightOffsetX = -20.0f;
                        card.lightOffsetY = 3.0f;
                        card.lightRotation = -30.0f;
                        break;
                    }
                    if (card.comboPosition == 1) {
                        card.targetX = centerX - 10.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = -15.0f;
                        card.lightOffsetX = -10.0f;
                        card.lightRotation = -15.0f;
                        break;
                    }
                    if (card.comboPosition == 2) {
                        card.targetX = centerX;
                        card.targetY = targetBaseY;
                        card.targetRotation = 0.0f;
                        break;
                    }
                    if (card.comboPosition == 3) {
                        card.targetX = centerX + 10.0f;
                        card.targetY = targetBaseY;
                        card.targetRotation = 15.0f;
                        card.lightOffsetX = 10.0f;
                        card.lightRotation = 15.0f;
                        break;
                    }
                    card.targetX = centerX + 20.0f;
                    card.targetY = targetBaseY + 3.0f;
                    card.targetRotation = 30.0f;
                    card.lightOffsetX = 3.0f;
                    card.lightOffsetY = 3.0f;
                    card.lightRotation = 30.0f;
                }
            }
            card.lightTargetX = card.targetX;
            card.lightTargetY = card.targetY;
        }
    }

    private CardInstance createCardInstance(float startX, float startY, long currentTime) {
        int cardWidth = 48;
        int cardHeight = 72;
        int cardTypeIndex = KillIconRenderer.cardComboCount - 1;
        CardInstance card = new CardInstance(currentTime, startX, startY, cardTypeIndex, cardWidth, cardHeight, KillIconRenderer.cardComboCount - 1);
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        card.targetX = (float)class_310.method_1551().method_22683().method_4486() / 2.0f + (float)pos.iconX;
        card.targetY = class_310.method_1551().method_22683().method_4502() + pos.iconY;
        CardModeRenderer.updateCardLightTexture(card);
        return card;
    }

    private void handleNormalAceCard(long currentTime) {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        float originX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float originY = screenHeight + pos.iconY;
        int cardWidth = 48;
        int cardHeight = 72;
        CardInstance aceCard = new CardInstance(currentTime, originX, originY, 4, cardWidth, cardHeight, 0);
        aceCard.isAceCard = true;
        aceCard.scale = 0.75f;
        aceCard.brightness = 1024.0f;
        aceCard.isAnimating = true;
        aceCard.animationStartTime = currentTime;
        aceCard.targetX = originX;
        aceCard.targetY = originY;
        aceCard.targetRotation = 0.0f;
        aceCard.startX = originX;
        aceCard.startY = originY;
        aceCard.startRotation = 0.0f;
        aceCard.lightOffsetX = 0.0f;
        aceCard.lightOffsetY = 0.0f;
        aceCard.lightRotation = 0.0f;
        CardModeRenderer.updateCardLightTexture(aceCard);
        KillIconRenderer.activeCards.add(aceCard);
    }

    private void startAceFormationAnimation(long currentTime) {
        RenderHelper.PositionConfig pos = CardModeRenderer.getCurrentPosition();
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float centerY = screenHeight + pos.iconY;
        KillIconRenderer.activeCards.removeIf(card -> card.isAceCard);
        for (CardInstance cardInstance : KillIconRenderer.activeCards) {
            cardInstance.isFormingAce = true;
            cardInstance.targetX = centerX;
            cardInstance.targetY = centerY;
            cardInstance.targetRotation = 0.0f;
            cardInstance.animationStartTime = currentTime;
            cardInstance.isAnimating = true;
            cardInstance.lightOffsetX = 0.0f;
            cardInstance.lightOffsetY = 0.0f;
            cardInstance.lightRotation = 0.0f;
            if (cardInstance.cardIndex == 4) continue;
            cardInstance.shouldRemoveAfterAce = true;
        }
        boolean hasAceCard = false;
        for (CardInstance card3 : KillIconRenderer.activeCards) {
            if (card3.cardIndex != 4) continue;
            hasAceCard = true;
            card3.isAceCard = true;
            card3.alpha = 0.0f;
            card3.lightStartTime = currentTime;
            card3.lightVisible = true;
            card3.lightAlpha = 0.0f;
            card3.lightBrightness = 1.0f;
            card3.lightYOffset = 200;
            card3.lightScale = 1.0f;
            break;
        }
        if (!hasAceCard) {
            int n = 48;
            int cardHeight = 72;
            CardInstance aceCard = new CardInstance(currentTime, centerX, centerY, 4, n, cardHeight, 4);
            aceCard.isAceCard = true;
            aceCard.alpha = 0.0f;
            aceCard.isFormingAce = true;
            aceCard.lightStartTime = currentTime;
            aceCard.lightVisible = true;
            aceCard.lightAlpha = 0.0f;
            aceCard.lightBrightness = 1.0f;
            aceCard.lightYOffset = 200;
            aceCard.lightScale = 1.0f;
            KillIconRenderer.activeCards.add(aceCard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderSingleCard(class_332 drawContext, class_4587 matrixStack, CardInstance card) {
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float finalScale = card.scale;
            float finalBrightness = card.brightness;
            RenderSystem.setShaderColor((float)finalBrightness, (float)finalBrightness, (float)finalBrightness, (float)card.alpha);
            matrixStack.method_22903();
            try {
                float centerX = card.x - (float)card.cardWidth * finalScale / 2.0f;
                float centerY = card.y - (float)card.cardHeight * finalScale / 2.0f;
                matrixStack.method_46416(centerX + (float)card.cardWidth * finalScale / 2.0f, centerY + (float)card.cardHeight * finalScale / 2.0f, 0.0f);
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(card.rotation));
                matrixStack.method_46416(-((float)card.cardWidth * finalScale) / 2.0f, -((float)card.cardHeight * finalScale) / 2.0f, 0.0f);
                matrixStack.method_22905(finalScale, finalScale, 1.0f);
                class_2960 cardTexture = CardModeRenderer.getCardTexture(card.cardIndex);
                drawContext.method_25290(cardTexture, 0, 0, 0.0f, 0.0f, card.cardWidth, card.cardHeight, card.cardWidth, card.cardHeight);
            }
            finally {
                matrixStack.method_22909();
            }
        }
        finally {
            modelViewStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderLightEffect(class_332 drawContext, class_4587 matrixStack, CardInstance card) {
        if (card.lightTexture == null || card.lightAlpha <= 0.0f) {
            return;
        }
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)card.lightBrightness, (float)card.lightBrightness, (float)card.lightBrightness, (float)card.lightAlpha);
            matrixStack.method_22903();
            try {
                float scaleToCardWidth = (float)card.cardWidth * card.scale / 248.0f;
                float baseScale = card.lightScale;
                float scaledLightWidth = 248.0f * scaleToCardWidth * baseScale;
                float scaledLightHeight = 2048.0f * scaleToCardWidth * baseScale;
                float lightX = card.x + card.lightOffsetX - scaledLightWidth / 2.0f;
                float lightY = card.y + card.lightOffsetY + (float)card.lightYOffset - scaledLightHeight / 2.0f;
                matrixStack.method_46416(lightX, lightY, 0.0f);
                if (card.lightRotation != 0.0f) {
                    matrixStack.method_46416(scaledLightWidth / 2.0f, scaledLightHeight / 2.0f, 0.0f);
                    matrixStack.method_22907(class_7833.field_40718.rotationDegrees(card.lightRotation));
                    matrixStack.method_46416(-scaledLightWidth / 2.0f, -scaledLightHeight / 2.0f, 0.0f);
                }
                drawContext.method_25293(card.lightTexture, 0, 0, (int)scaledLightWidth, (int)scaledLightHeight, 0.0f, 0.0f, 248, 2048, 248, 2048);
            }
            finally {
                matrixStack.method_22909();
            }
        }
        finally {
            modelViewStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    private void startLightRemoveAnimation(CardInstance card, long currentTime) {
        if (!card.lightVisible) {
            return;
        }
        long elapsedInCurrentPhase = currentTime - card.lightStartTime;
        if (elapsedInCurrentPhase < 500L) {
            card.lightStartTime = currentTime - 500L;
        } else if (elapsedInCurrentPhase < 3000L) {
            long remainingFadeTime = 3000L - elapsedInCurrentPhase;
            card.lightStartTime = currentTime - (3000L - Math.min(remainingFadeTime, 500L));
        }
    }

    private static void updateCardAnimation(CardInstance card, long elapsed, long currentTime) {
        float elapsedSeconds = (float)elapsed / 1000.0f;
        long animElapsed = currentTime - card.animationStartTime;
        float animProgress = class_3532.method_15363((float)((float)animElapsed / 500.0f), (float)0.0f, (float)1.0f);
        float easedProgress = 1.0f - (float)Math.pow(1.0f - animProgress, 3.0);
        if (card.isFormingAce) {
            card.x = class_3532.method_16439((float)easedProgress, (float)card.startX, (float)card.targetX);
            card.y = class_3532.method_16439((float)easedProgress, (float)card.startY, (float)card.targetY);
            card.rotation = class_3532.method_16439((float)easedProgress, (float)card.startRotation, (float)card.targetRotation);
            if (card.isAceCard) {
                card.alpha = class_3532.method_15363((float)(animProgress * 2.0f), (float)0.0f, (float)1.0f);
            }
            if (animProgress >= 1.0f) {
                card.isFormingAce = false;
                if (card.shouldRemoveAfterAce) {
                    card.alpha = 0.0f;
                }
            }
        } else if (card.isAceCard && KillIconRenderer.cardComboCount >= 7) {
            if (card.isAnimating) {
                card.x = class_3532.method_16439((float)easedProgress, (float)card.startX, (float)card.targetX);
                card.y = class_3532.method_16439((float)easedProgress, (float)card.startY, (float)card.targetY);
                card.rotation = class_3532.method_16439((float)easedProgress, (float)card.startRotation, (float)card.targetRotation);
                if (animProgress >= 1.0f) {
                    card.isAnimating = false;
                }
            }
        } else if (card.isAnimating) {
            card.x = class_3532.method_16439((float)easedProgress, (float)card.startX, (float)card.targetX);
            card.y = class_3532.method_16439((float)easedProgress, (float)card.startY, (float)card.targetY);
            card.rotation = class_3532.method_16439((float)easedProgress, (float)card.startRotation, (float)card.targetRotation);
            if (animProgress >= 1.0f) {
                card.isAnimating = false;
            }
        }
        if (elapsedSeconds < 0.5f) {
            card.brightness = 2.0f;
        } else if (elapsedSeconds < 0.8f) {
            float progress = class_3532.method_15363((float)((elapsedSeconds - 0.5f) / 0.3f), (float)0.0f, (float)1.0f);
            card.brightness = 2.0f * (1.0f - progress) + progress;
        } else {
            card.brightness = 1.0f;
        }
        CardModeRenderer.updateLightAnimation(card, currentTime);
    }

    private static void updateLightAnimation(CardInstance card, long currentTime) {
        if (!card.lightVisible) {
            return;
        }
        long lightElapsed = currentTime - card.lightStartTime;
        if (lightElapsed < 500L) {
            float progress = class_3532.method_15363((float)((float)lightElapsed / 500.0f), (float)0.0f, (float)1.0f);
            float easedProgress = CardModeRenderer.easeOutBack(progress);
            card.lightYOffset = class_3532.method_48781((float)easedProgress, (int)200, (int)0);
            if (lightElapsed < 100L) {
                float flashProgress = class_3532.method_15363((float)((float)lightElapsed / 100.0f), (float)0.0f, (float)1.0f);
                float easedFlash = flashProgress * flashProgress;
                card.lightBrightness = class_3532.method_16439((float)easedFlash, (float)1.0f, (float)2.5f);
            } else if (lightElapsed < 200L) {
                float flashProgress = class_3532.method_15363((float)((float)(lightElapsed - 100L) / 100.0f), (float)0.0f, (float)1.0f);
                float easedFlash = flashProgress * flashProgress;
                card.lightBrightness = class_3532.method_16439((float)easedFlash, (float)2.5f, (float)1.0f);
            } else {
                card.lightBrightness = 1.0f;
            }
            card.lightAlpha = easedProgress;
            card.lightScale = 1.0f;
        } else if (lightElapsed < 3000L) {
            card.lightYOffset = 0;
            card.lightBrightness = 1.0f;
            float scaleElapsed = lightElapsed - 500L;
            float scaleProgress = class_3532.method_15363((float)(scaleElapsed / 3000.0f), (float)0.0f, (float)1.0f);
            float easedScaleProgress = 1.0f - (float)Math.pow(1.0f - scaleProgress, 2.0);
            card.lightScale = 1.0f - easedScaleProgress * 0.2f;
            float fadeProgress = class_3532.method_15363((float)(scaleElapsed / 2500.0f), (float)0.0f, (float)1.0f);
            float easedFadeProgress = 1.0f - (float)Math.pow(1.0f - fadeProgress, 3.0);
            card.lightAlpha = 1.0f - easedFadeProgress;
        } else {
            card.lightAlpha = 0.0f;
            card.lightVisible = false;
        }
        CardModeRenderer.updateLightPosition(card);
    }

    private static float easeOutBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return 1.0f + c3 * (float)Math.pow(x - 1.0f, 3.0) + c1 * (float)Math.pow(x - 1.0f, 2.0);
    }

    private static class_3414 getCardKillSound() {
        return Gd656killicon.getCardKillSound();
    }

    private static class_2960 getCardTexture(int cardIndex) {
        String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        String cardFileName = cardIndex < 4 ? "killcard_" + (cardIndex + 1) + ".png" : "killcard_ace.png";
        return class_2960.method_43902((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/" + cardFileName));
    }

    private static class_2960 getBottomBarTexture() {
        String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        return class_2960.method_43902((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/bottom_bar.png"));
    }

    private static RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
            }
        }
        return config;
    }

    private static void updateCardLightTexture(CardInstance card) {
        String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        card.lightTexture = class_2960.method_43902((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/light.png"));
    }

    private static void updateLightPosition(CardInstance card) {
        card.lightX = card.x;
        float cardBottomY = card.y + (float)card.cardHeight * card.scale / 2.0f;
        card.lightY = cardBottomY - card.lightOffsetY;
    }

    private static void playSoundWithCooldown(class_3414 sound, float volume) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && sound != null) {
            client.field_1724.method_5783(sound, volume, 1.0f);
        }
    }

    public static class CardInstance {
        public float alpha;
        public long animationStartTime;
        public float brightness;
        public int cardHeight;
        public int cardIndex;
        public int cardWidth;
        public int comboPosition;
        public boolean isAceCard = false;
        public boolean isAnimating;
        public boolean isFormingAce = false;
        public float rotation;
        public float scale;
        public boolean shouldRemoveAfterAce = false;
        public long startTime;
        public float startRotation;
        public float startX;
        public float startY;
        public float targetRotation;
        public float targetX;
        public float targetY;
        public float x;
        public float y;
        public float lightAlpha;
        public float lightBrightness;
        public float lightOffsetX = 0.0f;
        public float lightOffsetY;
        public float lightRotation = 0.0f;
        public float lightScale;
        public long lightStartTime;
        public class_2960 lightTexture;
        public float lightTargetX;
        public float lightTargetY;
        public boolean lightVisible;
        public float lightX;
        public float lightY;
        private int lightYOffset;

        public CardInstance(long startTime, float x, float y, int cardIndex, int width, int height, int comboPosition) {
            this.startTime = startTime;
            this.x = x;
            this.y = y;
            this.startX = x;
            this.startY = y;
            this.targetX = x;
            this.targetY = y - 30.0f;
            this.brightness = 1024.0f;
            this.scale = 0.75f;
            this.alpha = 1.0f;
            this.cardIndex = cardIndex;
            this.cardWidth = width;
            this.cardHeight = height;
            this.rotation = 0.0f;
            this.targetRotation = 0.0f;
            this.startRotation = 0.0f;
            this.animationStartTime = startTime;
            this.isAnimating = true;
            this.comboPosition = comboPosition;
            this.lightStartTime = startTime;
            this.lightVisible = true;
            this.lightAlpha = 0.0f;
            this.lightBrightness = 1.0f;
            this.lightOffsetY = height * 2;
            this.lightYOffset = 200;
            this.lightScale = 1.0f;
            this.updateLightTexture();
        }

        private void updateLightTexture() {
            String stylePath = Config.cardIconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
            this.lightTexture = class_2960.method_43902((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/cardmode/light.png"));
        }
    }
}

