/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.iconrenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.iconrenderer.ScrollingIconRenderer;

@Environment(value=EnvType.CLIENT)
public class ComboIconRenderer {
    private static Config.IconStyle currentIconStyle = null;
    public static class_2960[] VANALLA_COMBO_ICONS;

    public static void handleComboMode(String weaponName, String targetName, boolean isCritical, boolean isAssist) {
        class_310 mc = class_310.method_1551();
        KillIconRenderer.activeIcons.clear();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int iconSize = Config.killIconSize;
        RenderHelper.PositionConfig pos = ComboIconRenderer.getCurrentPosition();
        float targetX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetY = screenHeight + pos.iconY;
        int comboIndex = Math.min(KillIconRenderer.comboCount, 6) - 1;
        comboIndex = Math.max(comboIndex, 0);
        ScrollingIconRenderer.KillIconInstance newIcon = new ScrollingIconRenderer.KillIconInstance(System.currentTimeMillis(), targetX - (float)iconSize / 2.0f, targetY - (float)iconSize / 2.0f, isCritical);
        newIcon.isCombo = true;
        newIcon.comboIndex = comboIndex;
        newIcon.isAssist = isAssist;
        if (Config.comboIconAnimationEnabled) {
            newIcon.animationStartTime = System.currentTimeMillis();
            newIcon.currentFrame = 0;
            newIcon.isAnimating = true;
            newIcon.scale = 1.8f;
            newIcon.brightness = 2.0f;
        } else {
            newIcon.isAnimating = false;
            newIcon.currentFrame = Config.comboIconAnimationTotalFrames - 1;
            newIcon.scale = 1.0f;
            newIcon.brightness = 1.0f;
        }
        KillIconRenderer.latestIsCritical = isCritical;
        class_3414[] comboSounds = ComboIconRenderer.getComboSounds();
        if (comboIndex < comboSounds.length) {
            try {
                class_3414 sound = comboSounds[comboIndex];
                float volume = (float)Config.soundVolume / 100.0f;
                ComboIconRenderer.playSoundWithCooldown(sound, volume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KillIconRenderer.activeIcons.add(newIcon);
        KillIconRenderer.textAnimationStartTime = System.currentTimeMillis();
        KillIconRenderer.textHideTime = 0L;
        KillIconRenderer.lastKillTime = System.currentTimeMillis();
        KillIconRenderer.isFadingOutAll = false;
        KillIconRenderer.latestWeaponName = weaponName;
        KillIconRenderer.latestTargetName = targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderComboIcon(class_332 drawContext, class_4587 matrixStack, ScrollingIconRenderer.KillIconInstance icon, int iconSize) {
        if (icon.comboIndex < 0 || icon.comboIndex >= VANALLA_COMBO_ICONS.length) {
            return;
        }
        if (icon.isAnimating) {
            ComboIconRenderer.updateAnimationFrame(icon);
        }
        int scaledSize = (int)((float)iconSize * icon.scale);
        int offsetX = (iconSize - scaledSize) / 2;
        int offsetY = (iconSize - scaledSize) / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)icon.brightness, (float)icon.brightness, (float)icon.brightness, (float)icon.alpha);
        matrixStack.method_22903();
        try {
            matrixStack.method_46416(icon.currentX + (float)offsetX, icon.currentY + (float)offsetY, 0.0f);
            matrixStack.method_22905(icon.scale, icon.scale, 1.0f);
            class_2960 iconTexture = VANALLA_COMBO_ICONS[icon.comboIndex];
            if (iconTexture == null) {
                return;
            }
            if (icon.isAnimating) {
                ComboIconRenderer.renderAnimationFrame(drawContext, iconTexture, icon, iconSize);
            } else {
                ComboIconRenderer.renderStaticFrame(drawContext, iconTexture, iconSize);
            }
        }
        finally {
            matrixStack.method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void loadResources() {
        if (currentIconStyle == Config.iconStyle) {
            return;
        }
        String stylePath = Config.iconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        VANALLA_COMBO_ICONS = new class_2960[6];
        for (int i = 0; i < 6; ++i) {
            ComboIconRenderer.VANALLA_COMBO_ICONS[i] = class_2960.method_43902((String)"gd656killicon", (String)("textures/gui/" + stylePath + "/combomode/combo_" + (i + 1) + ".png"));
        }
        currentIconStyle = Config.iconStyle;
    }

    private static void updateAnimationFrame(ScrollingIconRenderer.KillIconInstance icon) {
        if (!icon.isAnimating) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - icon.animationStartTime;
        float progress = class_3532.method_15363((float)((float)elapsed / (float)Config.comboIconAnimationDuration), (float)0.0f, (float)1.0f);
        int targetFrame = (int)(progress * (float)(Config.comboIconAnimationTotalFrames - 1));
        if (targetFrame >= Config.comboIconAnimationTotalFrames - 1) {
            icon.isAnimating = false;
            icon.currentFrame = Config.comboIconAnimationTotalFrames - 1;
        } else {
            icon.currentFrame = targetFrame;
        }
    }

    private static void renderAnimationFrame(class_332 drawContext, class_2960 texture, ScrollingIconRenderer.KillIconInstance icon, int iconSize) {
        if (texture == null) {
            return;
        }
        int textureHeight = iconSize * Config.comboIconAnimationTotalFrames;
        boolean frameX = false;
        int frameY = icon.currentFrame * iconSize;
        drawContext.method_25293(texture, 0, 0, iconSize, iconSize, (float)frameX, (float)frameY, iconSize, iconSize, iconSize, textureHeight);
    }

    private static void renderStaticFrame(class_332 drawContext, class_2960 texture, int iconSize) {
        if (texture == null) {
            return;
        }
        int textureHeight = iconSize * Config.comboIconAnimationTotalFrames;
        boolean frameX = false;
        int frameY = (Config.comboIconAnimationTotalFrames - 1) * iconSize;
        drawContext.method_25293(texture, 0, 0, iconSize, iconSize, (float)frameX, (float)frameY, iconSize, iconSize, iconSize, textureHeight);
    }

    private static class_3414[] getComboSounds() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return new class_3414[]{Gd656killicon.COMBO_1_VANILLA, Gd656killicon.COMBO_2_VANILLA, Gd656killicon.COMBO_3_VANILLA, Gd656killicon.COMBO_4_VANILLA, Gd656killicon.COMBO_5_VANILLA, Gd656killicon.COMBO_6_VANILLA};
        }
        return new class_3414[]{Gd656killicon.COMBO_1_MODERN, Gd656killicon.COMBO_2_MODERN, Gd656killicon.COMBO_3_MODERN, Gd656killicon.COMBO_4_MODERN, Gd656killicon.COMBO_5_MODERN, Gd656killicon.COMBO_6_MODERN};
    }

    private static RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        config.iconX = Config.comboIconX;
        config.iconY = Config.comboIconY;
        config.subtitleX = Config.comboSubtitleX;
        config.subtitleY = Config.comboSubtitleY;
        config.scoreX = Config.comboScoreX;
        config.scoreY = Config.comboScoreY;
        config.bonusX = Config.comboBonusX;
        config.bonusY = Config.comboBonusY;
        return config;
    }

    private static void playSoundWithCooldown(class_3414 sound, float volume) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && sound != null) {
            client.field_1724.method_5783(sound, volume, 1.0f);
        }
    }
}

