/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.subtitlerenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.RenderHelper;

@Environment(value=EnvType.CLIENT)
public class ScoreItemRenderer {
    private static final long COMBO_KILL_ANIMATION_DURATION = 500L;
    private static final long ANIMATION_DURATION = 500L;
    private static final float ANIMATION_SPEED_MULTIPLIER = 0.5f;
    private static final int BATCH_SIZE = 10;
    private static final long NUMBER_ANIMATION_UPDATE_INTERVAL = 66L;
    private static final long ENTRY_ANIMATION_UPDATE_INTERVAL = 33L;
    private static final StringBuilder textBuilder = new StringBuilder(64);
    private RenderHelper.PositionConfig cachedPositionConfig;
    private long lastConfigCheckTime;
    private long lastNumberAnimationUpdate;
    private long lastEntryAnimationUpdate;
    private final List<CachedText> textCache = new ArrayList<CachedText>(10);

    public void updateScoreItems(long currentTime) {
        if (!KillIconRenderer.scoreItems.isEmpty()) {
            int processed = 0;
            while (!KillIconRenderer.scoreItems.isEmpty() && processed < 10) {
                ScoreItem item = KillIconRenderer.scoreItems.poll();
                if (item == null) continue;
                item.yOffset = 15.0f;
                item.targetYOffset = 0.0f;
                item.isAnimating = true;
                item.animationStartTime = currentTime;
                KillIconRenderer.activeScoreItems.add(item);
                ++processed;
            }
        }
        if (KillIconRenderer.activeScoreItems.isEmpty()) {
            return;
        }
        this.updateNumberAnimations(currentTime);
        this.updateEntryAnimations(currentTime);
        this.updatePositions(currentTime);
    }

    public void renderScoreItems(class_332 drawContext, long currentTime) {
        if (!RenderHelper.isElementVisible(ModConfigScreen.ElementType.BONUS) || KillIconRenderer.activeScoreItems.isEmpty()) {
            return;
        }
        float[] oldColor = RenderSystem.getShaderColor();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310 mc = class_310.method_1551();
        class_327 textRenderer = mc.field_1772;
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        int bonusBaseY = screenHeight + pos.bonusY;
        float bonusSizeScale = (float)RenderHelper.getElementSize(ModConfigScreen.ElementType.BONUS) / 100.0f;
        this.textCache.clear();
        this.preprocessRenderData(textRenderer, screenWidth, bonusBaseY, bonusSizeScale, currentTime);
        this.renderCachedTexts(drawContext, textRenderer);
        RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        RenderSystem.enableBlend();
    }

    private void updateNumberAnimations(long currentTime) {
        if (currentTime - this.lastNumberAnimationUpdate < 66L) {
            return;
        }
        this.lastNumberAnimationUpdate = currentTime;
        for (ScoreItem item : KillIconRenderer.activeScoreItems) {
            item.updateNumberAnimation(currentTime);
            item.lastUpdateTime = currentTime;
        }
    }

    private void updateEntryAnimations(long currentTime) {
        if (currentTime - this.lastEntryAnimationUpdate < 33L) {
            return;
        }
        this.lastEntryAnimationUpdate = currentTime;
        for (ScoreItem item : KillIconRenderer.activeScoreItems) {
            item.updateEntryAnimation(currentTime);
        }
    }

    private void updatePositions(long currentTime) {
        float animationSpeed = (float)(0.1 * (0.2 / Config.scrollAnimationSpeed)) * 0.5f;
        Iterator<ScoreItem> iterator = KillIconRenderer.activeScoreItems.iterator();
        while (iterator.hasNext()) {
            ScoreItem item = iterator.next();
            long elapsed = currentTime - item.startTime;
            if (elapsed > item.displayDuration || item.quickDisappearStartTime > 0L && currentTime - item.quickDisappearStartTime > 200L) {
                iterator.remove();
                if (!item.isComboKill) continue;
                KillIconRenderer.comboKillItem = null;
                continue;
            }
            if (!(Math.abs(item.yOffset - item.targetYOffset) > 0.1f)) continue;
            item.yOffset = class_3532.method_16439((float)animationSpeed, (float)item.yOffset, (float)item.targetYOffset);
        }
        this.adjustItemPositions();
    }

    private void preprocessRenderData(class_327 textRenderer, int screenWidth, int bonusBaseY, float bonusSizeScale, long currentTime) {
        Iterator<ScoreItem> iterator = KillIconRenderer.activeScoreItems.iterator();
        while (iterator.hasNext()) {
            ScoreItem item = iterator.next();
            long elapsed = currentTime - item.startTime;
            if (elapsed > item.displayDuration) {
                iterator.remove();
                if (!item.isComboKill) continue;
                KillIconRenderer.comboKillItem = null;
                continue;
            }
            class_2561 textComponent = item.getCachedComponent();
            int textWidth = item.getTextWidth(textRenderer);
            int textY = (int)((float)bonusBaseY + item.yOffset + item.animationOffset);
            int textX = screenWidth / 2 + this.getCurrentPosition().bonusX - textWidth / 2;
            int baseColor = -1;
            if (item.alpha < 1.0f) {
                int alpha = (int)(item.alpha * 255.0f);
                baseColor = alpha << 24 | baseColor & 0xFFFFFF;
            }
            this.textCache.add(new CachedText(textComponent, textX, textY, baseColor, bonusSizeScale));
        }
    }

    private void renderCachedTexts(class_332 drawContext, class_327 textRenderer) {
        class_4587 matrices = drawContext.method_51448();
        for (CachedText cached : this.textCache) {
            int textWidth = textRenderer.method_27525((class_5348)cached.component);
            float centerX = (float)cached.x + (float)textWidth / 2.0f;
            float f = cached.y;
            Objects.requireNonNull(textRenderer);
            float centerY = f + 9.0f / 2.0f;
            matrices.method_22903();
            matrices.method_46416(centerX, centerY, 0.0f);
            matrices.method_22905(cached.scale, cached.scale, 1.0f);
            matrices.method_46416(-centerX, -centerY, 0.0f);
            drawContext.method_51439(textRenderer, cached.component, cached.x, cached.y, cached.color, true);
            matrices.method_22909();
        }
    }

    private void adjustItemPositions() {
        float prevOffset = 0.0f;
        for (int i = 0; i < KillIconRenderer.activeScoreItems.size(); ++i) {
            ScoreItem item = KillIconRenderer.activeScoreItems.get(i);
            if (i == 0) {
                item.targetYOffset = 0.0f;
            } else {
                float expectedOffset = prevOffset + (float)Config.bonusLineSpacing;
                if (Math.abs(item.targetYOffset - expectedOffset) > 0.1f) {
                    item.targetYOffset = expectedOffset;
                }
            }
            prevOffset = item.targetYOffset;
        }
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedPositionConfig == null || currentTime - this.lastConfigCheckTime > 1000L) {
            this.cachedPositionConfig = this.createPositionConfig();
            this.lastConfigCheckTime = currentTime;
        }
        return this.cachedPositionConfig;
    }

    private static String convertToMinecraftFormat(String text) {
        int length = text.length();
        textBuilder.setLength(0);
        for (int i = 0; i < length; ++i) {
            char colorChar;
            char c = text.charAt(i);
            if (c == '[' && i + 2 < length && text.charAt(i + 2) == ']' && ScoreItemRenderer.isHexDigit(colorChar = text.charAt(i + 1))) {
                textBuilder.append('\u00a7').append(colorChar);
                i += 2;
                continue;
            }
            textBuilder.append(c);
        }
        return textBuilder.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private RenderHelper.PositionConfig createPositionConfig() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                config.subtitleX = Config.scrollSubtitleX;
                config.subtitleY = Config.scrollSubtitleY;
                config.scoreX = Config.scrollScoreX;
                config.scoreY = Config.scrollScoreY;
                config.bonusX = Config.scrollBonusX;
                config.bonusY = Config.scrollBonusY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                config.subtitleX = Config.comboSubtitleX;
                config.subtitleY = Config.comboSubtitleY;
                config.scoreX = Config.comboScoreX;
                config.scoreY = Config.comboScoreY;
                config.bonusX = Config.comboBonusX;
                config.bonusY = Config.comboBonusY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
                config.subtitleX = Config.cardSubtitleX;
                config.subtitleY = Config.cardSubtitleY;
                config.scoreX = Config.cardScoreX;
                config.scoreY = Config.cardScoreY;
                config.bonusX = Config.cardBonusX;
                config.bonusY = Config.cardBonusY;
            }
        }
        return config;
    }

    public static class ScoreItem {
        public long quickDisappearStartTime = 0L;
        public float alpha = 1.0f;
        public final String baseText;
        public float currentPoints;
        public float targetPoints;
        public long startTime;
        public float yOffset;
        public float targetYOffset;
        public long lastUpdateTime;
        public String distance;
        public boolean isLongRange;
        public long displayDuration;
        public long animationStartTime;
        public float initialPoints;
        public float animationOffset;
        public boolean isAnimating;
        public boolean isComboKill = false;
        public int comboNumber = 0;
        public int displayComboNumber = 0;
        public boolean isAnimatingCombo = false;
        private String cachedText;
        private boolean textDirty = true;
        private class_2561 cachedComponent;
        private int cachedTextWidth = -1;

        public ScoreItem(String baseText, float points, long startTime, boolean isLongRange) {
            this.baseText = baseText;
            this.currentPoints = 0.0f;
            this.targetPoints = points;
            this.initialPoints = 0.0f;
            this.startTime = startTime;
            this.lastUpdateTime = startTime;
            this.animationStartTime = startTime;
            this.distance = null;
            this.isLongRange = isLongRange;
            this.displayDuration = isLongRange ? 3000L : (long)Config.comboScoreDuration;
            this.animationOffset = 8.0f;
            this.isAnimating = true;
        }

        public String getText() {
            if (!this.textDirty && this.cachedText != null) {
                return this.cachedText;
            }
            String pointsStr = this.targetPoints < 1.0f ? String.format("%.1f", Float.valueOf(this.currentPoints)) : String.format("%.0f", Float.valueOf(this.currentPoints));
            if (this.isComboKill) {
                String displayFormat = Config.comboBonusDisplay;
                this.cachedText = displayFormat.replace("{score}", pointsStr).replace("{combo}", String.valueOf(this.comboNumber));
            } else if (this.isLongRange && this.distance != null) {
                String displayFormat = Config.longrangeBonusDisplay;
                this.cachedText = displayFormat.replace("{score}", pointsStr).replace("{distance}", this.distance);
            } else {
                String displayFormat;
                if (this.baseText.startsWith("\u51fb\u8d25\u751f\u7269")) {
                    displayFormat = Config.killBonusDisplay;
                } else if (this.baseText.startsWith("\u52a9\u653b\u51fb\u8d25")) {
                    displayFormat = Config.assistBonusDisplay;
                } else if (this.baseText.startsWith("\u66b4\u51fb\u52a0\u6210")) {
                    displayFormat = Config.criticalBonusDisplay;
                } else if (this.baseText.startsWith("\u9b54\u6cd5\u4f24\u5bb3")) {
                    displayFormat = Config.magicBonusDisplay;
                } else if (this.baseText.startsWith("\u7a7a\u624b\u653b\u51fb")) {
                    displayFormat = Config.handBonusDisplay;
                } else if (this.baseText.startsWith("\u9020\u6210\u4f24\u5bb3")) {
                    displayFormat = Config.damageBonusDisplay;
                } else {
                    this.cachedText = this.baseText + pointsStr;
                    this.textDirty = false;
                    return this.cachedText;
                }
                this.cachedText = displayFormat.replace("{score}", pointsStr);
            }
            this.textDirty = false;
            return this.cachedText;
        }

        public class_2561 getCachedComponent() {
            if (this.cachedComponent == null || this.textDirty) {
                String formattedText = ScoreItemRenderer.convertToMinecraftFormat(this.getText());
                this.cachedComponent = class_2561.method_43470((String)formattedText);
                this.cachedTextWidth = -1;
                this.textDirty = false;
            }
            return this.cachedComponent;
        }

        public int getTextWidth(class_327 textRenderer) {
            if (this.cachedTextWidth == -1) {
                this.cachedTextWidth = textRenderer.method_27525((class_5348)this.getCachedComponent());
            }
            return this.cachedTextWidth;
        }

        public void markTextDirty() {
            this.textDirty = true;
        }

        public void updateNumberAnimation(long currentTime) {
            float progress;
            long elapsed;
            boolean pointsChanged = false;
            if (Math.abs(this.currentPoints - this.targetPoints) > 0.01f) {
                elapsed = currentTime - this.animationStartTime;
                if (elapsed >= 500L) {
                    this.currentPoints = this.targetPoints;
                } else {
                    progress = (float)elapsed / 500.0f;
                    float easedProgress = progress * progress;
                    this.currentPoints = this.initialPoints + (this.targetPoints - this.initialPoints) * easedProgress;
                }
                pointsChanged = true;
            }
            if (pointsChanged) {
                this.markTextDirty();
            }
            if (this.isComboKill && this.isAnimatingCombo) {
                elapsed = currentTime - KillIconRenderer.comboKillAnimationStart;
                if (elapsed >= 500L) {
                    this.displayComboNumber = this.comboNumber;
                    this.isAnimatingCombo = false;
                    this.markTextDirty();
                } else {
                    progress = (float)elapsed / 500.0f;
                    int steps = 11;
                    int currentStep = (int)(progress * (float)steps);
                    this.displayComboNumber = (KillIconRenderer.lastComboCount + currentStep) % 10;
                    if (this.displayComboNumber == 0) {
                        this.displayComboNumber = 10;
                    }
                    this.markTextDirty();
                }
            }
        }

        public void updateEntryAnimation(long currentTime) {
            if (this.isAnimating) {
                long animElapsed = currentTime - this.animationStartTime;
                float animProgress = Math.min((float)animElapsed / 75.0f, 1.0f);
                this.animationOffset = 8.0f * (1.0f - animProgress);
                if (animProgress >= 1.0f) {
                    this.isAnimating = false;
                    this.animationOffset = 0.0f;
                }
            }
        }
    }

    private record CachedText(class_2561 component, int x, int y, int color, float scale) {
    }
}

