/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_266;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.data.ScoreboardBindingData;

public class ScoreData
extends class_18 {
    private static final String DATA_NAME = "gd656killicon_scores";
    private final ConcurrentHashMap<UUID, Integer> playerScores = new ConcurrentHashMap();
    private int cardComboKillDurationTime = 60;
    private boolean rankingListEnabled = true;
    private int scoreLimit = 1024;

    public ScoreData() {
    }

    public ScoreData(class_2487 nbt) {
        class_2499 scoreList = nbt.method_10554("scores", 10);
        for (int i = 0; i < scoreList.size(); ++i) {
            class_2487 scoreTag = scoreList.method_10602(i);
            UUID playerId = scoreTag.method_25926("playerId");
            int score = scoreTag.method_10550("score");
            this.playerScores.put(playerId, score);
        }
        this.rankingListEnabled = nbt.method_10577("rankingListEnabled");
        this.cardComboKillDurationTime = nbt.method_10550("cardComboKillDurationTime");
        if (this.cardComboKillDurationTime < 0) {
            this.cardComboKillDurationTime = 60;
        }
        this.scoreLimit = nbt.method_10550("scoreLimit");
        if (this.scoreLimit < 1) {
            this.scoreLimit = 1024;
        }
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 compound) {
        class_2499 scoreList = new class_2499();
        for (Map.Entry<UUID, Integer> entry : this.playerScores.entrySet()) {
            class_2487 scoreTag = new class_2487();
            scoreTag.method_25927("playerId", entry.getKey());
            scoreTag.method_10569("score", entry.getValue().intValue());
            scoreList.add((Object)scoreTag);
        }
        compound.method_10566("scores", (class_2520)scoreList);
        compound.method_10556("rankingListEnabled", this.rankingListEnabled);
        compound.method_10569("cardComboKillDurationTime", this.cardComboKillDurationTime);
        compound.method_10569("scoreLimit", this.scoreLimit);
        return compound;
    }

    public static ScoreData get(MinecraftServer server) {
        if (server == null) {
            return new ScoreData();
        }
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            return new ScoreData();
        }
        class_26 persistentStateManager = overworld.method_17983();
        return (ScoreData)persistentStateManager.method_17924(ScoreData::fromNbt, ScoreData::new, DATA_NAME);
    }

    private static ScoreData fromNbt(class_2487 nbt) {
        return new ScoreData(nbt);
    }

    public int getScore(UUID playerId) {
        return this.playerScores.getOrDefault(playerId, 0);
    }

    public void addScore(UUID playerId, float points, MinecraftServer server) {
        int currentScore = this.getScore(playerId);
        if (currentScore >= 0x3FFFFFFF) {
            class_3222 player;
            if (server != null && (player = server.method_3760().method_14602(playerId)) != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u60a8\u7684\u5206\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u589e\u52a0").method_27692(class_124.field_1061));
            }
            return;
        }
        int roundedPoints = Math.round(points);
        if (roundedPoints > this.scoreLimit) {
            roundedPoints = this.scoreLimit;
        }
        int finalPoints = roundedPoints;
        this.playerScores.compute(playerId, (key, current) -> {
            int newScore = (current == null ? 0 : current) + finalPoints;
            if (newScore >= 0x3FFFFFFF) {
                class_3222 player;
                newScore = 0x3FFFFFFF;
                if (server != null && (player = server.method_3760().method_14602(playerId)) != null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"[\u516d\u4e94\u516d] \u60a8\u7684\u5206\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u589e\u52a0").method_27692(class_124.field_1061));
                }
            }
            return newScore;
        });
        this.method_78(true);
        this.syncToScoreboard(playerId, server);
    }

    public void reduceScore(UUID playerId, float points, MinecraftServer server) {
        int currentScore = this.getScore(playerId);
        int roundedPoints = Math.round(points);
        int newScore = Math.max(0, currentScore - roundedPoints);
        this.playerScores.put(playerId, newScore);
        this.method_78(true);
        this.syncToScoreboard(playerId, server);
    }

    public void setScore(UUID playerId, int score, MinecraftServer server) {
        int newScore = Math.max(0, score);
        this.playerScores.put(playerId, newScore);
        this.method_78(true);
        this.syncToScoreboard(playerId, server);
    }

    public Map<UUID, Integer> getAllScores() {
        return new HashMap<UUID, Integer>(this.playerScores);
    }

    public boolean getRankingListEnabled() {
        return this.rankingListEnabled;
    }

    public void setRankingListEnabled(boolean enabled) {
        this.rankingListEnabled = enabled;
        this.method_78(true);
    }

    public int getCardComboKillDurationTime() {
        return this.cardComboKillDurationTime;
    }

    public void setCardComboKillDurationTime(int duration) {
        this.cardComboKillDurationTime = Math.max(0, Math.min(duration, 3600));
        this.method_78(true);
    }

    public void setScoreLimit(int limit) {
        this.scoreLimit = Math.max(1, Math.min(limit, 0x7FFFFFFE));
        this.method_78(true);
    }

    private void syncToScoreboard(UUID playerId, MinecraftServer server) {
        class_3222 player;
        class_2995 scoreboard;
        class_266 objective;
        ScoreboardBindingData bindingData;
        if (server != null && (bindingData = ScoreboardBindingData.get(server)).isBound() && (objective = (scoreboard = server.method_3845()).method_1165(bindingData.getObjectiveName())) != null && (player = server.method_3760().method_14602(playerId)) != null) {
            int score = this.getScore(playerId);
            scoreboard.method_1180(player.method_5820(), objective).method_1128(score);
        }
    }
}

