/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.mods.gd656killicon.network.CardComboKillDurationPacket;
import org.mods.gd656killicon.network.DamageScorePacket;
import org.mods.gd656killicon.network.KillPacket;
import org.mods.gd656killicon.network.LongRangeKillPacket;
import org.mods.gd656killicon.network.RankingDataRequestPacket;
import org.mods.gd656killicon.network.RankingDataResponsePacket;
import org.mods.gd656killicon.network.ScoreRequestPacket;
import org.mods.gd656killicon.network.ScoreSyncPacket;

public class NetworkHandler {
    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ScoreRequestPacket.ID, ScoreRequestPacket::handleServer);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RankingDataRequestPacket.ID, RankingDataRequestPacket::handleServer);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)DamageScorePacket.ID, DamageScorePacket::handleServer);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)KillPacket.ID, KillPacket::handleClient);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DamageScorePacket.ID, DamageScorePacket::handleClient);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ScoreSyncPacket.ID, ScoreSyncPacket::handleClient);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)LongRangeKillPacket.ID, LongRangeKillPacket::handleClient);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RankingDataResponsePacket.ID, RankingDataResponsePacket::handleClient);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CardComboKillDurationPacket.ID, CardComboKillDurationPacket::handleClient);
    }

    public static void sendToAllPlayers(Object packet, MinecraftServer server) {
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            NetworkHandler.sendToClient(packet, player);
        }
    }

    public static void sendToClient(Object packet, class_3222 player) {
        if (packet instanceof KillPacket) {
            KillPacket killPacket = (KillPacket)packet;
            KillPacket.sendToClient(player, killPacket.getTargetName(), killPacket.isCritical(), killPacket.shouldPlayUltimateSound(), killPacket.getKillScore(), killPacket.isAssist(), killPacket.getDamageType());
        } else if (packet instanceof DamageScorePacket) {
            DamageScorePacket damageScorePacket = (DamageScorePacket)packet;
            DamageScorePacket.sendToClient(player, damageScorePacket.getDamage(), damageScorePacket.getReason());
        } else if (packet instanceof ScoreSyncPacket) {
            ScoreSyncPacket scoreSyncPacket = (ScoreSyncPacket)packet;
            ScoreSyncPacket.sendToClient(player, scoreSyncPacket.getScore());
        } else if (packet instanceof LongRangeKillPacket) {
            LongRangeKillPacket longRangeKillPacket = (LongRangeKillPacket)packet;
            LongRangeKillPacket.sendToClient(player, longRangeKillPacket.getDistance(), longRangeKillPacket.getBonusPoints());
        } else if (packet instanceof RankingDataResponsePacket) {
            RankingDataResponsePacket rankingDataResponsePacket = (RankingDataResponsePacket)packet;
            RankingDataResponsePacket.sendToClient(player, rankingDataResponsePacket.getRankingData(), rankingDataResponsePacket.isRankingEnabled());
        } else if (packet instanceof CardComboKillDurationPacket) {
            CardComboKillDurationPacket cardComboKillDurationPacket = (CardComboKillDurationPacket)packet;
            CardComboKillDurationPacket.sendToClient(player, cardComboKillDurationPacket.getDuration());
        }
    }

    public static void sendToServer(Object packet) {
        if (packet instanceof ScoreRequestPacket) {
            ScoreRequestPacket.sendToServer();
        } else if (packet instanceof RankingDataRequestPacket) {
            RankingDataRequestPacket.sendToServer();
        }
    }
}

