/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;

public class ConfigScreen
extends Screen {
    private final Screen parent;
    private static final int BACK_BUTTON_HEIGHT = 20;
    private static final int BACK_BUTTON_WIDTH = 80;
    private static final int BACK_PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 200;
    private static final int OPTIONS_LIST_BOTTOM_OFFSET = 32;
    private static final int OPTIONS_LIST_ITEM_HEIGHT = 25;
    private static final int OPTIONS_LIST_TOP_HEIGHT = 26;
    private static final int TITLE_HEIGHT = 10;
    private static final long RESET_CONFIRMATION_TIMEOUT = 3000L;
    private static ConfigScreen instance;
    private OptionsList list;
    private Button resetButton;
    private boolean resetConfirmation = false;
    private long resetConfirmationTime = 0L;

    public ConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"gd656killicon.config.title"));
        this.parent = parent;
    }

    public static ConfigScreen getInstance() {
        return instance;
    }

    protected void m_7856_() {
        super.m_7856_();
        int listTop = 26;
        int listBottom = this.f_96544_ - 32;
        int listHeight = listBottom - listTop;
        if (this.list == null) {
            this.list = new OptionsList(this.f_96541_, this.f_96543_, listHeight, listTop, listBottom, 25);
        } else {
            this.list.m_93437_(this.f_96543_, listHeight, listTop, listBottom);
        }
        this.m_169413_();
        this.m_7787_((GuiEventListener)this.list);
        instance = this;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gd656killicon.modconfig.back"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(this.f_96543_ - 80 - 10, 10, 80, 20).m_253136_());
        int totalButtonsWidth = 410;
        int startX = (this.f_96543_ - totalButtonsWidth) / 2;
        int buttonY = this.f_96544_ - 20 - 6;
        this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"gd656killicon.config.reset"), button -> {
            if (this.resetConfirmation) {
                this.resetToDefaults();
                this.resetConfirmation = false;
                this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.config.reset"));
            } else {
                this.resetConfirmation = true;
                this.resetConfirmationTime = System.currentTimeMillis();
                this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.config.reset_confirm"));
            }
        }).m_252987_(startX, buttonY, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.resetButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.saveConfig();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(startX + 200 + 10, buttonY, 200, 20).m_253136_());
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.list != null) {
            try {
                this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Error rendering options list: {}", (Object)e.getMessage());
            }
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        if (this.resetConfirmation && System.currentTimeMillis() - this.resetConfirmationTime > 3000L) {
            this.resetConfirmation = false;
            if (this.resetButton != null) {
                this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.config.reset"));
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clickedEditBox = false;
        if (this.list != null && this.list.m_5953_(mouseX, mouseY)) {
            for (OptionsList.Entry entry : this.list.m_6702_()) {
                if (!(entry instanceof OptionsList.EditBoxOptionEntry)) continue;
                OptionsList.EditBoxOptionEntry editBoxEntry = (OptionsList.EditBoxOptionEntry)entry;
                if (!editBoxEntry.editBox.m_5953_(mouseX, mouseY)) continue;
                this.m_7522_((GuiEventListener)editBoxEntry.editBox);
                clickedEditBox = editBoxEntry.editBox.m_6375_(mouseX, mouseY, button);
                break;
            }
        }
        if (clickedEditBox) {
            return true;
        }
        this.m_7522_(null);
        if (this.list != null && this.list.m_5953_(mouseX, mouseY)) {
            return this.list.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX, double scrollY) {
        double adjustedDelta = scrollY * (Double)Config.SCROLL_SENSITIVITY.get();
        if (this.list != null && this.list.m_5953_(mouseX, mouseY)) {
            return this.list.m_6050_(mouseX, mouseY, scrollX, adjustedDelta);
        }
        return super.m_6050_(mouseX, mouseY, scrollX, adjustedDelta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.list != null && this.list.m_5953_(mouseX, mouseY)) {
            return this.list.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.list != null && this.list.m_5953_(mouseX, mouseY)) {
            return this.list.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        instance = null;
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void saveConfig() {
        Config.ASSIST_BONUS_DISPLAY.set((Object)this.list.assistBonusDisplay.getValue());
        Config.COMBO_BONUS_DISPLAY.set((Object)this.list.comboBonusDisplay.getValue());
        Config.CRITICAL_BONUS_DISPLAY.set((Object)this.list.criticalBonusDisplay.getValue());
        Config.DAMAGE_BONUS_DISPLAY.set((Object)this.list.damageBonusDisplay.getValue());
        Config.HAND_BONUS_DISPLAY.set((Object)this.list.handBonusDisplay.getValue());
        Config.KILL_BONUS_DISPLAY.set((Object)this.list.killBonusDisplay.getValue());
        Config.LONGRANGE_BONUS_DISPLAY.set((Object)this.list.longrangeBonusDisplay.getValue());
        Config.MAGIC_BONUS_DISPLAY.set((Object)this.list.magicBonusDisplay.getValue());
        Config.ASSIST_SUBTITLE_FORMAT.set((Object)this.list.assistSubtitleFormat.getValue());
        Config.COMBO_SCORE_FONT_SCALE.set((Object)this.list.comboScoreFontScale.getValue());
        Config.COMBO_TIMEOUT.set((Object)this.list.comboTimeout.getValue());
        Config.CRITICAL_COLOR.set((Object)this.list.criticalColor.getValue());
        Config.CUSTOM_SUBTITLE_FORMAT.set((Object)this.list.customSubtitleFormat.getValue());
        Config.FLASHING_COLOR.set((Object)this.list.flashingColor.getValue());
        Config.FORCE_HIDE_COUNT.set((Object)this.list.forceHideCount.getValue());
        Config.HIGH_SCORE_COLOR.set((Object)this.list.highScoreColor.getValue());
        Config.ICON_MODE.set((Object)this.list.iconMode.getValue());
        Config.ICON_STYLE.set((Object)this.list.iconStyle.getValue());
        Config.CARD_ICON_STYLE.set((Object)this.list.cardIconStyle.getValue());
        Config.KILL_ICON_DURATION.set((Object)this.list.killIconDuration.getValue());
        Config.KILL_ICON_SIZE.set((Object)this.list.killIconSize.getValue());
        Config.MAX_DISPLAY_COUNT.set((Object)this.list.maxDisplayCount.getValue());
        Config.SCROLL_ANIMATION_SPEED.set((Object)((double)this.list.scrollAnimationSpeed.getValue() / 100.0));
        Config.SCROLL_SENSITIVITY.set((Object)((double)this.list.scrollSensitivity.getValue() / 100.0));
        Config.SOUND_VOLUME.set((Object)this.list.soundVolume.getValue());
        Config.TARGET_COLOR.set((Object)this.list.targetColor.getValue());
        Config.WEAPON_COLOR.set((Object)this.list.weaponColor.getValue());
        Config.ENABLE_SOUND_EFFECTS.set((Object)this.list.enableSoundEffects.getValue());
        Config.SPEC.save();
        Config.loadConfig();
        this.resetConfirmation = false;
        this.resetButton.m_93666_((Component)Component.m_237115_((String)"gd656killicon.config.reset"));
    }

    private void resetToDefaults() {
        Config.resetAllToDefaults();
        if (this.list != null) {
            this.list.assistBonusDisplay.setValue("\u52a9\u653b\u51fb\u8d25 +{score}");
            this.list.comboBonusDisplay.setValue("[6]{combo}[f] \u8fde\u6740 ! +{score}");
            this.list.criticalBonusDisplay.setValue("\u66b4\u51fb\u52a0\u6210 +{score}");
            this.list.damageBonusDisplay.setValue("\u9020\u6210\u4f24\u5bb3 +{score}");
            this.list.handBonusDisplay.setValue("\u7a7a\u624b\u653b\u51fb +{score}");
            this.list.killBonusDisplay.setValue("\u51fb\u8d25\u751f\u7269 +{score}");
            this.list.longrangeBonusDisplay.setValue("\u8fdc\u8ddd\u79bb\u51fb\u8d25 [6]{distance}[f] +{score}");
            this.list.magicBonusDisplay.setValue("\u9b54\u6cd5\u4f24\u5bb3 +{score}");
            this.list.assistSubtitleFormat.setValue("\u4f60 \u52a9\u653b\u51fb\u8d25\u4e86 {target}");
            this.list.comboScoreFontScale.setValue(250);
            this.list.comboTimeout.setValue(3);
            this.list.criticalColor.setValue("FFD700");
            this.list.customSubtitleFormat.setValue("\u4f60 \u4f7f\u7528 {weapon} \u51fb\u8d25\u4e86 {target}");
            this.list.flashingColor.setValue("DCDCDC");
            this.list.forceHideCount.setValue(9);
            this.list.highScoreColor.setValue("FFD700");
            this.list.iconMode.setValue(Config.IconMode.SCROLLING);
            this.list.iconStyle.setValue(Config.IconStyle.MODERN);
            this.list.cardIconStyle.setValue(Config.IconStyle.MODERN);
            this.list.killIconDuration.setValue(60);
            this.list.killIconSize.setValue(32);
            this.list.maxDisplayCount.setValue(30);
            this.list.scrollAnimationSpeed.setValue(20);
            this.list.scrollSensitivity.setValue(100);
            this.list.soundVolume.setValue(100);
            this.list.targetColor.setValue("008080");
            this.list.weaponColor.setValue("008080");
            this.list.enableSoundEffects.setValue(true);
        }
    }

    class OptionsList
    extends ContainerObjectSelectionList<Entry> {
        public BooleanOptionEntry enableSoundEffects;
        public EditBoxOptionEntry assistBonusDisplay;
        public EditBoxOptionEntry assistSubtitleFormat;
        public EditBoxOptionEntry comboBonusDisplay;
        public SliderOptionEntry comboScoreFontScale;
        public SliderOptionEntry comboTimeout;
        public EditBoxOptionEntry criticalBonusDisplay;
        public EditBoxOptionEntry criticalColor;
        public EditBoxOptionEntry customSubtitleFormat;
        public EditBoxOptionEntry damageBonusDisplay;
        public EditBoxOptionEntry flashingColor;
        public SliderOptionEntry forceHideCount;
        public EditBoxOptionEntry handBonusDisplay;
        public EditBoxOptionEntry highScoreColor;
        public ModeOptionEntry iconMode;
        public IconStyleOptionEntry iconStyle;
        public IconStyleOptionEntry cardIconStyle;
        public SliderOptionEntry killIconDuration;
        public SliderOptionEntry killIconSize;
        public EditBoxOptionEntry killBonusDisplay;
        public EditBoxOptionEntry longrangeBonusDisplay;
        public EditBoxOptionEntry magicBonusDisplay;
        public SliderOptionEntry maxDisplayCount;
        public SliderOptionEntry scrollAnimationSpeed;
        public SliderOptionEntry scrollSensitivity;
        public SliderOptionEntry soundVolume;
        public EditBoxOptionEntry targetColor;
        public EditBoxOptionEntry weaponColor;

        public OptionsList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.m_93488_(false);
            this.m_7085_((AbstractSelectionList.Entry)new SpacerEntry());
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)"gd656killicon.config.category.sound")));
            this.enableSoundEffects = new BooleanOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.enableSoundEffects"), (Boolean)Config.ENABLE_SOUND_EFFECTS.get());
            this.m_7085_((AbstractSelectionList.Entry)this.enableSoundEffects);
            this.soundVolume = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.soundVolume"), 0, 125, (Integer)Config.SOUND_VOLUME.get());
            this.m_7085_((AbstractSelectionList.Entry)this.soundVolume);
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)"gd656killicon.config.category.bonus_display")));
            this.assistBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.assistBonusDisplay"), Config.assistBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.assistBonusDisplay);
            this.comboBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.comboBonusDisplay"), Config.comboBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.comboBonusDisplay);
            this.criticalBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.criticalBonusDisplay"), Config.criticalBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.criticalBonusDisplay);
            this.damageBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.damageBonusDisplay"), Config.damageBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.damageBonusDisplay);
            this.handBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.handBonusDisplay"), Config.handBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.handBonusDisplay);
            this.killBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.killBonusDisplay"), Config.killBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.killBonusDisplay);
            this.longrangeBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.longrangeBonusDisplay"), Config.longrangeBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.longrangeBonusDisplay);
            this.magicBonusDisplay = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.magicBonusDisplay"), Config.magicBonusDisplay, 200);
            this.m_7085_((AbstractSelectionList.Entry)this.magicBonusDisplay);
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)"gd656killicon.config.category.combo_score")));
            this.comboScoreFontScale = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.comboScoreFontScale"), 100, 500, (Integer)Config.COMBO_SCORE_FONT_SCALE.get());
            this.m_7085_((AbstractSelectionList.Entry)this.comboScoreFontScale);
            this.comboTimeout = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.comboTimeout"), 1, 10, (Integer)Config.COMBO_TIMEOUT.get());
            this.m_7085_((AbstractSelectionList.Entry)this.comboTimeout);
            this.scrollAnimationSpeed = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.scrollAnimationSpeed"), 10, 100, (int)((Double)Config.SCROLL_ANIMATION_SPEED.get() * 100.0));
            this.m_7085_((AbstractSelectionList.Entry)this.scrollAnimationSpeed);
            this.m_7085_((AbstractSelectionList.Entry)new SpacerEntry());
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)"gd656killicon.config.category.kill_icon")));
            this.forceHideCount = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.forceHideCount"), 3, 20, (Integer)Config.FORCE_HIDE_COUNT.get());
            this.m_7085_((AbstractSelectionList.Entry)this.forceHideCount);
            this.iconMode = new ModeOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.iconMode"), (Config.IconMode)((Object)Config.ICON_MODE.get()));
            this.m_7085_((AbstractSelectionList.Entry)this.iconMode);
            this.iconStyle = new IconStyleOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.iconStyle"), (Config.IconStyle)((Object)Config.ICON_STYLE.get()));
            this.m_7085_((AbstractSelectionList.Entry)this.iconStyle);
            this.cardIconStyle = new IconStyleOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.cardIconStyle"), (Config.IconStyle)((Object)Config.CARD_ICON_STYLE.get()));
            this.m_7085_((AbstractSelectionList.Entry)this.cardIconStyle);
            this.killIconDuration = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.killIconDuration"), 20, 200, (Integer)Config.KILL_ICON_DURATION.get());
            this.m_7085_((AbstractSelectionList.Entry)this.killIconDuration);
            this.killIconSize = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.killIconSize"), 16, 64, (Integer)Config.KILL_ICON_SIZE.get());
            this.m_7085_((AbstractSelectionList.Entry)this.killIconSize);
            this.maxDisplayCount = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.maxDisplayCount"), 5, 30, (Integer)Config.MAX_DISPLAY_COUNT.get());
            this.m_7085_((AbstractSelectionList.Entry)this.maxDisplayCount);
            this.m_7085_((AbstractSelectionList.Entry)new SpacerEntry());
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)"gd656killicon.config.category.display_control")));
            this.assistSubtitleFormat = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.assistSubtitleFormat"), (String)Config.ASSIST_SUBTITLE_FORMAT.get(), 200);
            this.m_7085_((AbstractSelectionList.Entry)this.assistSubtitleFormat);
            this.customSubtitleFormat = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.customSubtitleFormat"), (String)Config.CUSTOM_SUBTITLE_FORMAT.get(), 200);
            this.m_7085_((AbstractSelectionList.Entry)this.customSubtitleFormat);
            this.scrollSensitivity = new SliderOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.scrollSensitivity"), 10, 200, (int)((Double)Config.SCROLL_SENSITIVITY.get() * 100.0));
            this.m_7085_((AbstractSelectionList.Entry)this.scrollSensitivity);
            this.m_7085_((AbstractSelectionList.Entry)new SpacerEntry());
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)"gd656killicon.config.category.text_colors")));
            this.criticalColor = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.criticalColor"), (String)Config.CRITICAL_COLOR.get());
            this.m_7085_((AbstractSelectionList.Entry)this.criticalColor);
            this.flashingColor = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.flashingColor"), (String)Config.FLASHING_COLOR.get());
            this.m_7085_((AbstractSelectionList.Entry)this.flashingColor);
            this.highScoreColor = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.highScoreColor"), (String)Config.HIGH_SCORE_COLOR.get());
            this.m_7085_((AbstractSelectionList.Entry)this.highScoreColor);
            this.targetColor = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.targetColor"), (String)Config.TARGET_COLOR.get());
            this.m_7085_((AbstractSelectionList.Entry)this.targetColor);
            this.weaponColor = new EditBoxOptionEntry((Component)Component.m_237115_((String)"gd656killicon.config.weaponColor"), (String)Config.WEAPON_COLOR.get());
            this.m_7085_((AbstractSelectionList.Entry)this.weaponColor);
            this.m_7085_((AbstractSelectionList.Entry)new SpacerEntry());
        }

        public boolean m_6050_(double mouseX, double mouseY, double scrollX, double scrollY) {
            if (this.m_93518_() <= 0) {
                return false;
            }
            double scrollAmount = -scrollY * (Double)Config.SCROLL_SENSITIVITY.get() * (double)this.f_93387_ / 2.0;
            this.m_93410_(this.m_93517_() + scrollAmount);
            return true;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseY >= (double)this.f_93390_ && mouseY <= (double)this.f_93391_ && mouseX >= (double)this.f_93393_ && mouseX <= (double)(this.f_93393_ + this.f_93388_);
        }

        static class SpacerEntry
        extends Entry {
            SpacerEntry() {
            }

            public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of();
            }
        }

        class CategoryEntry
        extends Entry {
            private final Component text;

            public CategoryEntry(Component text) {
                this.text = text;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280653_(ConfigScreen.this.f_96547_, this.text, left + width / 2, top + 5, 0xFFFFFF);
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of();
            }
        }

        class BooleanOptionEntry
        extends Entry {
            private final Checkbox checkbox;
            private final Component label;

            public BooleanOptionEntry(Component label, boolean initialValue) {
                this.label = label;
                this.checkbox = new Checkbox(0, 0, 20, 20, (Component)Component.m_237119_(), initialValue);
            }

            public void setValue(boolean value) {
                if (this.checkbox.m_93840_() != value) {
                    this.checkbox.m_5691_();
                }
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(ConfigScreen.this.f_96547_, this.label, left, top + 5, 0xFFFFFF);
                this.checkbox.m_252865_(left + width - 150);
                this.checkbox.m_253211_(top);
                this.checkbox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean getValue() {
                return this.checkbox.m_93840_();
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.checkbox);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.checkbox);
            }
        }

        class SliderOptionEntry
        extends Entry {
            private final Component label;
            private final CustomSlider slider;

            public SliderOptionEntry(Component label, int min, int max, int initialValue) {
                this.label = label;
                this.slider = new CustomSlider(0, 0, 150, 20, (Component)Component.m_237119_(), (double)(initialValue - min) / (double)(max - min), min, max);
            }

            public void setValue(int value) {
                this.slider.setIntValue(value);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(ConfigScreen.this.f_96547_, this.label, left, top + 5, 0xFFFFFF);
                this.slider.m_252865_(left + width - 150);
                this.slider.m_253211_(top);
                this.slider.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public int getValue() {
                return this.slider.getIntValue();
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.slider);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.slider);
            }

            static class CustomSlider
            extends AbstractSliderButton {
                private final int max;
                private final int min;

                public CustomSlider(int x, int y, int width, int height, Component message, double value, int min, int max) {
                    super(x, y, width, height, message, value);
                    this.min = min;
                    this.max = max;
                    this.m_5695_();
                }

                protected void m_5695_() {
                    this.m_93666_((Component)Component.m_237113_((String)(this.getIntValue() + "%")));
                }

                protected void m_5697_() {
                }

                public int getIntValue() {
                    return this.min + (int)(this.f_93577_ * (double)(this.max - this.min));
                }

                public void setIntValue(int value) {
                    this.f_93577_ = Mth.m_14008_((double)((double)(value - this.min) / (double)(this.max - this.min)), (double)0.0, (double)1.0);
                    this.m_5695_();
                }
            }
        }

        class EditBoxOptionEntry
        extends Entry {
            private final EditBox editBox;
            private final boolean isColorOption;
            private final Component label;

            public EditBoxOptionEntry(Component label, String initialValue) {
                this(label, initialValue, 100, true);
            }

            public EditBoxOptionEntry(Component label, String initialValue, int width) {
                this(label, initialValue, width, false);
            }

            public EditBoxOptionEntry(Component label, String initialValue, int width, boolean isColorOption) {
                this.label = label;
                this.isColorOption = isColorOption;
                this.editBox = new EditBox(ConfigScreen.this.f_96547_, 0, 0, width, 20, (Component)Component.m_237119_());
                this.editBox.m_94144_(initialValue);
                this.editBox.m_94199_(isColorOption ? 6 : 256);
                this.editBox.m_93692_(true);
                this.editBox.m_94190_(true);
            }

            public void setValue(String value) {
                this.editBox.m_94144_(value);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(ConfigScreen.this.f_96547_, this.label, left, top + 5, 0xFFFFFF);
                if (this.isColorOption) {
                    int colorValue;
                    this.editBox.m_252865_(left + width - 150 + 75);
                    this.editBox.m_253211_(top);
                    this.editBox.m_93674_(75);
                    this.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                    int colorBoxX = left + width - 150 + 130;
                    int colorBoxSize = 20;
                    String colorText = this.editBox.m_94155_();
                    try {
                        String colorStr = "FF" + colorText.replace("#", "");
                        colorValue = (int)Long.parseLong(colorStr, 16);
                    }
                    catch (Exception e) {
                        colorValue = -1;
                    }
                    guiGraphics.m_280509_(colorBoxX, top, colorBoxX + colorBoxSize, top + colorBoxSize, colorValue);
                    guiGraphics.m_280509_(colorBoxX, top, colorBoxX + 1, top + colorBoxSize, -16777216);
                    guiGraphics.m_280509_(colorBoxX + colorBoxSize - 1, top, colorBoxX + colorBoxSize, top + colorBoxSize, -16777216);
                    guiGraphics.m_280509_(colorBoxX, top, colorBoxX + colorBoxSize, top + 1, -16777216);
                    guiGraphics.m_280509_(colorBoxX, top + colorBoxSize - 1, colorBoxX + colorBoxSize, top + colorBoxSize, -16777216);
                } else {
                    this.editBox.m_252865_(left + width - 150 + 50);
                    this.editBox.m_253211_(top);
                    this.editBox.m_93674_(100);
                    this.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            public String getValue() {
                return this.editBox.m_94155_();
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.editBox);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.editBox);
            }
        }

        class ModeOptionEntry
        extends Entry {
            private final Component label;
            private final CycleButton<Config.IconMode> modeButton;

            public ModeOptionEntry(Component label, Config.IconMode initialValue) {
                this.label = label;
                this.modeButton = CycleButton.m_168894_(mode -> Component.m_237115_((String)mode.getTranslationKey())).m_168961_((Object[])Config.IconMode.values()).m_168948_((Object)initialValue).m_168936_(0, 0, 150, 20, (Component)Component.m_237119_(), (button, mode) -> Component.m_237115_((String)mode.getTranslationKey()));
            }

            public void setValue(Config.IconMode value) {
                this.modeButton.m_168892_((Object)value);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(ConfigScreen.this.f_96547_, this.label, left, top + 5, 0xFFFFFF);
                this.modeButton.m_252865_(left + width - 150);
                this.modeButton.m_253211_(top);
                this.modeButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconMode getValue() {
                return (Config.IconMode)((Object)this.modeButton.m_168883_());
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.modeButton);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.modeButton);
            }
        }

        class IconStyleOptionEntry
        extends Entry {
            private final Component label;
            private final CycleButton<Config.IconStyle> styleButton;

            public IconStyleOptionEntry(Component label, Config.IconStyle initialValue) {
                this.label = label;
                this.styleButton = CycleButton.m_168894_(style -> Component.m_237115_((String)style.getTranslationKey())).m_168961_((Object[])Config.IconStyle.values()).m_168948_((Object)initialValue).m_168936_(0, 0, 150, 20, (Component)Component.m_237119_(), (button, style) -> Component.m_237115_((String)style.getTranslationKey()));
            }

            public void setValue(Config.IconStyle value) {
                this.styleButton.m_168892_((Object)value);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(ConfigScreen.this.f_96547_, this.label, left, top + 5, 0xFFFFFF);
                this.styleButton.m_252865_(left + width - 150);
                this.styleButton.m_253211_(top);
                this.styleButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconStyle getValue() {
                return (Config.IconStyle)((Object)this.styleButton.m_168883_());
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.styleButton);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.styleButton);
            }
        }

        static abstract class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            Entry() {
            }
        }
    }
}

