/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.client.configmodules.BonusConfigModule;
import org.mods.gd656killicon.client.configmodules.CardIconConfigModule;
import org.mods.gd656killicon.client.configmodules.ComboKillIconConfigModule;
import org.mods.gd656killicon.client.configmodules.KillIconConfigModule;
import org.mods.gd656killicon.client.configmodules.ScoreConfigModule;
import org.mods.gd656killicon.client.configmodules.SubtitleConfigModule;

public class ElementConfigScreen
extends Screen {
    private final Screen parent;
    private final ModConfigScreen.DraggableElement element;
    private OptionsList list;
    public OptionsList.BooleanOptionEntry elementVisible;
    public OptionsList.SliderOptionEntry elementSize;
    private KillIconConfigModule killIconConfigModule;
    private SubtitleConfigModule subtitleConfigModule;
    private ScoreConfigModule scoreConfigModule;
    private BonusConfigModule bonusConfigModule;
    private CardIconConfigModule cardIconConfigModule;
    private ComboKillIconConfigModule comboKillIconConfigModule;
    private static final int ITEM_HEIGHT = 15;
    private static final int SLIDER_WIDTH = 100;
    private static final int SLIDER_HEIGHT = 20;

    public ElementConfigScreen(Screen parent, ModConfigScreen.DraggableElement element) {
        super((Component)Component.m_237115_((String)"gd656killicon.elementconfig.title"));
        this.parent = parent;
        this.element = element;
    }

    protected void m_7856_() {
        super.m_7856_();
        int listTop = 32;
        int listBottom = this.f_96544_ - 64;
        int listHeight = listBottom - listTop;
        this.list = new OptionsList(this.f_96541_, this.f_96543_, listHeight, listTop, 15);
        this.m_7787_((GuiEventListener)this.list);
        this.list.addEntryPublic(new OptionsList.CategoryEntry((Component)Component.m_237113_((String)("\u5143\u7d20\u914d\u7f6e: " + this.element.name))));
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        int minSize = 16;
        int maxSize = 500;
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            maxSize = 96;
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            minSize = 50;
            maxSize = 200;
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            minSize = 100;
        }
        this.elementSize = new OptionsList.SliderOptionEntry((Component)Component.m_237113_((String)"\u5143\u7d20\u5927\u5c0f"), minSize, maxSize, this.getCurrentElementSize(this.element.type));
        this.list.addEntryPublic(this.elementSize);
        this.list.addEntryPublic(new OptionsList.SpacerEntry());
        this.elementVisible = new OptionsList.BooleanOptionEntry((Component)Component.m_237113_((String)"\u6e38\u620f\u4e2d\u663e\u793a"), this.getCurrentElementVisible(this.element.type));
        this.list.addEntryPublic(this.elementVisible);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            this.addPrivateConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SUBTITLE) {
            this.addSubtitleConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.SCORE) {
            this.addScoreConfigOptions();
        } else if (this.element.type == ModConfigScreen.ElementType.BONUS) {
            this.addBonusConfigOptions();
        }
        int buttonWidth = 100;
        int buttonSpacing = 10;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int startX = (this.f_96543_ - totalWidth) / 2;
        int buttonY = this.f_96544_ - 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.saveConfig();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(startX, buttonY, buttonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(startX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).m_253136_());
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            String sharedText = switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> "\u6eda\u52a8\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
                case Config.IconMode.COMBO -> "\u8fde\u6740\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
                case Config.IconMode.CARD -> "\u5361\u724c\u6a21\u5f0f\u4e13\u7528\u914d\u7f6e";
            };
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280056_(this.f_96547_, sharedText, 10, this.f_96544_ - 9 - 10, 0x888888, true);
        }
        if (this.element.type == ModConfigScreen.ElementType.SUBTITLE || this.element.type == ModConfigScreen.ElementType.SCORE || this.element.type == ModConfigScreen.ElementType.BONUS) {
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280056_(this.f_96547_, "\u4e09\u6a21\u5f0f\u5171\u7528", 10, this.f_96544_ - 9 - 10, 0x888888, true);
        }
        if (this.list != null) {
            this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void addPrivateConfigOptions() {
        if (this.element.type == ModConfigScreen.ElementType.ICON) {
            switch (Config.iconMode) {
                case CARD: {
                    this.cardIconConfigModule = new CardIconConfigModule(this.list);
                    this.cardIconConfigModule.addConfigOptions();
                    break;
                }
                case COMBO: {
                    this.comboKillIconConfigModule = new ComboKillIconConfigModule(this.list);
                    this.comboKillIconConfigModule.addConfigOptions();
                    break;
                }
                default: {
                    this.killIconConfigModule = new KillIconConfigModule(this.list);
                    this.killIconConfigModule.addConfigOptions();
                }
            }
        }
    }

    private void addSubtitleConfigOptions() {
        this.subtitleConfigModule = new SubtitleConfigModule(this.list);
        this.subtitleConfigModule.addConfigOptions();
    }

    private void addScoreConfigOptions() {
        this.scoreConfigModule = new ScoreConfigModule(this.list);
        this.scoreConfigModule.addConfigOptions();
    }

    private void addBonusConfigOptions() {
        this.bonusConfigModule = new BonusConfigModule(this.list);
        this.bonusConfigModule.addConfigOptions();
    }

    private int getCurrentElementSize(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconSize;
                case Config.IconMode.COMBO -> Config.comboIconSize;
                case Config.IconMode.CARD -> Config.cardIconSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleSize;
                case Config.IconMode.COMBO -> Config.comboSubtitleSize;
                case Config.IconMode.CARD -> Config.cardSubtitleSize;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreSize;
                case Config.IconMode.COMBO -> Config.comboScoreSize;
                case Config.IconMode.CARD -> Config.cardScoreSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusSize;
                case Config.IconMode.COMBO -> Config.comboBonusSize;
                case Config.IconMode.CARD -> Config.cardBonusSize;
            };
        }
        if (type == ModConfigScreen.ElementType.BOTTOMBAR) {
            return Config.cardBottombarSize;
        }
        return 100;
    }

    private boolean getCurrentElementVisible(ModConfigScreen.ElementType type) {
        if (type == ModConfigScreen.ElementType.ICON) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollIconVisible;
                case Config.IconMode.COMBO -> Config.comboIconVisible;
                case Config.IconMode.CARD -> Config.cardIconVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SUBTITLE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollSubtitleVisible;
                case Config.IconMode.COMBO -> Config.comboSubtitleVisible;
                case Config.IconMode.CARD -> Config.cardSubtitleVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.SCORE) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollScoreVisible;
                case Config.IconMode.COMBO -> Config.comboScoreVisible;
                case Config.IconMode.CARD -> Config.cardScoreVisible;
            };
        }
        if (type == ModConfigScreen.ElementType.BONUS) {
            return switch (Config.iconMode) {
                default -> throw new IncompatibleClassChangeError();
                case Config.IconMode.SCROLLING -> Config.scrollBonusVisible;
                case Config.IconMode.COMBO -> Config.comboBonusVisible;
                case Config.IconMode.CARD -> Config.cardBonusVisible;
            };
        }
        return true;
    }

    private void saveConfig() {
        int newSize = this.elementSize.getValue();
        boolean newVisible = this.elementVisible.getValue();
        switch (this.element.type) {
            case ICON: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_ICON_SIZE.set((Object)newSize);
                        Config.SCROLL_ICON_VISIBLE.set((Object)newVisible);
                        if (this.killIconConfigModule == null) break;
                        this.killIconConfigModule.saveConfig();
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_ICON_SIZE.set((Object)newSize);
                        Config.COMBO_ICON_VISIBLE.set((Object)newVisible);
                        if (this.comboKillIconConfigModule == null) break;
                        this.comboKillIconConfigModule.saveConfig();
                        break;
                    }
                    case CARD: {
                        Config.CARD_ICON_SIZE.set((Object)newSize);
                        Config.CARD_ICON_VISIBLE.set((Object)newVisible);
                        if (this.cardIconConfigModule == null) break;
                        this.cardIconConfigModule.saveConfig();
                        if (this.cardIconConfigModule.bottombarVisibleEntry == null || this.cardIconConfigModule.bottombarSizeEntry == null) break;
                        Config.CARD_BOTTOMBAR_VISIBLE.set((Object)this.cardIconConfigModule.bottombarVisibleEntry.getValue());
                        Config.CARD_BOTTOMBAR_SIZE.set((Object)this.cardIconConfigModule.bottombarSizeEntry.getValue());
                    }
                }
                break;
            }
            case SUBTITLE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_SUBTITLE_SIZE.set((Object)newSize);
                        Config.SCROLL_SUBTITLE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_SUBTITLE_SIZE.set((Object)newSize);
                        Config.COMBO_SUBTITLE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_SUBTITLE_SIZE.set((Object)newSize);
                        Config.CARD_SUBTITLE_VISIBLE.set((Object)newVisible);
                    }
                }
                if (this.subtitleConfigModule == null) break;
                this.subtitleConfigModule.saveConfig();
                break;
            }
            case SCORE: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_SCORE_SIZE.set((Object)newSize);
                        Config.SCROLL_SCORE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_SCORE_SIZE.set((Object)newSize);
                        Config.COMBO_SCORE_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_SCORE_SIZE.set((Object)newSize);
                        Config.CARD_SCORE_VISIBLE.set((Object)newVisible);
                    }
                }
                if (this.scoreConfigModule == null) break;
                this.scoreConfigModule.saveConfig();
                break;
            }
            case BONUS: {
                switch (Config.iconMode) {
                    case SCROLLING: {
                        Config.SCROLL_BONUS_SIZE.set((Object)newSize);
                        Config.SCROLL_BONUS_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case COMBO: {
                        Config.COMBO_BONUS_SIZE.set((Object)newSize);
                        Config.COMBO_BONUS_VISIBLE.set((Object)newVisible);
                        break;
                    }
                    case CARD: {
                        Config.CARD_BONUS_SIZE.set((Object)newSize);
                        Config.CARD_BONUS_VISIBLE.set((Object)newVisible);
                    }
                }
                if (this.bonusConfigModule == null) break;
                this.bonusConfigModule.saveConfig();
            }
        }
        Config.SPEC.save();
        Config.loadConfig();
        if (this.parent instanceof ModConfigScreen) {
            ((ModConfigScreen)this.parent).updateElementSizes();
        }
    }

    public static class OptionsList
    extends ContainerObjectSelectionList<Entry> {
        public OptionsList(Minecraft minecraft, int width, int height, int y0, int itemHeight) {
            super(minecraft, width, height, y0, y0 + height, itemHeight);
            this.m_93488_(false);
        }

        public void addEntryPublic(Entry entry) {
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public static class EditBoxOptionEntry
        extends Entry {
            private final EditBox editBox;
            private final Component label;
            private final boolean isColorOption;

            public EditBoxOptionEntry(Component label, String initialValue, int width) {
                this(label, initialValue, width, false);
            }

            public EditBoxOptionEntry(Component label, String initialValue, int width, boolean isColorOption) {
                this.label = label;
                this.isColorOption = isColorOption;
                this.editBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, width, 20, (Component)Component.m_237119_());
                this.editBox.m_94144_(initialValue);
                this.editBox.m_94199_(isColorOption ? 6 : 256);
                this.editBox.m_93692_(true);
                this.editBox.m_94190_(true);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.label, left + 10, top + 5, 0xFFFFFF);
                if (this.isColorOption) {
                    int colorValue;
                    this.editBox.m_252865_(left + width - 150 + 75);
                    this.editBox.m_253211_(top + -2);
                    this.editBox.m_93674_(75);
                    this.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                    int colorBoxX = left + width - 150 + 130;
                    int colorBoxSize = 20;
                    int colorBoxY = top + -2;
                    String colorText = this.editBox.m_94155_();
                    try {
                        String colorStr = "FF" + colorText.replace("#", "");
                        colorValue = (int)Long.parseLong(colorStr, 16);
                    }
                    catch (Exception e) {
                        colorValue = -1;
                    }
                    guiGraphics.m_280509_(colorBoxX, colorBoxY, colorBoxX + colorBoxSize, colorBoxY + colorBoxSize, colorValue);
                    guiGraphics.m_280637_(colorBoxX, colorBoxY, colorBoxSize, colorBoxSize, -16777216);
                } else {
                    this.editBox.m_252865_(left + width - 150 + 50);
                    this.editBox.m_253211_(top + -2);
                    this.editBox.m_93674_(100);
                    this.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            public String getValue() {
                return this.editBox.m_94155_();
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.editBox);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.editBox);
            }
        }

        public static class IconStyleOptionEntry
        extends Entry {
            private final CycleButton<Config.IconStyle> styleButton;
            private final Component label;

            public IconStyleOptionEntry(Component label, Config.IconStyle initialValue) {
                this.label = label;
                this.styleButton = CycleButton.m_168894_(style -> Component.m_237115_((String)style.getTranslationKey())).m_168961_((Object[])Config.IconStyle.values()).m_168948_((Object)initialValue).m_168936_(0, 0, 100, 20, (Component)Component.m_237119_(), (button, style) -> Component.m_237115_((String)style.getTranslationKey()));
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.label, left + 10, top + 5, 0xFFFFFF);
                this.styleButton.m_252865_(left + width - 100 - 10);
                this.styleButton.m_253211_(top + -2);
                this.styleButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public Config.IconStyle getValue() {
                return (Config.IconStyle)((Object)this.styleButton.m_168883_());
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.styleButton);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.styleButton);
            }
        }

        public static class SliderOptionEntry
        extends Entry {
            private final CustomSlider slider;
            private final Component label;

            public SliderOptionEntry(Component label, int min, int max, int initialValue) {
                this.label = label;
                this.slider = new CustomSlider(0, 0, 100, 20, (Component)Component.m_237119_(), (double)(initialValue - min) / (double)(max - min), min, max);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.label, left + 10, top + 5, 0xFFFFFF);
                this.slider.m_252865_(left + width - 100 - 10);
                this.slider.m_253211_(top + -2);
                this.slider.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public int getValue() {
                return this.slider.getIntValue();
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.slider);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.slider);
            }

            public static class CustomSlider
            extends AbstractSliderButton {
                private final int min;
                private final int max;

                public CustomSlider(int x, int y, int width, int height, Component message, double value, int min, int max) {
                    super(x, y, width, height, message, value);
                    this.min = min;
                    this.max = max;
                    this.m_5695_();
                }

                protected void m_5695_() {
                    this.m_93666_((Component)Component.m_237113_((String)String.valueOf(this.getIntValue())));
                }

                protected void m_5697_() {
                }

                public int getIntValue() {
                    return this.min + (int)(this.f_93577_ * (double)(this.max - this.min));
                }
            }
        }

        public static class BooleanOptionEntry
        extends Entry {
            private final Checkbox checkbox;
            private final Component label;

            public BooleanOptionEntry(Component label, boolean initialValue) {
                this.label = label;
                this.checkbox = new Checkbox(0, 0, 20, 20, (Component)Component.m_237119_(), initialValue);
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.label, left + 10, top + 5, 0xFFFFFF);
                this.checkbox.m_252865_(left + width - 30);
                this.checkbox.m_253211_(top);
                this.checkbox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean getValue() {
                return this.checkbox.m_93840_();
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of(this.checkbox);
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of(this.checkbox);
            }
        }

        public static class CategoryEntry
        extends Entry {
            private final Component text;

            public CategoryEntry(Component text) {
                this.text = text;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.text, left + width / 2, top + 5, 0xFFFFFF);
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of();
            }
        }

        public static class SpacerEntry
        extends Entry {
            public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            }

            @NotNull
            public List<AbstractWidget> m_6702_() {
                return List.of();
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return List.of();
            }
        }

        public static abstract class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
        }
    }
}

