/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ScoreExpressionManager
extends SavedData {
    private static final String DATA_NAME = "gd656killicon_score_expressions";
    private static final Map<String, String> expressions = new HashMap<String, String>();

    public ScoreExpressionManager() {
        this.resetToDefaults();
    }

    public ScoreExpressionManager(CompoundTag nbt) {
        CompoundTag expressionsTag = nbt.m_128469_("expressions");
        for (String key : expressionsTag.m_128431_()) {
            expressions.put(key, expressionsTag.m_128461_(key));
        }
        if (expressions.isEmpty()) {
            this.resetToDefaults();
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        CompoundTag expressionsTag = new CompoundTag();
        for (Map.Entry<String, String> entry : expressions.entrySet()) {
            expressionsTag.m_128359_(entry.getKey(), entry.getValue());
        }
        compound.m_128365_("expressions", (Tag)expressionsTag);
        return compound;
    }

    public static ScoreExpressionManager get() {
        ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (overworld == null) {
            return new ScoreExpressionManager();
        }
        return (ScoreExpressionManager)overworld.m_8895_().m_164861_(new SavedData.Factory(ScoreExpressionManager::new, ScoreExpressionManager::new, null), DATA_NAME);
    }

    public void resetToDefaults() {
        expressions.clear();
        expressions.put("kill", "health * 5");
        expressions.put("critical", "killscore * 0.25");
        expressions.put("longrange", "distance");
        expressions.put("damage", "damage");
        expressions.put("magic", "damage");
        expressions.put("hand", "damage");
        expressions.put("assist", "damagedealt * 5");
        expressions.put("combobonus", "combo * 8");
        this.m_77762_();
    }

    public static String getExpression(String scoreType) {
        return expressions.getOrDefault(scoreType, "");
    }

    public void setExpression(String scoreType, String expression) {
        expressions.put(scoreType, expression);
        this.m_77762_();
    }

    public Map<String, String> getAllExpressions() {
        return new HashMap<String, String>(expressions);
    }
}

