/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.configmenu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.RankingDataRequestPacket;

public class RankingListScreen
extends Screen {
    private final Screen parent;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int PADDING = 10;
    private static final int ROWS_PER_PAGE = 32;
    private static final int TITLE_HEIGHT = 30;
    private static RankingListScreen instance;
    private Button nextPageButton;
    private Button prevPageButton;
    private int currentPage = 0;
    private boolean hasData = false;
    private boolean isLoading = true;
    private final boolean isInGame;
    private boolean rankingEnabled = true;
    private int totalPages = 0;
    private int currentMouseX;
    private int currentMouseY;
    private int rowHeight;
    private int tableHeight;
    private int tableWidth;
    private int tableX;
    private int tableY;
    private final List<RankingEntry> rankingEntries = new ArrayList<RankingEntry>();

    public RankingListScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"\u51fb\u6740\u56fe\u6807\u6392\u884c\u699c"));
        this.parent = parent;
        instance = this;
        this.isInGame = Minecraft.m_91087_().f_91074_ != null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tableWidth = this.f_96543_ - 20;
        this.tableHeight = this.f_96544_ - 30 - 20 - 30;
        this.tableX = 10;
        this.tableY = 40;
        this.rowHeight = 18;
        this.initButtons();
        this.loadRankingData();
    }

    public void m_7379_() {
        instance = null;
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        if (!this.isInGame) {
            guiGraphics.m_280137_(this.f_96547_, "\u8bf7\u5728\u6e38\u620f\u5185\u67e5\u770b\u6392\u884c\u699c", this.f_96543_ / 2, this.f_96544_ / 2, 0xFF5555);
        } else if (this.isLoading) {
            guiGraphics.m_280137_(this.f_96547_, "\u6b63\u5728\u52a0\u8f7d\u6392\u884c\u699c\u6570\u636e...", this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
        } else if (!this.rankingEnabled) {
            guiGraphics.m_280137_(this.f_96547_, "\u699c\u5355\u5df2\u88ab\u7ba1\u7406\u5458\u5173\u95ed", this.f_96543_ / 2, this.f_96544_ / 2, 0xFF5555);
        } else if (!this.hasData) {
            guiGraphics.m_280137_(this.f_96547_, "\u6682\u65e0\u6570\u636e", this.f_96543_ / 2, this.f_96544_ / 2, 0x888888);
        } else {
            String pageInfo = "\u7b2c " + (this.currentPage + 1) + " \u9875 / \u5171 " + this.totalPages + " \u9875";
            guiGraphics.m_280056_(this.f_96547_, pageInfo, this.f_96543_ / 2 - this.f_96547_.m_92895_(pageInfo) / 2, 20, 0xCCCCCC, true);
            this.renderRankingTable(guiGraphics);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public static RankingListScreen getInstance() {
        return instance;
    }

    public void updateRankingData(Map<UUID, Integer> serverRankingData, boolean rankingEnabled) {
        this.rankingEntries.clear();
        this.rankingEnabled = rankingEnabled;
        if (!rankingEnabled) {
            this.hasData = false;
            this.isLoading = false;
            this.updateButtonStates();
            return;
        }
        if (serverRankingData != null && !serverRankingData.isEmpty()) {
            ArrayList<Map.Entry<UUID, Integer>> sortedEntries = new ArrayList<Map.Entry<UUID, Integer>>(serverRankingData.entrySet());
            sortedEntries.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
            int rank = 1;
            for (Map.Entry entry : sortedEntries) {
                this.rankingEntries.add(new RankingEntry(rank, this.getPlayerName((UUID)entry.getKey()), (UUID)entry.getKey(), (Integer)entry.getValue()));
                ++rank;
            }
            this.hasData = true;
        } else {
            this.hasData = false;
        }
        this.totalPages = this.hasData ? (int)Math.ceil((double)this.rankingEntries.size() / 32.0) : 0;
        this.isLoading = false;
        this.updateButtonStates();
    }

    private void initButtons() {
        int bottomY = this.f_96544_ - 20 - 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u8fd4\u56de"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 30, bottomY, 60, 20).m_253136_());
        this.nextPageButton = Button.m_253074_((Component)Component.m_237113_((String)"\u4e0b\u4e00\u9875"), button -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
                this.updateButtonStates();
            }
        }).m_252987_(this.f_96543_ - 60 - 10, bottomY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.prevPageButton = Button.m_253074_((Component)Component.m_237113_((String)"\u4e0a\u4e00\u9875"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.updateButtonStates();
            }
        }).m_252987_(10, bottomY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.updateButtonStates();
    }

    private boolean isMouseOverRow(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.tableX && mouseX <= this.tableX + this.tableWidth && mouseY >= rowY && mouseY <= rowY + this.rowHeight;
    }

    private void loadRankingData() {
        this.isLoading = true;
        this.hasData = false;
        this.rankingEnabled = true;
        if (this.isInGame) {
            NetworkHandler.sendToServer(new RankingDataRequestPacket());
        } else {
            this.isLoading = false;
        }
    }

    private void renderRankingTable(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + this.tableHeight, Integer.MIN_VALUE);
        this.renderTableHeader(guiGraphics);
        this.renderTableRows(guiGraphics);
    }

    private void renderRowData(GuiGraphics guiGraphics, RankingEntry entry, int rowY) {
        Objects.requireNonNull(this.f_96547_);
        int textY = rowY + (this.rowHeight - 9) / 2;
        guiGraphics.m_280056_(this.f_96547_, String.valueOf(entry.rank), this.tableX + 10, textY, this.getRankColor(entry.rank), true);
        guiGraphics.m_280056_(this.f_96547_, entry.playerName, this.tableX + 80, textY, 0xFFFFFF, true);
        guiGraphics.m_280056_(this.f_96547_, String.format("%,d", entry.score), this.tableX + 290, textY, 0xFFFFFF, true);
    }

    private void renderTableHeader(GuiGraphics guiGraphics) {
        int headerY = this.tableY + 5;
        guiGraphics.m_280509_(this.tableX, this.tableY, this.tableX + this.tableWidth, this.tableY + 25, -2143009724);
        guiGraphics.m_280509_(this.tableX, this.tableY + 25, this.tableX + this.tableWidth, this.tableY + 26, -10066330);
        guiGraphics.m_280056_(this.f_96547_, "\u6392\u540d", this.tableX + 10, headerY, 0xFFFFFF, true);
        guiGraphics.m_280056_(this.f_96547_, "\u73a9\u5bb6\u540d\u79f0", this.tableX + 80, headerY, 0xFFFFFF, true);
        guiGraphics.m_280056_(this.f_96547_, "\u5206\u6570", this.tableX + 290, headerY, 0xFFFFFF, true);
        guiGraphics.m_280509_(this.tableX + 70, this.tableY, this.tableX + 71, this.tableY + this.tableHeight, -10066330);
        guiGraphics.m_280509_(this.tableX + 280, this.tableY, this.tableX + 281, this.tableY + this.tableHeight, -10066330);
    }

    private void renderTableRows(GuiGraphics guiGraphics) {
        int startIndex = this.currentPage * 32;
        int endIndex = Math.min(startIndex + 32, this.rankingEntries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            RankingEntry entry = this.rankingEntries.get(i);
            int rowY = this.tableY + 30 + (i - startIndex) * this.rowHeight;
            if ((i - startIndex) % 2 == 0) {
                guiGraphics.m_280509_(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40202020);
            }
            if (this.isMouseOverRow(this.currentMouseX, this.currentMouseY, rowY)) {
                guiGraphics.m_280509_(this.tableX, rowY, this.tableX + this.tableWidth, rowY + this.rowHeight, 0x40666666);
            }
            guiGraphics.m_280509_(this.tableX, rowY + this.rowHeight, this.tableX + this.tableWidth, rowY + this.rowHeight + 1, 0x40444444);
            this.renderRowData(guiGraphics, entry, rowY);
        }
    }

    private void updateButtonStates() {
        this.prevPageButton.f_93623_ = this.currentPage > 0 && this.hasData && this.rankingEnabled;
        this.nextPageButton.f_93623_ = this.currentPage < this.totalPages - 1 && this.hasData && this.rankingEnabled;
    }

    private String getPlayerName(UUID playerId) {
        try {
            Player player;
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (player = this.f_96541_.f_91073_.m_46003_(playerId)) != null) {
                return player.m_36316_().getName();
            }
            return "\u73a9\u5bb6_" + playerId.toString().substring(0, 8);
        }
        catch (Exception e) {
            return "\u672a\u77e5\u73a9\u5bb6";
        }
    }

    private int getRankColor(int rank) {
        return switch (rank) {
            case 1 -> -10496;
            case 2 -> -4144960;
            case 3 -> -3309774;
            default -> -1;
        };
    }

    private record RankingEntry(int rank, String playerName, UUID playerId, int score) {
    }
}

