/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client.iconrenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.RenderHelper;
import org.mods.gd656killicon.client.iconrenderer.ComboIconRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ScrollingIconRenderer {
    private static ResourceLocation VANALLA_KILL_ICON;
    private static ResourceLocation VANALLA_ULTIMATE_ICON;
    private static ResourceLocation VANALLA_ASSIST_ICON;

    public void handleScrollingMode(String weaponName, String targetName, boolean isCritical, boolean playUltimateSound, boolean isAssist) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int iconSize = ScrollingIconRenderer.getCurrentIconSize();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        float targetX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float targetY = screenHeight + pos.iconY;
        KillIconInstance newIcon = new KillIconInstance(System.currentTimeMillis(), targetX - (float)iconSize / 2.0f, targetY, isCritical);
        newIcon.isAssist = isAssist;
        newIcon.prevX = targetX - (float)iconSize / 2.0f;
        newIcon.currentX = targetX - (float)iconSize / 2.0f;
        newIcon.targetX = targetX - (float)iconSize / 2.0f;
        KillIconRenderer.latestIsCritical = isCritical;
        if (Config.enableSoundEffects) {
            float volume = (float)Config.soundVolume / 100.0f;
            SoundEvent sound = isAssist ? ScrollingIconRenderer.getAssistKillSound() : ScrollingIconRenderer.getKillSound(playUltimateSound);
            Gd656killicon.playSoundWithCooldown(sound, volume);
        }
        KillIconRenderer.activeIcons.add(newIcon);
        KillIconRenderer.textAnimationStartTime = System.currentTimeMillis();
        KillIconRenderer.textHideTime = 0L;
        if (KillIconRenderer.activeIcons.size() > Config.forceHideCount) {
            this.startFadeOutSequence(System.currentTimeMillis());
        }
        this.checkMaxDisplayCount();
        this.updateAllIconTargetPositions();
        KillIconRenderer.lastKillTime = System.currentTimeMillis();
        KillIconRenderer.isFadingOutAll = false;
        KillIconRenderer.latestWeaponName = weaponName;
        KillIconRenderer.latestTargetName = targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderIcons(GuiGraphics guiGraphics, PoseStack poseStack, long currentTime) {
        if (KillIconRenderer.activeIcons.isEmpty()) {
            return;
        }
        float[] oldColor = RenderSystem.getShaderColor();
        try {
            Iterator<KillIconInstance> iterator = KillIconRenderer.activeIcons.iterator();
            int iconSize = ScrollingIconRenderer.getCurrentIconSize();
            while (iterator.hasNext()) {
                KillIconInstance icon = iterator.next();
                long elapsed = currentTime - icon.startTime;
                ScrollingIconRenderer.updateIconAnimation(icon, elapsed, currentTime);
                if (icon.alpha <= 0.0f) {
                    iterator.remove();
                    this.updateAllIconTargetPositions();
                    if (!KillIconRenderer.activeIcons.isEmpty()) continue;
                    KillIconRenderer.isGroupDisplaying = false;
                    KillIconRenderer.shouldStartFadeOut = false;
                    KillIconRenderer.isFadingOutAll = false;
                    continue;
                }
                ScrollingIconRenderer.updatePosition(icon, currentTime);
                if (icon.isCombo) {
                    ComboIconRenderer.renderComboIcon(guiGraphics, poseStack, icon, iconSize);
                    continue;
                }
                ScrollingIconRenderer.renderSingleIcon(guiGraphics, poseStack, icon);
            }
        }
        finally {
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        }
    }

    public void updateAllIconTargetPositions() {
        if (KillIconRenderer.activeIcons.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int iconSize = ScrollingIconRenderer.getCurrentIconSize();
        RenderHelper.PositionConfig pos = this.getCurrentPosition();
        float centerX = (float)screenWidth / 2.0f + (float)pos.iconX;
        float iconSpacing = iconSize + Config.killIconSpacing;
        for (int i = 0; i < KillIconRenderer.activeIcons.size(); ++i) {
            KillIconInstance icon = KillIconRenderer.activeIcons.get(i);
            float position = (float)i - (float)(KillIconRenderer.activeIcons.size() - 1) / 2.0f;
            float newTargetX = centerX + position * iconSpacing - (float)iconSize / 2.0f;
            if (!(Math.abs(icon.targetX - newTargetX) > 1.0f)) continue;
            icon.prevX = icon.currentX;
            icon.targetX = newTargetX;
            icon.positionAnimationStart = System.currentTimeMillis();
        }
    }

    public void startFadeOutSequence(long currentTime) {
        KillIconRenderer.isFadingOutAll = true;
        int totalIcons = KillIconRenderer.activeIcons.size();
        float speedFactor = ScrollingIconRenderer.calculateFadeOutSpeedFactor(totalIcons);
        long baseDelay = (long)(40.0f / speedFactor);
        long fadeDuration = 100L;
        baseDelay = Math.max(baseDelay, 20L);
        for (int i = 0; i < totalIcons; ++i) {
            KillIconInstance icon = KillIconRenderer.activeIcons.get(i);
            icon.fadeStartTime = currentTime + (long)i * baseDelay;
            icon.fadeDuration = fadeDuration;
        }
    }

    public void loadResources() {
        String stylePath = Config.iconStyle == Config.IconStyle.VANILLA ? "vanilla_gui" : "modern_gui";
        VANALLA_KILL_ICON = new ResourceLocation("gd656killicon", "textures/gui/" + stylePath + "/rollingmode/kill_icon.png");
        VANALLA_ULTIMATE_ICON = new ResourceLocation("gd656killicon", "textures/gui/" + stylePath + "/rollingmode/ultimate_icon.png");
        VANALLA_ASSIST_ICON = new ResourceLocation("gd656killicon", "textures/gui/" + stylePath + "/rollingmode/assist_icon.png");
    }

    private void checkMaxDisplayCount() {
        if (KillIconRenderer.activeIcons.size() > Config.maxDisplayCount) {
            KillIconRenderer.activeIcons.remove(0);
            this.updateAllIconTargetPositions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderSingleIcon(GuiGraphics guiGraphics, PoseStack poseStack, KillIconInstance icon) {
        int currentIconSize = ScrollingIconRenderer.getCurrentIconSize();
        int scaledSize = (int)((float)currentIconSize * icon.scale);
        int offsetX = (currentIconSize - scaledSize) / 2;
        int offsetY = (currentIconSize - scaledSize) / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)icon.brightness, (float)icon.brightness, (float)icon.brightness, (float)icon.alpha);
        poseStack.m_85836_();
        try {
            ResourceLocation iconTexture;
            poseStack.m_252880_(icon.currentX + (float)offsetX, icon.baseY + (float)offsetY, 0.0f);
            poseStack.m_85841_(icon.scale, icon.scale, 1.0f);
            IconType iconType = ScrollingIconRenderer.getIconType(icon);
            switch (iconType) {
                case ASSIST: {
                    iconTexture = VANALLA_ASSIST_ICON;
                    break;
                }
                case COMBO: {
                    ComboIconRenderer.renderComboIcon(guiGraphics, poseStack, icon, currentIconSize);
                    return;
                }
                case CRITICAL: {
                    iconTexture = VANALLA_ULTIMATE_ICON;
                    break;
                }
                default: {
                    iconTexture = VANALLA_KILL_ICON;
                }
            }
            guiGraphics.m_280163_(iconTexture, 0, 0, 0.0f, 0.0f, currentIconSize, currentIconSize, currentIconSize, currentIconSize);
        }
        finally {
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void updateIconAnimation(KillIconInstance icon, long elapsed, long currentTime) {
        if (elapsed < (long)Config.killIconAnimationDuration) {
            float progress = Mth.m_14036_((float)((float)elapsed / (float)Config.killIconAnimationDuration), (float)0.0f, (float)1.0f);
            float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
            icon.scale = Mth.m_14179_((float)easedProgress, (float)1.5f, (float)1.0f);
            icon.brightness = Mth.m_14179_((float)easedProgress, (float)4.0f, (float)1.0f);
        }
        if (icon.fadeStartTime != -1L && currentTime >= icon.fadeStartTime) {
            long fadeElapsed = currentTime - icon.fadeStartTime;
            float fadeProgress = Math.min((float)fadeElapsed / 200.0f, 1.0f);
            icon.alpha = 1.0f - fadeProgress;
            if (fadeProgress >= 1.0f) {
                icon.alpha = 0.0f;
            }
        }
        if (KillIconRenderer.isFadingOutAll && icon.fadeStartTime == -1L) {
            icon.fadeStartTime = currentTime;
            icon.fadeDuration = 200L;
        }
    }

    private static void updatePosition(KillIconInstance icon, long currentTime) {
        if (Math.abs(icon.currentX - icon.targetX) > 0.1f) {
            long moveElapsed = currentTime - icon.positionAnimationStart;
            float progress = Math.min((float)moveElapsed / 300.0f, 1.0f);
            float easedProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
            icon.currentX = Mth.m_14179_((float)easedProgress, (float)icon.prevX, (float)icon.targetX);
        }
    }

    private static int getCurrentIconSize() {
        return switch (Config.iconMode) {
            default -> throw new IncompatibleClassChangeError();
            case Config.IconMode.SCROLLING -> Config.scrollIconSize;
            case Config.IconMode.COMBO -> Config.comboIconSize;
            case Config.IconMode.CARD -> Config.cardIconSize;
        };
    }

    private static IconType getIconType(KillIconInstance icon) {
        if (icon.isAssist) {
            return IconType.ASSIST;
        }
        if (icon.isCombo) {
            return IconType.COMBO;
        }
        if (icon.isCritical) {
            return IconType.CRITICAL;
        }
        return IconType.NORMAL;
    }

    private RenderHelper.PositionConfig getCurrentPosition() {
        RenderHelper.PositionConfig config = new RenderHelper.PositionConfig();
        switch (Config.iconMode) {
            case SCROLLING: {
                config.iconX = Config.scrollIconX;
                config.iconY = Config.scrollIconY;
                break;
            }
            case COMBO: {
                config.iconX = Config.comboIconX;
                config.iconY = Config.comboIconY;
                break;
            }
            case CARD: {
                config.iconX = Config.cardIconX;
                config.iconY = Config.cardIconY;
            }
        }
        return config;
    }

    private static SoundEvent getKillSound(boolean isUltimate) {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return isUltimate ? (SoundEvent)Gd656killicon.ULTIMATE_KILL_VANILLA.get() : (SoundEvent)Gd656killicon.KILL_SOUND_VANILLA.get();
        }
        return isUltimate ? (SoundEvent)Gd656killicon.ULTIMATE_KILL_MODERN.get() : (SoundEvent)Gd656killicon.KILL_SOUND_MODERN.get();
    }

    private static SoundEvent getAssistKillSound() {
        if (Config.iconStyle == Config.IconStyle.VANILLA) {
            return (SoundEvent)Gd656killicon.ASSIST_KILL_VANILLA.get();
        }
        return (SoundEvent)Gd656killicon.ASSIST_KILL_MODERN.get();
    }

    private static float calculateFadeOutSpeedFactor(int iconCount) {
        if (iconCount <= 3) {
            return 0.4f;
        }
        if (iconCount <= 6) {
            return 0.5f;
        }
        if (iconCount <= 10) {
            return 0.8f;
        }
        if (iconCount <= 15) {
            return 1.0f;
        }
        if (iconCount <= 20) {
            return 2.0f;
        }
        return 3.0f;
    }

    public static class KillIconInstance {
        public long startTime;
        public float brightness;
        public float scale;
        public float alpha;
        public float prevX;
        public float currentX;
        public float targetX;
        public float baseY;
        public long positionAnimationStart;
        public long fadeStartTime = -1L;
        public long fadeDuration = 1L;
        public boolean isCritical;
        public boolean isCombo;
        public int comboIndex;
        public boolean isAssist;
        public float currentY;
        public float targetY;
        public long animationStartTime;
        public int currentFrame;
        public boolean isAnimating;

        public KillIconInstance(long startTime, float initialX, float baseY, boolean isCritical) {
            this.startTime = startTime;
            this.baseY = baseY;
            this.currentY = baseY;
            this.targetY = baseY;
            this.brightness = 4.0f;
            this.scale = 1.5f;
            this.alpha = 1.0f;
            this.prevX = initialX;
            this.currentX = initialX;
            this.targetX = initialX;
            this.positionAnimationStart = System.currentTimeMillis();
            this.isCritical = isCritical;
            this.isAssist = false;
            this.isCombo = false;
            this.comboIndex = 0;
            this.animationStartTime = startTime;
            this.currentFrame = 0;
            this.isAnimating = false;
        }
    }

    private static enum IconType {
        ASSIST,
        COMBO,
        CRITICAL,
        NORMAL;

    }
}

