/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.mods.gd656killicon.client.KillIconRenderer;

public class KillPacket {
    private final String targetName;
    private final boolean isCritical;
    private final boolean playUltimateSound;
    private final int killScore;
    private final boolean isAssist;
    private final byte damageType;

    public KillPacket(String targetName, boolean isCritical, boolean playUltimateSound, int killScore, boolean isAssist, byte damageType) {
        this.targetName = targetName;
        this.isCritical = isCritical;
        this.playUltimateSound = playUltimateSound;
        this.killScore = killScore;
        this.isAssist = isAssist;
        this.damageType = damageType;
    }

    public KillPacket(FriendlyByteBuf buf) {
        this.targetName = buf.m_130277_();
        this.isCritical = buf.readBoolean();
        this.playUltimateSound = buf.readBoolean();
        this.killScore = buf.readInt();
        this.isAssist = buf.readBoolean();
        this.damageType = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.targetName);
        buf.writeBoolean(this.isCritical);
        buf.writeBoolean(this.playUltimateSound);
        buf.writeInt(this.killScore);
        buf.writeBoolean(this.isAssist);
        buf.writeByte((int)this.damageType);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            String weaponName = "\u62f3\u5934";
            if (this.damageType == 1) {
                weaponName = "\u9b54\u6cd5\u4f24\u5bb3";
            } else if (this.damageType == 0 && mc.f_91074_ != null && !mc.f_91074_.m_21205_().m_41619_()) {
                weaponName = mc.f_91074_.m_21205_().m_41611_().getString().replace("[", "").replace("]", "");
            }
            KillIconRenderer.triggerKillIcon(weaponName, this.targetName, this.isCritical, this.playUltimateSound, this.killScore, this.isAssist);
        });
        ctx.setPacketHandled(true);
    }
}

