/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.client.KillIconRenderer;
import org.mods.gd656killicon.client.ModConfigScreen;
import org.mods.gd656killicon.commands.ScoreCommand;
import org.mods.gd656killicon.data.BanListData;
import org.mods.gd656killicon.data.ScoreData;
import org.mods.gd656killicon.data.ScoreExpressionManager;
import org.mods.gd656killicon.data.ScoreboardBindingData;
import org.mods.gd656killicon.network.DamageScorePacket;
import org.mods.gd656killicon.network.KillPacket;
import org.mods.gd656killicon.network.NetworkHandler;
import org.mods.gd656killicon.network.ScoreSyncPacket;
import org.mods.gd656killicon.util.ScoreExpressionCalculator;

@Mod(value="gd656killicon")
public class Gd656killicon {
    public static final String MOD_ID = "gd656killicon";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"gd656killicon");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"gd656killicon");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"gd656killicon");
    public static final RegistryObject<SoundEvent> ASSIST_KILL_VANILLA = SOUND_EVENTS.register("assistkill_sound_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "assistkill_sound_vanilla")));
    public static final RegistryObject<SoundEvent> CARD_KILL_VANILLA = SOUND_EVENTS.register("cardkill_sound_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "cardkill_sound_vanilla")));
    public static final RegistryObject<SoundEvent> COMBO_1_VANILLA = SOUND_EVENTS.register("combo_1_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_1_vanilla")));
    public static final RegistryObject<SoundEvent> COMBO_2_VANILLA = SOUND_EVENTS.register("combo_2_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_2_vanilla")));
    public static final RegistryObject<SoundEvent> COMBO_3_VANILLA = SOUND_EVENTS.register("combo_3_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_3_vanilla")));
    public static final RegistryObject<SoundEvent> COMBO_4_VANILLA = SOUND_EVENTS.register("combo_4_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_4_vanilla")));
    public static final RegistryObject<SoundEvent> COMBO_5_VANILLA = SOUND_EVENTS.register("combo_5_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_5_vanilla")));
    public static final RegistryObject<SoundEvent> COMBO_6_VANILLA = SOUND_EVENTS.register("combo_6_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_6_vanilla")));
    public static final RegistryObject<SoundEvent> KILL_SOUND_VANILLA = SOUND_EVENTS.register("kill_sound_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "kill_sound_vanilla")));
    public static final RegistryObject<SoundEvent> ULTIMATE_KILL_VANILLA = SOUND_EVENTS.register("ultimatekill_sound_vanilla", () -> new SoundEvent(new ResourceLocation(MOD_ID, "ultimatekill_sound_vanilla")));
    public static final RegistryObject<SoundEvent> ASSIST_KILL_MODERN = SOUND_EVENTS.register("assistkill_sound_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "assistkill_sound_modern")));
    public static final RegistryObject<SoundEvent> CARD_KILL_MODERN = SOUND_EVENTS.register("cardkill_sound_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "cardkill_sound_modern")));
    public static final RegistryObject<SoundEvent> COMBO_1_MODERN = SOUND_EVENTS.register("combo_1_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_1_modern")));
    public static final RegistryObject<SoundEvent> COMBO_2_MODERN = SOUND_EVENTS.register("combo_2_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_2_modern")));
    public static final RegistryObject<SoundEvent> COMBO_3_MODERN = SOUND_EVENTS.register("combo_3_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_3_modern")));
    public static final RegistryObject<SoundEvent> COMBO_4_MODERN = SOUND_EVENTS.register("combo_4_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_4_modern")));
    public static final RegistryObject<SoundEvent> COMBO_5_MODERN = SOUND_EVENTS.register("combo_5_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_5_modern")));
    public static final RegistryObject<SoundEvent> COMBO_6_MODERN = SOUND_EVENTS.register("combo_6_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "combo_6_modern")));
    public static final RegistryObject<SoundEvent> KILL_SOUND_MODERN = SOUND_EVENTS.register("kill_sound_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "kill_sound_modern")));
    public static final RegistryObject<SoundEvent> ULTIMATE_KILL_MODERN = SOUND_EVENTS.register("ultimatekill_sound_modern", () -> new SoundEvent(new ResourceLocation(MOD_ID, "ultimatekill_sound_modern")));
    private static final Map<UUID, Map<UUID, AssistData>> assistDataMap = new HashMap<UUID, Map<UUID, AssistData>>();
    private static final Map<UUID, Long> lastDamageTimeMap = new HashMap<UUID, Long>();
    private static final Map<UUID, Boolean> playerCritMap = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> playerComboCount = new HashMap<UUID, Integer>();
    private static final long ASSIST_TIMEOUT = 60000L;

    public Gd656killicon() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        NetworkHandler.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkHandler::register);
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity().m_183503_().m_5776_()) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = (LivingEntity)event.getEntity();
        ResourceLocation entityId = Registry.f_122826_.m_7981_((Object)target.m_6095_());
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        boolean isBanned = BanListData.get().isBanned(entityId.toString());
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float damageAmount = event.getAmount();
            byte damageType = this.getDamageType(player, source);
            String reason = this.getDamageReason(damageType);
            if (!isBanned) {
                NetworkHandler.sendToClient(new DamageScorePacket(damageAmount, reason), player);
            }
            lastDamageTimeMap.put(player.m_142081_(), System.currentTimeMillis());
            playerCritMap.put(player.m_142081_(), this.isPlayerCritical(player));
            if (!isBanned) {
                this.handleDamageScore(player, target, damageAmount, damageType);
            }
            this.handleAssistData(target, player, damageAmount);
            this.cleanupExpiredAssistData();
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().m_183503_().m_5776_()) {
            return;
        }
        LivingEntity target = (LivingEntity)event.getEntity();
        DamageSource source = event.getSource();
        ResourceLocation entityId = Registry.f_122826_.m_7981_((Object)target.m_6095_());
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        boolean isBanned = BanListData.get().isBanned(entityId.toString());
        MinecraftServer server = target.m_183503_().m_142572_();
        if (server == null) {
            return;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)entity;
            this.handleKillEvent(killer, target, source, isBanned);
        }
        this.handleAssistKills(target, source, server, isBanned);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ScoreCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        ScoreData.get();
        BanListData.get();
        ScoreExpressionManager.get();
        ScoreboardBindingData.get();
        this.startScoreboardSyncTask(event.getServer());
    }

    private void handleDamageScore(ServerPlayer player, LivingEntity target, float damageAmount, byte damageType) {
        ScoreData scoreData = ScoreData.get();
        ScoreExpressionManager expressionManager = ScoreExpressionManager.get();
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("damage", Double.valueOf(damageAmount));
        variables.put("health", Double.valueOf(target.m_21233_()));
        String expressionKey = this.getDamageExpressionKey(damageType);
        double calculatedScore = ScoreExpressionCalculator.calculate(ScoreExpressionManager.getExpression(expressionKey), variables);
        scoreData.addScore(player.m_142081_(), (float)calculatedScore);
        NetworkHandler.sendToClient(new ScoreSyncPacket(scoreData.getScore(player.m_142081_())), player);
    }

    private void handleKillEvent(ServerPlayer killer, LivingEntity target, DamageSource source, boolean isBanned) {
        ScoreExpressionManager expressionManager = ScoreExpressionManager.get();
        String targetKey = this.getTargetName(target);
        boolean isCritical = playerCritMap.getOrDefault(killer.m_142081_(), false);
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("health", Double.valueOf(target.m_21233_()));
        double killScore = ScoreExpressionCalculator.calculate(ScoreExpressionManager.getExpression("kill"), variables);
        if (isCritical) {
            variables.put("killscore", killScore);
            double critBonus = ScoreExpressionCalculator.calculate(ScoreExpressionManager.getExpression("critical"), variables);
            killScore += critBonus;
        }
        byte damageType = this.getDamageType(killer, source);
        int displayScore = isBanned ? 0 : (int)Math.round(killScore);
        NetworkHandler.sendToClient(new KillPacket(targetKey, isCritical, isCritical, displayScore, false, damageType), killer);
        if (!isBanned) {
            ScoreData scoreData = ScoreData.get();
            scoreData.addScore(killer.m_142081_(), (float)killScore);
            NetworkHandler.sendToClient(new ScoreSyncPacket(scoreData.getScore(killer.m_142081_())), killer);
            this.updateComboCount(killer.m_142081_());
        }
        this.handleLongRangeKill(killer, target, isBanned);
        playerCritMap.remove(killer.m_142081_());
    }

    private void handleAssistKills(LivingEntity target, DamageSource source, MinecraftServer server, boolean isBanned) {
        UUID uUID;
        UUID targetId = target.m_142081_();
        if (!assistDataMap.containsKey(targetId)) {
            return;
        }
        Map<UUID, AssistData> targetAssists = assistDataMap.get(targetId);
        float maxHealth = target.m_21233_();
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)entity;
            uUID = killer.m_142081_();
        } else {
            uUID = null;
        }
        UUID killerId = uUID;
        for (AssistData assist : targetAssists.values()) {
            ServerPlayer assister;
            if (assist.attackerId.equals(killerId) || (assister = server.m_6846_().m_11259_(assist.attackerId)) == null) continue;
            HashMap<String, Double> variables = new HashMap<String, Double>();
            variables.put("damagedealt", Double.valueOf(assist.damageDealt));
            variables.put("health", Double.valueOf(maxHealth));
            double assistScore = ScoreExpressionCalculator.calculate(ScoreExpressionManager.getExpression("assist"), variables);
            if (isBanned) {
                assistScore = 0.0;
            }
            byte damageType = this.getDamageType(assister, source);
            NetworkHandler.sendToClient(new KillPacket(this.getTargetName(target), false, false, (int)Math.round(assistScore), true, damageType), assister);
            if (isBanned) continue;
            ScoreData scoreData = ScoreData.get();
            scoreData.addScore(assister.m_142081_(), (float)assistScore);
            NetworkHandler.sendToClient(new ScoreSyncPacket(scoreData.getScore(assister.m_142081_())), assister);
            this.updateComboCount(assister.m_142081_());
        }
        assistDataMap.remove(targetId);
    }

    private void handleLongRangeKill(ServerPlayer killer, LivingEntity target, boolean isBanned) {
        double distance = killer.m_20270_((Entity)target);
        if (distance >= 20.0) {
            HashMap<String, Double> variables = new HashMap<String, Double>();
            variables.put("distance", distance);
            double distanceScore = ScoreExpressionCalculator.calculate(ScoreExpressionManager.getExpression("longrange"), variables);
            if (!isBanned) {
                String reason = "\u8fdc\u8ddd\u79bb\u51fb\u8d25 " + (int)distance + "m";
                NetworkHandler.sendToClient(new DamageScorePacket((float)distanceScore, reason), killer);
                ScoreData scoreData = ScoreData.get();
                scoreData.addScore(killer.m_142081_(), (float)distanceScore);
                NetworkHandler.sendToClient(new ScoreSyncPacket(scoreData.getScore(killer.m_142081_())), killer);
            }
        }
    }

    private void handleAssistData(LivingEntity target, ServerPlayer player, float damageAmount) {
        Map<UUID, AssistData> targetAssists;
        UUID targetId = target.m_142081_();
        UUID attackerId = player.m_142081_();
        if (!assistDataMap.containsKey(targetId)) {
            assistDataMap.put(targetId, new HashMap());
        }
        if ((targetAssists = assistDataMap.get(targetId)).containsKey(attackerId)) {
            targetAssists.computeIfPresent(attackerId, (k, existing) -> new AssistData(attackerId, existing.damageDealt + damageAmount));
        } else {
            targetAssists.put(attackerId, new AssistData(attackerId, damageAmount));
        }
    }

    private void cleanupExpiredAssistData() {
        long currentTime = System.currentTimeMillis();
        assistDataMap.values().removeIf(targetAssists -> {
            targetAssists.entrySet().removeIf(e -> currentTime - ((AssistData)e.getValue()).timestamp > 60000L);
            return targetAssists.isEmpty();
        });
    }

    private void startScoreboardSyncTask(MinecraftServer server) {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            if (server.m_130010_()) {
                server.execute(() -> ScoreCommand.syncScoresToScoreboard(server));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void updateComboCount(UUID playerId) {
        long currentTime = System.currentTimeMillis();
        int comboCount = playerComboCount.getOrDefault(playerId, 0);
        if (currentTime - lastDamageTimeMap.getOrDefault(playerId, 0L) > (long)Config.comboTimeoutMs) {
            comboCount = 0;
        }
        playerComboCount.put(playerId, ++comboCount);
        lastDamageTimeMap.put(playerId, currentTime);
    }

    private byte getDamageType(ServerPlayer player, DamageSource source) {
        if (this.isMagicDamage(source)) {
            return 1;
        }
        if (player.m_21205_().m_41619_()) {
            return 2;
        }
        return 0;
    }

    private String getDamageReason(byte damageType) {
        return switch (damageType) {
            case 1 -> "\u9b54\u6cd5\u4f24\u5bb3";
            case 2 -> "\u7a7a\u624b\u653b\u51fb";
            default -> "\u9020\u6210\u4f24\u5bb3";
        };
    }

    private String getDamageExpressionKey(byte damageType) {
        return switch (damageType) {
            case 1 -> "magic";
            case 2 -> "hand";
            default -> "damage";
        };
    }

    private boolean isPlayerCritical(ServerPlayer player) {
        return player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_21255_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && !player.m_6047_();
    }

    private boolean isMagicDamage(DamageSource source) {
        String msgId = source.m_19385_();
        return msgId.contains("magic") || msgId.contains("potion") || msgId.contains("indirect") || msgId.contains("thrown") || msgId.contains("wither") || msgId.contains("dragon");
    }

    private String getTargetName(LivingEntity target) {
        return target instanceof ServerPlayer ? target.m_7755_().getString() : target.m_6095_().m_20675_();
    }

    public static SoundEvent getCardKillSound() {
        return Config.iconStyle == Config.IconStyle.VANILLA ? (SoundEvent)CARD_KILL_VANILLA.get() : (SoundEvent)CARD_KILL_MODERN.get();
    }

    static class AssistData {
        public final UUID attackerId;
        public final float damageDealt;
        public final long timestamp;

        public AssistData(UUID attackerId, float damageDealt) {
            this.attackerId = attackerId;
            this.damageDealt = damageDealt;
            this.timestamp = System.currentTimeMillis();
        }
    }

    @Mod.EventBusSubscriber(modid="gd656killicon", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MinecraftForge.EVENT_BUS.addListener(KillIconRenderer::renderKillIcon);
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new ModConfigScreen((Screen)screen)));
        }
    }
}

