/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.animation;

import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.Bone;
import com.magmaguy.freeminecraftmodels.dataconverter.AnimationBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.AnimationFrame;
import java.util.HashMap;

public class Animation {
    private final AnimationBlueprint animationBlueprint;
    private final HashMap<Bone, AnimationFrame[]> animationFrames = new HashMap();
    private int counter = 0;

    public void incrementCounter() {
        ++this.counter;
    }

    public Animation(AnimationBlueprint animationBlueprint, ModeledEntity modeledEntity) {
        this.animationBlueprint = animationBlueprint;
        animationBlueprint.getAnimationFrames().forEach((key, value) -> {
            for (Bone bone : modeledEntity.getSkeleton().getBones()) {
                if (!bone.getBoneBlueprint().equals(key)) continue;
                this.animationFrames.put(bone, (AnimationFrame[])value);
                break;
            }
        });
        modeledEntity.getSkeleton().getBones().forEach(bone -> {
            if (!this.animationFrames.containsKey(bone)) {
                this.animationFrames.put((Bone)bone, (AnimationFrame[])null);
            }
        });
    }

    public void resetCounter() {
        this.counter = 0;
    }

    public AnimationBlueprint getAnimationBlueprint() {
        return this.animationBlueprint;
    }

    public HashMap<Bone, AnimationFrame[]> getAnimationFrames() {
        return this.animationFrames;
    }

    public int getCounter() {
        return this.counter;
    }
}

