/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.animation;

import com.magmaguy.freeminecraftmodels.animation.Animation;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateConfig;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateType;
import com.magmaguy.freeminecraftmodels.animation.IAnimState;
import java.util.Optional;

public class SpawnState
implements IAnimState {
    private final AnimationStateConfig cfg;
    private boolean finished;

    public SpawnState(AnimationStateConfig cfg) {
        this.cfg = cfg;
    }

    @Override
    public void enter() {
        this.cfg.getAnimation().resetCounter();
        this.finished = false;
    }

    @Override
    public void update() {
        if (this.cfg.getAnimation().getCounter() >= this.cfg.getAnimation().getAnimationBlueprint().getDuration()) {
            this.finished = true;
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public AnimationStateType getType() {
        return AnimationStateType.SPAWN;
    }

    @Override
    public Optional<AnimationStateType> nextState() {
        return this.finished ? Optional.of(AnimationStateType.IDLE) : Optional.empty();
    }

    @Override
    public Animation getAnimation() {
        return this.cfg.getAnimation();
    }

    @Override
    public boolean isLoop() {
        return this.cfg.isLoop();
    }
}

