/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.config;

import com.google.gson.Gson;
import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.VersionChecker;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ModelsFolder {
    private static int counter;
    private static int folderCounter;

    public static void initializeConfig() {
        counter = 1;
        folderCounter = 50;
        File file = new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "models");
        if (!file.exists()) {
            file.mkdirs();
            file.mkdir();
        }
        if (!file.exists()) {
            Logger.warn("Failed to create models directory!");
            return;
        }
        if (!file.isDirectory()) {
            Logger.warn("Directory models was not a directory!");
            return;
        }
        if (VersionChecker.serverVersionOlderThan(21, 4)) {
            ModelsFolder.legacyHorseArmorGeneration(file);
        } else {
            ModelsFolder.newModelGeneration(file);
        }
    }

    private static void legacyHorseArmorGeneration(File file) {
        Gson gson = new Gson();
        ArrayList<FileModelConverter> bbModelConverterList = new ArrayList<FileModelConverter>();
        HashMap<String, Object> leatherHorseArmor = new HashMap<String, Object>();
        leatherHorseArmor.put("parent", "item/generated");
        leatherHorseArmor.put("textures", Collections.singletonMap("layer0", "minecraft:item/leather_horse_armor"));
        ModelsFolder.processFolders(file, bbModelConverterList, leatherHorseArmor, true);
        leatherHorseArmor.put("data", counter - 1 + folderCounter * 1000);
        try {
            FileUtils.writeStringToFile(new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + "FreeMinecraftModels" + File.separatorChar + "assets" + File.separatorChar + "minecraft" + File.separatorChar + "models" + File.separatorChar + "item" + File.separatorChar + "leather_horse_armor.json"), gson.toJson(leatherHorseArmor), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.warn("Failed to generate the iron horse armor file!");
            throw new RuntimeException(e);
        }
    }

    private static void newModelGeneration(File file) {
        String modelName;
        File itemModelsFolder = new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + "FreeMinecraftModels" + File.separatorChar + "assets" + File.separatorChar + "freeminecraftmodels" + File.separatorChar + "items");
        if (!itemModelsFolder.exists()) {
            itemModelsFolder.mkdir();
        }
        ArrayList<FileModelConverter> bbModelConverterList = new ArrayList<FileModelConverter>();
        HashMap<String, Object> jsonConfig = new HashMap<String, Object>();
        ModelsFolder.processFolders(file, bbModelConverterList, jsonConfig, true);
        HashMap<String, List> mappedModels = new HashMap<String, List>();
        for (FileModelConverter fileModelConverter : bbModelConverterList) {
            modelName = fileModelConverter.getID();
            mappedModels.computeIfAbsent(modelName, k -> new ArrayList()).add(fileModelConverter);
        }
        for (Map.Entry entry : mappedModels.entrySet()) {
            modelName = (String)entry.getKey();
            List models = (List)entry.getValue();
            File modelFolder = new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + "FreeMinecraftModels" + File.separatorChar + "assets" + File.separatorChar + "freeminecraftmodels" + File.separatorChar + "items" + File.separatorChar + modelName);
            modelFolder.mkdir();
            for (FileModelConverter fileModelConverter : models) {
                for (BoneBlueprint boneBlueprint : fileModelConverter.getSkeletonBlueprint().getBoneMap().values()) {
                    if (boneBlueprint.getBoneName().contains("freeminecraftmodels_autogenerated_root")) continue;
                    HashMap modelJson = new HashMap();
                    HashMap<String, Object> modelContentsJson = new HashMap<String, Object>();
                    modelContentsJson.put("type", "minecraft:model");
                    modelContentsJson.put("model", "freeminecraftmodels:" + boneBlueprint.getBoneName().split(":")[1]);
                    modelJson.put("model", modelContentsJson);
                    Gson gson = new Gson();
                    try {
                        FileUtils.writeStringToFile(new File(MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + "FreeMinecraftModels" + File.separatorChar + "assets" + File.separatorChar + "freeminecraftmodels" + File.separatorChar + "items" + File.separatorChar + boneBlueprint.getBoneName().split(":")[1] + ".json"), gson.toJson(modelJson), StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void processFiles(File childFile, List<FileModelConverter> bbModelConverterList, HashMap<String, Object> leatherHorseArmor) {
        try {
            FileModelConverter bbModelConverter = new FileModelConverter(childFile);
            bbModelConverterList.add(bbModelConverter);
            for (BoneBlueprint boneBlueprint : bbModelConverter.getSkeletonBlueprint().getMainModel()) {
                if (boneBlueprint.getBoneName().equals("hitbox") || boneBlueprint.getBoneName().equals("tag_name") || boneBlueprint.getBoneName().equals("freeminecraftmodels_autogenerated_root")) continue;
                ModelsFolder.assignBoneModelID(leatherHorseArmor, boneBlueprint);
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to parse model " + childFile.getName() + "! Warn the developer about this");
            e.printStackTrace();
        }
    }

    private static void processFolders(File file, List<FileModelConverter> bbModelConverterList, HashMap<String, Object> leatherHorseArmor, boolean firstLevel) {
        if (!firstLevel) {
            ++folderCounter;
        }
        File[] modelFiles = file.listFiles();
        Arrays.sort(modelFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File childFile : modelFiles) {
            if (childFile.isFile()) {
                ModelsFolder.processFiles(childFile, bbModelConverterList, leatherHorseArmor);
                continue;
            }
            ModelsFolder.processFolders(childFile, bbModelConverterList, leatherHorseArmor, false);
        }
    }

    private static void assignBoneModelID(HashMap<String, Object> ironHorseArmorFile, BoneBlueprint boneBlueprint) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>();
        entryMap.put("predicate", Collections.singletonMap("custom_model_data", counter + folderCounter * 1000));
        if (!boneBlueprint.getCubeBlueprintChildren().isEmpty()) {
            if (VersionChecker.serverVersionOlderThan(21, 4)) {
                boneBlueprint.setModelID("" + (counter + folderCounter * 1000));
            } else {
                boneBlueprint.setModelID(boneBlueprint.getBoneName());
            }
            ++counter;
        }
        entryMap.put("model", boneBlueprint.getBoneName());
        ironHorseArmorFile.computeIfAbsent("overrides", k -> new ArrayList());
        List existingList = (List)ironHorseArmorFile.get("overrides");
        existingList.add(entryMap);
        ironHorseArmorFile.put("overrides", existingList);
        if (!boneBlueprint.getBoneBlueprintChildren().isEmpty()) {
            for (BoneBlueprint childBoneBlueprint : boneBlueprint.getBoneBlueprintChildren()) {
                ModelsFolder.assignBoneModelID(ironHorseArmorFile, childBoneBlueprint);
            }
        }
    }
}

