/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.config.props;

import com.magmaguy.freeminecraftmodels.config.props.PropsConfigFields;
import com.magmaguy.freeminecraftmodels.magmacore.config.ConfigurationEngine;
import com.magmaguy.freeminecraftmodels.magmacore.config.CustomConfig;
import com.magmaguy.freeminecraftmodels.magmacore.config.CustomConfigFields;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.io.File;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PropsConfig
extends CustomConfig {
    public static PropsConfig INSTANCE;
    private static HashMap<String, PropsConfigFields> propsConfigs;

    public PropsConfig() {
        super("props", "com.magmaguy.freeminecraftmodels.config.props.premade", PropsConfigFields.class);
        INSTANCE = this;
        propsConfigs = new HashMap();
        for (String key : super.getCustomConfigFieldsHashMap().keySet()) {
            if (!super.getCustomConfigFieldsHashMap().get(key).isEnabled()) continue;
            propsConfigs.put(key, (PropsConfigFields)super.getCustomConfigFieldsHashMap().get(key));
        }
    }

    public static PropsConfigFields addPropConfigurationFile(String propFilename, Player player) {
        if (!propsConfigs.containsKey(propFilename)) {
            PropsConfigFields newProp = new PropsConfigFields(propFilename, true);
            propsConfigs.put(propFilename, newProp);
            INSTANCE.initialize(newProp);
            Logger.sendMessage((CommandSender)player, "Created new prop config file at ~/plugins/FreeMinecraftModels/props/" + propFilename + ".yml");
            return newProp;
        }
        Logger.sendMessage((CommandSender)player, "Using existing prop config. You can edit properties at ~/plugins/FreeMinecraftModels/props/" + propFilename + ".yml");
        return propsConfigs.get(propFilename);
    }

    private void initialize(CustomConfigFields customConfigFields) {
        File file = ConfigurationEngine.fileCreator("props", customConfigFields.getFilename());
        FileConfiguration fileConfiguration = ConfigurationEngine.fileConfigurationCreator(file);
        customConfigFields.setFile(file);
        customConfigFields.setFileConfiguration(fileConfiguration);
        customConfigFields.processConfigFields();
        ConfigurationEngine.fileSaverCustomValues(fileConfiguration, file);
        this.addCustomConfigFields(file.getName(), customConfigFields);
    }

    public static HashMap<String, PropsConfigFields> getPropsConfigs() {
        return propsConfigs;
    }

    static {
        propsConfigs = new HashMap();
    }
}

