/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.config.props.PropBlocks;
import com.magmaguy.freeminecraftmodels.config.props.PropsConfig;
import com.magmaguy.freeminecraftmodels.config.props.PropsConfigFields;
import com.magmaguy.freeminecraftmodels.customentity.StaticEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.components.PropBlockComponent;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.listeners.ArmorStandListener;
import com.magmaguy.freeminecraftmodels.magmacore.util.ChunkLocationChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.scheduler.BukkitRunnable;

public class PropEntity
extends StaticEntity {
    public static final NamespacedKey propNamespacedKey = new NamespacedKey(MetadataHandler.PLUGIN, "prop");
    public static HashMap<UUID, PropEntity> propEntities = new HashMap();
    private final String entityID;
    private final PropBlockComponent propBlockComponent = new PropBlockComponent(this);
    private PropsConfigFields propsConfigFields;
    private boolean persistent = true;
    private String chunkHash;

    public PropEntity(String entityID, Location spawnLocation) {
        super(entityID, spawnLocation);
        this.entityID = entityID;
        this.propsConfigFields = PropsConfig.getPropsConfigs().get(entityID + ".yml");
        this.initializePropEntity();
    }

    public PropEntity(String entityID, ArmorStand armorStand) {
        super(entityID, armorStand.getLocation());
        this.entityID = entityID;
        this.propsConfigFields = PropsConfig.getPropsConfigs().get(entityID + ".yml");
        this.initializePropEntity();
        this.setUnderlyingEntity((Entity)armorStand);
        this.spawnLocation = armorStand.getLocation();
        this.displayInitializer();
        this.chunkHash = ChunkLocationChecker.chunkToString(this.underlyingEntity.getLocation().getChunk());
        propEntities.put(this.underlyingEntity.getUniqueId(), this);
        propEntities.put(armorStand.getUniqueId(), this);
        this.chunkHash = ChunkLocationChecker.chunkToString(this.underlyingEntity.getLocation().getChunk());
    }

    public static void onStartup() {
        for (World world : Bukkit.getWorlds()) {
            for (Chunk loadedChunk : world.getLoadedChunks()) {
                for (Entity entity : loadedChunk.getEntities()) {
                    ArmorStand armorStand;
                    String propEntityID;
                    if (!(entity instanceof ArmorStand) || (propEntityID = PropEntity.getPropEntityID(armorStand = (ArmorStand)entity)) == null) continue;
                    PropEntity.respawnPropEntityFromArmorStand(propEntityID, armorStand);
                }
            }
        }
    }

    public static PropEntity spawnPropEntity(String entityID, Location location, PropsConfigFields config) {
        PropEntity propEntity = new PropEntity(entityID, location);
        propEntity.propsConfigFields = config;
        propEntity.spawn();
        return propEntity;
    }

    public static PropEntity spawnPropEntity(String entityID, Location spawnLocation) {
        PropEntity propEntity = new PropEntity(entityID, spawnLocation);
        propEntity.spawn();
        return propEntity;
    }

    public static PropEntity respawnPropEntityFromArmorStand(String entityID, ArmorStand armorStand) {
        FileModelConverter fileModelConverter = FileModelConverter.getConvertedFileModels().get(entityID);
        if (fileModelConverter == null) {
            return null;
        }
        if (propEntities.containsKey(armorStand.getUniqueId())) {
            return propEntities.get(armorStand.getUniqueId());
        }
        PropEntity propEntity = new PropEntity(entityID, armorStand);
        return propEntity;
    }

    public static boolean isPropEntity(ArmorStand armorStand) {
        return armorStand.getPersistentDataContainer().has(propNamespacedKey, PersistentDataType.STRING);
    }

    public static String getPropEntityID(ArmorStand armorStand) {
        return (String)armorStand.getPersistentDataContainer().get(propNamespacedKey, PersistentDataType.STRING);
    }

    private void initializePropEntity() {
        this.getDamageableComponent().setInternalHealth(3.0);
        this.setLeftClickCallback((player, entity) -> entity.damage((Entity)player));
        this.propBlockComponent.showFakePropBlocksToAllPlayers();
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
        this.underlyingEntity.setPersistent(persistent);
    }

    @Override
    public void spawn() {
        ArmorStandListener.bypass = true;
        super.spawn(this.getSpawnLocation().getWorld().spawn(this.getSpawnLocation(), EntityType.ARMOR_STAND.getEntityClass(), entity -> {
            entity.setVisibleByDefault(false);
            entity.setGravity(false);
            entity.setInvulnerable(true);
            entity.setPersistent(true);
            entity.getPersistentDataContainer().set(propNamespacedKey, PersistentDataType.STRING, (Object)this.entityID);
        }));
        this.chunkHash = ChunkLocationChecker.chunkToString(this.underlyingEntity.getLocation().getChunk());
        propEntities.put(this.underlyingEntity.getUniqueId(), this);
        ArmorStandListener.bypass = false;
    }

    public void setCustomDataString(NamespacedKey customNamespacedKey, String data) {
        this.underlyingEntity.getPersistentDataContainer().set(customNamespacedKey, PersistentDataType.STRING, (Object)data);
    }

    public String getCustomDataString(NamespacedKey customNamespacedKey) {
        return (String)this.underlyingEntity.getPersistentDataContainer().get(customNamespacedKey, PersistentDataType.STRING);
    }

    @Override
    public void remove() {
        super.remove();
        this.showRealBlocksToAllPlayers();
        propEntities.remove(this.underlyingEntity.getUniqueId());
        if (!this.persistent) {
            this.underlyingEntity.remove();
        }
        if (this.isDying() && this.underlyingEntity != null) {
            new BukkitRunnable(){

                public void run() {
                    PropEntity.this.underlyingEntity.remove();
                }
            }.runTask(MetadataHandler.PLUGIN);
        }
    }

    public void permanentlyRemove() {
        this.remove();
        if (this.underlyingEntity != null) {
            new BukkitRunnable(){

                public void run() {
                    PropEntity.this.underlyingEntity.remove();
                }
            }.runTask(MetadataHandler.PLUGIN);
        }
    }

    public void setPropBlocks(List<PropBlocks> propBlocks) {
        this.propBlockComponent.setPropBlocks(propBlocks);
    }

    public void showFakePropBlocksToPlayer(Player player) {
        this.propBlockComponent.showFakePropBlocksToPlayer(player);
    }

    public void showFakePropBlocksToAllPlayers() {
        this.propBlockComponent.showFakePropBlocksToAllPlayers();
    }

    public void showRealBlocksToPlayer(Player player) {
        this.propBlockComponent.showRealBlocksToPlayer(player);
    }

    public void showRealBlocksToAllPlayers() {
        this.propBlockComponent.showRealBlocksToAllPlayers();
    }

    public static HashMap<UUID, PropEntity> getPropEntities() {
        return propEntities;
    }

    public PropBlockComponent getPropBlockComponent() {
        return this.propBlockComponent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public static class PropEntityEvents
    implements Listener {
        @EventHandler
        public void onArmorStandInteract(PlayerInteractEntityEvent event) {
            ArmorStand armorStand;
            Entity entity = event.getRightClicked();
            if (entity instanceof ArmorStand && PropEntity.isPropEntity(armorStand = (ArmorStand)entity)) {
                event.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onChunkLoadEvent(ChunkLoadEvent event) {
            for (Entity entity : event.getChunk().getEntities()) {
                ArmorStand armorStand;
                String propEntityID;
                if (!(entity instanceof ArmorStand) || (propEntityID = PropEntity.getPropEntityID(armorStand = (ArmorStand)entity)) == null) continue;
                PropEntity.respawnPropEntityFromArmorStand(propEntityID, armorStand);
            }
        }

        @EventHandler
        private void onChunkUnloadEvent(ChunkUnloadEvent event) {
            String chunkHash = ChunkLocationChecker.chunkToString(event.getChunk());
            ArrayList<PropEntity> propEntitiesClone = new ArrayList<PropEntity>(propEntities.values());
            for (PropEntity value : propEntitiesClone) {
                if (!value.chunkHash.equals(chunkHash)) continue;
                value.remove();
            }
        }
    }
}

